package lsedit;

import java.awt.Event;
import java.awt.Graphics;
import java.awt.event.*;
import java.util.*;

import javax.swing.*;

public abstract class LandscapeModeHandler extends Object
{
	protected LandscapeViewerCore m_ls = null;
	protected Diagram             m_dg = null; 
	protected boolean             mouseIsDown = false;

	public LandscapeModeHandler() 
	{
		super();
	}

	public void init(LandscapeViewerCore ls) 
	{
		// N.B. Do not assume Diagram exists yet
		m_ls = ls;
	}



	public void select(Diagram dg) 
	{
		m_dg     = dg;
	}

	public void cleanup() 
	{
	}

	public void reset() 
	{
	}

	public void halt() 
	{
	}

	public void processKey(int key, int modifiers, Object object)
	{
	}

	public boolean entityPressed(MouseEvent ev, EntityInstance e, int x, int y) 
	{
//		System.out.println("LandscapeModeHandler entityPressed\n");
		return false;
	}

	public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y) 
	{
//		System.out.println("LandscapeModeHandler entityReleased\n");
		mouseIsDown = false;
	}

	public boolean relationPressed(MouseEvent ev, RelationInstance ri, int x, int y) 
	{
		return false;
	}

	public void relationReleased(MouseEvent ev, RelationInstance ri, int x, int y) 
	{
//		System.out.println("LandscapeModeHandler relationReleased\n");
		mouseIsDown = false;
	}

	public boolean entityDragged(MouseEvent ev, EntityInstance e, int x, int y)
	{
		return false;
	}

	public boolean relationDragged(MouseEvent ev, RelationInstance ri, int x, int y) 
	{
		return false;
	}

	public void movedOverThing(MouseEvent ev, Object thing, int x, int y) 
	{
	}

}