package lsedit;

import java.awt.Color;
import java.util.*;
import java.io.*; 
import javax.swing.*;

// Don't put any things in this class that can be avoided -- thousands of relations

public abstract class LandscapeObject {

	private   static int				m_edge_mode = Do.EDGE_STATE_DEFAULT;
	protected static LandscapeObject	m_infoShown = null;	// Last identified thing mouse moved over

	public final static String COLOUR_ID       =	 "color";
	public final static String LABEL_COLOUR_ID =	 "labelcolor";
	public final static String OPEN_COLOUR_ID  =	 "opencolor";

	protected final static int MAX_RGB = 255; 

	/* All things that are not LandscapeClassObjects must have a parentClass
	 * Otherwise we can't getDiagram() for object in diagram
	 */

	// The class this entity belongs to (if entity or relation)
	// Probably null if a LandscapeClassObject

	private LandscapeClassObject	m_parentClass;				

	/* Logical color's need to be kept separate from the JComponent colors
	 * otherwise when we paint a component we set its actual color to its
	 * logical color loosing the fact that it may not have had a logical color
	 * to begin with (ie. null->red if the class was red)
	 */

	private Color					m_objectColor  = null;		// 
	private int						m_style        = -1;		// No style
	private	JComponent				m_swingObject;

	// Attribute database

	private Hashtable m_attributes;

	protected String qt(String str) 
	{
		return AttributeValueItem.qt(str);
	}

	// --------------
	// Public methods 
	// --------------

	public LandscapeObject() 
	{
	}

	public JComponent getSwingObject()
	{
		return m_swingObject;
	}

	public void setSwingObject(JComponent swingObject)
	{
		m_swingObject = swingObject;
	}

	public LandscapeClassObject getParentClass()
	{
		return m_parentClass;
	}
	
	public LandscapeClassObject derivedFrom(int i)
	{
		return(i == 0 ? m_parentClass : null);
	}

	public void setParentClass(LandscapeClassObject parentClass)
	{
		m_parentClass = parentClass;
	}

	// Entities and Relations obtain the diagram from their class..
	// This avoids a reference to the diagram on every edge/entity at small cost

	public Diagram getDiagram()
	{
		return(m_parentClass.getDiagram());
	}

	public boolean hasStyle()
	{
		return(m_style >= 0);
	}

	/* This is broken re multiple inheritence rules IJD */

	public int getStyle() 
	{
		int	ret, i;

		ret = m_style;
		if (ret < 0) {
			LandscapeClassObject	superclass;

			for (i = 0; (superclass = derivedFrom(i)) != null; ++i) {
				ret = superclass.getStyle();
				if (ret >= 0) {
					break;
		}	}	}
		return ret;
	}

	public void setStyle(int value)
	{
		m_style = value;
	}

	// Relations and RelationClasses can't be opened

	public Color getColorWhenOpen() 
	{
		return null;
	}

	public void setColorWhenOpen(Color color) 
	{
		System.out.println("Can't setColorWhenOpen(" + color + ") on " + this);
	}

	public boolean hasColorWhenOpen()
	{
		return(false);
	}

	public boolean hasObjectColor()
	{
		return(m_objectColor != null);
	}

	public Color getObjectColor() 
	{
		Color	ret;

		ret = m_objectColor;
		if (ret == null) {
			LandscapeClassObject	superclass;
			int						i;

			for (i = 0; (superclass = derivedFrom(i)) != null; ++i) {
				ret = superclass.getObjectColor();
				if (ret != null) {
					break;
		}	}	}
		return ret;
	}

	public void setObjectColor(Color color) 
	{
		m_objectColor = color;
	}

	// Relations don't have labels

	public Color getLabelColor() 
	{
		return null;
	}

	public void setLabelColor(Color color) 
	{
		System.out.println("Can't setLabelColor(" + color + ") on " + this);
	}

	public boolean hasLabelColor()
	{
		return(false);
	}

	// Return the attribute with the associated id
	// Avoid name collision potential with Swing
	// Allow attributes to be null

	public int getLsAttributesSize()
	{
		if (m_attributes == null) {
			return 0;
		}
		return m_attributes.size();
	}

	public Attribute getLsAttribute(String id) 
	{
		if (m_attributes != null) {
			return (Attribute) m_attributes.get(id);
		}
		return(null);
	}

	public Attribute getLsAttributeAt(int index)
	{
		if (m_attributes != null) {
			Enumeration	en;
			Object		attr;

			for (en = m_attributes.elements(); en.hasMoreElements(); --index) {
				attr = en.nextElement();
				if (index == 0) {
					return((Attribute) attr);
		}	}	}
		return(null);
	}

	public Enumeration getLsAttributesEnum()
	{
		if (m_attributes == null) {
			return null;
		}
		return (m_attributes.elements());
	}

	public void putLsAttribute(Attribute attr)
	{
		if (m_attributes == null) {
			m_attributes = new Hashtable(5);
		}
		m_attributes.put(attr.id, attr);
	}

	public void addAttribute(Attribute attr) {

		if (processFirstOrder(attr)) { 
			return;
		}

		Attribute curAttr = getLsAttribute(attr.id);

		if (curAttr != null) {
			// Replace any old attributes with overrides
			m_attributes.remove(attr.id);
		}
		putLsAttribute(attr);
	}

	public void regRawAttribute(Vector v, Hashtable st, String id, Object type, Object val)
	{
		Object[] ent = new Object[3];

		ent[0] = st.get(id);
		ent[1] = type;
		ent[2] = val;

		v.addElement(ent);
	}

	public void regRawAttribute(Vector v, Hashtable st, String id, int val) 
	{
		regRawAttribute(v, st, id, Attribute.INT, new Integer(val));
	}

	public void regRawAttribute(Vector v, Hashtable st, String id, double val) 
	{
		regRawAttribute(v, st, id, Attribute.DOUBLE, new Double(val));
	}

	public void regRawAttribute(Vector v, Hashtable st, String id, String val) 
	{
		regRawAttribute(v, st, id, Attribute.STRING, val);
	}

	public void regRawAttribute(Vector v, Hashtable st, String id, int[] val)
	{
		regRawAttribute(v, st, id, Attribute.INT_LIST, val);
	}

	public void regRawAttribute(Vector v, Hashtable st, String id, double[] val)
	{
		regRawAttribute(v, st, id, Attribute.DOUBLE_LIST, val);
	}

	public void regRawAttribute(Vector v, Hashtable st, String id, String[] val)
	{
		regRawAttribute(v, st, id, Attribute.STRING_LIST, val);
	}

	public void regAttributeRaw(Vector v, Hashtable st, Attribute attr, boolean classType)
	{
		if (attr.avi == null) {
			if (classType) {
				regRawAttribute(v, st, attr.id, Attribute.NULL, null);
			}
		}
		else if (classType || !attr.cloneOnAssign) {
			if (attr.avi.next != null) {
				AttributeValueItem avi;
				int i;
				int num = 0;

				for (avi = attr.avi; avi != null; ++num) {
					avi = avi.next;
				}
				String[] sl = new String[num];
				avi = attr.avi;
				i = 0;
				for (avi = attr.avi; avi != null; ++i) {
					sl[i] = avi.value;
					avi   = avi.next;
				}
				regRawAttribute(v, st, attr.id, sl);
			} else {
				regRawAttribute(v, st, attr.id, attr.avi.value);
			}
		}
	}

	public void regRawAttribute(Vector v, Hashtable st, String id, Color c) 
	{
		int red = c.getRed();
		int green = c.getGreen();
		int blue = c.getBlue();

		double[] dl = new double[3];

		dl[0] = ((double) red)/((double) MAX_RGB);
		dl[1] = ((double) green)/((double) MAX_RGB);
		dl[2] = ((double) blue)/((double) MAX_RGB);

		regRawAttribute(v, st, id, dl);
	}

	// If a new attribute, add it to the attribute database,
	// otherwise merely update the value.

	public boolean processFirstOrder(Attribute attr) 
	{
		if (attr.id.equals(COLOUR_ID)) {
			setObjectColor(attr.parseColour());
			return true;
		}

		if (attr.id.equals(LABEL_COLOUR_ID)) {
			setLabelColor(attr.parseColour());
			return true;
		}

		if (attr.id.equals(OPEN_COLOUR_ID)) {
			setColorWhenOpen(attr.parseColour());
			return true;
		}
		return false;
	}

	public boolean addRawAttribute(String id) 
	{
		Attribute attr = new Attribute(id, null);
		addAttribute(attr);
		return true;
	}

	public boolean addRawAttribute(String id, String val) 
	{
		AttributeValueItem avi = new AttributeValueItem(val);
		Attribute attr = new Attribute(id, avi);
		addAttribute(attr);
		return true;
	}

	public boolean addRawAttribute(String id, double val)
	{
		System.out.println("0");
		return false;
	}

	public boolean addRawAttribute(String id, int val) 
	{
		return false;
	}

	public boolean addRawAttribute(String id, int[] val) 
	{
		return false;
	}

	public boolean addRawAttribute(String id, double[] val) 
	{
		if (id.equals(COLOUR_ID)) {
			setObjectColor(new Color((float) val[0], (float) val[1], (float) val[2]));
			return true;
		}
		if (id.equals(LABEL_COLOUR_ID)) {
			setLabelColor(new Color((float) val[0], (float) val[1], (float) val[2]));
			return true;
		}
		if (id.equals(OPEN_COLOUR_ID)) {
			setColorWhenOpen(new Color((float) val[0], (float) val[1], (float) val[2]));
			return true;
		}
		return false;
	}

	public boolean addRawAttribute(String id, String[] val) 
	{
		AttributeValueItem favi = null;
		AttributeValueItem lavi = null;
		int num = val.length;

		for (int i=0; i<num; i++) {
			AttributeValueItem avi = new AttributeValueItem(val[i]);

			if (lavi != null)
				lavi.next = avi;
			if (favi == null)
				favi = avi;
			lavi = avi;
		}
		Attribute attr = new Attribute(id, favi);
		addAttribute(attr);
		return true;
	}

	public void replaceAttribute(Attribute newAttr)
	{
		addAttribute(newAttr);
	}



	public void writeAttributes(PrintStream ps, LandscapeObject parentClass, boolean classType) throws IOException 
	{
		Color color, color1;
		Enumeration en;

		// Output the body of the attribute record 
		// The child method outputs the header and tail 

		if (hasObjectColor()) {
			color = getObjectColor();
			if (parentClass != null) {
				color1 = parentClass.getObjectColor();
			} else {
				color1 = null;
			}
			if (!color.equals(color1)) {
				ps.print(Attribute.indent + COLOUR_ID + " = " + taColor(color) + "\n"); 
		}	}

		if (hasLabelColor()) { 
			color = getLabelColor();
			if (parentClass != null) {
				color1 = parentClass.getLabelColor();
			} else {
				color1 = null;
			}
			if (!color.equals(color1)) {
				ps.print(Attribute.indent + LABEL_COLOUR_ID + " = " + taColor(color) + "\n");
		}	}

		if (hasColorWhenOpen()) { 
			color = getColorWhenOpen();
			if (parentClass != null) {
				color1 = parentClass.getColorWhenOpen();
			} else {
				color1 = null;
			}
			if (!color.equals(color1)) {
				ps.print(Attribute.indent + OPEN_COLOUR_ID + " = " + taColor(color) + "\n");
		}	}

		if (m_attributes != null) {
			for (en = m_attributes.elements(); en.hasMoreElements(); ) {
				Attribute attr = (Attribute) en.nextElement();
				attr.writeAttribute(ps, parentClass, classType);
		}	}
	}

	public void getLsAttributesRaw(Vector v, Hashtable st, boolean classType) 
	{
		Enumeration en;

		if (hasObjectColor()) {
			regRawAttribute(v, st, COLOUR_ID, getObjectColor());
		}
		if (hasLabelColor()) {
			regRawAttribute(v, st, LABEL_COLOUR_ID, getLabelColor());
		}
		if (hasColorWhenOpen()) {
			regRawAttribute(v, st, OPEN_COLOUR_ID, getColorWhenOpen());
		}

		if (m_attributes != null) {
			for (en = m_attributes.elements(); en.hasMoreElements(); ) {
				Attribute attr = (Attribute) en.nextElement();
				regAttributeRaw(v, st, attr, classType);
		}	}
	}

	public static void setEdgeMode(int mode) 
	{
		m_edge_mode = mode;
	}

	public static int getEdgeMode() 
	{
		return m_edge_mode;
	}

	// The routines that follow hide the complexity of getting/setting attribute values
	// from EditAttributes

	public int getPrimaryAttributeCount()
	{
		return(0);
	}

	public int getLsAttributeCount()
	{
		return(getPrimaryAttributeCount() + getLsAttributesSize() + 1);
	}

	public boolean canEditName(int index)
	{
		int	primary = getPrimaryAttributeCount();

		if (index < primary) {
			return(false);
		}
		return(true);
	}

	public boolean canEditAttribute(int index)
	{
		int	primary;

		if (index == 0) {
			// This is the id of the object
			return(false);
		}

		primary =  getPrimaryAttributeCount();
		if (index < primary) {
			return(true);
		}
		index -= primary;
		if (index < getLsAttributesSize()) {
			return(true);
		}
		return(false);
	}

	public String getLsAttributeNameAt(int index)
	{
		Attribute	attr;

		index -= getPrimaryAttributeCount();
		if (index == getLsAttributesSize()) {
			// Dummy row to allow insertion
			return("");
		}
		attr   = getLsAttributeAt(index);
		if (attr == null) {
			return(null);
		}
		return(attr.id);
	}

	public Object getLsAttributeValueAt(int index)
	{
		Attribute	attr;

		index -= getPrimaryAttributeCount();
		if (index == getLsAttributesSize()) {
			// Dummy row to allow insertion
			return("");
		}
		attr   = getLsAttributeAt(index);
		if (attr == null) {
			return(null);
		}
		return(attr.avi);
	}

	private boolean unknownAttributeName(String name)
	{
		int			i, primary;
		String		name1;

		for (i = 0; ; ++i) {
			name1 = getLsAttributeNameAt(i);
			if (name1 == null) {
				break;
			}
			if (name.equals(name1)) {
				System.out.println("Can't rename generic attribute to '" + name + "': attribute already exists");
				return(false);
		}	} 
		return(true);
	}

	public boolean setAttributeNameAt(int index, Object value)
	{
		Attribute	attr;
		String		name;
		int			primary;

		primary = getPrimaryAttributeCount();

		if (index < primary) {
			// Can't change names of first order attributes
			return(false);
		}
		index -= primary;

		name = (String) value;
		if (index == getLsAttributesSize()) {
			if (name.equals("")) {
				// Dummy row hasn't changed
				return(false);
			}
			if (!unknownAttributeName(name)) {
				return(false);
			} 
			// insert the new attribute
			attr = new Attribute(name, null);
			putLsAttribute(attr);
			return(true);
		}

		attr = getLsAttributeAt(index);
		if (attr == null) {
			return(false);
		}

		if (name.equals("")) {
			m_attributes.remove(attr.id);
			return(true);
		}
		if (name.equals(attr.id)) {
			return(false);
		}
		if (!unknownAttributeName(name)) {
			return(false);
		} 

		m_attributes.remove(attr.id);
		attr.id = name;
		putLsAttribute(attr);
		return(true);
	}

	public void setAttributeValueAt(int index, Object value)
	{
		Attribute	attr;

		index -= getPrimaryAttributeCount();
		attr   = getLsAttributeAt(index);
		if (attr == null) {
			return;
		}
		attr.avi = (AttributeValueItem) value;
	}


	// Need to know the type in cases where value might be null
	// For example with some colors

	public int getLsAttributeTypeAt(int index)
	{
		if (index < getLsAttributeCount() - 1) {
			return(Attribute.AVI_TYPE);
		}
		// This attribute does not yet exist
		return(Attribute.NULL_TYPE);
	}

	public static String taColor(Color color1)
	{  
		int		red, green, blue; 

		red    = color1.getRed();
		green  = color1.getGreen();
		blue   = color1.getBlue();

		return("(" + ((double) red)/((double) MAX_RGB) + " " +	((double) green)/((double) MAX_RGB) + " " +	((double) blue)/((double) MAX_RGB) + ")"); 
	}

	public int getLsAttributeOffset(String id)
	{
		String	name;
		int		i;

		for (i = 0; ; ++i) {
			name = getLsAttributeNameAt(i);
			if (name == null) {
				return(-1);
			}
			if (name.equals(id)) {
				return(i);
	}	}	}

	public boolean defaultValue(String id, Object object)
	{
		if (object != null) {
			int		i;
			Object	object1;

			i = getLsAttributeOffset(id);
			if (i >= 0) {
				object1 = getLsAttributeValueAt(i);
				if (object.equals(object1)) {
					return(true);
		}	}	}
		return(false);
	}
}

