package lsedit;

import java.applet.AppletContext;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.print.Printable;
import java.awt.print.PageFormat;
import java.awt.Rectangle;
import java.util.regex.Pattern;

import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeCellRenderer;

public class LandscapeViewerCore extends Do implements ToolBarEventHandler
{
	protected final static String TITLE = "Software Landscape Viewer";

	protected final static int GAP         = 4;		// Gap between GUI objects

	protected final static int DROPDOWN_WIDTH = 150;
	protected final static int DROPDOWN_HEIGHT = 25;
	protected final static int TOP_CTRL_DELTA = 50;

	public static final int FA_LOAD = 0;

	/* Parameters */

	public    String editURL     = null;
	public	  String aboutURL    = null;
	public	  String helpURL     = null;
	public    String startEntity = null;
	public    String lsPath      = null;
	protected Vector lsPath_bg = new Vector();
	protected String prefURL, prefInvokeURL;
	protected String user;

	// protected HelpEngine helpEngine;

	protected static final int RELN_ALL = 10;

	protected JFrame        af       = null;
	protected JApplet		m_applet = null;
	protected AppletContext ac       = null; 


	protected static final String m_leftTextBoxHelp  = "Displays the 'description' for the current landscape.";
	protected static final String m_rightTextBoxHelp = "Displays the 'description' for the closed (not a container) entity currently under the mouse cursor.";
	protected static final String m_feedbackHelp     = "Displays feedback from the program. Examples include errors, warnings, and confirmations of action.";
	protected static final String m_nameBoxHelp      = "Displays the landscape entity, edge, or application button/box currently under the mouse cursor.";

	protected static double m_mainSplitRatio   = 0.80;
	protected static double m_secondSplitRatio = 0.1;
	protected static double m_thirdSplitRatio  = 0.5;

	// Frame contained in

	protected static int m_openFrames = 1;	// Number of open frames

	protected JFrame			m_frame;

	// Content pane

	protected Container			m_contentPane;

	// GUI compontents

	protected JToolBar			m_toolBar	         = null;
	protected JComboBox			m_lsDropDown         = null; 

	protected MySplitPane		m_thirdSplitPane	 = null;	// Left and right diagnostic area
	protected JSplitPane		m_secondSplitPane    = null;	// Diagram below
	protected JSplitPane		m_mainSplitPane      = null;	// Tab box on right
	protected JScrollPane		m_scrollLeftTextBox  = null;		

	protected JPanel			m_leftPanel          = null;
	protected JPanel			m_rightPanel         = null;

	protected JLabel			m_leftTextBoxTitle   = null;
	protected TextBox			m_leftTextBox        = null;
	protected JScrollPane		m_scrollRightTextBox = null;
	protected JLabel			m_rightTextBoxTitle  = null;
	protected TextBox			m_rightTextBox       = null;
	protected Feedback			m_feedback           = null;
	protected Feedback			m_nameBox            = null; 

	protected JScrollPane		m_scrollDiagram      = null;
	protected Diagram			m_diagram            = null;		// Active diagram 

	protected RightTabbedPane	m_rightTabbedPane    = null;		// The right panel of the view
	protected LegendBox			m_legendBox          = null;
	protected MapBox			m_mapBox             = null;
	protected QueryBox			m_queryBox           = null;
	protected ResultBox			m_resultBox          = null;
	protected TextTree			m_tocBox             = null;


	protected EntityInstance currentNameEntity = null;
	protected ViewModeHandler m_modeHandler;

	/* Parameters */

	protected String lsSavePath, lsSaveSuffix, lsSaveCmd;	// Not used by viewer

	protected Vector m_clipboard = null;

	protected int mode = 0;

	// ----------------- 
	// Protected methods
	// ----------------- 


	// Draw the tab which we actually want to see last

	protected void repaintTabs() 
	{
		if (m_rightTabbedPane != null) {
			m_rightTabbedPane.revalidate();
		}
	}

	public String getTitle() 
	{
		return TITLE;
	}

	public JMenuBar genMenu() 
	{
		JMenuBar mb = new JMenuBar();

		MyMenuItem mi;

		// Build Menu

		JMenu m = new JMenu("Menu");
		Do.refreshMenuItem(m, this);
		m.addSeparator();
		Do.findMenuItem(m, this);
		m.addSeparator();
		bestEdgeMenuItem(m, this);
		m.addSeparator();
		showMenuItem(m, this);
		m.addSeparator();
		mb.add(m);

		m = new JMenu("Help");
		Do.helpMenuItem(m, this, "Viewer");
		mb.add(m);
		return(mb);
	}

	// Generate top of screen GUI 

	protected ToolBarButton[] toolButton = 
	{
		new Find_Button(this),	
		new Query_f_Button(this),
		new Query_b_Button(this), 
		new Query_C_Button(this),
		new Query_Clear_Button(this),
		new Elision_c_Button(this),

		new Elision_I_Button(this), 
		new Elision_u_Button(this),
		new Elision_CU_Button(this), 
		new Elision_s_Button(this),
		new Elision_CS_Button(this),
		new FontSmallerButton(this),
		new FontBiggerButton(this)

	};

	protected int getNumToolButtons() 
	{
		// Viewer shows only the first 6 buttons
		return 6;
	}

	protected void computeMinInfoHeight()
	{
		Dimension d;

		int	left  = 0;
		int	right = 0;

		if (m_leftTextBoxTitle != null && m_leftTextBoxTitle.isVisible()) {
			d = m_leftTextBoxTitle.getMinimumSize();
			left += d.height;
		}
		if (m_scrollLeftTextBox != null && m_scrollLeftTextBox.isVisible()) {
			d = m_scrollLeftTextBox.getMinimumSize();
			left += d.height;
		}
		if (m_feedback != null && m_feedback.isVisible()) {
			d = m_feedback.getMinimumSize();
			left += d.height;
		}
		d = new Dimension(100, left);
		m_leftPanel.setMinimumSize(d);

		if (m_rightTextBoxTitle != null && m_rightTextBoxTitle.isVisible()) {
			d = m_rightTextBoxTitle.getMinimumSize();
			right += d.height;
		}
		if (m_scrollRightTextBox != null && m_scrollRightTextBox.isVisible()) {
			d = m_scrollRightTextBox.getMinimumSize();
			right += d.height;
		}
		if (m_nameBox != null && m_nameBox.isVisible()) {
			d = m_nameBox.getMinimumSize();
			right += d.height;
		}
		d = new Dimension(100, right);
		m_rightPanel.setMinimumSize(d);
	}

/*
	Rough sketch of layout

	MENU BAR
    Buttons x x x                                     ****
	*********************** ******************* ***********
	*  Leftbox			  * * Right box		  * *		  *
	*********************** ******************* *		  *
											    *		  *
	******Feedback********* * Edge under mouse* * TABBED  *
	                                            * TABLE   *
	******************************************* *		  *
	*										  * *		  *
	*	    			DIAGRAM				  * *		  *
	*										  * *		  *
	******************************************* ***********
*/

	protected void genMainGUI(int diagramPercentWidth, int diagramPercentHeight) 
	{
		int			width, height;
		int			w, h;
		Dimension	d, min;

		width  = m_contentPane.getWidth();
		height = m_contentPane.getHeight();
		min    = new Dimension(100,50);

		if (diagramPercentWidth > 0 && diagramPercentHeight > 0) {
			// Specifies as percentages of total width x total height size of diagram
			m_secondSplitRatio = (double) (1.0 - (diagramPercentHeight/100.0));
			m_mainSplitRatio   = (double) (diagramPercentWidth / 100.0);
		}
			
//		System.out.println("LandscapeViewerCore width=" + width + " height=" + height);

		m_contentPane.setVisible(false);

		// Handle the tool bar

		if (getNumToolButtons() > 0 || m_lsDropDown != null) {
			m_toolBar = new JToolBar();
			m_toolBar.setRollover(true);
			if (m_lsDropDown != null) {
				m_toolBar.add(m_lsDropDown);
			} 
			for (int i = 0; i< getNumToolButtons() ; ++i) {
				 m_toolBar.add(toolButton[i]);
			}
			m_toolBar.setFloatable(false);
			m_toolBar.setSize(width-2*GAP, ToolBarButton.HEIGHT);
			m_contentPane.add(m_toolBar, BorderLayout.NORTH);		
		}

		// Handle the informational display above the diagram

		{
			w = (int) ((width  * m_mainSplitRatio) / 2.0);
			h = (int) (height * m_secondSplitRatio);

			d = new Dimension(w, h);

			m_leftPanel        = new JPanel(new BorderLayout());
//			m_leftPanel.setMinimumSize(min);
			m_leftPanel.setPreferredSize(d);
			m_leftPanel.setVisible(true);

			m_leftTextBoxTitle = new JLabel();
			m_leftTextBoxTitle.setBackground(Diagram.boxColour);
			m_leftTextBoxTitle.setForeground(TextBox.titleColor);
			m_leftTextBoxTitle.setFont(TextBox.m_titleFont);
			m_leftTextBoxTitle.setSize(w, 20);
			m_leftPanel.add(m_leftTextBoxTitle, BorderLayout.NORTH);
			m_scrollLeftTextBox = new JScrollPane();
			m_leftTextBox = new TextBox(this, m_scrollLeftTextBox, m_leftTextBoxHelp);
			m_leftTextBox.setSize(w, h-40);
			m_scrollLeftTextBox.setSize(w, h-40);
			m_leftPanel.add(m_scrollLeftTextBox,BorderLayout.CENTER);
			m_feedback = new Feedback(this, m_feedbackHelp);
			m_feedback.setSize(w, 20);
			m_leftPanel.add(m_feedback, BorderLayout.SOUTH);


			m_rightPanel       = new JPanel(new BorderLayout());
//			m_rightPanel.setMinimumSize(min);
			m_rightPanel.setPreferredSize(d);
			m_rightPanel.setVisible(true);


			m_rightTextBoxTitle = new JLabel();
			m_rightTextBoxTitle.setBackground(Diagram.boxColour);
			m_rightTextBoxTitle.setForeground(TextBox.titleColor);
			m_rightTextBoxTitle.setFont(TextBox.m_titleFont);
			m_rightTextBoxTitle.setSize(w,20);
			m_rightPanel.add(m_rightTextBoxTitle, BorderLayout.NORTH);
			m_scrollRightTextBox = new JScrollPane();
			m_rightTextBox = new TextBox(this, m_scrollRightTextBox, m_rightTextBoxHelp);
			m_rightTextBox.setSize(w, h-40);
			m_scrollRightTextBox.setSize(w, h-40);
			m_rightPanel.add(m_scrollRightTextBox, BorderLayout.CENTER);
			m_nameBox  = new Feedback(this, m_nameBoxHelp);
			m_nameBox.setSize(w, 20);
			m_rightPanel.add(m_nameBox, BorderLayout.SOUTH);

			computeMinInfoHeight();

			m_thirdSplitPane = new MySplitPane(JSplitPane.HORIZONTAL_SPLIT, m_leftPanel, m_rightPanel);
			m_thirdSplitPane.setOneTouchExpandable(true);
			m_thirdSplitPane.setDividerLocation(m_thirdSplitRatio);
		}

		// Handle the scroll diagram

		{
			h = height - h - ToolBarButton.HEIGHT;
			w = (int) (width  * m_mainSplitRatio);

			m_scrollDiagram = new JScrollPane(); 

			m_scrollDiagram.setSize(w, h);

			m_secondSplitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, m_thirdSplitPane, m_scrollDiagram);
			m_secondSplitPane.setOneTouchExpandable(true);
			m_secondSplitPane.setDividerLocation(m_secondSplitRatio);
		}

		// Handle the right tabs

		{
			w = (int) (width  -  width * m_mainSplitRatio);
			h = height - ToolBarButton.HEIGHT;

			m_rightTabbedPane = new RightTabbedPane();

			m_legendBox = new LegendBox(this, m_rightTabbedPane);
			m_mapBox    = new MapBox(this, m_rightTabbedPane);
			m_queryBox  = new QueryBox(this, m_rightTabbedPane);
			m_resultBox = new ResultBox(this, m_rightTabbedPane);
			m_tocBox    = new TextTree(this, m_rightTabbedPane);

			d = new Dimension(w, h);

			m_legendBox.setSize(d);
			m_mapBox.setSize(d);
			m_queryBox.setSize(d);
			m_resultBox.setSize(d);
			m_tocBox.setSize(d);
			m_rightTabbedPane.setSize(d);

			m_legendBox.setPreferredSize(d);
			m_mapBox.setPreferredSize(d);
			m_queryBox.setPreferredSize(d);
			m_resultBox.setPreferredSize(d);
			m_tocBox.setPreferredSize(d);
			m_rightTabbedPane.setPreferredSize(d);

			m_legendBox.activate();
		}
		m_secondSplitPane.setMinimumSize(min);
		m_rightTabbedPane.setMinimumSize(min);

		m_mainSplitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, m_secondSplitPane, m_rightTabbedPane);
		m_mainSplitPane.setOneTouchExpandable(true);
		m_mainSplitPane.setSize(width, height-ToolBarButton.HEIGHT);
		m_mainSplitPane.setDividerLocation(m_mainSplitRatio);

		m_contentPane.add(m_mainSplitPane, BorderLayout.CENTER);

		m_contentPane.setVisible(true);
 	}

	protected void genModeHandlers() 
	{
		m_modeHandler = new ViewModeHandler();

		m_modeHandler.init(this);
	}

	protected void genGUI(int diagramPercentWidth, int diagramPercentHeight) 
	{
		genMainGUI(diagramPercentWidth, diagramPercentHeight);
	}

	protected void setLeftBox() 
	{
		if (m_diagram != null) {
			EntityInstance root = m_diagram.getDrawRoot();
			String label = root.getLabel();
			String title = root.getTitle();
			String desc  = root.getDescription();
			String topline;

			if (desc == null) {
				if (root.getContainedBy() == null) {
					desc = "The " + label + " landscape.";
				} else {
					desc = "The " + label + " " + root.getEntityClass().getLabel();
			}	}

			if (title != null) {
				topline = title + " (" + label + ")";
			} else {
				topline = label;
			}
			m_leftTextBoxTitle.setText(topline);
			m_leftTextBox.set(desc);
		}
	}

	protected void about() 
	{
		if (aboutURL != null) {
			showURL(aboutURL, LsLink.TARGET_FRAME);
		}
	}

	protected void help() 
	{
		if (helpURL != null) {
			showURL(helpURL, LsLink.TARGET_HELP);
		}
	}

	protected void setVisibility(JComponent bd, boolean state) 
	{
		if (bd != null) {
			bd.setVisible(state);
		}
	} 

	protected void readyMsg() 
	{
		doFeedback(getTitle() + " " + Version.MAJOR + "." + Version.MINOR + " (build " + Version.BUILD + ") Started.");
	}

	protected static final String indAdd = "  ";

	// Called to initialize applet component

	protected void init_core(int diagramPercentWidth, int diagramPercentHeight) 
	{
		m_contentPane.setBackground(Color.lightGray);
//		m_contentPane.setBackground(Color.GREEN);

		// Generate fonts

		EntityInstance.generateFonts();

		// We must generate the mode handlers before the Diagram
		genModeHandlers();
		genGUI(diagramPercentWidth, diagramPercentHeight);

		m_diagram = new Diagram(this, true /* Make backup */);
		initialLoad();
		showInfo("");
	}

	// Called as super from LandscapeEditorCore.initialLoad()
	// Called from LandscapeViewerCore.start()

	protected void initialLoad() 
	{
		if (lsPath == null) {
			MsgOut.dprintln("Empty landscape");
			if (m_leftTextBox != null) {
				m_leftTextBoxTitle.setText("Empty Landscape");
				m_leftTextBox.set("Select 'Open landscape' from 'File' menu to load a new landscape.");
			}
			readyMsg();
		} else if (m_diagram != null) {

			MsgOut.dprintln("Load: " + lsPath);

			String rc = m_diagram.loadDiagram(lsPath, lsPath_bg, null);

			if (rc != null) {
				error("Load failed (" + rc + ") for: " + lsPath);
				System.out.println("Load failed (" + rc + ") for: " + lsPath);
			} else {
				m_diagram.prepostorder();
				setDiagram(m_diagram);
				if (startEntity == null) {
					m_diagram.navigateTo();
				} else {
					EntityInstance e = (EntityInstance) m_diagram.getEntity(startEntity);
					if (e == null) {
						error("Entity not found: '" + startEntity + "'");		// IJD
					} else {
						m_diagram.setPreserveEntityMarks(0);
						m_diagram.setPreserveRelationMarks(0);
						m_diagram.navigateTo(e);
				}	}
				setLeftBox();
				readyMsg();
		}	}

		if (m_rightTabbedPane != null && m_rightTabbedPane.isVisible()) {
			m_legendBox.activate();
		}

		requestFocus();

		setDirectEdge();
		if (m_diagram != null) {
			switch(m_diagram.getEdgeMode()) {
			case Do.BEST_EDGE:
				setBestEdge();
				break;
			case Do.TB_EDGE:
				setTbEdge();
				break;
		}	}
	}

	protected void goTo(Vector res) 
	{
		Enumeration en;
		
		doFeedback("");

		m_diagram.clearFlags();

		EntityInstance e  = (EntityInstance) res.elementAt(0);
		EntityInstance pe = e.getContainedBy();

		for (en = res.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.setRedBoxFlag();
		}
		
		m_diagram.setPreserveEntityMarks(EntityInstance.REDBOX_MARK);
		m_diagram.setPreserveRelationMarks(0);

		if (pe != m_diagram.getDrawRoot()) {
			m_diagram.navigateTo(pe);
		}

		SortVector.byString(res);
		showResults("FIND RESULTS:", res);
		setLeftBox();
		m_rightTextBoxTitle.setText("");
		m_rightTextBox.set("");
		redrawDg();
	}

	protected Find findResults = null;


	// Called by Cntl F

	protected void find() 
	{
		Pattern pattern = FindBox.Create(m_frame, "Find Landscape Entities");

		if (pattern != null) {

			findResults = new Find(pattern, m_diagram.getRootInstance());

			if (findResults.foundCount() > 0) {
				goTo(findResults.firstResult());
				if (findResults.haveNextResult()) {
					m_rightTextBox.set("Use F3 to step forward through layers found and F2 to step back");
				}
			} else {
				error("No entities found which match search pattern.");
			}
		}
	}

	// Called by Cntl.F3

	protected void findNext() 
	{
		if (findResults == null) {
			error("No search has occured.");
		} else if (findResults.foundCount() == 0) {
			error("No search results.");
		} else {
			Vector result = findResults.nextResult();
			if (result == null) {
				error("No more results available.");
			} else {
				goTo(findResults.nextResult());
		}	}
	}

	// Called by Cntl.F2

	protected void findPrev() 
	{
		Vector result;

		if (findResults == null) {
			error("No search has occured.");
		} else if (findResults.foundCount() == 0) {
			error("No search results.");
		} else {
			result = findResults.prevResult();
			if (result == null) {
				error("At first result.");
			} else {
				goTo(result);
		}	}
	}

	// --------------
	// Public methods 
	// --------------

	public LandscapeViewerCore()
	{
		super();
	}

	public void init_app(JFrame af, JApplet applet, int diagramPercentWidth, int diagramPercentHeight) 
	{
		this.af      = af;
		m_applet     = applet;
		init_core(diagramPercentWidth, diagramPercentHeight);
	}

	protected void setDiagram(Diagram diagram) 
	{
//		System.out.println("LandscapeViewerCore.setDiagram " + m_scrollDiagram.getBounds());

		m_diagram = diagram;
		if (diagram != null) {
			diagram.setVisible(true);
			if (m_modeHandler != null) {
				diagram.setModeHandler(m_modeHandler);
		}	}
		if (m_tocBox != null) {
			if (!isTocHidden()) {
				// Force a refresh is TOC_HIDDEN_DEFAULT=false
				setTocHidden(true);
			}
			setTocHidden(TOC_HIDDEN_DEFAULT);
			if (m_tocBox.isVisible()) {
				m_tocBox.repaint();
		}	}
		if (m_legendBox != null) {
			m_legendBox.fillLegendBox();
		}
		if (m_queryBox != null) {
			m_queryBox.fillQueryBox();
		}
		if (m_rightTabbedPane != null) {
			m_rightTabbedPane.validate();
		}
		m_scrollDiagram.setViewportView(diagram);
	}

	public String getParameter(String name) 
	{
		if (m_applet != null) {
			return m_applet.getParameter(name);
		} else {
			return System.getProperty(name);
	}	}

	public void repaintDg()
	{
		m_diagram.revalidate();
		if (m_mapBox.isActive()) {
			m_mapBox.revalidate();
		}
	}

	public void redrawDg() 
	{
		waitCursorOn();
		m_diagram.redrawDiagram();
		waitCursorOff();
	}

	protected boolean isReadWrite() 
	{
		return false;	// No write with viewer
	}

	public void showURL(String urlName, int target) 
	{
		MsgOut.vprintln("URL: " + urlName + " - target: " + target);

		try {
			URL newURL;
			
			if (m_applet != null) {
				newURL = new URL(m_applet.getDocumentBase(), urlName);
			} else {
				newURL = new URL(new URL("http://swag.uwaterloo.ca"), urlName);
			}
			// URLConnection urlCon = newURL.openConnection();
			// urlCon.connect();

			switch(target) {
			case LsLink.TARGET_TOP:
				ac.showDocument(newURL, "_top");
				break;
			case LsLink.TARGET_HELP:
				ac.showDocument(newURL, "_blank");
				break;
			case LsLink.TARGET_FRAME:
				ac.showDocument(newURL, "Map");
				break;
			case LsLink.TARGET_LIST:
				ac.showDocument(newURL, "List");
				break;
			}
		}
		catch (MalformedURLException ex) 
		{
			MsgOut.println("Malformed URL: " + urlName);
		} 
		catch (IOException ex) {
			MsgOut.println("Couldn't access URL: " + urlName);
		}
	}

	public void showResults(String title, Vector v, boolean activateBox) 
	{
		m_resultBox.setResultTitle(title);

		if (v.size() > 0) {
			Enumeration		en;
			EntityInstance	e;

			for (en = v.elements(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				m_resultBox.addResultEntity(e);
			}
		} else {
			m_resultBox.addText("No entities");
		}
/*		if (activateBox) {
			m_resultBox.activate();
		}
*/
		m_resultBox.validate();
	}

	public void showResults(String title, Vector v) 
	{
		showResults(title, v, true);
	}

	public void doFeedback(String str) 
	{
		if (m_feedback != null) {
			m_feedback.set(str);
	}	}



	public void showInfo(String str) 
	{
		if (m_nameBox != null) {
			m_nameBox.set(str);
	}	}


	public void error(String msg) 
	{
		doFeedback(msg);
		System.out.print("\007");
		System.out.flush();
	}

	public void clearFeedback() 
	{
		m_feedback.set("");
	}

	protected String filePrompt(String banner, String default_file, int mode) 
	{
		File	file;
		String	name;
		int	ret;

		JFileChooser fd = new JFileChooser();

		fd.setDialogTitle(banner);
		fd.setFileSelectionMode(JFileChooser.FILES_ONLY);
		if (default_file != null) {
			fd.setSelectedFile(new File(default_file));
		}

		if (mode == FA_LOAD) {
			ret = fd.showOpenDialog(m_contentPane);
		} else {
			ret = fd.showSaveDialog(m_contentPane);
		}
		if (ret == JFileChooser.APPROVE_OPTION) {
			file = fd.getSelectedFile();
			name = file.getAbsolutePath();
		} else {
			name = null;
		}
/*;
		if (name != null) {
			name = fd.getDirectory() + name;
		}
*/
		return name;
	}

	protected boolean modeHandlingActive = false;

	protected RelationInstance	m_currentEdge       = null;
	protected EntityInstance	m_currentDescEntity = null;

	protected void showDescription(RelationInstance ri, boolean showOpens)
	{
		if (ri != m_currentEdge) {
			EntityInstance	src, dst;
			String			info;

			m_currentEdge      = ri;
			currentNameEntity  = null;
			src                = ri.m_drawSrc;
			dst                = ri.m_drawDst;
			if (src == null) {
				info = "??null??";
			} else {
				info = Util.quoted(src.getLabel());
			}
			info += " " + ri.getRelationClass().getLabel() + "";
			if (dst == null) {
				info += "??null??";
			} else {
				info += Util.quoted(dst.getLabel());
			}
			showInfo(info);
		} 
	}

	protected void showDescription(EntityInstance e, boolean showOpens)
	{
		if (e != currentNameEntity) {
			currentNameEntity = e;
			m_currentEdge     = null;
			String str;

			if (e == null) {
				str = "";
			} else {
				EntityInstance pe = e.getEnterableParent();
				if (pe != null) {
					str = pe.getLabel() + " . " + e.getLabel();
				} else {
					str = e.getLabel();
				}
			}
			showInfo(str);
		}
		if (e != null) {

			if (m_currentDescEntity != e && (!e.isOpen() || showOpens) &&	e.getEntityClass() != null)	{
				String label = e.getLabel();
				String title = e.getTitle(); 
				String desc = e.getDescription();

				if (desc == null) {
					desc = "The " + e.getLabel() + " " + e.getEntityClass().getLabel() + ".";
				}
				String topline = " (" + e.getEntityClass().getLabel() + (e.hasChildren() ? " - " + e.numChildren() + " items)" : ")" );
				if (title != null) {
					topline = title + topline;
				} else {
					topline = label + topline;
				}
				m_rightTextBoxTitle.setText(topline);
				m_rightTextBox.set(desc);
				m_currentDescEntity = e;
		}	}
	}

	public void setTocHidden(boolean value)
	{
		if (isTocHidden() != value) {
			super.setTocHidden(value);
			if (m_tocBox != null) {
				m_tocBox.fillTOC();
	}	}	}

	public Vector getClipboard()
	{
		return(m_clipboard);
	}

	// The containment hierarchy in the diagram has changed
	// Recompute the TOC

	public void insertTOC(EntityInstance container, EntityInstance e)
	{
		if (!isTocHidden()) {
			m_tocBox.insertTOC(container, e);
	}	}

	public void deleteTOC(EntityInstance e)
	{
		if (!isTocHidden()) {
			m_tocBox.deleteTOC(e);
	}	}

	public void deleteJustMeTOC(EntityInstance e)
	{
		if (!isTocHidden()) {
			m_tocBox.deleteJustMeTOC(e);
	}	}

	public void newEntity(EntityInstance container)
	{
		doFeedback( "Landscape viewer may not create new Entities");
	}

	public void DeleteEntity(Object object) 
	{
		doFeedback( "Landscape viewer may not delete Entities");
	}

	public void moveEntityContainment(EntityInstance newparent, EntityInstance e)
	{
		if (newparent != e.getContainedBy()) {
			doFeedback( "Landscape viewer may not change containment hierarchy");
	}	}

	public void deleteContainer(EntityInstance e)
	{
		doFeedback( "Landscape viewer may not delete containers");
	}

	protected boolean testForClose() 
	{
		if (af == null) {
			return false;
		}
		return true;
	}

	// Keyboard event handling 

	public void processKey(int key, int modifiers, Object object) 
	{
		String str;
		EntityInstance e;

//		System.out.println("LandscapeViewerCore.processKey");

		if (modifiers == Event.CTRL_MASK) {
			switch (key) {
			case Do.QUIT_PROGRAM:
				if (testForClose()) {
					System.exit(0);
				}
				return;
			case Do.CLOSE:
				if (!testForClose()) {
					return;
				}
				if (m_openFrames == 1) {
					System.exit(0);
					return;
				}
				m_frame.setVisible(false);
				m_frame.dispose();
				m_openFrames--;
				return;			
			case Do.UNDO:
				// undo();
				return;
			case Do.REFRESH:
				validate();
				repaint();
				return;
			case Do.FIND_QUERY:
				find();
				return;
			case Do.SWITCH_TOC:
				if (m_tocBox != null) {
					m_tocBox.switch_TOC();
				}
				return;
			case Do.SET_TO_VIEWPORT:
				if (m_diagram.set_to_viewport()) {
					doFeedback( "Diagram set to viewport");
				}
				return;
			}
		} else if ((modifiers & Event.ALT_MASK) != 0) {
			switch(key) {
			case Do.QUERY_PERSIST:
			{
				boolean state = !isQueryPersist();
				setQueryPersist(state);
				doFeedback("Query persistence set to: " + (state ? "On" : "Off"));
				return;
			}
			case Do.BEST_EDGE:
				m_diagram.setEdgeMode(Do.BEST_EDGE_STATE);
				setBestEdge();
				navigateTo(m_diagram.getDrawRoot());
				doFeedback("Edge mode set to: best edge."); 
				return;
			case Do.TB_EDGE:
				m_diagram.setEdgeMode(Do.TB_EDGE_STATE);
				setTbEdge();
				navigateTo(m_diagram.getDrawRoot());
				doFeedback("Edge mode set to: top/bottom."); 
				return;
			case Do.DIRECT_EDGE:
				m_diagram.setEdgeMode(Do.DIRECT_EDGE_STATE);
				setDirectEdge();
				navigateTo(m_diagram.getDrawRoot());
				doFeedback("Edge mode set to: direct."); 
				return;
			case Do.SHOW_DESC:
			{	
				boolean		show = !isShowDesc();

				setShowDesc(show);
				setVisibility(m_leftTextBoxTitle, show);
				setVisibility(m_scrollLeftTextBox, show);
				setVisibility(m_rightTextBoxTitle, show);
				setVisibility(m_scrollRightTextBox, show);
				computeMinInfoHeight();
//				m_leftPanel.revalidate();
//				m_rightPanel.revalidate();
				m_secondSplitPane.revalidate();
				
//				validate();
//				repaint();
				return;
			}
			case Do.SHOW_FB:
			{
				boolean show = !isShowFeedback();

				setShowFeedback(show);
				setVisibility(m_feedback, show);
				setVisibility(m_nameBox,  show); 
				computeMinInfoHeight();
//				m_leftPanel.revalidate();
//				m_rightPanel.revalidate();
				m_secondSplitPane.revalidate();

//				validate();
//				repaint();
				return;
			}
			case Do.SHOW_CLIENTS:
			{
				boolean show = !isShowClients();

				setShowClients(show);
				navigateTo(m_diagram.getDrawRoot());
				return;
			}
			case Do.SHOW_SUPPLIERS:
			{
				boolean show = !isShowSuppliers();

				setShowSuppliers(show);
				navigateTo(m_diagram.getDrawRoot());
				return;
			}
			case Do.TOP_CLIENTS:
				setTopClients(!isTopClients());
				navigateTo(m_diagram.getDrawRoot());
				return;
			case Do.SHOW_CARDINALS:
			{
				boolean show = !isShowCardinals();

				setShowCardinals(show);
				m_diagram.redrawDiagram();
				return;
			}
			case Do.USE_COMPACTION:
			{
				boolean use = !isUseCompaction();
				setUseCompaction(use);
				m_diagram.redrawDiagram();
				return;
			}
			case Do.SHOW_TOC:
				m_tocBox.activate();
				return;
			case Do.LEGEND_TAB:
				m_legendBox.activate();
				return;
			case Do.MAP_TAB:
				m_mapBox.activate();
				return;
			case Do.QUERY_TAB:
				m_queryBox.activate();
				return;
			case Do.RESULT_TAB:
				m_resultBox.activate();
				return;
			case Do.FIX_SCROLLBARS:
			{
				boolean state;

				state = !isFixScrollBars();
				setFixScrollBars(state);
				if (state) {
					m_scrollDiagram.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
					m_scrollDiagram.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
					doFeedback("Diagram scroll bars permanently enabled");
				} else {
					m_scrollDiagram.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
					m_scrollDiagram.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
					doFeedback("Diagram scroll bars will appear as needed");
				}
				return;
			}
			case LEFT_TABBOX:
			{
				boolean		state;
				JComponent	left, right;
				Dimension	min;
				int			divider;

				state = !isLeftTabbox();
				setLeftTabbox(state);
				
				m_mainSplitPane.setLeftComponent(null);
				m_mainSplitPane.setRightComponent(null);

				if (state) {
					left    = m_rightTabbedPane;
					right   = m_secondSplitPane;
				} else {
					left    = m_secondSplitPane;
					right   = m_rightTabbedPane;
				}
				divider = left.getWidth();

				min    = new Dimension(100,50);
				left.setMinimumSize(min);
				right.setMinimumSize(min);
				m_mainSplitPane.setLeftComponent(left);
				m_mainSplitPane.setRightComponent(right);
				m_mainSplitPane.setDividerLocation(divider);

//				If either min width is zero slider won't move
//				System.out.println("Min " + m_mainSplitPane.getMinimumDividerLocation() + " Max " + m_mainSplitPane.getMaximumDividerLocation()); 

				return;
			}
			case Do.TOC_HIDDEN:
			{
				boolean show = !isTocHidden();

				setTocHidden(show);
				return;
			}
			case Do.TOC_PATH:
				if (m_tocBox != null) {
					m_tocBox.toc_path();
				}
				return;
			}
		} else if (modifiers == Event.SHIFT_MASK) {
			switch (key) {
			case Do.TOGGLE_RELATION_ALL:
			case Do.TOGGLE_RELATION_1:
			case Do.TOGGLE_RELATION_2:
			case Do.TOGGLE_RELATION_3:
			case Do.TOGGLE_RELATION_4:
			case Do.TOGGLE_RELATION_5:
			case Do.TOGGLE_RELATION_6:
			case Do.TOGGLE_RELATION_7:
			case Do.TOGGLE_RELATION_8:
			case Do.TOGGLE_RELATION_9:
				m_queryBox.activate();
				m_queryBox.toggleRelationActivity(key - Do.TOGGLE_RELATION_ALL);
				repaintDg();
				requestFocus();
				return;
			}
		} else if (modifiers == 0) { 
			switch(key) {
			case Do.FONT_CORRECTION:
			{
				boolean state;
				
				state = !isFontCorrection();
				setFontCorrection(state);
				doFeedback("Font adjustment set to " + (state ? "on" : "off") + "."); 
				repaint();
				return;  
			}
			case Do.CLEAR:
				m_diagram.clearFlags();
				doFeedback("Query/selection cleared");
				m_diagram.setPreserveEntityMarks(0);
				m_diagram.setPreserveRelationMarks(0);
				redrawDg();
				m_resultBox.clear();
				m_modeHandler.reset();
				return;
			case Do.GROUPING_FLAG:
				m_queryBox.toggleGroupingFlag();
				return;
			case Do.TOGGLE_LEGEND_ALL:
			case Do.TOGGLE_LEGEND_1:
			case Do.TOGGLE_LEGEND_2:
			case Do.TOGGLE_LEGEND_3:
			case Do.TOGGLE_LEGEND_4:
			case Do.TOGGLE_LEGEND_5:
			case Do.TOGGLE_LEGEND_6:
			case Do.TOGGLE_LEGEND_7:
			case Do.TOGGLE_LEGEND_8:
			case Do.TOGGLE_LEGEND_9:
				m_legendBox.activate();
				m_legendBox.toggleRelationVisibility(key - Do.TOGGLE_LEGEND_ALL);
				redrawDg();
				requestFocus();
				return;
			case Do.FIND_PREV:
				findPrev();
				return;
			case Do.FIND_NEXT:
				findNext();
				return;
			case Do.ABOUT_PROGRAM:
				JOptionPane.showMessageDialog(m_frame, 	getTitle() + " " + Version.Details(), "About " + getTitle(), JOptionPane.OK_OPTION);
				return;
			case Do.ABOUT_URL:
				about();
				return;
			case Do.HELP_URL:
				help();
				return;
		}	}
		if (m_modeHandler != null) {
			m_modeHandler.processKey(key, modifiers, object);
		}
	} // end processKey	  


	public void dialogAction(Object[] results, int type) 
	{
		// Null
	}

	protected void sleep(int ms) 
	{
		try {
			Thread.sleep(ms);
		} catch(Exception e) {
		}
	}

	static protected int EC_CNT = 40;


	protected void navigateTo(EntityInstance e) 
	{
		EntityInstance oldRoot = m_diagram.getDrawRoot();

		m_diagram.setPreserveEntityMarks(0);
		m_diagram.setPreserveRelationMarks(0);

		m_diagram.navigateTo(e);
		setLeftBox();
		m_diagram.clearFlags();
		m_rightTextBoxTitle.setText("");
		m_rightTextBox.set("");
//		m_resultBox.clear();
//		m_mapBox.activate();
		doFeedback("Now showing: " + e.getLabel());
		validate();		
	}

	public void followLink(String url, int target) 
	{
		showURL(url, target);
	}

	public void followLink(EntityInstance e, boolean newViewer) 
	{
		Attribute attr = e.getLsAttribute(EntityInstance.LINK_ID);
		AttributeValueItem avi;

		m_diagram.setPreserveEntityMarks(0);
		m_diagram.setPreserveRelationMarks(0);

		if (attr == null) {
			// This seems to be the case when going down.
			navigateTo(e);
			return;
		}

		avi = attr.avi;
		if (avi == null) {
		   // This seems to be the case when going up
		   /* [irbull] if avi is null, just use the navigate to? */
			navigateTo(e);
			return;
		}

		for (; avi != null; avi = avi.nextList) {
			String file = LsLink.expand(avi.value, e, this);
			if (file != null) {
				if (newViewer) {
					followLink(file, LsLink.TARGET_NEW);
				} else if (attr.avi.next != null) {
					String tgtStr = Util.expand(avi.next.value, this);
					int target = LsLink.convertTarget(tgtStr);
					if (target == LsLink.TARGET_APP) {
						// Eventually the link name should be resolved
						// we may want to allow a navigate on one 
						// entity to go to another
						navigateTo(e);
					} else {
						followLink(file, target);
					}
				} else {
					error("No target: " + attr.avi.value);
		}	}	}
	}

	protected void doSetCursor(int cursor) 
	{
		if (m_frame != null) {
			m_frame.setCursor(cursor);
	}	}

	private int curCursor          = Cursor.DEFAULT_CURSOR;
	private int m_anticipateCursor = Cursor.DEFAULT_CURSOR;

	protected boolean waitActive = false;


	public void setFrame(JFrame frame)
	{
		m_frame       = frame;
		m_contentPane = frame.getContentPane();
	}

	public JFrame getFrame()
	{
		return(m_frame);
	}

	public JPanel getContentPane()
	{
		return((JPanel) m_contentPane);
	}

	public Diagram getDiagram() 
	{
		return m_diagram;
	}

	public TextTree getTocBox() 
	{
		return 	m_tocBox;
	}

	public LegendBox getLegendBox() 
	{
		return 	m_legendBox;
	}

	public MapBox getMapBox()
	{
		return m_mapBox;
	}

	public QueryBox getQueryBox()
	{
		return m_queryBox;
	}

	public ResultBox getResultBox()
	{
		return m_resultBox;
	}

	public void add(JComponent c)
	{
		m_contentPane.add(c);
	}

	public void repaint()
	{
		m_contentPane.repaint();
	}

	public void validate()
	{
		m_contentPane.validate();
	}

	public void requestFocus()
	{
		m_contentPane.requestFocus();
	}

	public Graphics getGraphics()
	{
		return(m_contentPane.getGraphics());
	}

	public int getHeight()
	{
		return(m_contentPane.getHeight());
	}

	public void setCursor(int cursor) 
	{
//		System.out.println("setCursor " + cursor + " waitActive=" + waitActive);
		if (curCursor != cursor) {
			curCursor = cursor;
			if (!waitActive) {
				doSetCursor(cursor);
		}	}
	}

	public void resetAnticipateCursor()
	{
		m_anticipateCursor = Cursor.DEFAULT_CURSOR;
	}

	public void setAnticipateCursor(int cursor)
	{
		m_anticipateCursor = cursor;
	}

	public void useAnticipateCursor()
	{
		setCursor(m_anticipateCursor);
	}

	public void waitCursorOn() 
	{
		if (!waitActive) {
			waitActive = true;
			doSetCursor(Cursor.WAIT_CURSOR);
		}
	}

	public void waitCursorOff() 
	{
		if (waitActive) {
			waitActive = false;
			doSetCursor(curCursor);
		}
	}

	public void processKeyEvent(int key, int modifiers, Object object) 
	{
//		System.out.println("Process Key seen");

		if (key <= KeyEvent.VK_Z) {
			if (key >= KeyEvent.VK_A) {
				if ((modifiers & Event.SHIFT_MASK) != 0) {
					// Keep character as upper case but remove shift
					modifiers &= ~Event.SHIFT_MASK;
				} else {
					// Convert to lower case
					key += 'a' - KeyEvent.VK_A;
			}	}
		} else if ((key >= KeyEvent.VK_F1 && key <= KeyEvent.VK_F12) && (modifiers & (Event.ALT_MASK|Event.CTRL_MASK)) == 0) {
			key += Do.FUNCTION_KEY;
		}	
		processKey(key, modifiers, object);
	}

	public boolean isViewer() 
	{
		return true;
	}

	public boolean getGroupQueryFlag() 
	{
		return m_queryBox.getGroupingFlag();
	}

	public void setRightTextBox(String title, String description)
	{
		m_rightTextBoxTitle.setText(title);
		m_rightTextBox.set(description);
	}

	public InternalBufferStream getInternalBufferStream() {
/*
		return (new InternalBufferStream(TA_SRC.intTable, TA_SRC.doubleTable, TA_SRC.stringTable));
*/
		return null;
	}

	public Enumeration enumEntityClasses() {

		return m_diagram.enumEntityClasses(); 
	}

	public Enumeration enumEntityClassesInOrder() {

		return m_diagram.enumEntityClassesInOrder(); 
	}

	public void toggleRelation(RelationClass rc)
	{
		if (rc != null) {
			boolean ns = !rc.isActive();
			rc.setActiveState(ns);
			doFeedback("Relation " + rc.getLabel() + " set to " + (ns ? "active" : "inactive"));
	}	}

	public void toggleVisibility(RelationClass rc)
	{
		if (rc != null) {
			boolean ns = !rc.isClassVisible();
			rc.setClassVisible(ns);
			doFeedback("Relation " + rc.getLabel() + " set to " + (ns ? "shown" : "hidden"));
	}	}

	public JApplet getApplet()
	{
		return(m_applet);
	}

	int getDiagramX()
	{
		return(m_scrollDiagram.getX());
	}

	int getDiagramY()
	{
		return(m_scrollDiagram.getY());
	}
}



