package lsedit;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.*;
import java.util.*;

// This handler is strictly concerned with moving the I/O points

public class MoveModeHandler extends LandscapeModeHandler
{
	protected EdgePoint m_ept;

	// IO points

	protected RealPoint getFactors(int x, int y) 
	{
		// Can only have factors along edges 
		// Find closest edge and calculate new width and height factors

		Rectangle lyt = m_ept.getEntity().getDiagramBounds();

		double xp = x;
		double yp = y;

		double dl = Math.abs(xp - lyt.x);
		double dr = Math.abs(xp - (lyt.x + lyt.width));
		double dt = Math.abs(yp - lyt.y);
		double db = Math.abs(yp - (lyt.y + lyt.height));

		double wf, hf;

		if (dl < dr) {
			if (dt < db) {
				if (dt < dl) {
					// Top
					wf = (xp - lyt.x)/lyt.width;
					hf = 0.0;
				} else {
					// Left
					wf = 0.0;
					hf = (yp - lyt.y)/lyt.height;
				}
			} else if (db < dl) {
				// Bottom
				wf = (xp - lyt.x)/lyt.width;
				hf = 1.0;
			} else {
				// Left
				wf = 0.0;
				hf = (yp - lyt.y)/lyt.height;
			}
		} else {
			if (dt < db) {
				if (dt < dr) {
					// Top
					wf = (xp - lyt.x)/lyt.width;
					hf = 0.0;
				} else {
					// Right
					wf = 1.0;
					hf = (yp - lyt.y)/lyt.height;
				}
			} else if (db < dr) {
				// Bottom
				wf = (xp - lyt.x)/lyt.width;
				hf = 1.0;
			} else {
				// Right
				wf = 1.0;
				hf = (yp - lyt.y)/lyt.height;
			}
		}

		wf = Math.max(0.0, Math.min(1.0, wf));	// Normalize
		hf = Math.max(0.0, Math.min(1.0, hf));
		return new RealPoint(wf, hf);
	}

	protected boolean moveIOStart(int x, int y)
	{
		m_ls.setCursor(Cursor.CROSSHAIR_CURSOR);
		m_ls.redrawDg();
		RealPoint factors = getFactors(x, y);
		m_ls.doFeedback("I/O point at factors (" + factors.getX() + ", " + factors.getY() + ")");
		return true;
	}

	protected void moveIOMotion(int x, int y) 
	{
		RealPoint factors = getFactors(x, y);

		m_ls.setCursor(Cursor.CROSSHAIR_CURSOR);

		m_ept.m_wf = factors.getX();
		m_ept.m_hf = factors.getY();
		m_ept.isDefault = false;
		m_ept.rescale();		/// Recompute where the edge point now is in the diagram

		m_ls.doFeedback("I/O point at factors (" + m_ept.getX() + "/" + factors.getX() + ", " + m_ept.getY() + "/" + factors.getY() + ")");
	}

	protected void moveIOEnd(MouseEvent ev)
	{
		m_ls.redrawDg();
	}

	// --------------
	// Public methods
	// --------------

	public MoveModeHandler() 
	{
	}

	public boolean entityPressed(MouseEvent ev, EntityInstance e, int x, int y) 
	{
//		System.out.println("MoveModeHandler entityPressed\n");
		m_ept   = null;
		return false;
	}

	public boolean relationPressed(MouseEvent ev, RelationInstance ri, int x, int y)
	{
//		System.out.println("MoveModeHandler relationPressed\n");
		m_ept    = null;

		if (!m_ls.isViewer()) {
			m_ept = ri.mouseOverEdgePoint(x, y);
			if (m_ept != null) {
				moveIOStart(x, y);
				return true;
			} 
		}
		return false;
	}

	public boolean relationDragged(MouseEvent ev, RelationInstance ri, int x, int y) 
	{
		if (m_ept != null) {
			moveIOMotion(x, y);
		} 
		return true;
	}

	public void relationReleased(MouseEvent ev, RelationInstance ri, int x, int y) 
	{
		m_ls.clearFeedback();
		if (m_ept != null) {
			moveIOEnd(ev);

	}	} 

}

