package lsedit;

import java.awt.event.*;
import java.util.*;

// This is the handler used if CTRL is pressed when mouse down occurs

public class NavigateModeHandler extends LandscapeModeHandler
{
	protected boolean m_highLight;		   
	protected boolean m_middleButton;

	protected final static String titleStr = "Navigate mode options";
	protected final static String helpStr = "Left - Enter (in viewer)\nCtrl+Left Exit\nMiddle - Enter (new viewer)";

	// --------------
	// Public methods
	// --------------

	public NavigateModeHandler() 
	{
	}

	public boolean entityPressed(MouseEvent ev, EntityInstance e, int x, int y) 
	{
//		System.out.println("NavigateModeHandler entityPressed\n");

		m_middleButton = ev.isAltDown();
		if (e.isClickable()) {
			e.drawHighlight();
			m_highLight = true;
		} else {
			m_highLight = false;
		}
		return m_highLight;
	}

	// Consider the thing pressed (not dragged) when still inside it
	
	public boolean entityDragged(MouseEvent ev, EntityInstance e, int x, int y) 
	{
		if (m_highLight) {
			if (!e.containsDiagramPoint(x, y)) {
				e.undrawHighlight();
				m_highLight = false;
			}
		} else {
			if (e.containsDiagramPoint(x, y)) {
				e.drawHighlight();
				m_highLight = true;
			}
		}	
		return true;
	}

	public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y) 
	{
//		System.out.println("NavigateModeHandler entityReleased e=" + e);

		if (m_highLight) {
			m_ls.followLink(e, m_middleButton);
	}	}
}

