package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

public class QueryBox extends JComponent
{
	protected static final int	MARGIN = 5;

	class ActiveRelnChkBox extends RelnChkBox /* extends JCheckBox */ implements ItemListener
	{
		public ActiveRelnChkBox(LandscapeViewerCore ls, RelationClass rc,  int index) 
		{
			super(ls, rc, index);

			setSelected(isActive());
			addItemListener(this);
		}

		public boolean isActive()
		{
			return(m_rc.isActive());
		}

		public void setActive(boolean value)
		{
			if (m_rc.isActive() != value) {
				m_rc.setActiveState(value);
				setSelected(isActive());
				repaint();
		}	}

		public void itemStateChanged(ItemEvent ev)
		{
			getLs().toggleRelation(m_rc);
	}	}

	protected class GrpChkBox extends JCheckBox implements ItemListener
	{
		protected LandscapeViewerCore m_ls;

		GrpChkBox(LandscapeViewerCore ls, String label)
		{
			super(label);
			m_ls = ls;
			addItemListener(this);
		}

		protected void grpStateInfo() 
		{
			m_ls.doFeedback("Entities " + (isSelected() ? "are" : "aren't") + " grouped with queries");
		}

		public void itemStateChanged(ItemEvent ev)
		{
			grpStateInfo();
			m_ls.requestFocus();
	}	}

	protected static final Font textFont    = new Font("Helvetica", Font.PLAIN, 11); 
	protected static final Font	titleFont  = new Font("Helvetica", Font.BOLD,  12);

	public    static final String m_helpStr = "This box shows the relations which are active during queries";

	protected static final int SB_WIDTH = 12;
	protected static final int GAP = 5; 

	protected LandscapeViewerCore   m_ls;
	protected JTabbedPane			m_tabbedPane;
	protected JScrollPane			m_scrollPane;

	// Objects used in layout

	protected JLabel				m_ulabel;
	protected JLabel				m_footer1;
	protected JLabel				m_footer2;

	protected int					m_width;
	protected int					m_height;

	protected GrpChkBox				m_grpChk;

	// --------------
	// Public methods 
	// --------------

	public QueryBox(LandscapeViewerCore ls, JTabbedPane tabbedPane) 
	{
		m_ls         = ls;
		m_tabbedPane = tabbedPane;

		setBackground(Diagram.boxColour);

		m_ulabel = new JLabel("Relations");
		m_ulabel.setFont(titleFont);
		m_ulabel.setForeground(Color.black);
		m_ulabel.setBackground(Diagram.boxColour);

		m_footer1 = new JLabel("Checkboxes select active relations.");
		m_footer1.setFont(textFont);
		m_footer1.setForeground(Color.black);
		m_footer1.setBackground(Diagram.boxColour);

		m_footer2 = new JLabel("Click relation arrow for description.");
		m_footer2.setFont(textFont);
		m_footer2.setForeground(Color.black);
		m_footer2.setBackground(Diagram.boxColour);


		m_grpChk = new GrpChkBox(m_ls, "Group with queries");
		m_grpChk.setFont(textFont);
		m_grpChk.setForeground(Color.black);
		m_grpChk.setBackground(Diagram.boxColour);

		setToolTipText(m_helpStr);
		m_scrollPane = new JScrollPane();
		m_scrollPane.setViewportView(this);
		tabbedPane.addTab("Queries", null, m_scrollPane, m_helpStr);	
	}

	public boolean isActive() 
	{
		Component active;

		if (!isVisible()) {
			return(false);
		}
		active = m_tabbedPane.getSelectedComponent();
		return(active != null && this == active);
	}	

	public void activate() 
	{
		m_tabbedPane.setSelectedComponent(m_scrollPane);
	}

	protected void add(JComponent component, int space)
	{
		Dimension	d;
		int			width, height;

		m_height += space;
		d         = component.getPreferredSize();
		width     = d.width;
		height    = d.height;
		if (width > m_width) {
//			System.out.println("Width=" + width + " for " + component);
			m_width = width;
		}
		component.setBounds(MARGIN, m_height, width, height);
		super.add(component);
		m_height += height;
	}

	public void fillQueryBox() 
	{
		Diagram				dg;
		Enumeration			en;
		RelationClass		rc;
		String				id;
		Color				color;
		ActiveRelnChkBox	relnChk;
		int					n;
		Dimension			dimension;

		removeAll();

		m_width  = 0;
		m_height = 0;

		add(m_ulabel, 10);

		// Draw legend for relations

		dg = m_ls.getDiagram();
		if (dg != null) {
			n  = 0;
			for (en = dg.enumRelationClassesInOrder(); en.hasMoreElements(); ) {

				rc = (RelationClass) en.nextElement();
				id = rc.getId();

				if (!dg.excludeReln(rc)) {
					relnChk = new ActiveRelnChkBox(m_ls, rc, ++n);
					add(relnChk, 10);
		}	}	}

		add(m_footer1, 20);
		add(m_footer2);
		add(m_grpChk, 10);

		dimension = new Dimension(m_width, m_height);
		setPreferredSize(dimension);
		setBounds(0, 0, m_width, m_height);
	}

	public void toggleRelationActivity(int key) 
	{
		int				cnt = getComponentCount();
		int				i;
		Component		c;
		boolean			ns;

		if (key == 0) {
			ns = true;
			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ActiveRelnChkBox) {
					if ( ((ActiveRelnChkBox) c).getIndex() == 1) {
						// Set everything same way as first
						ns = !((ActiveRelnChkBox) c).isActive();
						break;
			}	}	}

			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ActiveRelnChkBox) {
					if (((ActiveRelnChkBox) c).isActive() != ns) {
						((ActiveRelnChkBox) c).doClick();
			}	}	}
		} else {
			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ActiveRelnChkBox) {
					if (((ActiveRelnChkBox) c).getIndex() == key) {
						((ActiveRelnChkBox) c).doClick();
						break;
		}	}	}	}
	}

	public void toggleGroupingFlag() 
	{
		m_grpChk.doClick();
	}

	public boolean getGroupingFlag() 
	{
		return m_grpChk.isSelected();
	}
}

