package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

// Used by query and legend box

class RelnChkBox extends JCheckBox
{
	class ArrowIcon extends Object implements Icon
	{	
		protected static final int WIDTH  = 50;
		protected static final int HEIGHT = 20;
		protected static final int GAP    = 5; 

		private RelationClass m_rc;

		public ArrowIcon(RelationClass rc)
		{
			m_rc = rc;
		}
		
		public int getIconWidth()
		{
			return(WIDTH);
		}

		public int getIconHeight()
		{
			return(HEIGHT);
		}

		public void paintIcon(Component c, Graphics g, int x, int y) 
		{
			int		x1, y1, x2, y2;

			g.setColor(Color.black);

			x1 = x  + 2;
			y1 = y  + 2;
			x2 = x1 + 16;
			y2 = y1 + 16;

			g.drawRect(x1, y1, 16, 16); 

			if (!isSelected()) {
				g.setColor(Color.red);
				g.drawLine(x1+1,y1+1, x2-1, y2-1);
				g.drawLine(x1+1,y2-1, x2-1, y1+1);
			}
			x1  = x2 + GAP;
			y1  = y  + HEIGHT/2;
			x2  = x  + WIDTH - GAP;
			y2  = y1;

			g.setColor(m_rc.getObjectColor());
			Util.drawArrow(g, x1, y1, x2, y2);
		}
	}

	protected	LandscapeViewerCore m_ls;
	protected	RelationClass		m_rc;
	protected	int					m_index;

	public RelnChkBox(LandscapeViewerCore ls, RelationClass rc, int index) 
	{
		super(rc.getLabel() + " (" + index + ")");

		m_ls    = ls;
		m_rc    = rc;
		m_index = index;

		ArrowIcon arrow = new ArrowIcon(rc);

		setIcon(arrow);
		setToolTipText(rc.getDescription());
	}

	public int getIndex()
	{
		return(m_index);
	}
	
	public LandscapeViewerCore getLs()
	{
		return(m_ls);
	}
}
