package lsedit;

import java.util.*;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;

import javax.swing.*;

class StringCompareFn extends Object implements CompareFn 
{
	public int compare(Object o1, Object o2) 
	{
		String s1 = o1.toString();
		String s2 = o2.toString();

		return s1.compareTo(s2);
	}
}

class ClientSupplierCompareFn extends Object implements CompareFn
{
	public int compare(Object o1, Object o2) 
	{
		if (o1 == o2) {
			return 0;
		}
		EntityInstance e1 = (EntityInstance) o1;
		EntityInstance e2 = (EntityInstance) o2;

		double x1 = e1.avgX();
		double x2 = e2.avgX();

		if (x1 > x2) {
			return 1;
		} 
		if (x1 < x2) {
			return -1;
		}
		return 0;
	}
}

class HorizontalCompareFn implements CompareFn
{
	public int compare(Object o1, Object o2)
	{
		int	x1, x2;

		x1 = ((EntityInstance) o1).getDiagramX();
		x2 = ((EntityInstance) o2).getDiagramX();

		if (x1 < x2) {
			return(-1);
		}
		if (x1 > x2) {
			return(1);
		}
		return(0);
}	}

class VerticalCompareFn implements CompareFn
{
	public int compare(Object o1, Object o2)
	{
		int	y1, y2;

		y1 = ((EntityInstance) o1).getDiagramY();
		y2 = ((EntityInstance) o2).getDiagramY();

		if (y1 < y2) {
			return(-1);
		}
		if (y1 > y2) {
			return(1);
		}
		return(0);
}	}

class PostorderCompareFn extends Object implements CompareFn
{
	public int compare(Object o1, Object o2) 
	{
		if (o1 == o2) {
			return 0;
		}
		EntityInstance e1 = (EntityInstance) o1;
		EntityInstance e2 = (EntityInstance) o2;

		int x1 = e1.getPostorder();
		int x2 = e2.getPostorder();

		if (x1 > x2) {
			return 1;
		} 
		if (x1 < x2) {
			return -1;
		}
		return 0;
	}
}

class IdCompareFn extends Object implements CompareFn
{
	public int compare(Object o1, Object o2) 
	{
		if (o1 == o2) {
			return 0;
		}
		LandscapeClassObject e1 = (LandscapeClassObject) o1;
		LandscapeClassObject e2 = (LandscapeClassObject) o2;

		int x1 = e1.getNid();
		int x2 = e2.getNid();

		if (x1 > x2) {
			return 1;
		} 
		if (x1 < x2) {
			return -1;
		}
		return 0;
	}
}

public class SortVector
{
	static final StringCompareFn			m_stringCompareFn         = new StringCompareFn();
	static final ClientSupplierCompareFn	m_clientSupplierCompareFn = new ClientSupplierCompareFn();
	static final HorizontalCompareFn		m_horizontalCompareFn     = new HorizontalCompareFn();
	static final VerticalCompareFn			m_verticalCompareFn       = new VerticalCompareFn();
	static final PostorderCompareFn			m_postorderCompareFn      = new PostorderCompareFn();
	static final IdCompareFn				m_idCompareFn		      = new IdCompareFn();

	private static final int partition( Vector v, int l, int r, CompareFn cf, boolean asc )
	{
		// Arbitrarily pick the left element as the pivot element:

		Object p = v.elementAt(l);

		l--; 
		r++;

		while(true) {
			// Figure out what's before and after the pivot:

			boolean f;

			do {
				r--;
				Object o = v.elementAt(r);

				if (asc) {
					f = (cf.compare(o, p) > 0);
				} else {	
					f = (cf.compare(o, p) < 0);
				}
			} while (f);

			do {
				l++;
				Object o = v.elementAt(l);

				if (asc) {
					f = (cf.compare(o, p) < 0);
				} else {	
					f = (cf.compare(o, p) > 0);
				}
			} while (f);

			// Swap elements if we can:

			if (l < r) {
				if (cf.compare(v.elementAt(l), v.elementAt(r)) != 0) {
					Object o = v.elementAt(l);
					v.setElementAt(v.elementAt(r), l);
					v.setElementAt(o, r);
				}
			} else {
				return r;
	}	}	}

	private static final void qsort( Vector v, int l, int r, CompareFn cf, boolean asc)
	{
		// If we haven't reached a termination condition...

		if (l < r) {

			//	Partition the vector into left and right halves:
			int p = partition(v, l, r, cf, asc);

			//	Recursively sort each half:
			qsort(v, l, p, cf, asc);
			qsort(v, p+1, r, cf, asc);
	}	}

	private static final void sort( Vector v, int l, int r, CompareFn cf, boolean asc)
	{
		switch(r) {
		case 0:
			return;
		case 1:
			if (cf.compare(v.elementAt(0), v.elementAt(1)) == 1) {
				Object o = v.elementAt(0);
				v.setElementAt(v.elementAt(1), 0);
				v.setElementAt(o, 1);
			}
			return;
		default:
			qsort(v, l, r, cf, asc);
			return;
	}	}

	public static void sortVector(Vector v, CompareFn cf, boolean ascending) 
	{
		sort(v, 0, v.size() - 1, cf, ascending);
	}

	public static void byString(Vector v, boolean ascending)
	{
		sort(v, 0, v.size() - 1, m_stringCompareFn, ascending);
	}

	public static void byString(Vector v) 
	{
		byString(v, true);
	}

	public static void byAvgX(Vector v, boolean ascending)
	{
		sort(v, 0, v.size() - 1, m_clientSupplierCompareFn, ascending);
	}

	public static void byAvgX(Vector v) 
	{
		byAvgX(v, true);
	}

	public static void byDiagramX(Vector v, boolean ascending)
	{
		sort(v, 0, v.size() - 1, m_horizontalCompareFn, ascending);
	}

	public static void byDiagramX(Vector v) 
	{
		byDiagramX(v, true);
	}

	public static void byDiagramY(Vector v, boolean ascending)
	{
		sort(v, 0, v.size() - 1, m_verticalCompareFn, ascending);
	}

	public static void byDiagramY(Vector v) 
	{
		byDiagramY(v, true);
	}

	public static void byPostorder(Vector v, boolean ascending)
	{
		sort(v, 0, v.size() - 1, m_postorderCompareFn, ascending);
	}

	public static void byPostorder(Vector v) 
	{
		byPostorder(v, true);
	}

	public static void byId(Vector v) 
	{
		sort(v, 0, v.size() - 1, m_idCompareFn, true);
	}
}

