package lsedit;

// Layout method using Coffman-Graham Layer Assignment algorithm and the
// Sugiyama algorithm.

// John S. Y. Lee January 2000

import java.awt.Rectangle;
import java.util.*;

public class SugiyamaLayout extends LandscapeLayouter  implements ToolBarEventHandler {

  public SugiyamaLayout(LandscapeViewerCore ls) 
  {
	super(ls);
  }

/****************************************************************************/

  public String getMenuLabel() 
  {
	return "Coffman-Graham-Sugiyama method applied";
  } // getMenuLabel

/***************************************************************************/

  // The boxIndex method returns the vector index of a box named ID.

  private int boxIndex(Vector selectedBoxes, String ID) {
	
	int index;
	for (index = 0; index < selectedBoxes.size(); index++) {
	  if (ID.equals(((EntityInstance)selectedBoxes.elementAt(index)).getId()))
		break;
	} // for
	return index;

  } // boxIndex

/***************************************************************************/

  // The doLayout method executes the Coffman-Graham Layer Assignment
  // algorithm and the Sugiyama algorithm on the boxes selected.
  // Assumption: All boxes selected are in the same container.

	public String doLayout(Diagram dg) {

		boolean debug = true;

		// get user's selection of boxes to be laid out

		Vector selectedBoxes = dg.getGroup();
		if (selectedBoxes == null) {
			  beep();
			  return "No group selected";
		}

		int vertexID = 0;
		int groupSize = selectedBoxes.size();

		EntityInstance container  = ((EntityInstance)selectedBoxes.firstElement()).getContainedBy();
		Rectangle containerLayout = container.getDiagramBounds();

		// create graph to store info on selected boxes and their relationships
		Graph graph = new Graph(groupSize, containerLayout.width, containerLayout.height, debug);

		for (Enumeration e = selectedBoxes.elements(); e.hasMoreElements(); ) {
			graph.addVertex(((EntityInstance)e.nextElement()).getDiagramBounds().width);
		}

		// get (directed) relationships between the boxes

		for (Enumeration e = selectedBoxes.elements(); e.hasMoreElements(); vertexID++) {

			EntityInstance box = (EntityInstance) e.nextElement();

			for (Enumeration edge = box.srcRelListEnum(); edge.hasMoreElements(); ) {

				RelationInstance relation = (RelationInstance) edge.nextElement();
				EntityInstance child = relation.getDst();
			  
				// store relationship only if children is in the same container

				int index = boxIndex(selectedBoxes, child.getId());
				if (index < groupSize) {
					graph.addEdge(vertexID, index);
				}
			} // for
		} // for

		if (debug) {
			int index = 0;
		  
			System.out.println("Graph read:");
			for (Enumeration e = selectedBoxes.elements(); e.hasMoreElements(); index++) {
				System.out.println(index + " " + e.nextElement());
			}
			graph.print();
		}

		Vector layers = graph.doCoffmanGrahamSugiyama();

		if (debug) {
			System.out.println("RESULTS");
			int level = 0;
			for (Enumeration e = layers.elements(); e.hasMoreElements(); ) {
				System.out.println("level " + level);
				for (Enumeration f = ((Vector)e.nextElement()).elements(); f.hasMoreElements(); ) {
					System.out.print(f.nextElement() + " ");
				}
				System.out.println();
			}
		} // if

		// Assign coordinates to each box

		int numLayers = layers.size();
		double layerHeight = (double)containerLayout.height / (double)numLayers;

		double curX = 20;
		double curY = containerLayout.height;

		for (Enumeration e = layers.elements(); e.hasMoreElements(); ) {

			Rectangle curLayout = null;
			Vector row = (Vector)e.nextElement();
			double boxWidth = (double)containerLayout.width / (double)(row.size());

			for (Enumeration f = row.elements(); f.hasMoreElements(); ) {
				int curVertex = ((Integer)f.nextElement()).intValue();

				// Process non-dummy boxes only
				if (curVertex < groupSize) {
					  EntityInstance curBox = (EntityInstance) selectedBoxes.elementAt(curVertex);
					  curLayout = curBox.getDiagramBounds();
					  curLayout.x = (int) (curX + (boxWidth    - curBox.getWidth()) / 2);
					  curLayout.y = (int) (curY - (layerHeight - curBox.getHeight())/ 2);
					  curX += boxWidth;
					  curBox.setDiagramBounds(curLayout);
				} // if
			} // for

			curY -= layerHeight;
			curX  = 20;

		} // for

		return "Graph redrawn with Coffman-Graham-Sugiyama method";

	} // doLayout

	public void processKeyEvent(int key, int modifiers, Object object) 
	{
		Diagram	dg;
		String	rmsg;

		dg = m_ls.getDiagram();
		if (dg != null) {
			rmsg = doLayout(dg);
			m_ls.doFeedback(rmsg);
			dg.rescaleDiagram();
			m_ls.repaintDg();
	}	}

} // SugiyamaLayout






