package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;
import javax.swing.*;

public class Ta extends JPanel implements Runnable
{
	public final static String INSTANCE_ID				= "$INSTANCE";	
	public final static String INHERIT_RELN				= "$INHERIT";

	public final static String CONTAIN_ID				= "contain"; 
	public final static String EDGEMODE_ID				= "edgemode"; 
	public final static String TOPCLIENTS_ID			= "topclients"; 
	public final static String WANTCLIENTS_ID			= "wantclients"; 
	public final static String WANTSUPPLIERS_ID			= "wantsuppliers"; 
	public final static String WANTCARDINALS_ID			= "wantcardinals"; 
	public final static String SCALE_ID					= "scale";
	public final static String RELN_HIDDEN_ID			= "reln_hidden";
	public final static String NAVLINK_ID				= "navlink";

	private final static String RAW_HEADER				= "#TA_RAW#";

	private final static int	UPDATE_FREQ = 250; 
	private final static int	DEF_CAP     = 2000; 
	private final static float	DEF_LOAD    = 0.5f;
	private final static int	DEF_REL_CAP = 10000; 

	public    final static String ROOT_ID = "$ROOT";
	private   final static String BG_STR = "0.75";			// String value of BG

	// Non-first order attributes of $ROOT

	private final static String g_rootAttributes[] =
		{ SCALE_ID, 
		  RELN_HIDDEN_ID, 
		  EDGEMODE_ID, 
		  NAVLINK_ID, 
		  TOPCLIENTS_ID,
		  WANTCLIENTS_ID,
		  WANTSUPPLIERS_ID,
		  WANTCARDINALS_ID
		};

	// Values

	protected LandscapeViewerCore	m_ls;
	private   Diagram				m_diagram;					// The actual diagram instance else null
	protected EntityInstance		m_rootInstance;				// The root instance of the graph
	
	private   Hashtable m_entityClasses	  = new Hashtable(10);

	// The set of relationClasses
	protected Hashtable m_relationClasses = new Hashtable(5);

	// The set of entities (used to navigate to)
	protected Hashtable m_entityInstances = new Hashtable(DEF_CAP, DEF_LOAD);

	private   Hashtable m_attrNames	      = new Hashtable(20);
	private   Vector	m_numToRel		  = new Vector(10);

	public    RelationClass		m_relationBaseClass; 
	public    EntityClass		m_entityBaseClass;

	protected int				m_numRelationClasses = 0;

	protected EntityClass		defaultEntityClass = null;
	private   int				m_numEntityClasses = 0; 

	private   boolean			universalScheme = false;
	private   boolean			readOnly        = false;

	private   Object			context;

	/* Must detect use of legacy coordinates and convert after diagram loaded
	 * since attributes may not be in tree order so won't know parent dimensions
	 * necessarily when doing conversion from legacy coordinates to relative ones
	 */

	boolean						m_uses_local_coordinates;

	/* Used in writing raw */

	private boolean				schemeSetup = false;
	protected String			m_resString = null;

	protected int				progressCount;
	protected boolean			changedFlag = false;

	// -----------------
	// Protected methods
	// -----------------

	protected Diagram getDiagram()
	{
		return(null);
	}

	private void setReadOnly()
	{
		readOnly = true;
	}

	private void updateProgress() 
	{
		progressCount++;

		StringBuffer sb = new StringBuffer("Loading: ");
		for (int i=0; i<progressCount; i++) {
			sb.append('*');
		}
		m_ls.doFeedback(new String(sb));
	}

	// After this method has been called however many times
	// need to fillLegendBox again

	private EntityClass addEntityClass(String id) 
	{
		EntityClass ec = (EntityClass) m_entityClasses.get(id); 

		if (ec == null) {
			ec = new EntityClass(id, m_numEntityClasses++, m_entityBaseClass /* parent class */, m_diagram);
			m_entityClasses.put(id, ec);
			if (defaultEntityClass == null) {
				defaultEntityClass = ec;
			}
		}
		return ec;
	}

	// After this method has been called however many times
	// need to fillLegendBox again

	private RelationClass addRelationClass(String id) 
	{
		RelationClass rc = (RelationClass) m_relationClasses.get(id);		// Lookup in the hash table

		if (rc == null) {
			rc = new RelationClass(id, m_numRelationClasses, m_relationBaseClass, m_diagram);
			m_relationClasses.put(id, rc);
			m_numToRel.addElement(rc);
			m_numRelationClasses++;
		}
		return rc;
	}

	private void registerAttrName(String id) 
	{
		if (m_attrNames.get(id) == null) {
			m_attrNames.put(id, id);
		}
	}

	private void registerAttrNames(Attribute attr) {

		while(attr != null) {
			registerAttrName(attr.id);
			attr = attr.next;
		}
	}

	/* Only called from process raw fact tuples.. don't need to manage TOC */

	private EntityInstance addEntity(EntityClass ec, String eid) 
	{
		EntityInstance e = ec.newEntity(eid);
		putEntity(e);
		// For now make it contained by root
		m_rootInstance.addContainment(e);
		return e;
	}

	private void addEdge(EntityInstance src, EntityInstance dst, RelationClass rc)
	{

/*
		String key = Util.hashEdge(rc, src, dst);
		if (edges.contains(key))
			return;
		edges.put(key, key);
*/
		RelationInstance ri = rc.newRelation(src, dst);
		src.addRelation(ri, dst); 
	}

	// Setup for universal scheme
	// This is employed if there are no SCHEME TUPLES

	private void setupUniversalScheme() 
	{
		m_relationBaseClass.addRelation(m_entityBaseClass, m_entityBaseClass);
		universalScheme = true;
	}

	// Section processing methods

	private void 
	processSchemeTuples(LandscapeTokenStream ts) throws IOException {

		for (;;) {

			Tuple tuple = ts.nextTuple();

			if (tuple == null) {
				return;
			}

//			System.out.println("Schema Tuples: " + tuple);

			RelationClass rc = null;

			boolean inheritance = tuple.token1.equals(INHERIT_RELN);			// $INHERIT

			if (inheritance) {
				if (tuple.token2.equals(EntityClass.ENTITY_BASE_CLASS_ID)) {	// $ENTITY
					ts.errorNS("Improper use of $ENTITY with $INHERIT");
					return;
				}
			} else { 
				rc = addRelationClass(tuple.token1);
			}

			EntityClass ec1 = addEntityClass(tuple.token2); 
			EntityClass ec2 = addEntityClass(tuple.token3);

			if (inheritance) {

				String msg = ec1.addParentClass(ec2);
				if (msg != null)
					ts.errorNS(msg);
			} else {
				rc.addRelation(ec1, ec2);		// If not already present
			}
		}
	}

	private void processSchemeAttributes(LandscapeTokenStream ts) throws IOException 
	{

		for (;;) {

			AttributeRecord ar = ts.nextRecord();
			if (ar == null) {
				return;
			}

//			System.out.println("Schema Attributes: " + ar);

			if (ar.id.startsWith("(")) {
				StringTokenizer st = new StringTokenizer(ar.id, "() ");
				String rel = st.nextToken();

				RelationClass rc = (RelationClass) m_relationClasses.get(rel);

				if (rc != null) {
					Attribute attr = ar.attributes;
					while(attr != null) { 
						rc.addAttribute(attr);
						attr = attr.next;
					}
					registerAttrNames(ar.attributes);
				} else {
					ts.errorNS("Can't process record. Missing relation class '" + rel + "'");
				}
			} else {

				if (ar.id.equals(ROOT_ID)) {
					Attribute attr = ar.attributes;

					while(attr != null) {
						m_rootInstance.addAttribute(attr);
						attr = attr.next;
					}
					registerAttrNames(ar.attributes);
				} else { 

					EntityClass ec = (EntityClass) m_entityClasses.get(ar.id);

					if (ec != null) {
						Attribute attr = ar.attributes;
						while(attr != null) {
							ec.addAttribute(attr);
							attr = attr.next;
						}
						registerAttrNames(ar.attributes);
					} else {
						ts.errorNS("Can't process record. Missing entity class '" + ar.id + "'");
					}
				}
			}
		}
	}

	private void processFactTuples(LandscapeTokenStream ts) throws IOException 
	{
		int ne = 0;
		int nr = 0;

		MsgOut.vprint("\nFACT TUPLE : ");

		for (;;) {
			Tuple tuple = ts.nextTuple();

			if (tuple == null) {
				return;
			}	

//			System.out.println(ne + "/" + nr + ":Fact Tuple: " + tuple);

			if (tuple.token1.equals(INSTANCE_ID)) {

				// 
				// $INSTANCE instanceId classId
				//

				ne++;
		
				if ((ne % UPDATE_FREQ) == 0) {
					MsgOut.vprint(".");
					updateProgress();
					m_ls.showInfo("Entities: " + ne);
				}		


				EntityInstance e = getEntity(tuple.token2);

				if (e == null) {

					// New $INSTANCE

					EntityClass ec = (EntityClass) m_entityClasses.get(tuple.token3);


					if (ec != null) {

						e = ec.newEntity(tuple.token2);
						putEntity(e);

						// For now make it contained by root

						m_rootInstance.addContainment(e);

					}  else {
						ts.errorNS("EntityClass '" + tuple.token3 + "' has not been declared");
					}
				} else {

					EntityClass ec = e.getEntityClass();

					if (ec.hasId(tuple.token3)) {
						ts.warning("Redeclaration of " + e.toString());
					} else {

						ts.errorNS("Attempt to declare " + e.getId() + " as instanceof " + tuple.token3 + ". Currently declared as instanceof " + ec.getId());
					}
				}
			} else {

				// Relation tuple definition
				//
				// relationClass entityInstance entityInstance
				//

				nr++;

				if ((nr % UPDATE_FREQ) == 0) {

					MsgOut.vprint(".");
					updateProgress();
					m_ls.showInfo("Relations: " + nr);
				}		



				RelationClass rc  = (RelationClass)	 m_relationClasses.get(tuple.token1);
				EntityInstance e1 = getEntity(tuple.token2);
				EntityInstance e2 = getEntity(tuple.token3);

				if (universalScheme) {

					// Implicit declaration upon use

					if (rc == null) {
						rc = m_relationBaseClass;
					}

					if (e1 == null) {
						e1 = m_entityBaseClass.newEntity(tuple.token2);
						putEntity(e1);
						m_rootInstance.addContainment(e1);
					}

					if (e2 == null) {
						e2 = m_entityBaseClass.newEntity(tuple.token3);
						putEntity(e2);
						m_rootInstance.addContainment(e2);
					}
				}

				if (rc == null) {
					ts.errorNS("Can't process: " + "(" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token1 + "'");
				} else if (e1 == null) {
					ts.errorNS("Can't process: " + "(" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token2 + "'");
				} else if (e2 == null) {
					ts.errorNS("Can't process: " + "(" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token3 + "'");
				} else {

					EntityClass ec1 = e1.getEntityClass();
					EntityClass ec2 = e2.getEntityClass();

					if (tuple.token1.equals(CONTAIN_ID)) {
						// Right now it is contained by root, so
						// remove from root's containment, and
						// make it contained by another e1.

						if (e2.isMarked(EntityInstance.IN_TREE_MARK)) {
							System.out.println("Entity " + e2 + " has multiple parents");
						} else {
							if (m_rootInstance.removeContainment(e2)) {
								e2.orMark(EntityInstance.IN_TREE_MARK);
								e1.addContainment(e2);
							} else {
								System.out.println("Entity " + e2 + " not in unassigned collection waiting containment");
						}	}
					} else {
						addEdge(e1, e2, rc);
					}
				}
			}
		}
	}

	private void processFactAttributes(LandscapeTokenStream ts) throws IOException 
	{
		int n = 0;

		MsgOut.vprint("\nFACT ATTRIBUTE : ");
		for (;;) {
			AttributeRecord ar = ts.nextRecord();
			if (ar == null) {
				break;
			}

//			System.out.println("Fact Attribute: " + ar);
				
			n++; 

			if ((n % UPDATE_FREQ) == 0) {
				MsgOut.vprint(".");
				updateProgress();
				m_ls.showInfo("Attr Records: " + n);
			}

			MsgOut.vprintln("Processing record: " + ar.id);

			if (ar.id.startsWith("(")) {
				// Attributes assigned to a relation tuple (rare)

				Tuple tuple = new Tuple(ar.id);

				RelationClass  rc  = (RelationClass)	m_relationClasses.get(tuple.token1);
				EntityInstance src = getEntity(tuple.token2);
				EntityInstance dst = getEntity(tuple.token3);

				if (rc == null) {
					ts.errorNS("Can't process record for " + ar.id + ". " + "Missing relation '" + tuple.token1 + "'");
				} else if (src == null) {
					ts.errorNS("Can't process record for " + ar.id + ". " + "Missing entity '" + tuple.token2 + "'");
				} else if (dst == null) {
					ts.errorNS("Can't process record for " + ar.id + ". " + "Missing entity '" + tuple.token3 + "'");
				} else {
					RelationInstance ri = src.getRelation(rc, dst);

					if (ri == null) {
						ts.errorNS("Can't process record. " + "Missing relation " + ar.id);
					} else {
						ri.assignAttributes(ar.attributes, m_entityInstances);
						registerAttrNames(ar.attributes);
					}
				}
			}  else {

				EntityInstance e;

				if (ar.id.equals(ROOT_ID)) {
					e = m_rootInstance;
				} else {
					e = getEntity(ar.id);
				}
				if (e != null) {
					e.assignAttributes(ar.attributes);
					registerAttrNames(ar.attributes);
				} else if (universalScheme) {

					// Create it

					e = m_entityBaseClass.newEntity(ar.id);
					putEntity(e);

					m_rootInstance.addContainment(e);

					e.assignAttributes(ar.attributes);

					registerAttrNames(ar.attributes);

				} else {

					ts.errorNS("Can't process record. " + "Missing entity '" + ar.id + "'");
				}
			}
		}
	}



	// *** And now for output ***



	private void writeRawPairs(DataOutputStream dos, Vector v) throws IOException 
	{
		Enumeration en;

		dos.writeInt(v.size());

		for (en = v.elements(); en.hasMoreElements(); ) {
			Integer[] pair = (Integer[]) en.nextElement();
			dos.writeInt(pair[0].intValue());
			dos.writeInt(pair[1].intValue());
		}
	}

	private void writeRawTriples(DataOutputStream dos, Vector v) throws IOException
	{
		Enumeration en;

		dos.writeInt(v.size());

		for (en = v.elements(); en.hasMoreElements(); ) {
			Integer[] triple = (Integer[]) en.nextElement();
			dos.writeInt(triple[0].intValue());
			dos.writeInt(triple[1].intValue());
			dos.writeInt(triple[2].intValue());
		}
	}

	private void writeRawAttributes(DataOutputStream dos, Vector v) throws IOException
	{
		dos.writeInt(v.size());

		Enumeration en = v.elements();
		while(en.hasMoreElements()) {
			Object[] obj = (Object []) en.nextElement();
			dos.writeInt(((Integer) obj[0]).intValue());
			Vector lv = (Vector) obj[1];
			dos.writeInt(lv.size());
			Enumeration en1 = lv.elements();
			while (en1.hasMoreElements()) {
				Object[] attr = (Object []) en1.nextElement();
				dos.writeInt(((Integer) attr[0]).intValue());
				int type = ((Integer) attr[1]).intValue();
				dos.writeInt(type);

				switch(type) 
				{
				case Attribute.NULL_TYPE:
					break;

				case Attribute.INT_TYPE:
					dos.writeInt(((Integer) attr[2]).intValue());
					break;

				case Attribute.DOUBLE_TYPE:
					dos.writeDouble(((Double) attr[2]).doubleValue());
					break;

				case Attribute.STRING_TYPE:
					dos.writeUTF((String) attr[2]);
					break;

				case Attribute.INT_LIST_TYPE:
					{
					int[] il = (int[]) attr[2];
					int num = il.length;

					dos.writeInt(num);

					for (int i=0; i<num; i++) {
						dos.writeInt(il[i]);
					}
					}
					break;

				case Attribute.DOUBLE_LIST_TYPE:
					{
					double[] dl = (double[]) attr[2];
					int num = dl.length;

					dos.writeInt(num);
					for (int i=0; i<num; i++) {
						dos.writeDouble(dl[i]);
					}
					}
					break; 

				case Attribute.STRING_LIST_TYPE:
					{
					String[] sl = (String[]) attr[2];
					int num = sl.length;

					dos.writeInt(num);
					for (int i=0; i<num; i++) {
						dos.writeUTF(sl[i]);
					}
					}
					break;
				}
			}
		}
	}

	private void writeSchemeTuples(PrintStream ps) throws IOException 
	{
		ps.print("// Landscape TA file\n\n");
		ps.print("SCHEME TUPLE :\n\n// The ERD\n\n"); 

		Enumeration en0 = enumEntityClassesInOrder();

		while(en0.hasMoreElements()) {
			EntityClass ec = (EntityClass) en0.nextElement();
			if (ec != m_entityBaseClass) {
				Enumeration en = ec.getParentElements();
				while (en.hasMoreElements()) {
					EntityClass parent = (EntityClass) en.nextElement();
					if (parent != m_entityBaseClass) {
						ps.print(INHERIT_RELN + " " + ec.getId() + " " + parent.getId() + "\n");
					}
				}
			}
		}
		ps.print("\n");
		for (en0 = enumRelationClassesInOrder(); en0.hasMoreElements(); ) {	// Output in same order as input
			RelationClass rc = (RelationClass) en0.nextElement();
			rc.writeRelations(ps); 
		}
	}

	/* Write out:
	 *
     * #1#
	 * cnt [id/parentid]*
     * cnt [id/from/to]*
     *
     */

	private void writeSchemeTuplesRaw(DataOutputStream dos, Hashtable stringTable) throws IOException
	{
		Enumeration en, en1;

		dos.writeUTF("#1#");

		Vector v = new Vector();

		for (en = enumEntityClassesInOrder(); en.hasMoreElements(); ) {
			EntityClass ec = (EntityClass) en.nextElement();
			if (ec != m_entityBaseClass) {
				for (en1 = ec.getParentElements(); en1.hasMoreElements(); ) {
					EntityClass parent = (EntityClass) en1.nextElement();
					if (parent != m_entityBaseClass) {
						Integer[] pair = new Integer[2];
						pair[0] = (Integer) stringTable.get(ec.getId());
						pair[1] = (Integer) stringTable.get(parent.getId());
						v.addElement(pair);
					}
				}
			}
		}
		writeRawPairs(dos, v);

		v = new Vector();

		for (en = enumRelationClassesInOrder(); en.hasMoreElements(); ) {	// Output in same order as input
			RelationClass rc = (RelationClass) en.nextElement();
			rc.getRelationsRaw(v, stringTable);
		}
		writeRawTriples(dos, v);
	}

	private void processRawSchemeTuples(DataInputStream dis, Vector st) throws IOException 
	{
		// Read inherits

		int num = dis.readInt();
		for (int i=0; i<num; i++) {
			String child = (String) st.elementAt(dis.readInt());
			String parent = (String) st.elementAt(dis.readInt());
			EntityClass ec1 = addEntityClass(child);
			EntityClass ec2 = addEntityClass(parent);
			ec1.addParentClass(ec2);
		}

		num = dis.readInt();
		for (int i=0; i<num; i++) {
			String rcid	 = (String) st.elementAt(dis.readInt());
			String ecid1 = (String) st.elementAt(dis.readInt());
			String ecid2 = (String) st.elementAt(dis.readInt());

			RelationClass rc = addRelationClass(rcid);
			EntityClass ec1	 = addEntityClass(ecid1);
			EntityClass ec2	 = addEntityClass(ecid2);

			rc.addRelation(ec1, ec2);
		}
	}

	private void writeSchemeAttributes(PrintStream ps) throws IOException 
	{
		Enumeration en;

		ps.print("\n\nSCHEME ATTRIBUTE :\n\n");
		ps.print("// EntityClass attributes\n\n");
		// Write attributes for entity classes 

		for (en = m_entityClasses.elements(); en.hasMoreElements(); ) {
			EntityClass ec = (EntityClass) en.nextElement(); 
			ec.writeAttributes(ps);
		}

		// Write attributes for relation classes 

		for (en = m_relationClasses.elements(); en.hasMoreElements(); ) {
			RelationClass rc = (RelationClass) en.nextElement();
			rc.writeAttributes(ps);
		}
	}

	private void writeSchemeAttributesRaw(DataOutputStream dos, Hashtable stringTable) throws IOException
	{
		Enumeration en;

		// Write attributes for entity classes 
		dos.writeUTF("#2#");
		Vector v = new Vector();
		for (en = m_entityClasses.elements(); en.hasMoreElements(); ) {
			EntityClass ec = (EntityClass) en.nextElement(); 
			ec.getLsAttributesRaw(v, stringTable);
		}
		writeRawAttributes(dos, v);

		// Write attributes for relation classes 

		v = new Vector();

		for (en = m_relationClasses.elements(); en.hasMoreElements(); ) {
			RelationClass rc = (RelationClass) en.nextElement();
			rc.getLsAttributesRaw(v, stringTable);
		}
		writeRawAttributes(dos, v);
	}

	private void processRawSchemeAttributes(DataInputStream dis, Vector st) throws IOException 
	{
		int num = dis.readInt();

		for (int i=0; i<num; i++) {
			String ecid = (String) st.elementAt(dis.readInt());
			EntityClass ec = (EntityClass) m_entityClasses.get(ecid);
			processRawAttributes(ec, dis, st);
		}

		num = dis.readInt();

		for (int i=0; i<num; i++) {
			String rcid = (String) st.elementAt(dis.readInt());
			RelationClass rc = (RelationClass) m_relationClasses.get(rcid);
			processRawAttributes(rc, dis, st);
		}
	}

	private void writeFactAttributes(PrintStream ps) throws IOException
	{
		ps.print("\n\nFACT ATTRIBUTE :\n\n"); 
		m_rootInstance.writeAttributes(ps); 
	}

	private void writeFactTuples(PrintStream ps) throws IOException 
	{
		ps.print("\n\nFACT TUPLE :\n\n"); 
		ps.print("// Instances of entity classes\n\n");
		m_rootInstance.writeInstances(ps);
		m_rootInstance.writeRelations(ps); 
	}

	private void writeFactTuplesRaw(DataOutputStream dos, Hashtable stringTable)	throws IOException
	{
		Enumeration		en;
		EntityInstance	child;

		dos.writeUTF("#3#");
		Vector v = new Vector();

		// Don't write out the root itself
		for (en = m_rootInstance.getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			child.getInstancesRaw(v, stringTable);
		}

		writeRawPairs(dos, v);
		v = new Vector();
		m_rootInstance.getRelationsRaw(v, stringTable, (Integer) stringTable.get(CONTAIN_ID)); 
		writeRawTriples(dos, v);
	}

	private void writeFactAttributesRaw(DataOutputStream dos, Hashtable stringTable)	throws IOException
	{
		dos.writeUTF("#4#");
		Vector v = new Vector();
		m_rootInstance.getLsAttributesRaw(v, stringTable);
		writeRawAttributes(dos, v);
	}

	private Vector readStringTable(DataInputStream dis) throws IOException 
	{
		Vector st = new Vector();
		int num = dis.readInt();

		for (int i=0; i<num; i++) {
			st.addElement(dis.readUTF());
		}

/*
		Enumeration en = st.elements();
		while(en.hasMoreElements()) {
			String str = (String) en.nextElement();
			System.out.println(str);
		}
*/
		return st;
	}

	private void processRawAttributes(LandscapeObject lo, DataInputStream dis, Vector st) throws IOException
	{
		int na = dis.readInt();

		for (int i=0; i<na; i++) {
			String aid = (String) st.elementAt(dis.readInt());
			int type = dis.readInt();

			registerAttrName(aid);

			boolean rc;

			switch(type)
			{
			case Attribute.NULL_TYPE:
				rc = lo.addRawAttribute(aid);
				break;

			case Attribute.INT_TYPE:
				rc = lo.addRawAttribute(aid, dis.readInt());
				break;

			case Attribute.DOUBLE_TYPE:
				rc = lo.addRawAttribute(aid, dis.readDouble());
				break;
				
			case Attribute.STRING_TYPE:
				rc = lo.addRawAttribute(aid, dis.readUTF());
				break;

			case Attribute.INT_LIST_TYPE:
			{
				int num = dis.readInt();

				int[] il = new int[num];

				for (int j=0; j<num; j++) {
					il[j] = dis.readInt();
				}
				rc = lo.addRawAttribute(aid, il);
				break;
			}
			case Attribute.DOUBLE_LIST_TYPE:
			{
				int num = dis.readInt();
				double[] dl = new double[num];
				for (int j=0; j<num; j++) {
					dl[j] = dis.readDouble();
				}
				rc = lo.addRawAttribute(aid, dl);
				break;
			}
			case Attribute.STRING_LIST_TYPE:
			{
				int num = dis.readInt();
				String[] sl = new String[num];

				for (int j=0; j<num; j++) {
					sl[j] = dis.readUTF();
				}
				rc = lo.addRawAttribute(aid, sl);
				break;
			}
			default:
				rc = false;
				MsgOut.println("Unknown attribute type: " + type);
				break;
			}

			if (!rc) {
				MsgOut.println("Unhandled attribute: " + aid + " - type: " + type);
			}
		}
	}

	private void processRawFactTuples(DataInputStream dis, Vector st) throws IOException 
	{
		// Read instances

		int num = dis.readInt();
		EntityClass ec	 = null;
		int			lind = -1;

		for (int i=0; i<num; i++) {
			String eid = (String) st.elementAt(dis.readInt());
			int ind = dis.readInt();
			if (ind != lind) {
				String ecid = (String) st.elementAt(ind);
				ec = (EntityClass) m_entityClasses.get(ecid);
				lind = ind;
			}
			addEntity(ec, eid);

			if ((i % UPDATE_FREQ) == 0) {
				MsgOut.vprint(".");
				updateProgress();
				m_ls.showInfo("Entities: " + i);
			}	
		}

		// Read edge tuples

		num = dis.readInt();
		RelationClass crc = (RelationClass) m_relationClasses.get(CONTAIN_ID);
		RelationClass	rc	   = null;
		int				lrcind = -1;
		EntityInstance	e1	   = null;
		int				leind  = -1;	

		for (int i=0; i<num; i++) {
			int rcind = dis.readInt();
			int eind  = dis.readInt();

			if (rcind != lrcind) {
				String rcid = (String) st.elementAt(rcind);
				rc = (RelationClass) m_relationClasses.get(rcid);
				lrcind = rcind;
			}
			if (eind != leind) {		
				String eid1 = (String) st.elementAt(eind);

				e1 = getEntity(eid1);
				leind = eind;
			}

			String eid2 = (String) st.elementAt(dis.readInt());
			EntityInstance e2 = getEntity(eid2);

			if (rc == crc) {
				// Right now it is contained by root, so
				// remove from root's containment, and
				// make it contained by e1.

				if (m_rootInstance.removeContainment(e2)) {
					e1.addContainment(e2);
				}
			} else {
				addEdge(e1, e2, rc);
			}
			if ((i % UPDATE_FREQ) == 0) {
				MsgOut.vprint(".");
				updateProgress();
				m_ls.showInfo("Relations: " + i);
			}
		}
	}

	private void processRawFactAttributes(DataInputStream dis, Vector st) throws IOException 
	{
		int num = dis.readInt();

		for (int i=0; i<num; i++) {
			String eid = (String) st.elementAt(dis.readInt());
			EntityInstance e = getEntity(eid);
			processRawAttributes(e, dis, st);
			if ((i % UPDATE_FREQ) == 0) {
				MsgOut.vprint(".");
				updateProgress();
				m_ls.showInfo("Attr records: " + i);
			}
		}
	}

	private void parseRawStream(DataInputStream dis, String src, URL context)
	{
		try {
			String hdr = dis.readUTF();
			if (hdr.equals(RAW_HEADER)) {
				Vector stringTable = readStringTable(dis);
				for (;;) {
					String sec = dis.readUTF();
					if (sec.equals("#END#"))
						break;
					if (sec.equals("#1#")) 
						processRawSchemeTuples(dis, stringTable);
					else if (sec.equals("#2#"))
						processRawSchemeAttributes(dis, stringTable);
					else if (sec.equals("#3#"))
						processRawFactTuples(dis, stringTable);
					else if (sec.equals("#4#"))
						processRawFactAttributes(dis, stringTable);
					else  
						MsgOut.println(src + "- Bad section: " + sec);
				}
			} else {
				m_resString = "Not a raw TA file";
			}
		}
		catch (Exception e) {
			System.out.println(e);
			m_resString = e.toString();
		}
	}

	private boolean isRaw(BufferedInputStream bis) throws IOException 
	{
		bis.mark(100);

		bis.read();
		bis.read();

		for (int i = 0; i<RAW_HEADER.length(); i++) {
			int c = bis.read();
			if (c != RAW_HEADER.charAt(i)) {
				bis.reset();
				return false;
			}
		}
		bis.reset();
		return true;
	}

	private void computeRelCoordinates()
	{
		if (m_rootInstance != null) {
			m_rootInstance.computeRelCoordinates(m_rootInstance.xRelLocal(), m_rootInstance.yRelLocal(), m_rootInstance.widthRelLocal(), m_rootInstance.heightRelLocal() );
	}	}

	private void parseStream(InputStream is, String src, URL context) {

		MsgOut.vprintln("Parse TA file: " + src);

		m_uses_local_coordinates = false;

		try {
			BufferedInputStream bis = new BufferedInputStream(is);

			if (isRaw(bis)) {
				DataInputStream dis = new DataInputStream(bis);
				parseRawStream(dis, src, context);
				dis.close();
				bis.close();
				is.close();
				return;
			}

			LandscapeTokenStream ts = new LandscapeTokenStream(bis, src);

			for (;;) {
				int sec = ts.nextSection();

				if (sec == LandscapeTokenStream.EOF) {
					MsgOut.vprintln("");
					break;
				}
				try { 
					switch(sec) {

					case LandscapeTokenStream.SCHEME_TUPLE:

						// regSrcInfo(src, sec);

						schemeSetup = true;
						universalScheme = false;

						processSchemeTuples(ts);
						updateProgress();
						break;



					case LandscapeTokenStream.SCHEME_ATTRIBUTE:

						// regSrcInfo(src, sec);

						if (!schemeSetup) {
							schemeSetup = true;
							setupUniversalScheme();
						}
						processSchemeAttributes(ts);
						updateProgress();
						break;



					case LandscapeTokenStream.FACT_TUPLE:

						// regSrcInfo(src, sec);

						if (!schemeSetup) {
							schemeSetup = true;
							setupUniversalScheme();
						}

						processFactTuples(ts);
						break;



					case LandscapeTokenStream.FACT_ATTRIBUTE:

						// int srcIndex = regSrcInfo(src, sec);

						processFactAttributes(ts);
						break;


					case LandscapeTokenStream.INCLUDE_FILE:

						if (context == null) {
							parseFile(ts.getIncludeFile(), null);
						} else {
							parseURL(ts.getIncludeFile(), context);
						}
						MsgOut.vprintln("Back to TA file: " + src);
						break; 
					}

				}

				catch (IOException e) {

					MsgOut.println("IO error reading landscape"); 
					m_resString = e.toString();
					break; 
				}
			}
			ts.freeHashTable();
			bis.close(); 
			is.close();

			if (m_uses_local_coordinates) {
				computeRelCoordinates();
			}
		}

		catch (Exception e) {
			m_resString = e.toString();
			System.out.println("Parse error: " + m_resString);
		}


	} // end parseStream() 



	private URL parseURL(String taURL, URL context) {

		progressCount = 0;

		updateProgress();

		try {

			URL lsURL;

			if (context == null) {
				lsURL = new URL(taURL);

			} else {
				lsURL = new URL(context, taURL);
			}

			MsgOut.dprintln("Opening URL: " + taURL);
			InputStream is = lsURL.openStream();
			MsgOut.dprintln("opened");
			parseStream(is, taURL, lsURL);
			return lsURL; 
		}
		catch(Exception e) {
			m_resString = e.toString();
			return null;
		}
	}


	// Called from diagram.loadDiagram to parse a file or an include within a file

	private File parseFile(String taFile, File context) {

		progressCount = 0;

		updateProgress();

		try {
			File file;

			if (context == null)
				file = new File(taFile);
			else {
				String dir = getDir(context);

				file = new File(dir, taFile);
			}

			FileInputStream fis = new FileInputStream(file);

			parseStream(fis, taFile, null);
			return file;

		} catch (Exception e) {
			m_resString = e.toString();
			return null;
		}
	}

	private void processInternalBuffer(String taFile) 
	{
		InternalBufferStream iis = m_ls.getInternalBufferStream();

		if (iis == null) {
			m_resString = "Internal landscape not available";
			return;
		}

		parseRawStream(iis, taFile, null);
		setReadOnly();
	}

	// --------------
	// Public methods
	// --------------

	public Ta(LandscapeViewerCore ls) 
	{
		m_ls      = ls;
		m_diagram = getDiagram();

		// Must create this before create $ROOT
		// Need a navlink attribute on rootInstance

		m_entityBaseClass = new EntityClass(EntityClass.ENTITY_BASE_CLASS_ID, m_numEntityClasses++, null, m_diagram);							// $ENTITY
		m_entityClasses.put(EntityClass.ENTITY_BASE_CLASS_ID, m_entityBaseClass);

		// Create root entity

		m_rootInstance = new EntityInstance(m_entityBaseClass, ROOT_ID); 	// $ROOT
		m_rootInstance.prepostorder(1);									// Ensure root always has preorder == 1

		m_entityInstances.put(ROOT_ID, m_rootInstance);

		for (int i = 0; i < g_rootAttributes.length; i++) {
			m_rootInstance.addAttribute( new Attribute(g_rootAttributes[i], null));
		}

		AttributeValueItem av = new AttributeValueItem(BG_STR);																			// 0.75

		av.next = new AttributeValueItem(BG_STR);
		av.next.next = new AttributeValueItem(BG_STR);
		m_rootInstance.addAttribute(new Attribute("color", av));																			// $ROOT (0.75 0.75 0.75)


		m_relationBaseClass =	 new RelationClass(RelationClass.RELATION_BASE_CLASS_ID, m_numRelationClasses++, null /* parent */, m_diagram);	// $RELATION
		m_relationClasses.put(RelationClass.RELATION_BASE_CLASS_ID, m_relationBaseClass);													// Add to hash table
		m_numToRel.addElement(m_relationBaseClass);

		RelationClass rc = new RelationClass(CONTAIN_ID, m_numRelationClasses++, m_relationBaseClass, m_diagram);								// contain
		m_relationClasses.put(CONTAIN_ID, rc);																							// Add to hash table
		m_numToRel.addElement(rc);
	}

	public LandscapeViewerCore getLs() 
	{
		return m_ls;
	}

	public boolean isReadOnly() 
	{
		return readOnly;
	}

	public RelationClass nameToRelationClass(String name) 
	{
		if (m_relationClasses.containsKey(name)) {

		   return (RelationClass) m_relationClasses.get(name);

		}
		return null;
	}

	public EntityInstance getEntity(String name) 
	{
		return((EntityInstance) m_entityInstances.get(name));
	}

	public void putEntity(EntityInstance e)
	{
		m_entityInstances.put(e.getId(), e);
	}

	public Enumeration enumRelationClasses() 
	{
		return m_relationClasses.elements(); 
	}

	public Enumeration enumRelationClassesInOrder() 
	{
		return OrderedHashTableEnumeration.elements(m_relationClasses); 
	}

	public int numRelationClasses() 
	{
		return m_numRelationClasses;
	}

	public Enumeration enumEntityClasses() 
	{
		return m_entityClasses.elements(); 
	}

	public Enumeration enumEntityClassesInOrder() 
	{
		return OrderedHashTableEnumeration.elements(m_entityClasses); 
	}

	public int numEntityClasses() 
	{
		return m_numEntityClasses;
	}

	public Object getContext() 
	{
		return context;
	}

	public Object setContext(Object context) 
	{
		return this.context = context;
	}

	public String getName() 
	{
		if (context instanceof File) {
			return Util.nameFromPath(((File) context).getPath()); 
		}
		return m_rootInstance.getLabel();
	}

	public String getDir(File file) 
	{
		if (file.isAbsolute()) {
			return file.getParent();
		}
		return (new File(file.getAbsolutePath())).getParent();
	}

	public String getDir() 
	{
		return getDir((File) context);
	}

	public String getAbsolutePath() 
	{
		if (context instanceof File) {
			return ((File) context).getAbsolutePath();
		}
		return ((URL) context).toExternalForm();
	}

	public RelationClass numToRelationClass(int n) 
	{
		return (RelationClass) m_numToRel.elementAt(n);
	}

	// Save the landscape in the output stream

	public void saveDiagram(OutputStream os, boolean markEnd) throws IOException
	{
		BufferedOutputStream bos = new BufferedOutputStream(os);
		PrintStream ps = new PrintStream(bos);

		writeSchemeTuples(ps);
		writeSchemeAttributes(ps);
		writeFactTuples(ps);
		writeFactAttributes(ps);

		if (markEnd) {
			ps.print("END\n");
		}
		ps.flush();
		ps.close();
		changedFlag = false;
	}

	/* writeUTF prepends a short to the output specifying the length of the output
     * for characters > 127 multibyte sequence is used
	 *
     * Key:
     *		<l> length of UTF string (always a two byte encoded short)
	 *		<i>	integer value
	 *		<s>	UTF string
	 *
	 * Outputs:  
	 *
	 *		<l>#TA_RAW#						-- header
	 *		<i>								-- size of string table
	 *		<s>*							-- repeats
	 *
	 *      <l>#END#
	 */

	public void	saveDiagramRaw(OutputStream os) throws IOException
	{
		Enumeration en;
		BufferedOutputStream bos = new BufferedOutputStream(os);
		DataOutputStream	 dos = new DataOutputStream(bos);

		Hashtable stringHash = new Hashtable();
		Vector	  stringTable = new Vector();
		String str;

		int id = 0;

		for (en = m_entityClasses.keys(); en.hasMoreElements(); ) {
			str = (String) en.nextElement();
			stringHash.put(str, new Integer(id++));
			stringTable.addElement(str);
		}
		
		for (en = m_relationClasses.keys(); en.hasMoreElements(); ) {
			str = (String) en.nextElement();
			stringHash.put(str, new Integer(id++));
			stringTable.addElement(str);
		}

		for (en = m_entityInstances.keys(); en.hasMoreElements(); ) {
			str = (String) en.nextElement();
			stringHash.put(str, new Integer(id++));
			stringTable.addElement(str);
		}

		for (en = m_attrNames.keys(); en.hasMoreElements(); ) {
			str = (String) en.nextElement();
			stringHash.put(str, new Integer(id++));
			stringTable.addElement(str);
		}

		dos.writeUTF(RAW_HEADER);

		/* Write string table */

		dos.writeInt(stringTable.size());
		for (en = stringTable.elements(); en.hasMoreElements(); ) {
			dos.writeUTF((String) en.nextElement());
		}

		writeSchemeTuplesRaw(dos, stringHash);
		writeSchemeAttributesRaw(dos, stringHash);
		writeFactTuplesRaw(dos, stringHash);
		writeFactAttributesRaw(dos, stringHash);

		dos.writeUTF("#END#");
		dos.flush();
		dos.close();
		bos.close();

		changedFlag = false;
	}

	protected Vector bgpaths;

	public void run() 
	{
		Object ncontext;

		Enumeration en = bgpaths.elements();

		while (en.hasMoreElements()) {
			String path = (String) en.nextElement();

			if (Util.isHTTP(path)) {
				ncontext = parseURL(path, (URL) context);
			} else {
				ncontext = parseFile(path, (File) context);
			}
		}
	}

	protected String backgroundLoad(Vector paths) 
	{
		if (paths != null && paths.size() > 0) {
			bgpaths = paths;
			Thread thread = new Thread(this);
			thread.start();
		}
		return null;
	}

	public String loadTA(String taPath, Vector bgPaths, Object context) {

		Attribute	attr;
		boolean		option;

		m_resString = null;

		char lc	  = taPath.charAt(taPath.length()-1);

		if (lc == File.separatorChar) {
			taPath = taPath.substring(0, taPath.length()-1);
		}

		if (taPath.equals("__internal")) {
			processInternalBuffer(taPath);		
		} else if (context instanceof URL || Util.isHTTP(taPath)) {
			MsgOut.dprintln("Parse a URL");
			this.context = parseURL(taPath, (URL) context);
		} else {
			MsgOut.dprintln("Parse a file");
			this.context = parseFile(taPath, (File) context);
		}

		if (this.context == null) {
			return m_resString;
		}
		return backgroundLoad(bgPaths);
	}
	
}

