package lsedit;

import java.awt.Component;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;

/* In a large diagram the m_tree can be huge .. therefore we compute
 * the contents of m_tree only when needed and discard ASAP
 */

public class TextTree extends JComponent implements MouseListener
{
	public    static final String m_helpStr	 = "Right click for menu.";
	
	protected static final String[] m_say    = 
	{
		"Table of contents is hidden",
		"Press Alt-v to show TOC"
	};

	protected static final int margin     = 10;
	protected static final int say_height = 30;

	protected static final Color titleColor = Color.red.darker();

	protected static final Font m_titleFont = new Font("Helvetica", Font.BOLD, 14);
	protected static final Font m_textFont  = new Font("Helvetica", Font.PLAIN, 11); 

	// Need to subclass since want to pass right click mouse events up chain 

	class MyTree extends JTree implements MouseListener
	{
		protected TextTree	m_tocBox;

		public MyTree(TextTree tocBox)
		{
			super();

			m_tocBox = tocBox;
			addMouseListener(this);
		}
	
		// Generic 	MouseListener interface

		public void mouseClicked(MouseEvent ev)
		{
			if (ev.isMetaDown()) {
				int				x, y;
				TreePath		selPath;
				TreeNode		treeNode;
				EntityInstance	e;
				Diagram			diagram;
					
				x       = ev.getX();
				y       = ev.getY();
				selPath = getPathForLocation(x, y);
				if(selPath == null) {
					m_tocBox.mouseClicked(ev);
				} else {
					treeNode = (TreeNode) selPath.getLastPathComponent();
					if (treeNode != null) {
						e = (EntityInstance) ((DefaultMutableTreeNode) treeNode).getUserObject();
						if (e != null) {
							diagram = m_ls.getDiagram();
							if (diagram != null) {
								diagram.navigateTo(e);
		}	}	}	}	}	}
	

		public void mouseEntered(MouseEvent ev)
		{
		}

		public void mouseExited(MouseEvent e)
		{
		}

		public void mousePressed(MouseEvent ev)
		{
		}

		public void mouseReleased(MouseEvent ev)
		{
		}
	}

	protected LandscapeViewerCore m_ls;

	protected MyTree			  m_tree;
	protected JPanel			  m_say_panel;
	protected JComponent		  m_use;

	protected JTabbedPane		  m_tabbedPane;
	protected JScrollPane		  m_scrollPane;
	protected JLabel[]			  m_say_labels;

	// --------------
	// Public methods 
	// --------------

	public TextTree(LandscapeViewerCore ls, JTabbedPane tabbedPane) 
	{
		super();

		int						i, cnt;
		JLabel					say;

		setLayout(null);

		m_ls          = ls;
		m_tabbedPane  = tabbedPane;
		m_say_panel   = new JPanel();
//		m_say_panel.setBackground(Color.lightGray);

		m_say_panel.setLayout(new GridLayout(0, 1));

		cnt   = m_say.length;
		m_say_labels = new JLabel[cnt];
		for (i = 0; i < cnt; ++i) {
			m_say_labels[i] = say = new JLabel(m_say[i]);
			say.setBackground(Diagram.boxColour);
			say.setForeground(Color.red);
			say.setFont(m_textFont);
//			say.setPreferredSize(new Dimension(100,40));
			say.setVisible(true);
			m_say_panel.add(say);
		}
		m_say_panel.setSize(m_say_panel.getPreferredSize());
		fillTOC();

		setToolTipText(m_helpStr);

		m_scrollPane = new JScrollPane();
		m_scrollPane.setBounds(tabbedPane.getBounds());
		setBounds(tabbedPane.getBounds());
		m_scrollPane.setViewportView(this);

		tabbedPane.addTab("TOC", null, m_scrollPane, m_helpStr);
		addMouseListener(this);
	}
	
 	public void activate() 
	{
		m_tabbedPane.setSelectedComponent(m_scrollPane);
	}

	public boolean isActive() 
	{
		Component active;

		if (!isVisible()) {
			return(false);
		}
		active = m_tabbedPane.getSelectedComponent();
		return(active != null && this == active);
	}

	protected JPopupMenu buildPopup()
	{
		JPopupMenu m;

		
		m = new JPopupMenu("TOC options");


		if (m_use != null && m_use == m_tree && !m_ls.isViewer()) {
			Vector	clipboard = m_ls.getClipboard();
			// Get paths of all selected nodes
			TreePath[] paths = m_tree.getSelectionPaths();
			MyMenuItem	m1;
			if (clipboard == null || clipboard.size() == 0) {
				if (paths != null && paths.length > 0) {
					m1 = m_ls.cutMenuItem(m, m_ls);
					m1.setObject(this);
				}
			} else {
				if (paths != null && paths.length == 1) {
					m1 = m_ls.pasteMenuItem(m, m_ls);
					m1.setObject(this);
		}	}	}
		m_ls.tocMenuItem(m, m_ls);

		return(m);
	}

	// Identify the nodes to cut

	public Vector getGroup()
	{
		Vector	ret = null;

		if (m_use != null && m_use == m_tree) {
			MutableTreeNode	treeNode;
			EntityInstance	e;
			int				i, cnt;
			TreePath[]		paths = m_tree.getSelectionPaths();

			if (paths != null && (cnt = paths.length) > 0) {
				ret = new Vector(cnt);
				for (i = 0; i < cnt; ++i) {
					treeNode = (MutableTreeNode) paths[i].getLastPathComponent();
					e = (EntityInstance) ((DefaultMutableTreeNode) treeNode).getUserObject();
					ret.add(e);
		}	}	}
		return(ret);
	}

	// Identify the single selected node where we are to paste

	public EntityInstance targetEntity()
	{
		if (m_use != null && m_use == m_tree) {
			MutableTreeNode	treeNode;
			EntityInstance	e;
			TreePath[]		paths = m_tree.getSelectionPaths();

			if (paths != null && paths.length == 1) {
				treeNode = (MutableTreeNode) paths[0].getLastPathComponent();
				e = (EntityInstance) ((DefaultMutableTreeNode) treeNode).getUserObject();
				return(e);
		}	}	
		return(null);
	}

	protected void syncSizes()
	{
		Dimension d;

		d     = m_use.getPreferredSize();
		m_use.setSize(d);
		setSize(d);
	}

	// Free all memory used by TOC

	public void emptyTOC()
	{
		removeAll();
		m_use = null;
		if (m_tree != null) {
			m_tree = null;
	}	}

	protected void fillTOC(DefaultMutableTreeNode node, EntityInstance e)
	{
		Enumeration				en;	
		EntityInstance			child;
		DefaultMutableTreeNode	below;

		for (en = e.getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			below = new DefaultMutableTreeNode(child);
			node.add(below); 
			fillTOC(below, child);
	}	}

	protected void fillTOC() 
	{
		Diagram diagram = m_ls.getDiagram();
		JComponent	use;

		removeAll();
		m_use  = null;
		m_tree = null;

//		System.out.println("TextTree.fillToc() " + m_ls.isTocHidden());
		if (m_ls.isTocHidden() || diagram == null) {
			use = m_say_panel;
			setSize(use.getPreferredSize());
		} else {
			DefaultTreeCellRenderer	renderer;

			m_tree = new MyTree(this);
			m_tree.setBackground(Diagram.boxColour);
			m_tree.setFont(m_textFont);
			m_tree.setEditable(false);
			m_tree.setShowsRootHandles(true);
			renderer = (DefaultTreeCellRenderer) m_tree.getCellRenderer();
			renderer.setBackgroundNonSelectionColor(Diagram.boxColour);
//			renderer.setBackgroundSelectionColor(Color.BLUE); 
			m_tree.setCellRenderer(renderer);
			m_tree.getSelectionModel().setSelectionMode(TreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION);
			m_tree.setDragEnabled(true);

			EntityInstance root;
			DefaultMutableTreeNode	top;
			
			root = diagram.getRootInstance();
			top  = new DefaultMutableTreeNode(root);
			m_tree.setModel(new DefaultTreeModel(top, false));
			fillTOC(top, root);

			use = m_tree;
		}
		add(use);
		m_use = use;
		syncSizes();
		use.setVisible(true);
		repaint();
	}

	protected MutableTreeNode locateTreeNode(MutableTreeNode treeNode, EntityInstance e)
	{
		Enumeration		children;
		EntityInstance	e1;
		MutableTreeNode	ret;

		e1 = (EntityInstance) ((DefaultMutableTreeNode) treeNode).getUserObject();
		if (e == e1) {
			return(treeNode);
		}
		if (e1.hasDescendant(e)) {
			for (children = treeNode.children(); children.hasMoreElements(); ) {
				ret = locateTreeNode((MutableTreeNode) children.nextElement(), e);
				if (ret != null) {
					return(ret);
		}	}	}
		return(null);
	}

	protected MutableTreeNode locateTreeNode(EntityInstance e)
	{
		int					cnt;
		TreePath			path;
		MutableTreeNode		treeNode;
		MutableTreeNode		ret;

		ret = null;
		if (e != null) {
			path     = m_tree.getPathForRow(0);
			if (path != null) {
				treeNode = (MutableTreeNode) path.getLastPathComponent();
				if (treeNode != null) {
					ret = locateTreeNode(treeNode, e);
		}	}	}
		return(ret);
	}
			
	public void insertTOC(EntityInstance parent, EntityInstance e)
	{
		MutableTreeNode	node;

		if (m_use != null && m_use == m_tree) {
			node = locateTreeNode(parent);
			if (node != null) {
				DefaultTreeModel	model   = (DefaultTreeModel) m_tree.getModel();			
				MutableTreeNode		newNode = new DefaultMutableTreeNode(e);
    			// Insert new node as last child of node
				model.insertNodeInto(newNode, node, node.getChildCount());
	}	}	}

	public void deleteTOC(EntityInstance e)
	{
		MutableTreeNode	node;

		if (m_use != null && m_use == m_tree) {
			node = locateTreeNode(e);
			if (node != null) {
				DefaultTreeModel	model   = (DefaultTreeModel) m_tree.getModel();			
				// Remove node; if node has descendants, all descendants are removed as well
				model.removeNodeFromParent(node);
	}	}	}

	public void deleteJustMeTOC(EntityInstance e)
	{
		MutableTreeNode	node;

		if (m_use != null && m_use == m_tree) {
			node = locateTreeNode(e);
			if (node != null) {
				DefaultTreeModel	model   = (DefaultTreeModel) m_tree.getModel();			
				Enumeration			children;
				MutableTreeNode		parent, child;

				parent = (MutableTreeNode) node.getParent();
				for (children = node.children(); children.hasMoreElements(); ) {
					child = (MutableTreeNode) children.nextElement();
					// Remove child; if child has descendants, all descendants are removed as well
					model.removeNodeFromParent(child);
    				// Insert new node as last child of grandparent
					model.insertNodeInto(child, parent, parent.getChildCount());
				}
				model.removeNodeFromParent(node);
	}	}	}

	public void validate()
	{
		m_use.setBounds(0, 0, getWidth(), getHeight());
	}

	public Dimension getPreferredSize()
	{
		return(m_use.getPreferredSize());
	}

	public void setBounds(int x, int y, int width, int height)
	{	
		super.setBounds(x, y, width, height);
		if (m_use != null) {
			m_use.setBounds(x, y, width, height);
	}	}
			
	protected void closeAll()
	{
		int			i, cnt;

		cnt = m_tree.getRowCount();
		for (i = cnt; i > 0; ) {
			m_tree.collapseRow(--i);
		}
	}
		
	protected void expandTo(EntityInstance e)
	{
		int				cnt;
		TreePath		path;
		TreeNode		treeNode;
		EntityInstance	e1;

		closeAll();
		m_tree.clearSelection();
		if (e != null) {
			for (cnt = 0; cnt < m_tree.getRowCount(); ++cnt) {
				path     = m_tree.getPathForRow(cnt);
				treeNode = (TreeNode) path.getLastPathComponent();
				if (treeNode != null) {
					e1 = (EntityInstance) ((DefaultMutableTreeNode) treeNode).getUserObject();
					if (e1 != null) {
						if (e1 == e) {
							m_tree.setSelectionRow(cnt);
							m_tree.scrollRowToVisible(cnt);
							break;
						}
						if (e1.hasDescendant(e)) {
							m_tree.expandRow(cnt);
	}	}	}	}	}	} 
		
	public void toc_path()
	{
		Diagram diagram = m_ls.getDiagram();
		EntityInstance e;

		if (diagram != null) {
			m_ls.setTocHidden(false);
			activate();
			e = diagram.getDrawRoot();
			expandTo(e);
			syncSizes();
	}	}

	protected void expandAll()
	{
		int	cnt;

		for (cnt = 0; cnt < m_tree.getRowCount(); ++cnt) {
			m_tree.expandRow(cnt);
	}	}

	// Open up or close down the Table of contents

	public void switch_TOC()
	{
		int	cnt;

		m_ls.setTocHidden(false);
		activate();
		cnt = m_tree.getRowCount();
		if (cnt > 1) {
			closeAll();
		} else {
			expandAll();
		}
		syncSizes();
	}	

	// Generic 	MouseListener interface

	public void mouseClicked(MouseEvent ev)
	{
		if (ev.isMetaDown()) {
			int				x, y;
			TreePath		selPath;
			TreeNode		treeNode;
			EntityInstance	e;
			Diagram			diagram;
			JPopupMenu		popupMenu;
					
			x         = ev.getX();
			y         = ev.getY();
			popupMenu = buildPopup();
			add(popupMenu);
			popupMenu.show(this, x, y);
			remove(popupMenu);
	}	}

	public void mouseEntered(MouseEvent ev)
	{
	}

	public void mouseExited(MouseEvent e)
	{
	}

	public void mousePressed(MouseEvent ev)
	{
	}

	public void mouseReleased(MouseEvent ev)
	{
	}



}





