package lsedit;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.*;
import javax.swing.*;

public class UnderlinedLabel extends JLabel 
{
	public final int DROP  = 3;
	public final int EXTRA = 4;

	public UnderlinedLabel()
	{
		super();
	}

	public UnderlinedLabel(String text)
	{
		super(text);

		Dimension dim = super.getPreferredSize();
		dim.height += EXTRA;
		setPreferredSize(dim);
	}
	
	public void paintComponent(Graphics g)
	{
		int	at;

		super.paintComponent(g);
		
		at = super.getY() + super.getHeight() + DROP;
		g.drawLine(super.getX(), at, super.getX() + super.getWidth(), at); 
	}

	public int getHeight()
	{
		return(super.getHeight() + EXTRA);
	}

	public void setBounds(int x, int y, int width, int height) 
	{
		super.setBounds(x,y, width, height-EXTRA);
	}

	public void setBounds(Rectangle r)
	{
		r.height -= EXTRA;
		super.setBounds(r);
	}
	
	public Rectangle getBounds(Rectangle r)
	{	
		r = super.getBounds(r);
		r.setSize(r.x, r.y + EXTRA);
		return(r);
	}
	
	public Rectangle getBounds()
	{
		Rectangle r = new Rectangle();
		return(getBounds(r));
	}
}

