package lsedit;

// Needs to be parent class of EditModeHandler

import java.awt.Cursor;
import java.awt.Container;
import java.awt.Event;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

// The Edit and View ModeHandler are toggled by typing 'V'

public class ViewModeHandler extends LandscapeModeHandler /* extends Object */
{

	protected final static int MENU_BASE				= 2000;

	protected final static double SMALL_SCALE_UP		= 1.2; 
	protected final static double SMALL_SCALE_DOWN		= 0.8; 
	protected final static String SMALL_SCALE_STRING	= "20%";

	// Supported modes

	protected MoveModeHandler	  m_moveHandler;
	protected ResizeModeHandler	  m_resizeHandler;
	protected NavigateModeHandler m_navHandler;
	protected GroupModeHandler	  m_groupingHandler;

	protected LandscapeModeHandler m_handler = null;
	private	long			      m_lastUp;

	// Supported popups

	protected JPopupMenu		  m_rootEntityPopup;
	protected JPopupMenu		  m_entityPopup;
	protected JPopupMenu		  m_relationPopup;

	protected JPopupMenu buildRootPopup()
	{
		JPopupMenu m;
		JMenu	   m1;
		
		m = new JPopupMenu("Root options");

		m1 = new JMenu("Draw");
		Do.fontMenuItem(m1, m_ls);
		m.add(m1);

		m1 = new JMenu("Move");
		Do.groupAllMenuItem(m1, m_ls);
		m.addSeparator();
		Do.scaleMenuItem(m1, m_ls);
		m.add(m1);
		return(m);
	}
	
	protected JPopupMenu buildEntityPopup()
	{
		JPopupMenu m;
		
		m = new JPopupMenu("Entity options");

		Do.queryMenuItem(m, m_ls);
		m.addSeparator();
		Do.hideMenuItem(m, m_ls);
		m.addSeparator();
		Do.groupAllMenuItem(m, m_ls);
		m.addSeparator();
		Do.scaleMenuItem(m, m_ls);
		return(m);
	}
	
	protected JPopupMenu buildRelationPopup()
	{
		JPopupMenu m;
		
		m = new JPopupMenu("Edge options");
		Do.navigateEdgeMenu(m, m_ls);
		return(m);
	}
	
	protected int[] resizeCursor =
		{ 
			Cursor.NW_RESIZE_CURSOR, Cursor.N_RESIZE_CURSOR, 
			Cursor.NE_RESIZE_CURSOR, Cursor.E_RESIZE_CURSOR, 
			Cursor.SE_RESIZE_CURSOR, Cursor.S_RESIZE_CURSOR,
			Cursor.SW_RESIZE_CURSOR, Cursor.W_RESIZE_CURSOR, 
		};

	protected int curX, curY;


	// -----------------
	// Protected methods
	// -----------------

	public void processSelectList(Vector edges, int key) 
	{
		Enumeration			en;
		RelationInstance	edge;
		EntityInstance		drawSrc, drawDst;

		ResultBox resultBox = m_ls.getResultBox();
		resultBox.setResultTitle("SELECTED RELATIONS:");

		for (en = edges.elements(); en.hasMoreElements(); ) {
			edge    = (RelationInstance) en.nextElement();
			drawSrc = edge.getDrawSrc();
			drawDst = edge.getDrawDst();
			switch (key) {
			case Do.EDGE_OPEN_LOW:
				drawSrc.orAllContainedSrcRelationsDstUnder(drawDst);
				break;
			case Do.EDGE_OPEN_SRC:
				drawDst.orDstRelationsSrcUnder(drawDst);
				break;
			case Do.EDGE_OPEN_DST:
				drawSrc.orSrcRelationsDstUnder(drawDst);
				break;
		}	}

		for (en = edges.elements(); en.hasMoreElements(); ) {
			edge    = (RelationInstance) en.nextElement();
			drawSrc = edge.getDrawSrc();
			drawDst = edge.getDrawDst();
			switch (key) {
			case Do.EDGE_OPEN_LOW:
				drawSrc.addSrcDstRelations(RelationInstance.ADD_RESULTS_MARK, resultBox);
				break;
			case Do.EDGE_OPEN_SRC:
				drawDst.addDstRelations(RelationInstance.ADD_RESULTS_MARK, resultBox);
				break;
			case Do.EDGE_OPEN_DST:
				drawSrc.addSrcRelations(RelationInstance.ADD_RESULTS_MARK, resultBox);
				break;
			default:
				resultBox.addRelation(edge);
		}	}

//		resultBox.activate();
		resultBox.validate();
		m_dg.selectEdges(edges);
	}

	protected void selectEntity(EntityInstance e) 
	{
		if (e.getGroupFlag()) {
			// Already a member of a group

			if (e != m_dg.getKeyEntity()) {
				m_dg.setKeyEntity(e);
			}
		} else {
			EntityInstance old_ke = m_dg.getKeyEntity();

			if (old_ke != null) {
				m_dg.clearGroupFlags();
			}
			m_dg.setKeyEntity(e);
		}
	}

	protected void doHandleElision(int key, Object object) 
	{
		Vector grp = m_dg.targetEntities(object);

		if (grp == null) {
			return;
		}

		Enumeration en;
		EntityInstance ge;

		for (en = grp.elements(); en.hasMoreElements(); ) {
			ge = (EntityInstance) en.nextElement();

			switch(key)	{
			case Do.SHOW_CONTENTS:
				// Toggle contain elision
				m_dg.toggleContainElision(ge);
				break;

			case Do.DST_EDGES:
				m_dg.toggleDstElision(ge);
				break;

			case Do.SRC_EDGES:
				m_dg.toggleSrcElision(ge);
				break;

			case Do.ENTERING_EDGES:
				if (ge.isOpen()) {
					m_dg.toggleEnteringElision(ge);
				}
				break;

			case Do.EXITING_EDGES:
				if (ge.isOpen()) {
					m_dg.toggleExitingElision(ge);
				}
				break;
			
			case Do.INTERNAL_EDGES:
				if (ge.isOpen()) {
					m_dg.toggleInternalElision(ge);
				}
				break;
			}
		}
		m_dg.redrawDiagram();
	}

	protected void handleElision(int key, Object object) 
	{
		String em = "";

		switch(key)	{
		case Do.SHOW_CONTENTS:
			 // Toggle contain elision
			 em = "Containment";
			 doHandleElision(key, object);
			 break;

		case Do.DST_EDGES:
			em = "Target ";
			doHandleElision(key, object);
			break;

		case Do.SRC_EDGES:
			em = "Source "; 
			doHandleElision(key, object);
			break;

		case Do.ENTERING_EDGES:
			em = "Entering";
			doHandleElision(key, object);
			break; 

		case Do.EXITING_EDGES:
			em = "Exiting";
			doHandleElision(key, object);
			break;

		case Do.INTERNAL_EDGES:
			em = "Internal edges";
			doHandleElision(key, object);
			break;
		}

		m_ls.doFeedback(em + " elision toggled for group");
	}

	protected void edgeNavigateSrc(Object object) 
	{
		RelationInstance ri = m_dg.targetRelation(object);

		if (ri == null) {
			return;
		}
		navigateTo(ri.getSrc()); 
	}

	protected void edgeNavigateDst(Object object) 
	{
		RelationInstance ri = m_dg.targetRelation(object);

		if (ri == null) {
			return;
		}
		navigateTo(ri.getDst()); 
	}

	protected void handleEdgeExpansion(int key, Object object) 
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		visible, src, dst, drawRoot;
		String				msg, msg1;
		Vector				edges;

		edges = m_dg.targetRelations(object);
		if (edges == null) {
			return;
		}
		msg = null;

		switch (key) {
		case Do.EDGE_OPEN_LOW:
			msg1 = "Opened sources and destinations of edges.";
			break;
		case Do.EDGE_OPEN_SRC:
			msg1 = "Opened sources of edges.";
			break;
		case Do.EDGE_OPEN_DST:
			msg1 = "Opened destination of edges.";
			break;
		case Do.EDGE_CLOSE_LOW:
			msg1 = "Closed source and destination of edges";
			break;
		case Do.EDGE_CLOSE_SRC:
			msg1 = "Closed source of edges";
			break;
		default:
			msg1 = "Closed source and destination of edges";
			break;
		}

		drawRoot = m_dg.getDrawRoot();

		for (en = edges.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();

			switch (key) {
			case Do.EDGE_OPEN_SRC:
			case Do.EDGE_OPEN_LOW:
				visible = ri.getDrawSrc();
				src     = ri.getSrc();
				for (;;) {
					src = src.getContainedBy();
					if (src == null) {
						break;
					}

					if (src.isDstRelationElided(Diagram.CONTAIN_ID)) {
//						System.out.println("Opening " + src);
						m_dg.toggleContainElision(src);
						msg = msg1;
					}
					if (src == visible) {
						break;
				}	}
				break;
			case Do.EDGE_CLOSE_LOW:
			case Do.EDGE_CLOSE_SRC:
				dst = ri.getDst();
				src = ri.getSrc();
				for (;;) {
					src = src.getContainedBy();
					if (src == null) {
						break;
					}
					if (!drawRoot.hasDescendant(src)) {
						break;
					}
					if (src == dst || src.hasDescendant(dst)) {
						break;
					}
					if (!src.isDstRelationElided(Diagram.CONTAIN_ID)) {
						m_dg.toggleContainElision(src);
						msg = msg1;
				}	}
				break;
			}

			switch (key) {
			case Do.EDGE_OPEN_DST:
			case Do.EDGE_OPEN_LOW:
				visible = ri.getDrawDst();
				dst     = ri.getDst();
				for (;;) {
					dst = dst.getContainedBy();
					if (dst == null) {
						break;
					}
					if (dst.isDstRelationElided(Diagram.CONTAIN_ID)) {
						m_dg.toggleContainElision(dst);
						msg = msg1;
					}
					if (dst == visible) {
						break;
				}	}
				break;
			case Do.EDGE_CLOSE_LOW:
			case Do.EDGE_CLOSE_DST:
				dst = ri.getDst();
				src = ri.getSrc();
				for (;;) {
					dst = dst.getContainedBy();
					if (dst == null) {
						break;
					}
					if (!drawRoot.hasDescendant(dst)) {
						break;
					}
					if (src == dst || dst.hasDescendant(src)) {
						break;
					}
					if (!dst.isDstRelationElided(Diagram.CONTAIN_ID)) {
						m_dg.toggleContainElision(dst);
						msg = msg1;
				}	}
				break;
		}	}

		if (msg != null) {
			processSelectList(edges, key);
			m_ls.doFeedback(msg);
			m_ls.redrawDg();
		} else {
		switch (key) {
			case Do.EDGE_OPEN_LOW:
			case Do.EDGE_OPEN_SRC:
			case Do.EDGE_OPEN_DST:
				msg = "No further expansion is possible";
				break;
			default:
				msg = "No further contraction is possible";
			}	
			m_ls.error(msg);
		}
	}


	// -------
	// Queries
	// -------

	protected boolean goodQueryEdge(EntityInstance src, EntityInstance dst, EntityInstance root)
	{
		if (src.hasDescendant(dst) || dst.hasDescendant(src))
			return false;

		if (src.isClientOrSupplier()) { 
			return root.hasDescendant(dst);
		}
		return true;
	}

	protected int addToForwardEntityList(EntityInstance te, EntityInstance e, RelationClass rc, Vector list)
	{
		Enumeration		en;
		RelationInstance ri;
		EntityInstance	root = m_dg.getDrawRoot();
		EntityInstance	dst, vdst, ne;

		int num = 0;

//		System.out.println("ViewModeHandler.addToForwardEdgeList " + e);
		for (en = e.srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
//			System.out.println("ViewModeHandler.addToForwardEdgeList " + ri);
			if (ri.getRelationClass() == rc) {
				dst  = ri.getDst();
				vdst = ri.getDrawDst();

				if (vdst != null && goodQueryEdge(te, dst, root)) {

					ri.setHighlightFlag();
					dst.setRedBoxFlag();

					if (list.indexOf(vdst) < 0) {
						vdst.setRedBoxFlag();
						if (m_ls.getGroupQueryFlag()) {
							vdst.setGroupFlag();
						}
						list.addElement(vdst);
						num++;
					}	
				}
			}
		}
		return num;
	}

	protected int addForwardRelation(EntityInstance e, RelationClass rc, ResultBox resultBox, boolean alwaysShowReln)
	{
		Vector list = new Vector();

		int num = addToForwardEntityList(e, e, rc, list);

		if (num > 0 || alwaysShowReln) {
			resultBox.addForwardRelation(e, rc, list);
		}
		return num;
	}

	protected int showForwardEdges(EntityInstance e, ResultBox resultBox) 
	{
		int num = 0;

		if (!e.isSupplier()) {
			Enumeration en;

			for (en = m_dg.enumRelationClasses(); en.hasMoreElements(); ) {
				RelationClass rc = (RelationClass) en.nextElement();
//				System.out.println("ViewModeHandler.showForwardEdges class " + rc);
				if (rc.isActive()) {
					num += addForwardRelation(e, rc, resultBox, false);
//					System.out.println("ViewModeHandler.showForwardEdges num " + num);
		}	}	}
		return num;
	}

	// Get all of the relationships from visited destinations to earlier sources

	protected void getSrcRelationWithClosure(EntityInstance e, Vector list)
	{
		Enumeration en;

		EntityInstance root = m_dg.getDrawRoot();

		for (en = e.srcRelationElements(); en.hasMoreElements(); ) {
			RelationInstance ri = (RelationInstance) en.nextElement();

			EntityInstance dst = ri.getDst();

			// Using highlight flag to mark visitation

			boolean visited = dst.isMarked(EntityInstance.REDBOX_MARK);

			ri.setHighlightFlag();

			if (list.indexOf(ri) < 0) 
				list.addElement(ri);

			if (!visited) {
				dst.setRedBoxFlag();
				if (m_ls.getGroupQueryFlag())
					dst.setGroupFlag();
		
				getSrcRelationWithClosure(dst, list);
			}
		}
	}

	protected int addRelations(EntityInstance e, RelationClass rc, Vector list, ResultBox resultBox, boolean src)
	{

		int num = 0;

		if (list.size() > 0) {
			Vector	sublist = new Vector();
			Enumeration en;

			for (en = list.elements(); en.hasMoreElements(); ) {
				RelationInstance ri = (RelationInstance) en.nextElement();

				if (ri.getRelationClass() == rc) {
					ri.setHighlightFlag();
					sublist.add(ri);
					// nsb.append("\t" + ri.getSrc().getLabel() + " " + ri.getDst().getLabel() + "\n");
					num++;
			}	}

			if (num > 0) {
				resultBox.addRelations(e, rc, sublist, src);
			}
		}

		return num;
	}

	// Performed when FORWARD_CLOSURE is pressed

	protected int showSrcEdgesWithClosure(EntityInstance e, ResultBox resultBox) 
	{
		Enumeration en;
		RelationClass rc;
		Vector list = new Vector();

		int num = 0;

		m_dg.clearQueryFlags();
		getSrcRelationWithClosure(e, list);
		m_dg.clearQueryFlags();

		for (en = m_dg.enumRelationClasses(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement();

			if (rc.isActive()) {
				num += addRelations(e, rc, list, resultBox, true);
		}	}
		return num;
	}

	// Backtrace

	public int addToBackEntityList(EntityInstance te, EntityInstance e,	RelationClass rc, Vector list)
	{
		Enumeration en;
		RelationInstance ri;
		EntityInstance child, src, vsrc;

		int num = 0;

		EntityInstance root = m_dg.getDrawRoot();

		for (en = e.dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();

			if (ri.getRelationClass() == rc) {
				src = ri.getSrc();
				vsrc = ri.getDrawSrc();

				if (vsrc != null && goodQueryEdge(src, te, root)) {
					ri.setHighlightFlag();
					src.setRedBoxFlag();

					if (list.indexOf(vsrc) < 0) {
						vsrc.setRedBoxFlag();
						if (m_ls.getGroupQueryFlag())
							vsrc.setGroupFlag();
		
						list.addElement(vsrc);
						num++;
		}	}	}	}
		return num;
	}

	public int addBackRelation(EntityInstance e, RelationClass rc, ResultBox resultBox, boolean alwaysShowReln)
	{
		Vector list = new Vector();

		int num = addToBackEntityList(e, e, rc, list);

		if (num > 0 || alwaysShowReln) {
			resultBox.addBackRelation(e, rc, list);
		}
		return num;
	}

	public int showBackEdges(EntityInstance e, ResultBox resultBox) 
	{
		int num = 0;

		if (!e.isClient()) {

			Enumeration en;
			RelationClass rc;

			for (en = m_dg.enumRelationClasses(); en.hasMoreElements(); ) {
				rc = (RelationClass) en.nextElement();
				if (rc.isActive()) {
					num += addBackRelation(e, rc, resultBox, false);
		}	}	}	
		return num;
	}


	protected void getDstRelationWithClosure(EntityInstance e, Vector list)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		src;
		boolean				visited;

		for (en = e.dstRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			src = ri.getSrc();

			visited = src.isMarked(EntityInstance.REDBOX_MARK);
			ri.setHighlightFlag();
			if (list.indexOf(ri) < 0) {
				list.addElement(ri);
			}

			if (!visited) {
				src.setRedBoxFlag();
				if (m_ls.getGroupQueryFlag()) {
					src.setGroupFlag();
				}
				getDstRelationWithClosure(src, list);
			}
		}
	}

	// Backward closure

	protected int showDstEdgesWithClosure(EntityInstance e, ResultBox resultBox) 
	{
		Enumeration en;
		Vector list = new Vector();

		int num = 0;

		m_dg.clearQueryFlags();
		getDstRelationWithClosure(e, list);
		m_dg.clearQueryFlags();


		for (en = m_dg.enumRelationClasses(); en.hasMoreElements(); ) {
			RelationClass rc = (RelationClass) en.nextElement();

			if (rc.isActive()) {
				num += addRelations(e, rc, list, resultBox, false);
		}	}
		return num;
	}

	protected int showContents(EntityInstance e, ResultBox resultBox) 
	{
		Enumeration en;
		Vector list = new Vector();
		int n = 0;

		for (en = e.getChildren(); en.hasMoreElements(); ) {
			list.add(en.nextElement());
			n++;
		}
		if (n > 0) {
			SortVector.byString(list);
		}
		resultBox.addContents(e, list);
		return n;
	}

	protected int showContentsWithClosure(EntityInstance e, ResultBox resultBox)
	{ 
		Enumeration en;
		int			n;

		n = showContents(e, resultBox);

		for (en = e.getChildren(); en.hasMoreElements(); ) {
			n += showContentsWithClosure((EntityInstance) en.nextElement(), resultBox);
		}
		return n;
	}

	protected int doQueryEntity(EntityInstance e, int query, ResultBox resultBox) 
	{
		switch(query) {
		case Do.FORWARD_QUERY:
			return showForwardEdges(e, resultBox);

		case Do.BACKWARD_QUERY:
			return showBackEdges(e, resultBox);

		case Do.FORWARD_CLOSURE:
			return showSrcEdgesWithClosure(e, resultBox);

	
		case Do.BACKWARD_CLOSURE:
			return showDstEdgesWithClosure(e, resultBox);

		case Do.CONTENTS_QUERY:
			return showContents(e, resultBox);

		case Do.CONTENT_CLOSURE:
			return showContentsWithClosure(e, resultBox);

		default:
			return 0;
		}
	}

	protected void queryEntity(int query, Object object) 
	{
		Enumeration		en;
		ResultBox		resultBox  = m_ls.getResultBox();
		Vector			grp        = m_dg.targetEntities(object);
		String			title;

		if (!m_dg.getQueryPersistance()) {
			m_dg.clearQueryFlags();
		}

		switch(query) {
		case Do.FORWARD_QUERY:
			title = "FORWARD QUERY";
			break;
		case Do.FORWARD_CLOSURE:
			title = "FORWARD QUERY (closure)";
			break;
		case Do.BACKWARD_QUERY:
			title = "BACKWARD QUERY";
			break;
		case Do.BACKWARD_CLOSURE:
			title = "BACKWARD QUERY (closure)";
			break;
		default:
			title = null;
		}

		resultBox.setResultTitle(title);

		if (grp == null || grp.isEmpty()) {
			m_ls.error("No entity or group is selected");
			resultBox.validate();
			return;
		}

		int num = 0;

		for (en = grp.elements(); en.hasMoreElements(); ) {
			EntityInstance ge = (EntityInstance) en.nextElement();

			num += doQueryEntity(ge, query, resultBox);
		}

		if (num == 0) {
			resultBox.addText("NO ENTITIES");
		}
		resultBox.validate();
		m_dg.clearDrawEdges();
	}

	protected void queryContents(int key) 
	{
		Enumeration		en;
		ResultBox		resultBox  = m_ls.getResultBox();
		Vector			grp        = m_dg.getGroup();
		EntityInstance  ge;
		String			title;

		switch (key) {
			case Do.CONTENT_CLOSURE:
				title = "CONTENTS (CLOSURE)";
				break;
			case Do.CONTENTS_QUERY:
				title = "CONTENTS";
				break;
			default:
				title = null;
		}

		resultBox.setResultTitle(title);

		if (grp == null || grp.isEmpty()) {
			doQueryEntity(m_dg.getDrawRoot(), key, resultBox);
			resultBox.validate();
			return;
		}

		int num = 0;

		for (en = grp.elements(); en.hasMoreElements(); ) {
			ge = (EntityInstance) en.nextElement();
			num += doQueryEntity(ge, key, resultBox);
		}

		if (num == 0) {
			resultBox.addText("NO ENTITIES");
		}
		resultBox.validate();
	}

	protected void doScaleEntity(EntityInstance ge, int scale, boolean incFlag) 
	{
		switch(scale) {
		case Do.DECREASE_WIDTH:
			ge.scaleX(SMALL_SCALE_DOWN, incFlag);
			break; 

		case Do.INCREASE_WIDTH:
			ge.scaleX(SMALL_SCALE_UP, incFlag);
			break; 

		case Do.DECREASE_HEIGHT:
			ge.scaleY(SMALL_SCALE_DOWN, incFlag);
			break; 

		case Do.INCREASE_HEIGHT:
			ge.scaleY(SMALL_SCALE_UP, incFlag);
			break; 

		case Do.DECREASE_SIZE:
			ge.scale(SMALL_SCALE_DOWN, incFlag);
			break;

		case Do.INCREASE_SIZE:
			ge.scale(SMALL_SCALE_UP, incFlag);
			break;
		}
	}

	protected void scaleEntity(int scale, boolean incFlag) 
	{
		Vector grp = m_dg.getGroup();

		if (grp != null) {
			Enumeration en;

			switch (grp.size()) {
			case 0:
				break;
			case 1:
				if (grp.firstElement() == m_dg.getDrawRoot()) {
					break;
				}
			default:
				for (en = grp.elements(); en.hasMoreElements(); ) {
					EntityInstance ge = (EntityInstance) en.nextElement();
					doScaleEntity(ge, scale, incFlag);
				}
				return;
		}	}

		// Do it to root

		switch (scale) {
		case Do.INCREASE_SIZE:
			// Zoom in
			if (m_dg.zoom(SMALL_SCALE_UP, SMALL_SCALE_UP)) {
				m_ls.doFeedback( "Zoomed in (" + SMALL_SCALE_STRING + ")");
			}
			return;

		case Do.DECREASE_SIZE:
			// Zoom out
			if (m_dg.zoom(SMALL_SCALE_DOWN, SMALL_SCALE_DOWN)) {
				m_ls.doFeedback( "Zoomed out (" + SMALL_SCALE_STRING + ")");
			}
			return;

		case Do.INCREASE_WIDTH:
			if (m_dg.zoom(SMALL_SCALE_UP, 1.0)) {
				m_ls.doFeedback("Scaled X direction (" + SMALL_SCALE_STRING + ")");
			}
			return;

		case Do.DECREASE_WIDTH:
			if (m_dg.zoom(SMALL_SCALE_DOWN, 1.0)) {
				m_ls.doFeedback("Scaled X direction (-" + SMALL_SCALE_STRING + ")");
			}
			return;

		case Do.INCREASE_HEIGHT:
			if (m_dg.zoom(1.0, SMALL_SCALE_UP)) {
				m_ls.doFeedback("Scaled Y direction (" + SMALL_SCALE_STRING + ")");
			}
			return;

		case Do.DECREASE_HEIGHT:
			if (m_dg.zoom(1.0, SMALL_SCALE_DOWN)) {
				m_ls.doFeedback("Scaled Y direction (-" + SMALL_SCALE_STRING + ")");
			}
			return;
		}
	}

	protected boolean exclusiveEntityCommand(int key) 
	{
		switch(key)	{
		case Do.DESCEND:
		case Do.MOVE_GROUP_UP:
		case Do.MOVE_GROUP_DOWN:
		case Do.MOVE_GROUP_LEFT:
		case Do.MOVE_GROUP_RIGHT:
			return true;
		}

		return false;
	}

	protected void navigateTo(EntityInstance e) 
	{
		m_ls.followLink(e, false);
	}

	// Overloaded by EditModeHandler

	protected boolean handleCommands(int key, int modifiers, Object object) 
	{
//		System.out.println("ViewModeHandler:handleCommands(" + key + ", " + ", " + modifiers + ", " + object +")");

		if (modifiers == Event.CTRL_MASK) {
			switch(key)	{
			case Do.GROUP_ALL:
				m_groupingHandler.groupAll();
				break;
			default:
				return false;
			}
		} else if ((modifiers & Event.ALT_MASK) != 0) {
			// Alt key set if get here
			switch(key)	{
			case Do.CONTENT_CLOSURE:
				queryContents(key);
				break;
			case Do.EDGE_OPEN_LOW:
			case Do.EDGE_OPEN_SRC:
			case Do.EDGE_OPEN_DST:
			case Do.EDGE_CLOSE_LOW:
			case Do.EDGE_CLOSE_SRC:
			case Do.EDGE_CLOSE_DST:
				handleEdgeExpansion(key, object);
				return true;
			case Do.EDGE_NAVIGATE_SRC:
				edgeNavigateSrc(object);
				return true;
			case Do.EDGE_NAVIGATE_DST:
				edgeNavigateDst(object);
				return true;
			default:
				return false;
			}
		} else if (modifiers == Event.SHIFT_MASK) {
			switch (key) {
			case Do.ASCEND:	// Special key SHIFT still set
			{
				EntityInstance e = m_dg.targetEntity(object);
				if (e == null) {
					return false;
				}
				m_dg.setDrawRoot(e);
				m_dg.navigateToDrawRootParent();
				break;
			}
			default:
				return false;
			}
		} else {
			switch(key)	{
			case Do.CONTENTS_QUERY:
				queryContents(key);
				break;
			case Do.FORWARD_QUERY:
			case Do.FORWARD_CLOSURE:
			case Do.BACKWARD_QUERY:
			case Do.BACKWARD_CLOSURE:		
				queryEntity(key, object);
				break;

			case Do.SHOW_CONTENTS:
			case Do.DST_EDGES:
			case Do.ENTERING_EDGES:
			case Do.SRC_EDGES:
			case Do.EXITING_EDGES:
			case Do.INTERNAL_EDGES:
				handleElision(key, object);
				break;

			case Do.DECREASE_WIDTH:
			case Do.INCREASE_WIDTH:
			case Do.DECREASE_HEIGHT:
			case Do.INCREASE_HEIGHT:
			case Do.DECREASE_SIZE:
			case Do.INCREASE_SIZE:
				scaleEntity(key, !mouseIsDown);
				break;
			case Do.MOVE_GROUP_UP:
			case Do.MOVE_GROUP_DOWN:
			case Do.MOVE_GROUP_LEFT:
			case Do.MOVE_GROUP_RIGHT:
				m_groupingHandler.moveGroup(key);
				break;

			case Do.DESCEND:
			{
				EntityInstance e = m_dg.targetEntity(object);
				if (e == null) {
					return false;
				}

				EntityInstance drawRoot = m_dg.getDrawRoot();

				if (e == drawRoot) {
					m_ls.error("Already in: " + e.getLabel());
				} else if (e == drawRoot.getContainedBy()) {
					// Going up
					navigateTo(e);
				} else if (e.isClientOrSupplier()) {
					if (e.hasChildren()) {
						navigateTo(e);
					} else {
						navigateTo(e.getEnterableParent());
					}
				} else {
					// Going down

					while (e.getContainedBy() != drawRoot && !e.getContainedBy().isEnterable()) {
						e = e.getContainedBy();
					}

					if (e.isEnterable()) {
						navigateTo(e);
					} else {
						m_ls.error("Can't navigate into: " + e.getLabel());
					}
				}
				break;
			}
			default:
				return false;
			}
		} 
		m_ls.redrawDg();
		return true;
	}

	// --------------
	// Public methods
	// --------------

	public ViewModeHandler() 
	{
		m_moveHandler     = new MoveModeHandler();
		m_resizeHandler   = new ResizeModeHandler();
		m_navHandler      = new NavigateModeHandler();
		m_groupingHandler = new GroupModeHandler(this);
	}

	public void init(LandscapeViewerCore ls) 
	{
		// N.B. Do not assume Diagram exists yet

		super.init(ls);

		m_moveHandler.init(ls);
		m_resizeHandler.init(ls);
		m_navHandler.init(ls);
		m_groupingHandler.init(ls);
	}
	
	public void select(Diagram dg) 
	{
		super.select(dg);

		m_moveHandler.select(dg);
		m_resizeHandler.select(dg);
		m_navHandler.select(dg);
		m_groupingHandler.select(dg);
	}

	public void cleanup() 
	{
		super.cleanup();

		m_moveHandler.cleanup();
		m_resizeHandler.cleanup();
		m_navHandler.cleanup();
		m_groupingHandler.cleanup();
	}

	public void processKey(int key, int modifiers, Object object) 
	{
//		System.out.println("ViewModeHandler:processKey(" + key + ", " + ", " + modifiers + ", " + object +")");

		if ((modifiers & Event.ALT_MASK) != 0) {
			switch (key) {
			case Do.EDGE_OPEN_LOW:
			case Do.EDGE_OPEN_SRC:
			case Do.EDGE_OPEN_DST:
			case Do.EDGE_CLOSE_LOW:
			case Do.EDGE_CLOSE_SRC:
			case Do.EDGE_CLOSE_DST:
				handleEdgeExpansion(key, object);
				return;
			case Do.EDGE_NAVIGATE_SRC:
				edgeNavigateSrc(object);
				return;
			case Do.EDGE_NAVIGATE_DST:
				edgeNavigateDst(object);
				return;
		}	}

		handleCommands(key, modifiers, object);
	}

	protected static void usesObject(Object c, Object object)
	{
		if (c instanceof MyMenuItem) {
			((MyMenuItem) c).setObject(object);
			return;
		}
		if (c instanceof JMenu) {
			JMenu 		c1;
			JMenuItem	item;
			int		i;
			
			c1 = (JMenu) c;
			for (i = c1.getItemCount(); i > 0; ) {
				item = c1.getItem(--i);
				if (item != null) {
					usesObject(item, object);
			}	}
			return;
		}				
		if (c instanceof Container) {
			Container	c1;
			int			i;

			c1 = (Container) c;
			for (i = c1.getComponentCount(); i > 0; ) {
				usesObject(c1.getComponent(--i), object);
			}
			return;
		}
		System.out.println("ViewModeHandler.usesObject " + c);
	}

		
	public void rightClickEntity(MouseEvent ev, EntityInstance e, int x, int y)
	{
		JPopupMenu	m;

		if (e == m_dg.getRootInstance()) {
			m = m_rootEntityPopup;
			if (m == null) {
				m_rootEntityPopup = m = buildRootPopup();
			}
		} else {
			m = m_entityPopup;
			if (m == null) {
				m_entityPopup = m = buildEntityPopup();
		}	}
	
		usesObject(m, e);
		m_ls.add(m);
		m.show(m_ls.getContentPane(), m_ls.getDiagramX()+x, m_ls.getDiagramY()+y);
	}

	public void rightClickRelation(MouseEvent ev, RelationInstance ri, int x, int y)
	{
		JPopupMenu	m;

		m = m_relationPopup;
		if (m == null) {
			m_relationPopup = m = buildRelationPopup();
		}
		usesObject(m, ri);
		m_ls.add(m);
		m.show(m_ls.getContentPane(), m_ls.getDiagramX()+x, m_ls.getDiagramY()+y);
	}

	public boolean entityPressed(MouseEvent ev, EntityInstance e, int x, int y) 
	{

//		System.out.println("ViewModeHandler entity mousedown\n");

		m_handler = null;

		if (ev.isMetaDown()) {
			rightClickEntity(ev, e, x, y);
		} else {
			mouseIsDown = true;

			curX = x;
			curY = y;

			if (e == m_dg.getDrawRoot()) {
				if (m_dg.clearFlags()) {
					m_dg.redrawDiagram();
			}	}

			LandscapeModeHandler newHandler = null;

			if (ev.isControlDown()) {
				if (m_navHandler.entityPressed(ev, e, x, y)) {
					newHandler = m_navHandler;
				}
			} else if (ev.isShiftDown()) {
				if (m_groupingHandler.entityPressed(ev, e, x, y)) {
					newHandler = m_groupingHandler;
				}
			} else {
				// Determine if bend/IO move, resize, or group move/activate

				if (m_resizeHandler.entityPressed(ev, e, x, y)) {
					newHandler = m_resizeHandler;
				} else if (m_moveHandler.entityPressed(ev, e, x, y)) {
					newHandler = m_moveHandler;
				} else if (m_groupingHandler.entityPressed(ev, e, x, y)) {
					newHandler = m_groupingHandler;
			}	}

			if (newHandler != null) {
				m_handler = newHandler;
		}	}
		return true;
	}

	public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y)
	{
		if (mouseIsDown) {
			long newUp = ev.getWhen();

			if (newUp - m_lastUp < 300) {
//				System.out.println("Double click");
				m_ls.setCursor(Cursor.DEFAULT_CURSOR);
				mouseDoubleClick(ev, e);
				m_lastUp = 0;
			} else if (m_handler != null) {
				m_handler.entityReleased(ev, e, x, y);
			}
			m_lastUp = newUp;
			mouseIsDown = false;
	}	}

	public boolean relationPressed(MouseEvent ev, RelationInstance ri, int x, int y) 
	{

//		System.out.println("ViewModeHandler edge mousedown\n");

		m_handler = null;

		if (ev.isMetaDown()) {
			rightClickRelation(ev, ri, x, y);
		} else {
			mouseIsDown = true;

			m_dg.clearFlags();
		
			curX = x;
			curY = y;

			LandscapeModeHandler newHandler = null;

			if (!ev.isControlDown()) {
				if (ev.isShiftDown()) {
					if (m_groupingHandler.relationPressed(ev, ri, x, y)) {
						newHandler = m_groupingHandler;
					}
				} else {
					// Determine if edge point move
					if (m_moveHandler.relationPressed(ev, ri, x, y)) {
						newHandler = m_moveHandler;
					} else if (m_groupingHandler.relationPressed(ev, ri, x, y)) {
						newHandler = m_groupingHandler;
				}	}
				if (newHandler != null) {
					m_handler = newHandler;
		}	}	}
		return true;
	}

	public void relationReleased(MouseEvent ev, RelationInstance ri, int x, int y)
	{
		if (mouseIsDown) {
			if (m_handler != null) {
				long newUp = ev.getWhen();

				if (newUp - m_lastUp < 300) {

//					System.out.println("Double click");

					m_ls.setCursor(Cursor.DEFAULT_CURSOR);
					mouseDoubleClick(ev, ri);
					m_lastUp = 0;
				} else {
					m_lastUp = newUp;
					m_handler.relationReleased(ev, ri, x, y);
				}
			}
			mouseIsDown = false;
	}	}
	
	public void mouseDoubleClick(MouseEvent ev, Object object) 
	{
		m_ls.processKey(Do.DESCEND, (ev.getModifiers() & (Event.SHIFT_MASK|Event.ALT_MASK|Event.CTRL_MASK|Event.META_MASK)), object);
	}

	public void movedOverThing(MouseEvent ev, Object thing, int x, int y) 
	{
		if (thing instanceof EntityInstance) {
			EntityInstance e = (EntityInstance) thing;

			if (e != m_dg.getDrawRoot()) {
				if (e.getGroupKeyFlag()) {
					int zn = e.overResizeTab(x, y);

					if (zn != EntityInstance.RSZ_NONE) {
						m_ls.setAnticipateCursor(resizeCursor[zn]);
						return;
		}	}	}	}
	}

	public boolean entityDragged(MouseEvent ev, EntityInstance e, int x, int y) 
	{
		if (m_handler != null) {
			return m_handler.entityDragged(ev, e, x, y);
		}
		return false;
	}

	public boolean relationDragged(MouseEvent ev, RelationInstance ri, int x, int y) 
	{
		if (m_handler != null) {
			return m_handler.relationDragged(ev, ri, x, y);
		}
		return false;
	}
}
