package lsedit;

import java.util.*;

/* AttributeRecord.java
 *
 * An attribute record consists of a object id, and one or more
 * attribute definitions.
 *
 */

public class AttributeRecord extends Object 
{
	public String id;				// Id of object
	public Attribute attributes;	// Linked list of attributes


	public AttributeRecord() {
	}

	public AttributeRecord(String id) {
		this.id = id; 
	}


	public Object clone() {
		AttributeRecord ar = new AttributeRecord(id);

		Attribute attr, prev; 

		if (attributes != null) {  
			// Clone head 
			ar.attributes = (Attribute) attributes.clone(); 
			prev = ar.attributes; 
			attr = this.attributes.next; 
		} else {
			attr = null; 
			prev = null; 
		}

		while (attr != null) {

			// For every other attribute in list

			Attribute nattr = (Attribute) attr.clone();
			prev.next = nattr; 
			prev = nattr; 
			attr = attr.next; 
		}
		return ar; 
	}

	public String toString()
	{
		String			ret;
		Attribute		att1;

		ret = id + " {";
		for (att1 = attributes; att1 != null; att1 = att1.next) {
			if (att1 != attributes) {
				ret += " ";
			}
			ret += att1;
		}
		ret += "}";
		return(ret);
	}
}

