package lsedit;

import java.awt.Font;
import java.awt.Color;
import java.awt.Graphics;

import java.util.*;
import java.io.*;
import javax.swing.*;

class Cardinal extends JComponent {

	private int	m_cnt;
	private int m_w, m_h;	// Width and height of text

	protected static final Color CARD_FORE_COLOUR = new Color(1.0f, 1.0f, 0.85f);

	public void reset()
	{
		m_cnt = 0;
	}

	public void inc()
	{
		++m_cnt;
	}

	public int getCnt()
	{
		return(m_cnt);
	}

	public void setTextSize(int w, int h)
	{
		m_w = w;
		m_h = h;
	}

	// Center at top the cardinal

	public void setCenterTop(int x, int y)
	{
//		System.out.println("setCenterTop " + x + "x" + y);
		this.setBounds(x - (m_w/2) - 2, y, m_w + 4, m_h + 4);
	}

	public void paintComponent(Graphics g)
	{
		int width, height;

//		System.out.println("Cardinal.paint cardinal Component()");
		
		width  = getWidth();
		height = getHeight();

		g.setFont(EntityInstance.smallFont);
		g.setColor(getBackground());
		g.fillOval(0, 0, width, height);
		g.setColor(Color.black);
		g.drawOval(0, 0, width-1, height-1);
		g.setColor(CARD_FORE_COLOUR);
		g.drawString(""+m_cnt, 2, m_h + 2);

//		System.out.println("Cardinal.paintComponent() done");
	}

	public void removeNotify()
	{
		super.removeNotify();
		setSize(0,0);
	}
	
	public String toString()
	{
		return("Cardinal " + m_cnt);
	}
}
