package lsedit;

import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.KeyEvent;
import java.awt.Toolkit;
import javax.swing.*;

public class Do 
{
	/* Utter stupidity -- the set accelerator wants the Upper case value of a letter even if it is lower
	 * case and VK_F1 is defined to have the same value as a 'p'.  So if a lower case 'p' is pressed
	 * it is ambiguous if this is really a 'p' or a F1, unless one converts to upper case and sets SHIFT_MASK.
	 * We don't want to do this stupidity since it messes up all our case statements so do a cludge
	 */

	 protected static final int FUNCTION_KEY   = 1024;

	/* N.B. For a key to be active it **MUST** be in a permanent menu -- this ensures that it is treated as an
	 * accelerator key
	 */

	/* Control keys */

	protected static final int GROUP_ALL       = 'a';
	protected static final int COPY            = 'c';	/* Reserved for future use */
	protected static final int SET_TO_VIEWPORT = 'd';
	protected static final int FIND_QUERY      = 'f';
	protected static final int OPEN_LANDSCAPE  = 'o';
	protected static final int PRINT_LANDSCAPE = 'p';
	protected static final int QUIT_PROGRAM    = 'q';
	protected static final int REFRESH         = 'r';
	protected static final int SAVE            = 's';	/* May be combined with ALT to save RAW */
	protected static final int SAVE_AS         = 'S';
	protected static final int SWITCH_TOC      = 't';
	protected static final int PASTE           = 'v';
	protected static final int CLOSE           = 'w';
	protected static final int CUT             = 'x';
	protected static final int UNDO            = 'z';

	/* Alt keys */

	protected static final int A_HORIZ_TOP       = KeyEvent.VK_UP;
	protected static final int A_VERTICAL_LEFT   = KeyEvent.VK_LEFT;
	protected static final int A_VERTICAL_RIGHT  = KeyEvent.VK_RIGHT;
	protected static final int TB_EDGE           = 'a';
	protected static final int CONTENT_CLOSURE   = 'A';
	protected static final int SHOW_FB           = 'B';
	protected static final int EDGE_CLOSE_SRC    = 'C';
	protected static final int EDGE_CLOSE_DST    = 'c';
	protected static final int SHOW_DESC         = 'D';
	protected static final int ARROW_DIMENSIONS  = 'd';
	protected static final int BEST_EDGE         = 'E';
	protected static final int DIRECT_EDGE       = 'e';
	protected static final int A_FIT             = 'F';
	protected static final int A_FIT_LABEL       = 'f';
	protected static final int A_GROUP           = 'g';
	protected static final int SPC_VERTICAL      = 'H';
	protected static final int SZ_HEIGHT         = 'h';
	protected static final int EDGE_CLOSE_LOW    = 'I';
	protected static final int EDGE_OPEN_LOW     = 'i';
	protected static final int SHOW_CARDINALS    = 'k';
	protected static final int LEGEND_TAB        = 'l';
	protected static final int LEFT_TABBOX       = 'L';
	protected static final int MAP_TAB           = 'm';
	protected static final int EDGE_NAVIGATE_SRC = 'N';
	protected static final int EDGE_NAVIGATE_DST = 'n';
	protected static final int EDGE_OPEN_SRC     = 'O';
	protected static final int EDGE_OPEN_DST     = 'o';
	protected static final int TOC_PATH          = 'p';
	protected static final int USE_COMPACTION    = 'P';
	protected static final int QUERY_PERSIST     = 'Q';
	protected static final int QUERY_TAB         = 'q';
	protected static final int RESULT_TAB        = 'r';
	protected static final int SHOW_CLIENTS      = 'S';
	protected static final int SHOW_SUPPLIERS    = 's';
	protected static final int SHOW_TOC          = 'T';
	protected static final int TOP_CLIENTS       = 't';
	protected static final int TOC_HIDDEN        = 'v';
	protected static final int SPC_HORIZ         = 'W';
	protected static final int SZ_WIDTH          = 'w';
	protected static final int SZ_WIDTH_HEIGHT   = 'x';
	protected static final int A_HORIZ_CENTER    = 'X';
	protected static final int A_VERTICAL_CENTER = 'Y';
	protected static final int FIX_SCROLLBARS    = 'z';

	/* Normal upper keys */

	protected static final int EDIT_ENTITY_CLASS = 'A';
	protected static final int BACKWARD_CLOSURE  = 'B';
	protected static final int CONTENTS_QUERY    = 'C';
	protected static final int NEW_EDGE          = 'E';
	protected static final int FORWARD_CLOSURE   = 'F';
	protected static final int GRID_INCREASE     = 'G';
	protected static final int INTERNAL_EDGES    = 'I';
	protected static final int LIFT_EDGES        = 'L';
	protected static final int MOVE_REDBOXES     = 'M'; 
	protected static final int GROUPING_FLAG     = 'Q';
	protected static final int EDIT_REL_CLASS    = 'R';
	protected static final int EXITING_EDGES     = 'S';
	protected static final int INCREASE_LABEL_FONT = 'T';
	protected static final int ENTERING_EDGES    = 'U';
	protected static final int VIEW_MODE         = 'V';
	protected static final int INCREASE_WIDTH    = 'X';
	protected static final int INCREASE_HEIGHT   = 'Y';
	protected static final int INCREASE_SIZE     = 'Z';

	/* Special upper case keys */

	protected static final int TOGGLE_RELATION_ALL = '0';
	protected static final int TOGGLE_RELATION_1   = '1';
	protected static final int TOGGLE_RELATION_2   = '2';
	protected static final int TOGGLE_RELATION_3   = '3';
	protected static final int TOGGLE_RELATION_4   = '4';
	protected static final int TOGGLE_RELATION_5   = '5';
	protected static final int TOGGLE_RELATION_6   = '6';
	protected static final int TOGGLE_RELATION_7   = '7';
	protected static final int TOGGLE_RELATION_8   = '8';
	protected static final int TOGGLE_RELATION_9   = '9';

	protected static final int ASCEND              = KeyEvent.VK_ENTER;

	/* Normal lower keys */

	protected static final int EDIT_ATTRIBUTES   = 'a';
	protected static final int BACKWARD_QUERY    = 'b';
	protected static final int SHOW_CONTENTS     = 'c';
	protected static final int NEW_ENTITY        = 'e';
	protected static final int FORWARD_QUERY     = 'f';
	protected static final int GRID_DECREASE     = 'g';
	protected static final int DELETE_CONTAINER  = 'k';
	protected static final int EDIT_REL_ATTRIBUTES = 'r';
	protected static final int SRC_EDGES         = 's';
	protected static final int DECREASE_LABEL_FONT = 't';
	protected static final int DST_EDGES         = 'u';
	protected static final int DECREASE_WIDTH    = 'x';
	protected static final int DECREASE_HEIGHT   = 'y';
	protected static final int DECREASE_SIZE     = 'z';

	protected static final int TOGGLE_LEGEND_ALL = '0';
	protected static final int TOGGLE_LEGEND_1   = '1';
	protected static final int TOGGLE_LEGEND_2   = '2';
	protected static final int TOGGLE_LEGEND_3   = '3';
	protected static final int TOGGLE_LEGEND_4   = '4';
	protected static final int TOGGLE_LEGEND_5   = '5';
	protected static final int TOGGLE_LEGEND_6   = '6';
	protected static final int TOGGLE_LEGEND_7   = '7';
	protected static final int TOGGLE_LEGEND_8   = '8';
	protected static final int TOGGLE_LEGEND_9   = '9';

	/* Special keys */

	protected static final int DESCEND           = KeyEvent.VK_ENTER;
	protected static final int DELETE            = KeyEvent.VK_DELETE;
	protected static final int FONT_CORRECTION   = KeyEvent.VK_SLASH;
	protected static final int CLEAR             = KeyEvent.VK_ESCAPE;

	protected static final int MOVE_GROUP_UP     = KeyEvent.VK_UP;
	protected static final int MOVE_GROUP_DOWN   = KeyEvent.VK_DOWN;
	protected static final int MOVE_GROUP_LEFT   = KeyEvent.VK_LEFT;
	protected static final int MOVE_GROUP_RIGHT  = KeyEvent.VK_RIGHT;

	protected static final int ABOUT_PROGRAM     = KeyEvent.VK_F1  + FUNCTION_KEY;	
	protected static final int FIND_PREV         = KeyEvent.VK_F2  + FUNCTION_KEY;
	protected static final int FIND_NEXT         = KeyEvent.VK_F3  + FUNCTION_KEY;
	protected static final int ABOUT_URL         = KeyEvent.VK_F11 + FUNCTION_KEY;		
	protected static final int HELP_URL          = KeyEvent.VK_F12 + FUNCTION_KEY;

	public	  static final boolean TOP_CLIENTS_DEFAULT	 = true;
	public    static final boolean SHOW_DESC_DEFAULT      = true;
	public 	  static final boolean SHOW_FB_DEFAULT       = true;
	public    static final boolean SHOW_CLIENTS_DEFAULT  = true;
	public    static final boolean SHOW_SUPPLIERS_DEFAULT= true;
	public    static final boolean SHOW_CARDINALS_DEFAULT= false;
	public	  static final boolean USE_COMPACTION_DEFAULT= true;
	public    static final boolean QUERY_PERSIST_DEFAULT = false;
	public    static final boolean VIEW_MODE_DEFAULT     = false;
	public	  static final boolean FONT_CORRECTION_DEFAULT=false;
	public	  static final boolean FIX_SCROLLBARS_DEFAULT= false;
	public	  static final boolean LEFT_TABBOX_DEFAULT   = false;
	public	               boolean TOC_HIDDEN_DEFAULT    = true;
	public    static final boolean LIFT_EDGES_DEFAULT    = true;

	public final static int BEST_EDGE_STATE	  = 0;			// INFLECTION POINT			
	public final static int TB_EDGE_STATE	  = 1;			// TOP BOTTOM EDGE
	public final static int DIRECT_EDGE_STATE = 2; 
	public final static int EDGE_STATE_DEFAULT= 0;

	// These are the master values

	private boolean	m_top_clients_state    = TOP_CLIENTS_DEFAULT;
	private boolean m_show_desc_state      = SHOW_DESC_DEFAULT;
	private boolean m_show_fb_state        = SHOW_FB_DEFAULT;
	private boolean m_show_clients_state   = SHOW_CLIENTS_DEFAULT;
	private boolean m_show_suppliers_state = SHOW_SUPPLIERS_DEFAULT;
	private boolean m_show_cardinals_state = SHOW_CARDINALS_DEFAULT;
	private boolean m_use_compaction_state = USE_COMPACTION_DEFAULT;
	private boolean m_query_persist_state  = QUERY_PERSIST_DEFAULT;
	private boolean m_view_mode_state      = VIEW_MODE_DEFAULT;
	private static boolean m_font_correction_state= FONT_CORRECTION_DEFAULT;
	private boolean m_fix_scrollbars_state = FIX_SCROLLBARS_DEFAULT;
	private boolean m_left_tabbox_state    = LEFT_TABBOX_DEFAULT;
	private boolean m_toc_hidden_state     = TOC_HIDDEN_DEFAULT;
	private boolean m_lift_edges_state     = LIFT_EDGES_DEFAULT;

	private int		m_edge_state	       = EDGE_STATE_DEFAULT;

	private MyCheckBoxMenuItem	m_top_clients    = null;
	private MyCheckBoxMenuItem	m_show_desc      = null;
	private MyCheckBoxMenuItem  m_show_fb        = null;
	private MyCheckBoxMenuItem  m_show_clients   = null;
	private MyCheckBoxMenuItem  m_show_suppliers = null;
	private MyCheckBoxMenuItem  m_show_cardinals = null;
	private MyCheckBoxMenuItem	m_use_compaction = null;
	private MyCheckBoxMenuItem  m_query_persist  = null;
	private MyCheckBoxMenuItem  m_view_mode      = null;
	private static MyCheckBoxMenuItem	m_font_correction= null;
	private MyCheckBoxMenuItem	m_fix_scrollbars = null;
	private MyCheckBoxMenuItem	m_left_tabbox    = null;
	private MyCheckBoxMenuItem	m_toc_hidden     = null;

	
	private MyCheckBoxMenuItem  m_best_edge      = null;
	private MyCheckBoxMenuItem  m_tb_edge        = null;
	private MyCheckBoxMenuItem  m_direct_edge    = null;
	private MyCheckBoxMenuItem	m_lift_edges     = null;



	public static void groupAllMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Select all children", handler,        Event.CTRL_MASK, GROUP_ALL);
	}

	public static void findMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Clear current query/group", handler, 0, CLEAR);
		new MyMenuItem(m, "Find entities",   handler, Event.CTRL_MASK, FIND_QUERY);
		new MyMenuItem(m, "Find prev",   handler, 0, FIND_PREV);
		new MyMenuItem(m, "Find next",   handler, 0, FIND_NEXT);
	}

	public static void landscapeMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Open landscape",  handler, Event.CTRL_MASK, OPEN_LANDSCAPE);
		new MyMenuItem(m, "Save landscape",       handler, Event.CTRL_MASK,                    SAVE);
		new MyMenuItem(m, "Save landscape (raw)", handler, Event.CTRL_MASK | Event.ALT_MASK,   SAVE);
		new MyMenuItem(m, "Save landscape as",    handler, Event.CTRL_MASK | Event.SHIFT_MASK, SAVE_AS);
	}

	public static void printLandscapeMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Print", handler, Event.CTRL_MASK, PRINT_LANDSCAPE);
	}

	public static void quitMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Close editor",    handler, Event.CTRL_MASK, CLOSE);
		new MyMenuItem(m, "Quit",    		  handler, Event.CTRL_MASK, QUIT_PROGRAM);
	}

	public static void refreshMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Undo", handler, Event.CTRL_MASK, UNDO);
		new MyMenuItem(m, "Refresh", handler, Event.CTRL_MASK, REFRESH);
	}

	public static MyMenuItem cutMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		MyMenuItem	ret = new MyMenuItem(m, "Cut group",		  handler, Event.CTRL_MASK, CUT);
		return(ret);
	}


	public static MyMenuItem pasteMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		MyMenuItem	ret = new MyMenuItem(m, "Paste group", handler, Event.CTRL_MASK, PASTE);
		return(ret);
	}

	public static void alignMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Align (top/horiz.)",      handler, Event.ALT_MASK, A_HORIZ_TOP);
		new MyMenuItem(m, "Align (center/horiz.)",   handler, Event.ALT_MASK|Event.SHIFT_MASK, A_HORIZ_CENTER);
		new MyMenuItem(m, "Align (left/vertical)",   handler, Event.ALT_MASK, A_VERTICAL_LEFT);
		new MyMenuItem(m, "Align (right/vertical)",  handler, Event.ALT_MASK, A_VERTICAL_RIGHT);
		new MyMenuItem(m, "Align (center/vertical)", handler, Event.ALT_MASK|Event.SHIFT_MASK, A_VERTICAL_CENTER);

		new MyMenuItem(m, "Same size",				 handler, Event.ALT_MASK, SZ_WIDTH_HEIGHT);
		new MyMenuItem(m, "Same width",              handler, Event.ALT_MASK, SZ_WIDTH);
		new MyMenuItem(m, "Same height",             handler, Event.ALT_MASK, SZ_HEIGHT);
		new MyMenuItem(m, "Equal spacing (horiz.)",  handler, Event.ALT_MASK|Event.SHIFT_MASK, SPC_HORIZ);
		new MyMenuItem(m, "Equal spacing (vertical)",handler, Event.ALT_MASK|Event.SHIFT_MASK, SPC_VERTICAL);

		new MyMenuItem(m, "Move group up",   handler,   0, MOVE_GROUP_UP);
		new MyMenuItem(m, "Move group down",   handler, 0, MOVE_GROUP_DOWN);
		new MyMenuItem(m, "Move group left",  handler,  0, MOVE_GROUP_LEFT);
		new MyMenuItem(m, "Move group right", handler,  0, MOVE_GROUP_RIGHT);
	}

	public static void groupMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Put group in container",  handler, Event.ALT_MASK, A_GROUP);
	}

	public static void fitMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Fit children to container", handler, Event.ALT_MASK | Event.SHIFT_MASK, A_FIT);
	}

	public static void fitLabelMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Fit to label", handler, Event.ALT_MASK, A_FIT_LABEL);
	}

	public static void tabMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Show legend",handler, Event.ALT_MASK, LEGEND_TAB);
		new MyMenuItem(m, "Show map",handler, Event.ALT_MASK,    MAP_TAB);
		new MyMenuItem(m, "Show query",handler, Event.ALT_MASK,  QUERY_TAB);
		new MyMenuItem(m, "Show result",handler, Event.ALT_MASK,  RESULT_TAB);
		new MyMenuItem(m, "Show TOC", handler, Event.ALT_MASK|Event.SHIFT_MASK, SHOW_TOC);	
	}

	/* N.B. All menu check items must have different key code */

	public void showMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		m_top_clients    = new MyCheckBoxMenuItem(m, "Clients at top",        TOP_CLIENTS_DEFAULT,    handler, Event.ALT_MASK, TOP_CLIENTS);					/* t */
		m_show_desc      = new MyCheckBoxMenuItem(m, "Show descriptions",     SHOW_DESC_DEFAULT,      handler, Event.ALT_MASK|Event.SHIFT_MASK, SHOW_DESC);		/* D */
		m_show_fb        = new MyCheckBoxMenuItem(m, "Show feedback",         SHOW_FB_DEFAULT,        handler, Event.ALT_MASK|Event.SHIFT_MASK, SHOW_FB);		/* B */
		m_show_clients   = new MyCheckBoxMenuItem(m, "Show clients",          SHOW_CLIENTS_DEFAULT,   handler, Event.ALT_MASK|Event.SHIFT_MASK, SHOW_CLIENTS);	/* S */
		m_show_suppliers = new MyCheckBoxMenuItem(m, "Show suppliers",        SHOW_SUPPLIERS_DEFAULT, handler, Event.ALT_MASK, SHOW_SUPPLIERS);					/* s */
		m_show_cardinals = new MyCheckBoxMenuItem(m, "Show edge cardinals",   SHOW_CARDINALS_DEFAULT, handler, Event.ALT_MASK, SHOW_CARDINALS);					/* k */
		m_use_compaction = new MyCheckBoxMenuItem(m, "Compact clients/suppliers", USE_COMPACTION_DEFAULT, handler, Event.ALT_MASK|Event.SHIFT_MASK, USE_COMPACTION); /* P */
		m_fix_scrollbars = new MyCheckBoxMenuItem(m, "Fixed scrollbars",      FIX_SCROLLBARS_DEFAULT, handler, Event.ALT_MASK, FIX_SCROLLBARS);
		m_left_tabbox    = new MyCheckBoxMenuItem(m, "Tabbox on left",        LEFT_TABBOX_DEFAULT ,   handler, Event.ALT_MASK|Event.SHIFT_MASK, LEFT_TABBOX);
		m_lift_edges     = new MyCheckBoxMenuItem(m, "Lift edges",            LIFT_EDGES_DEFAULT,     handler, Event.SHIFT_MASK,                LIFT_EDGES);
	}

	public void bestEdgeMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		m_best_edge     = new MyCheckBoxMenuItem(m, "Inflection point edge", true, handler, Event.ALT_MASK|Event.SHIFT_MASK, BEST_EDGE);		/* E */
		m_tb_edge       = new MyCheckBoxMenuItem(m, "Top/Bottom edge",       false, handler, Event.ALT_MASK, TB_EDGE);						/* a */
		m_direct_edge   = new MyCheckBoxMenuItem(m, "Direct edge",           false, handler, Event.ALT_MASK, DIRECT_EDGE);					/* e */
		m_query_persist = new MyCheckBoxMenuItem(m, "Query Persists",        QUERY_PERSIST_DEFAULT, handler, Event.ALT_MASK, QUERY_PERSIST);					/* Q */
	}

	public void viewModeMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		m_view_mode     = new MyCheckBoxMenuItem(m, "Viewer mode on/off (V)", VIEW_MODE_DEFAULT, handler, 0, (int) VIEW_MODE);						/* V */
	}

	public static void helpMenuItem(JComponent m, ToolBarEventHandler handler, String type)
	{
		new MyMenuItem(m, "About Landscape" + type, handler, 0, ABOUT_PROGRAM);
		new MyMenuItem(m, "Show About URL",  handler, 0, ABOUT_URL);
		new MyMenuItem(m, "Show Help  URL",  handler, 0, HELP_URL);
	}

	public void tocMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Open/close TOC", handler,          Event.CTRL_MASK,SWITCH_TOC);
		new MyMenuItem(m, "Align TOC with diagram",  handler,          Event.ALT_MASK, TOC_PATH);
		m_toc_hidden     = new MyCheckBoxMenuItem(m, "Hide TOC",              TOC_HIDDEN_DEFAULT ,    handler, Event.ALT_MASK, TOC_HIDDEN);
	}

	public static void navigateEdgeMenu(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Open to lowest level",    handler, Event.ALT_MASK, EDGE_OPEN_LOW);		// Open all edges to real src,dst
		new MyMenuItem(m, "Open edge destination",   handler, Event.ALT_MASK, EDGE_OPEN_DST);		// Open all edges to real dst
		new MyMenuItem(m, "Open edge source",        handler, Event.ALT_MASK, EDGE_OPEN_SRC);		// Open all edges to real src
		new MyMenuItem(m, "Close to top level",      handler, Event.ALT_MASK, EDGE_CLOSE_LOW);		// Close all edges to real src,dst
		new MyMenuItem(m, "Close edge destination",  handler, Event.ALT_MASK, EDGE_CLOSE_DST);		// Close all edges to real dst
		new MyMenuItem(m, "Close edge source",       handler, Event.ALT_MASK, EDGE_CLOSE_SRC);		// Close all edges to real src
		new MyMenuItem(m, "Navigate to destination", handler, Event.ALT_MASK, EDGE_NAVIGATE_DST);	// Make the destination the new root
		new MyMenuItem(m, "Navigate to source",      handler, Event.ALT_MASK, EDGE_NAVIGATE_SRC);	// Make the source the new root
	}

	public static void navigateEntityMenu(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Descend",                 handler, 0,                DESCEND);
		new MyMenuItem(m, "Ascend",                  handler, Event.SHIFT_MASK, ASCEND);
	}

	public static void deleteEdgeMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Delete edge", handler,         Event.SHIFT_MASK, DELETE);
	}

	public static void editEntityMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Edit entity attributes", handler,                                0, EDIT_ATTRIBUTES);
		new MyMenuItem(m, "Edit entity class attributes", handler,           Event.SHIFT_MASK, EDIT_ENTITY_CLASS);
	}

	public static void editRelationMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Edit relation attributes", handler,        0, EDIT_REL_ATTRIBUTES);
		new MyMenuItem(m, "Edit relation class attributes", handler,  Event.SHIFT_MASK, EDIT_REL_CLASS);
		new MyMenuItem(m, "Change arrow settings", handler,           Event.ALT_MASK, ARROW_DIMENSIONS);
	}

	public static void queryMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Forward query", handler,                                  0, FORWARD_QUERY);
		new MyMenuItem(m, "Forward closure", handler, Event.SHIFT_MASK, FORWARD_CLOSURE);
		new MyMenuItem(m, "Backward query", handler,                                0, BACKWARD_QUERY);
		new MyMenuItem(m, "Backward closure", handler,       Event.SHIFT_MASK, BACKWARD_CLOSURE);
		new MyMenuItem(m, "Contents query", handler, Event.SHIFT_MASK, CONTENTS_QUERY);
		new MyMenuItem(m, "Content closure", handler, Event.ALT_MASK, CONTENT_CLOSURE);
	}

	public static void gridMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Grid decrease",	  handler,                0, GRID_DECREASE);
		new MyMenuItem(m, "Grid increase",	  handler, Event.SHIFT_MASK, GRID_INCREASE);
	}

	public static void hideMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Hide/show destination edges", handler,                            0, DST_EDGES);
		new MyMenuItem(m, "Hide/show edges to inside", handler,     Event.SHIFT_MASK, ENTERING_EDGES);
		new MyMenuItem(m, "Hide/show source edges", handler,                        0, SRC_EDGES);
		new MyMenuItem(m, "Hide/show edges from inside", handler, Event.SHIFT_MASK, EXITING_EDGES);
		new MyMenuItem(m, "Hide/show internal edges", handler,        Event.SHIFT_MASK, INTERNAL_EDGES);
		new MyMenuItem(m, "Hide/show contents", handler,                             0, SHOW_CONTENTS);
		new MyMenuItem(m, "Toggle grouping flag", handler,            Event.SHIFT_MASK, GROUPING_FLAG);
	}

	public static void fontMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		m_font_correction = new MyCheckBoxMenuItem(m, "Font correction", FONT_CORRECTION_DEFAULT,  handler, 0, FONT_CORRECTION);					/* t */
		new MyMenuItem(m, "Decrease label font size", handler,                 0, DECREASE_LABEL_FONT);
		new MyMenuItem(m, "Increase label font size", handler,  Event.SHIFT_MASK, INCREASE_LABEL_FONT);

	}

	public static void scaleMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Set to viewport", handler, Event.CTRL_MASK, SET_TO_VIEWPORT);
		new MyMenuItem(m, "Scale smaller in X dim", handler,                         0, DECREASE_WIDTH);
		new MyMenuItem(m, "Scale larger in X dim", handler,           Event.SHIFT_MASK, INCREASE_WIDTH);
		new MyMenuItem(m, "Scale smaller in Y dim", handler,                         0, DECREASE_HEIGHT);
		new MyMenuItem(m, "Scale larger in Y dim", handler,           Event.SHIFT_MASK, INCREASE_HEIGHT);
		new MyMenuItem(m, "Scale smaller", handler,                                  0, DECREASE_SIZE);
		new MyMenuItem(m, "Scale larger", handler,                    Event.SHIFT_MASK, INCREASE_SIZE);
	}

	public static void activeMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Toggle active  relations", handler,           Event.SHIFT_MASK, TOGGLE_RELATION_ALL);
		new MyMenuItem(m, "Toggle active  relation 1",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_1);
		new MyMenuItem(m, "Toggle active  relation 2",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_2);
		new MyMenuItem(m, "Toggle active  relation 3",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_3);
		new MyMenuItem(m, "Toggle active  relation 4",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_4);
		new MyMenuItem(m, "Toggle active  relation 5",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_5);
		new MyMenuItem(m, "Toggle active  relation 6",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_6);
		new MyMenuItem(m, "Toggle active  relation 7",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_7);
		new MyMenuItem(m, "Toggle active  relation 8",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_8);
		new MyMenuItem(m, "Toggle active  relation 9",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_9);
	}

	public static void visibleMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Toggle visible relations", handler,                              0, TOGGLE_LEGEND_ALL);
		new MyMenuItem(m, "Toggle visible relation 1",    handler,                          0, TOGGLE_LEGEND_1);
		new MyMenuItem(m, "Toggle visible relation 2",    handler,                          0, TOGGLE_LEGEND_2);
		new MyMenuItem(m, "Toggle visible relation 3",    handler,                          0, TOGGLE_LEGEND_3);
		new MyMenuItem(m, "Toggle visible relation 4",    handler,                          0, TOGGLE_LEGEND_4);
		new MyMenuItem(m, "Toggle visible relation 5",    handler,                          0, TOGGLE_LEGEND_5);
		new MyMenuItem(m, "Toggle visible relation 6",    handler,                          0, TOGGLE_LEGEND_6);
		new MyMenuItem(m, "Toggle visible relation 7",    handler,                          0, TOGGLE_LEGEND_7);
		new MyMenuItem(m, "Toggle visible relation 8",    handler,                          0, TOGGLE_LEGEND_8);
		new MyMenuItem(m, "Toggle visible relation 9",    handler,                          0, TOGGLE_LEGEND_9);
	}

	public static void drawMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Draw new entity", handler,                                0, NEW_ENTITY);
		new MyMenuItem(m, "Draw new source edge", handler,            Event.SHIFT_MASK, NEW_EDGE);	// Not implemented ??
		new MyMenuItem(m, "Delete entity", handler,		                             0, DELETE);
		new MyMenuItem(m, "Delete container", handler,                               0, DELETE_CONTAINER);
		new MyMenuItem(m, "Move redbox's into entity", handler,       Event.SHIFT_MASK, MOVE_REDBOXES);

	}

	private static void setMyCheckBoxMenuItemState(MyCheckBoxMenuItem m, boolean value)
	{
		if (m != null) {
			m.setState(value);
	}	}

	public Do()
	{
//		super(null, true);
	}

	public boolean isTopClients()
	{
		return m_top_clients_state;
	}

	public void setTopClients(boolean value)
	{
		m_top_clients_state = value;
		setMyCheckBoxMenuItemState(m_top_clients, value);
	}

	public boolean isShowDesc()
	{
		return m_show_desc_state;
	}

	public void setShowDesc(boolean value)
	{
		m_show_desc_state = value;
		setMyCheckBoxMenuItemState(m_show_desc, value);
	}

	public boolean isShowFeedback()
	{
		return m_show_fb_state;
	}

	public void setShowFeedback(boolean value)
	{
		m_show_fb_state = value;
		setMyCheckBoxMenuItemState(m_show_fb, value);
	}

	public boolean isShowClients()
	{
		return m_show_clients_state;
	}

	public void setShowClients(boolean value)
	{
		m_show_clients_state = value;
		setMyCheckBoxMenuItemState(m_show_clients, value);
	}

	public boolean isShowSuppliers()
	{
		return m_show_suppliers_state;
	}

	public void setShowSuppliers(boolean value)
	{
		m_show_suppliers_state = value;
		setMyCheckBoxMenuItemState(m_show_suppliers, value);
	}

	public boolean isShowCardinals()
	{
		return m_show_cardinals_state;
	}

	public void setShowCardinals(boolean value)
	{
		m_show_cardinals_state = value;
		setMyCheckBoxMenuItemState(m_show_cardinals, value);
	}

	public boolean isUseCompaction()
	{
		return m_use_compaction_state;
	}

	public void setUseCompaction(boolean value)
	{
		m_use_compaction_state = value;
		setMyCheckBoxMenuItemState(m_use_compaction, value);
	}

	public boolean isQueryPersist()
	{
		return m_query_persist_state;
	}

	public void setQueryPersist(boolean value)
	{
		m_query_persist_state = value;
		setMyCheckBoxMenuItemState(m_query_persist, value);
	}

	public boolean isViewMode()
	{
		return m_view_mode_state;
	}

	public void setViewMode(boolean value)
	{
		m_view_mode_state = value;
		setMyCheckBoxMenuItemState(m_view_mode, value);
	}

	public static boolean isFontCorrection()
	{
		return m_font_correction_state;
	}

	public static void setFontCorrection(boolean value)
	{
		m_font_correction_state = value;
		setMyCheckBoxMenuItemState(m_font_correction, value);
	}

	public boolean isFixScrollBars()
	{
		return m_fix_scrollbars_state;
	}


	public void setFixScrollBars(boolean value)
	{
		m_fix_scrollbars_state = value;
		setMyCheckBoxMenuItemState(m_fix_scrollbars, value);
	}

	public boolean isLeftTabbox()
	{
		return m_left_tabbox_state;
	}

	public void setLeftTabbox(boolean value)
	{
		m_left_tabbox_state = value;
		setMyCheckBoxMenuItemState(m_left_tabbox, value);
	}

	public boolean isLiftEdges()
	{
		return m_lift_edges_state;
	}

	public void setLiftEdges(boolean value)
	{
		m_lift_edges_state = value;
		setMyCheckBoxMenuItemState(m_lift_edges, value);
	}

	public boolean isTocHidden()
	{
		return m_toc_hidden_state;
	}

	public void setTocHiddenState(boolean value)
	{
		m_toc_hidden_state = value;
		TOC_HIDDEN_DEFAULT = value;
	}

	public void setTocHidden(boolean value)
	{
		m_toc_hidden_state = value;
		setMyCheckBoxMenuItemState(m_toc_hidden, value);
	}

	public static int fontHeight(FontMetrics fm)
	{
		return (m_font_correction_state ? fm.getHeight()/2 : fm.getHeight());
	}

	public static int fontHeight(Font font)
	{
		Toolkit tk = Toolkit.getDefaultToolkit();

		FontMetrics fm = tk.getFontMetrics(font);
		return (m_font_correction_state ? fm.getHeight()/2 : fm.getHeight());
	}

	public void setBestEdge()
	{
		m_edge_state = BEST_EDGE_STATE;
		setMyCheckBoxMenuItemState(m_best_edge, true);
		setMyCheckBoxMenuItemState(m_direct_edge, false);
		setMyCheckBoxMenuItemState(m_tb_edge, false);
	}

	public void setTbEdge()
	{
		m_edge_state = TB_EDGE_STATE;
		setMyCheckBoxMenuItemState(m_best_edge, false);
		setMyCheckBoxMenuItemState(m_direct_edge, false);
		setMyCheckBoxMenuItemState(m_tb_edge, true);
	}

	public void setDirectEdge()
	{
		m_edge_state = DIRECT_EDGE_STATE;
		setMyCheckBoxMenuItemState(m_best_edge, false);
		setMyCheckBoxMenuItemState(m_direct_edge, true);
		setMyCheckBoxMenuItemState(m_tb_edge, false);
	}
}
