package lsedit;

import java.awt.Color;
import java.awt.Event;
import java.awt.Dimension;
import java.awt.Graphics;

import java.util.*;

public class Elision_CU_Button extends ToolBarButton 
{
	protected static final String description = "Hide/show edges going from outside of selected entities to inside";

	protected String getDesc() 
	{
		return description;
	}

	protected void paintIcon(Graphics gc) 
	{
		Dimension dim = getSize();

		int w = dim.width/2;
		int h = dim.height - MARGIN*2 - 1;

		Color c = new Color(0.70f, 0.70f, 0.70f);
		if (Util.isBlack(c))
			c = Color.lightGray;

		gc.setColor(c);
		gc.fillRect(MARGIN*2, MARGIN, w, h);
		gc.setColor(Color.black);
		gc.drawRect(MARGIN*2, MARGIN, w, h);

		int x = MARGIN*2 + w/2;

		drawEdge(gc, x, MARGIN, x, dim.height/2);
	}

	public Elision_CU_Button(ToolBarEventHandler teh) 
	{
		super(teh);
		setKeystroke(Event.SHIFT_MASK, Do.ENTERING_EDGES);
	 }
}


