package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.*;

import java.util.*;
import java.io.*; 
import javax.swing.*;

// Entities in a landscape 

public class EntityInstance extends LandscapeObject3D /* extends LandscapeObject */ implements Icon, DiagramCoordinates, MouseListener, MouseMotionListener {

	private static EntityInstance m_currentDescEntity = null;

	// Final values
	
	public final static int SMALL_FONT = 0;
	public final static int REG_FONT   = 1;

	public final static String LABEL_ID =			 "label";
	public final static String XPOSITION_ID =		 "x";
	public final static String YPOSITION_ID =		 "y";
	public final static String WIDTH_ID =			 "width";
	public final static String HEIGHT_ID =			 "height";

	public final static String XRELPOSITION_ID =	 "xrel";
	public final static String YRELPOSITION_ID =	 "yrel";
	public final static String WIDTHREL_ID =		 "widthrel";
	public final static String HEIGHTREL_ID =		 "heightrel";

	public final static String IN_ELISION_ID =		 "elision";
	public final static String OUT_ELISION_ID =		 "outelision";
	public final static String CLIENT_ELISION_ID =	 "clientelision";
	public final static String SUPPLIER_ELISION_ID = "supplierelision";
	public final static String INTERNAL_ELISION_ID = "internalelision";
	public final static String AGG_ELISION_ID =		 "aggelision";
	public final static String LINK_ID =			 "navlink";
	public final static String INPOINT_ID =			 "inpoints";
	public final static String OUTPOINT_ID =		 "outpoints";
	public final static String LEFTPOINT_ID =		 "leftpoints";
	public final static String RIGHTPOINT_ID =		 "rightpoints";
	public final static String DESC_ID =			 "description";
	public final static String TITLE_ID =			 "title";
	public final static String FONTDELTA_ID =		 "fontdelta";

	public  final static int RSZ_NONE = -1;
	private final static int RSZ_NW	= 0;
	private final static int RSZ_N	= 1;
	private final static int RSZ_NE	= 2; 
	private final static int RSZ_E	= 3;
	private final static int RSZ_SE	= 4;
	private final static int RSZ_S	= 5;
	private final static int RSZ_SW	= 6;
	private final static int RSZ_W	= 7;

	private final static int DEF_CONT_CAP  = 35; // Default contains capacity
	private final static int ROOT_CONT_CAP = 1000; // root contains capacity

	// Annotation tab constants

	private final static double TAB_HEIGHT = 16.0; 

	private final static int MOUSE_NEAR_EDGE_THRESHOLD = 4;
	private final static int SEP_THRESHOLD = 8;

	// Static font info 

	private final static int MARGIN = 5; 
	private final static int MIN_HEIGHT = 10;
	private final static int MIN_WIDTH = 30;

	private final static int CONTENTS_FLAG_DIM = 8;

	private final static String	OPEN_FAMILY = "Helvetica";
	private final static int	OPEN_FONT_SIZE = 12;
	public  final static Font	openFont = new Font(OPEN_FAMILY, Font.PLAIN, OPEN_FONT_SIZE);

	private final static String CLOSED_FAMILY = "Helvetica";
	private final static int	CLOSED_FONT_MIN_SIZE = 6; 
	private final static int	CLOSED_FONT_SMALL_SIZE = 10; 
	private final static int	NUM_FONTS = 25;
	public  final static int	START_FONT_NUM = 6;
	public    final static Font smallFont =	new Font(CLOSED_FAMILY, Font.PLAIN, CLOSED_FONT_SMALL_SIZE);

	// Bits set in m_mark
	
	public final static int	DIAGRAM_MARK		= 0x01;		// This entity is visible in the main diagram  (at present)
	public final static int	CLIENT_MARK			= 0x02;		// This entity is in the set of clients   (at present)
	public final static int SUPPLIER_MARK		= 0x04;		// This entity is in the set of suppliers (at present)

	public final static int HIGHLIGHT_EDGE_MARK	= 0x01000;		// Highlight the edge of the object
	public final static int DRAW_CLIENT_MARK	= 0x02000;
	public final static int DRAW_SUPPLIER_MARK	= 0x04000;
	public final static int REDBOX_MARK         = 0x08000;	// Mark this box in deep red for (forward/back) edge tracing     
	public final static int	GROUP_MARK			= 0x10000;	// This entity is part of a group
	public final static int GROUPKEY_MARK		= 0x20000;	// This entity is the key entity in the group
	public final static int	OPEN_MARK			= 0x40000;	// This entity is open
	public final static int CLOSED_MARK			= 0x80000;	// This entity is closed

	public final static int CLIENT_SUPPLIER     = CLIENT_MARK | SUPPLIER_MARK;
	public final static int IN_DIAGRAM          = CLIENT_SUPPLIER | DIAGRAM_MARK;
	public final static int PRESENTATION_MARKS  = HIGHLIGHT_EDGE_MARK | REDBOX_MARK | GROUP_MARK | GROUPKEY_MARK;

	public final static int	IN_TREE_MARK		= 0x100000;
	public final static int	LIFTED_MARK			= 0x200000;
	
	public static Font closedFont[]    = new Font[NUM_FONTS];

	private static boolean mungeIdToLabel = true;

	private int				m_mark = 0;
	private String			m_title;					// The title of this entity

	// First order attributes

	private Vector	 m_dstElision;
	private Vector	 m_srcElision;
	private Vector	 m_enteringElision;
	private Vector	 m_exitingElision;
	private Vector	 m_internalElision;

	private EdgePoint[] topPoints, bottomPoints, leftPoints, rightPoints;

	// Changed width and height to have some [reasonable?] default IJD

	private int		m_diagramX         = Integer.MIN_VALUE;
	private int		m_diagramY         = Integer.MIN_VALUE;

	private int		m_x;
	private int		m_y;
	private int		m_width;
	private int		m_height;

	// These are the coordinates with respect to the parent node

	private double		m_xrelLocal	     = 1.0/32.0;
	private double		m_yrelLocal      = 1.0/32.0;
	private double		m_widthrelLocal  = 15.0/16.0;
	private	double		m_heightrelLocal = 15.0/16.0;

	// These are the top left coordinates of the object on the screen

	private int		 m_fontDelta     = 0;

	private int		 m_preorder;
	private int		 m_postorder;
	
	/* keep tight control over the group flags so can draw changes at a low level */

	// Relation info

	// Our container (null -> $ROOT)

	private EntityInstance m_containedBy;

	// Entities contained by this one

	private Hashtable m_containsList;			

	private Vector m_srcRelList    = new Vector();	// List of relations for which this entity is the source 
	private Vector m_dstRelList    = new Vector();	// List of relations for which this entity is the destination 
	private Vector m_srcLiftedList = new Vector();	// List of relations whose source is lifted to leave this entity
	private Vector m_dstLiftedList = new Vector();	// List of relations whose destination is lifted to address this entity

	// Temp Rectangle storage

	Rectangle tempLyt;

	// Stat gathering

/*
	private int m_debug_x      = Integer.MIN_VALUE;
	private int m_debug_y      = Integer.MIN_VALUE;
	private int m_debug_width  = Integer.MIN_VALUE;
	private int m_debug_height = Integer.MIN_VALUE;
*/
 	private   Cardinal[] m_dstCardinals;

	// ---------------
	// Wrapper methods
	// ---------------

	// Used by legend box

	public EntityComponent neededPlainComponent()
	{
		EntityComponent entityComponent = (EntityComponent) getSwingObject();
		if (entityComponent == null) {
			entityComponent = new EntityComponent(this);
		}
		return(entityComponent);
	} 

	public EntityComponent neededComponent()
	{
		EntityComponent entityComponent = (EntityComponent) getSwingObject();
		if (entityComponent == null) {
			entityComponent = new EntityComponent(this);
			// Do this here so that the legend use of entities isn't compromised
			entityComponent.setToolTipText(getLabel());
			entityComponent.addMouseListener(this);
			entityComponent.addMouseMotionListener(this);

		}
		return(entityComponent);
	} 


	private Vector neededDstElision()
	{
		Vector dstElision = m_dstElision;
		if (dstElision == null) {
			m_dstElision = dstElision = new Vector();
		}
		return(dstElision);
	}
	
	private Vector neededSrcElision()
	{
		Vector srcElision = m_srcElision;
		if (srcElision == null) {
			m_srcElision = srcElision = new Vector();
		}
		return(srcElision);
	}
	
	private Vector neededEnteringElision()
	{
		Vector enteringElision = m_enteringElision;
		if (enteringElision == null) {
			m_enteringElision = enteringElision = new Vector();
		}
		return(enteringElision);
	}
	
	private Vector neededExitingElision()
	{
		Vector exitingElision = m_exitingElision;
		if (exitingElision == null) {
			m_exitingElision = exitingElision = new Vector();
		}
		return(exitingElision);
	}
	
	private Vector neededInternalElision()
	{
		Vector internalElision = m_internalElision;
		if (internalElision == null) {
			m_internalElision = internalElision = new Vector();
		}
		return(internalElision);
	}

	public void removeAll()
	{
		JComponent entityComponent = getSwingObject();
		if (entityComponent != null) {
			entityComponent.removeAll();
	}	}

	public void setVisible(boolean value)
	{
		JComponent entityComponent;
		
		if (value) {
			entityComponent = neededComponent();
			entityComponent.setVisible(true);
		} else {
			entityComponent = (EntityComponent) getSwingObject();
			if (entityComponent != null) {
				entityComponent.setVisible(false);
	}	}	}
	
	public void setBounds(int x, int y, int width, int height) 
	{
		JComponent entityComponent = getSwingObject();

		if (width <= 0 || height <= 0) {
			if (m_width > 0 && m_height > 0) {
				openStatusUnknown();
			}
		} else if (m_width <= 0 || m_height <= 0) {
			openStatusUnknown();
		}
		m_x      = x;
		m_y      = y;
		m_width  = width;
		m_height = height;


		if (entityComponent != null) {
			entityComponent.setBounds(x, y, width, height);
		}
		rescaleChildren();
	}

	public void setBothBounds(int parentDiagramX, int parentDiagramY, int x, int y, int width, int height) 
	{
		m_diagramX = parentDiagramX + x;
		m_diagramY = parentDiagramY + y;
			
		setBounds(x, y, width, height);
	}

	public void repaint()
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null) {
			entityComponent.repaint();
	}	}
		
	public void validate()
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null) {
			entityComponent.validate();
	}	}

	public void paintMap(Graphics g, int x, int y, int width, int height, EntityInstance onPath, int depth)
	{
		EntityComponent entityComponent = neededComponent();

		entityComponent.paintMap(g, x, y, width, height, onPath, depth);
	}

	public int getX()
	{
		return(m_x);
	}

	public int getY()
	{
		return(m_y);
	}

	public int getWidth()
	{
		return(m_width);
	}

	public int getHeight()
	{
		return(m_height);
	}

	// --------------
	// Wrapper methods
	// ---------------

	protected EntityInstance getDrawRoot()
	{
		return(getDiagram().getDrawRoot());
	}

	protected int numRelationClasses()
	{
		return(getDiagram().numRelationClasses());
	}

	protected RelationClass numToRelationClass(int i)
	{
		return(getDiagram().numToRelationClass(i));
	}

	// -----------------
	// Protected methods
	// -----------------

	protected void setFont(Graphics g, int type) 
	{
		switch(type) {
		case SMALL_FONT:
			g.setFont(smallFont);
			return;
		default:
			g.setFont(closedFont[START_FONT_NUM + m_fontDelta]);
			return;
	}	}

	public int getFontDelta()
	{
		return(m_fontDelta);
	}

	protected void setFontDelta(int fd) 
	{
		// Keep it in bounds
//		System.out.print("Changing font from size " + m_fontDelta);
		m_fontDelta = Math.max(-START_FONT_NUM, Math.min(fd, NUM_FONTS-START_FONT_NUM-1));
//		System.out.println(" to " + m_fontDelta);
		repaint();
	}

	public Color getCurrentLabelColor() 
	{
		if (isMarked(REDBOX_MARK) && !isOpen()) {
			return Color.yellow;
		}
		return getLabelColor();
	}

	//
	// Parse an attribute record to set the appropriate edge point factors
	// supplied in an attribute record.

	protected void parsePoints(EdgePoint[] ept, Attribute attr) 
	{
		AttributeValueItem avi;

		for (avi = attr.avi; avi != null; avi = avi.nextList) {
			RelationClass rc = getDiagram().nameToRelationClass(avi.value);

			if (rc != null) {
				int nid = rc.getNid();

				double wf = Util.parseReal(avi.next.value);
				double hf = Util.parseReal(avi.next.next.value);

				if (ept[nid] == null) {
					ept[nid] = new EdgePoint(this, rc, wf, hf);
				} else {
					if (rc != ept[nid].getRc()) {
						MsgOut.println("Class nid mismatch");
					}
					ept[nid].m_wf = wf;
					ept[nid].m_hf = hf;
				}
				ept[nid].isDefault = false;
			}
		}
	}

	static protected Hashtable est = new Hashtable();

	protected void processElision(Attribute attr, Vector list) 
	{
		AttributeValueItem av;

		for (av = attr.avi; av != null; av = av.next) {
			String str = (String) est.get(av.value);
			if (str == null) {
				str = av.value;
				est.put(str, str);
			}
			if (!list.contains(str)) {
				list.addElement(str);
	}	}	}

	protected void processRawElision(String[] sl, Vector list) 
	{
		for (int i = 0; i<sl.length; ++i) {
			list.addElement(sl[i]);
		}
	}

	//
	// Parse the values of any first order attributes into their storage.
	// 

	// First thing called by EntityInstance::AddAttributes
	// If the attribute is a known member of storage -- don't save attribute -- just store value

	protected boolean processFirstOrderAttributes(Attribute attr)
	{
		boolean hasVal = (attr.avi != null);

		if (attr.hasId(XPOSITION_ID)) {			
			if (hasVal) {
				setxLocal(attr.parseReal());		// Legacy code
				attr.id = XRELPOSITION_ID;			// So right name gets registered
			}
			return true; 
		}

		if (attr.hasId(YPOSITION_ID)) {
			if (hasVal) {
				setyLocal(attr.parseReal());		// Legacy code
				attr.id = YRELPOSITION_ID;
			}
			return true; 
		}

		if (attr.hasId(WIDTH_ID)) {
			if (hasVal) {
				setwidthLocal(attr.parseReal());	// Legacy code
				attr.id = WIDTHREL_ID;
			}
			return true; 
		}

		if (attr.hasId(HEIGHT_ID)) {
			if (hasVal) {
				setheightLocal(attr.parseReal());	// Legacy code
				attr.id = HEIGHTREL_ID;
			}
			return true; 
		}

		if (attr.hasId(XRELPOSITION_ID)) {
			if (hasVal) {
				setxRelLocal(attr.parseReal());
			}
			return true; 
		}

		if (attr.hasId(YRELPOSITION_ID)) {
			if (hasVal) {
				setyRelLocal(attr.parseReal());
			}
			return true; 
		}

		if (attr.hasId(WIDTHREL_ID)) {
			if (hasVal) {
				setwidthRelLocal(attr.parseReal());
			}
			return true; 
		}

		if (attr.hasId(HEIGHTREL_ID)) {
			if (hasVal) {
				setheightRelLocal(attr.parseReal());
			}
			return true; 
		}

		if (attr.hasId(LABEL_ID)) {
			if (hasVal) {
				setLabel(attr.parseString());
			}
			return true; 
		}

		if (attr.hasId(DESC_ID)) {
			if (hasVal) { 
				setDescription(attr.parseString());
			}
			return true; 
		} 

		if (attr.hasId(TITLE_ID)) {
			if (hasVal) {
				setTitle(attr.parseString());
			}
			return true;
		}

		if (attr.hasId(FONTDELTA_ID)) {
			if (hasVal) {
				setFontDelta(attr.parseInt());
			}
			return true; 
		}

		if (attr.hasId(COLOUR_ID)) {
			if (hasVal) {
				setObjectColor(attr.parseColour());
			}
			return true;
		}

		if (attr.hasId(OPEN_COLOUR_ID)) {
			if (hasVal) {
				setColorWhenOpen(attr.parseColour());
			}
			return true;
		}

		if (attr.hasId(LABEL_COLOUR_ID)) {
			if (hasVal) {
				setLabelColor(attr.parseColour());
			}
			return true;
		}

		if (attr.hasId(IN_ELISION_ID)) {
			if (hasVal) { 
				processElision(attr, neededDstElision()); 
			}
			return true; 
		}

		if (attr.hasId(OUT_ELISION_ID)) {
			if (hasVal) {
				processElision(attr, neededSrcElision());
			}
			return true;
		}

		if (attr.hasId(CLIENT_ELISION_ID)) {
			if (hasVal) {
				processElision(attr, neededEnteringElision());
			}
			return true;
		}

		if (attr.hasId(SUPPLIER_ELISION_ID)) {
			if (hasVal) {
				processElision(attr, neededExitingElision());
			}
			return true;
		}

		if (attr.hasId(INTERNAL_ELISION_ID)) {
			if (hasVal) {
				processElision(attr, neededInternalElision());
			}
			return true;
		}

		if (attr.hasId(INPOINT_ID)) {
			if (hasVal) {
				if (topPoints == null) {
					topPoints = new EdgePoint[numRelationClasses()];
				}
				parsePoints(topPoints, attr);
			}
			return true; 
		}

		if (attr.hasId(OUTPOINT_ID)) {
			if (hasVal) {
				if (bottomPoints == null) {
					bottomPoints = new EdgePoint[numRelationClasses()];
				}
				parsePoints(bottomPoints, attr); 
			}
			return true; 
		}

		if (attr.hasId(LEFTPOINT_ID)) {
			if (hasVal) {
				if (leftPoints == null) {
					leftPoints = new EdgePoint[numRelationClasses()];
				}
				parsePoints(leftPoints, attr); 
			}
			return true; 
		}

		if (attr.hasId(RIGHTPOINT_ID)) {
			if (hasVal) {
				if (rightPoints == null) {
					rightPoints = new EdgePoint[numRelationClasses()];
				}
				parsePoints(rightPoints, attr); 
			}
			return true; 
		}

		return false; 
	}

	protected void doEntityDelete() 
	{
		// Remove m_dstRelList relations from entities on our m_srcRelList.
		// Remove m_srcRelList relations from entities on our m_dstRelList. 
		// Remove entity from parent's contain list. 

		Enumeration		en;
		RelationInstance ri;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.getDst().removeDstRelation(ri); 
		} 

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.getSrc().removeSrcRelation(ri);
		}
		m_containedBy.removeContainment(this);
	}

	// Determine the bounding box of all children

	public RelRectangle getChildrenRelBoundingBox() 
	{
		Enumeration		en;
		EntityInstance	e;
		double			x1, x2, y1, y2;
		double			temp;
		boolean			seen;

		x1   = Integer.MAX_VALUE;
		x2   = Integer.MIN_VALUE;
		y1   = Integer.MAX_VALUE;
		y2   = Integer.MIN_VALUE;
		seen = false;

		for (en = getChildren(); en.hasMoreElements(); ) {
			seen = true;
			e = (EntityInstance) en.nextElement();

			temp = e.xRelLocal();
			if (temp < x1) {
				x1 = temp;
			}

			temp = e.yRelLocal();
			if (temp < y1) {
				y1 = temp;
			}

			temp = e.xRelLocal() + e.widthRelLocal();
			if (temp > x2) {
				x2 = temp;
			}

			temp = e.yRelLocal() + e.heightRelLocal();
			if (temp > y2) {
				y2 = temp;
		}	}

		if (!seen) {
			MsgOut.dprintln("No children");
			return(null);
		} 
		return new RelRectangle(x1, y1, x2-x1, y2-y1);
	}

	protected String endSet[] = { 
		".ss",
		".dup",
		"__funcdef",
		"__funcdcl",
		"__vardef",
		"__vardcl",
		"__macro", 
		"__struct", 
		"__union", 
		"__enum", 
		"__type"
	}; 

	public String mungeId(String id) 
	{
		if (mungeIdToLabel && id.length() > 0) {

			for (int i = 0; i < endSet.length; ++i) {
				if (id.endsWith(endSet[i])) {
					id = id.substring(0, id.length()-endSet[i].length());
					break;
				}
			}

			if (id.charAt(0) != '<') {
				int lpi = id.lastIndexOf('/');

				if (lpi < 0) {
					lpi = id.lastIndexOf('\\');
				}
				if (lpi >= 0 && id.length() != lpi+1) {
					return id.substring(lpi+1);
				}
			}
		}
		return id;
	}

	// --------------
	// Static methods
	// -------------- 


	/* Allocates helvetica fonts of increasing point size */

	static public void generateFonts() {

		for (int i=0; i<NUM_FONTS; ++i) {
			closedFont[i] =	new Font(CLOSED_FAMILY, Font.PLAIN, CLOSED_FONT_MIN_SIZE+i /* Point size */);
		}
	}

	static public void setLabelMungeFlag(boolean state) 
	{
		mungeIdToLabel = state;
	}

	// --------------
	// Public methods
	// --------------

 	public EntityInstance(EntityClass parentClass, String id) 
	{
		setParentClass(parentClass);
		setLabel(mungeId(id)); // Default
		setId(id);

		// A default layout
		
		m_containsList = new Hashtable(id.equals(Diagram.ROOT_ID) ? ROOT_CONT_CAP : DEF_CONT_CAP);
	}

	public String getTitle() 
	{
		return m_title;
	}

	public void setTitle(String title) 
	{
		m_title = title;
	}

	// Destroy just the entity, leaving the children 

	public void deleteJustMe() 
	{
		Enumeration en;
		EntityInstance e;

		// Promote our children

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			m_containedBy.addContainment(e);
		}
		doEntityDelete(); 
		m_containedBy.rescaleChildren();
	}

	// Destroy entity and all it contains 

	public void deleteMe() 
	{
		// deleteAll on our children then ourself

		Enumeration en;
		EntityInstance e;

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.deleteMe();
		} 
		doEntityDelete();
	}

	public void addContainment(EntityInstance e) 
	{
		// This entity contains the passed entity
		// Put on this' contains list

		String id = e.getId();

		if (m_containsList.put(id, e) != null) {
			MsgOut.println("Entity " + getId() + " already contains " + id);
		} else {
			e.m_containedBy = this;
			if (e.inDiagram()) {
				EntityComponent entityComponent = neededComponent();
				EntityComponent childComponent  = e.neededComponent();

				nandMark(OPEN_MARK|CLOSED_MARK);
				entityComponent.add(childComponent); // Add e back into new containment
		}	}
	}

	public boolean removeContainment(EntityInstance e) 
	{
		String id = e.getId();

		if (m_containsList.containsKey(id)) {
			JComponent entityComponent = getSwingObject();
			
			m_containsList.remove(id);
			if (entityComponent != null) {
				JComponent childComponent = e.getSwingObject();
				if (childComponent != null) {
					entityComponent.remove(childComponent);
			}	}
			e.m_containedBy = null;
			e.m_mark        = 0;
			return true;
		}
		MsgOut.println("Entity " + getId() + " doesn't contain " + id);
		return false;
	}

	public void moveEntityContainment(EntityInstance newContainer) 
	{
		// Transfer containment iff we need to

		if (newContainer != m_containedBy) {
/*
			System.out.println("moveEntityContainment");
			java.lang.Thread.dumpStack();
			System.out.println("-----");
 */

			m_containedBy.removeContainment(this);
			newContainer.addContainment(this); 
		}
	}

	public void addRelation(RelationInstance ri, EntityInstance dst) 
	{
		// Should check to see if relation is already present
		addSrcRelation(ri); 
		dst.addDestRelation(ri); 
	}

	public RelationInstance getRelation(RelationClass rc, EntityInstance dst) 
	{
		// Return relation instance if present

		Enumeration		en;
		RelationInstance ri;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			if (ri.getRelationClass() == rc && ri.getDst() == dst) {
				return ri;
		}	}
		return null;
	}

	public void addSrcRelation(RelationInstance ri) 
	{
		m_srcRelList.addElement(ri); 
	}

	public void removeSrcRelation(RelationInstance ri) 
	{
		m_srcRelList.removeElement(ri); 
	}

	public void addDestRelation(RelationInstance ri) {

		m_dstRelList.addElement(ri); 

	}

	public void removeDstRelation(RelationInstance ri) 
	{
		m_dstRelList.removeElement(ri);

	}

	public void addAttribute(Attribute attr) {

		// Process first order attributes, and add all others 
		// to an attribute database

		if (processFirstOrderAttributes(attr)) {
			return;
		}
		super.addAttribute(attr);
	}

	public boolean addRawAttribute(String id, int val) {

		if (id.equals(FONTDELTA_ID)) {
			setFontDelta(val);
			return true; 
		}
		return false;
	}

	public boolean addRawAttribute(String id, double val) {

		if (id.equals(XPOSITION_ID)) {			// Legacy code
			setxLocal(val);						// Legacy code
			return true; 
		}
		else if (id.equals(YPOSITION_ID)) {
			setyLocal(val);						// Legacy code
			return true; 
		}
		else if (id.equals(WIDTH_ID)) {
			setwidthLocal(val);					// Legacy code
			return true; 
		}
		else if (id.equals(HEIGHT_ID)) {
			setheightLocal(val);				// Legacy code
			return true; 
		}
		if (id.equals(XRELPOSITION_ID)) {
			setxRelLocal(val);
			return true; 
		}
		else if (id.equals(YRELPOSITION_ID)) {
			setyRelLocal(val);
			return true; 
		}
		else if (id.equals(WIDTHREL_ID)) {
			setwidthRelLocal(val);
			return true; 
		}
		else if (id.equals(HEIGHTREL_ID)) {
			setheightRelLocal(val);
			return true; 
		}
		return false;
	}

	public boolean addRawAttribute(String id, String val) {

		if (id.equals(LABEL_ID)) {
			setLabel(val);
			return true; 
		}

		else if (id.equals(DESC_ID)) {
			setDescription(val);
			return true; 
		} 
		else if (id.equals(TITLE_ID)) {
			setTitle(val);
			return true;
		}
		return super.addRawAttribute(id, val);
	}

	public boolean addRawAttribute(String id, int[] il) {
		return false;
	}

	public boolean addRawAttribute(String id, double[] dl) 
	{
		if (id.equals(COLOUR_ID)) {
			setObjectColor( new Color((float) dl[0], (float) dl[1], (float) dl[2]));
			return true;
		}
		if (id.equals(LABEL_COLOUR_ID)) {
			setLabelColor( new Color((float) dl[0], (float) dl[1], (float) dl[2]) );
			return true;
		}
		if (id.equals(OPEN_COLOUR_ID)) {
			setColorWhenOpen( new Color((float) dl[0], (float) dl[1], (float) dl[2]));
			return true;
		}
		return false;
	}

	public boolean addRawAttribute(String id, String[] sl) 
	{
		if (id.equals(IN_ELISION_ID)) {
			processRawElision(sl, neededDstElision()); 
			return true; 
		}
		else if (id.equals(OUT_ELISION_ID)) {
			processRawElision(sl, neededSrcElision());
			return true;
		}
		else if (id.equals(CLIENT_ELISION_ID)) {
			processRawElision(sl, neededEnteringElision());
			return true;
		}
		else if (id.equals(SUPPLIER_ELISION_ID)) {
			processRawElision(sl, neededExitingElision());
			return true;
		}
		else if (id.equals(INTERNAL_ELISION_ID)) {
			processRawElision(sl, neededInternalElision());
			return true;
		}

		return super.addRawAttribute(id, sl);
	}

	public void assignAttributes(Attribute attr) 
	{
		// Passed list of attribute assignments

		for (; attr != null; attr = attr.next) {

			// For each attribute assignment, find the variable,
			// and assign the value.

			if (attr.avi == null) {
				MsgOut.println("Null attribute assignment");
			} else if (!processFirstOrderAttributes(attr)) {
				Attribute attrVar = getLsAttribute(attr.id);

				if (attrVar == null) {
					MsgOut.println("Missing attribute '" + attr.toString() + "'");
				} else {
					if (attrVar.cloneOnAssign) {
						attrVar = (Attribute) attrVar.clone();
						attrVar.cloneOnAssign = false;
						replaceAttribute(attrVar);
					}
					attrVar.avi = attr.avi;
				}
			}
		}
	} 

	public void assignRelnAttributes(RelationClass rc, EntityInstance dst, Attribute attr)
	{	
		// Find the associated edge
		System.out.println("Asgn: " + rc.getId() + " " + getId() + " " + dst.getId());
	}


/*
		v6.0.3
		Stupid to rescale -- might as well recalculate 
 */

	public void validateAllMyEdges() 
	{
		Enumeration			en;
		RelationInstance	ri;

		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			if (ri.m_drawSrc != this) {
				System.out.println("validateAllMyEdges() " + this + " drawsrc " + ri.m_drawSrc);
				continue;
			}
			ri.validate();
		}

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			if (ri.m_drawDst != this) {
				System.out.println("validateAllMyEdges() " + this + " drawdst " + ri.m_drawDst);
				continue;
			}
			ri.validate();
	}	}

	protected void rescale(EdgePoint[] pts) {

		if (pts != null) {
			for (int i = 0; i < pts.length; ++i) {
				if (pts[i] != null) {
					pts[i].clearRc();
	}	}	}	}

	// Global coordinate transform
	//
	// Calculate global values for Rectangle from local with scale.
	// The absolute x and y offsets of the parent are passed.
	//
	// This also handles calling the rescale on the containing entities.
	//

	public void rescale(int parentDiagramX, int parentDiagramY, int parent_width, int parent_height)
	{
		int 		new_x, new_y, new_width, new_height;

		new_x      = (int) (parent_width  * m_xrelLocal);
		new_y      = (int) (parent_height * m_yrelLocal);
		new_width  = (int) (parent_width  * m_widthrelLocal);
		new_height = (int) (parent_height * m_heightrelLocal);

/*		System.out.println("EntityInstance.rescale(" + parent_width + ", " + parent_height + ") using " + this + " [" + m_xrelLocal + ", " + m_yrelLocal + ", " + m_widthrelLocal + ", " + m_heightrelLocal + "] = {" + new_x + ", " + new_y + ", " + new_width + ", " + new_height + "}");
		java.lang.Thread.dumpStack();
		System.out.println("-----");
*/
		// This set bounds causes children to be rescaled
		setBothBounds(parentDiagramX, parentDiagramY, new_x, new_y, new_width, new_height);
	}

	public void rescaleChildren() 
	{
		Enumeration		en;
		int				width, height;
		EntityInstance	e;
		
		width  = getWidth();
		height = getHeight();
		
		// rescale edge points

		rescale(topPoints);
		rescale(bottomPoints);
		rescale(leftPoints);
		rescale(rightPoints);
		
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.rescale(m_diagramX, m_diagramY, width, height);
		}
	}

	public Rectangle getDiagramBounds() 
	{
		return new Rectangle(getDiagramX(), getDiagramY(), getWidth(), getHeight());
	}

	protected void scale(double wf, double hf, boolean doContainer, boolean doPos)
	{
		// Scale ourselves 

//		System.out.println("EntityInstance.scale(" + wf + "," + hf + "," + doContainer + "," + doPos + ")");

		if (doContainer) {
			double x1, y1, w1, h1; 

			x1 = xRelLocal();		
			y1 = yRelLocal();
			w1 = widthRelLocal()  * wf;
			h1 = heightRelLocal() * hf;

			if (doPos) {
				x1 *= wf;
				y1 *= hf;
			}

			if (x1 >= 0.0 && w1 > 0.0 && y1 >= 0.0 && h1 > 0.0 && (x1+w1) <= 1.0 && (y1+h1) <= 1.0) {
				setxRelLocal(x1);
				setyRelLocal(y1);
				setwidthRelLocal(w1);
				setheightRelLocal(h1);	
			}
			return;

		} 
		
		// Insure the scale of the bounding box of the contained elements
		// will be within the container.
		
		RelRectangle bb = getChildrenRelBoundingBox();

		if (bb == null) {
			return;
		}

		bb.width  *= wf;
		bb.height *= hf;

		if (doPos) {
			bb.x = bb.x * wf;
			bb.y = bb.y * hf;
		}

		// Don't bother, if it won't fit right
		if (bb.x >= 0.0 && bb.width > 0.0 && bb.y >= 0.0 && bb.height > 0.0 && (bb.x + bb.width) < 1.0 && (bb.y + bb.height) < 1.0) {
		
			Enumeration en;

			// ... and then our children

			for (en = getChildren(); en.hasMoreElements(); ) {
				EntityInstance e = (EntityInstance) en.nextElement();
				e.scale(wf, hf, true, true);
		}	}
	}

	public void scale(double sf, boolean doContainer, boolean doPos) 
	{
		scale(sf, sf, doContainer, doPos);
	}

	public void scale(double sf, boolean doContainer) 
	{
		scale(sf, sf, doContainer, false);
	}

	public void scale(double sf) 
	{
		scale(sf, sf, true, false);
	}

	public void scaleX(double sf, boolean doContainer, boolean doPos) 
	{
		scale(sf, 1.0, doContainer, doPos);
	}

	public void scaleX(double sf, boolean doContainer) 
	{
		scale(sf, 1.0, doContainer, false);
	}

	public void scaleX(double sf) 
	{
		scale(sf, 1.0, true, false);
	}

	public void scaleY(double sf, boolean doContainer, boolean doPos) 
	{
		scale(1.0, sf, doContainer, doPos);
	}

	public void scaleY(double sf, boolean doContainer) 
	{
		scale(1.0, sf, doContainer, false); 
	}

	public void scaleY(double sf) 
	{
		scale(1.0, sf, true, false);
	}

	// Attempt to fit children to us  

	private void doFitScale(double dx, double dy, double wf, double hf) 
	{
		setxRelLocal(xRelLocal() * wf + dx);
		setyRelLocal(yRelLocal() * hf - dy);
		setwidthRelLocal(dx + widthRelLocal() * wf);
		setheightRelLocal(dy + heightRelLocal() * hf);	
	}

	public void fitTo(boolean alwaysFit) 
	{
		Enumeration en;

		MsgOut.dprintln("Fit to: " + getId() );

		if ( (widthRelLocal() == 0) || (heightRelLocal() == 0)) {
			m_containsList = new Hashtable();
		}

		if (m_containsList.size() == 0) {
			MsgOut.dprintln("No children");
			return;
		}

		RelRectangle bb = getChildrenRelBoundingBox();

		if (bb.width <= 0.0 || bb.height <= 0.000) {
			return;
		}

		if (!alwaysFit) {

			// Only continue if bb isn't completely contained in this

			if (bb.x >= 0.0 && bb.y >= 0.0 && (bb.x + bb.width) <= 1.0 && (bb.y + bb.height) <= 1.0) {
				return;
		}	}
		

		// Translate bb to top left of parent and scale to fit

		// want new_relx = 1/15 and (new_relx + new_relwidth) = 14/15 for bounding box
		// so:
		//	m*x         + c =  1/15
		//	m*(x+width) + c = 14/15
		//	m*(x+width-x)   = 13/15 => m = 13/(15*width)
		//							=> c = (1/15) - m * x;

		double scaleX = 13.0 / (15.0 * bb.width);
		double scaleY = 13.0 / (15.0 * bb.height);
		double dx     = (1.0 / 15.0) - scaleX * bb.x;
		double dy     = (1.0 / 15.0) - scaleY * bb.y;

		for (en = getChildren(); en.hasMoreElements(); ) {
			EntityInstance e = (EntityInstance) en.nextElement();

			e.doFitScale(dx, dy, scaleX, scaleY);
		}

		MsgOut.dprintln("Fit: " + scaleX + " " + scaleY);
		return;
	}

	// Change the relative dimensions if anything is out of wack -- ie relative < 1/15 or > 14/15

	public void verifyFit() 
	{
		fitTo( false );
	}

	public void deltaFont(int delta) 
	{
		setFontDelta(m_fontDelta + delta);
	}

	public Dimension getLabelDim(Graphics g, int type, boolean wParent) 
	{
		setFont(g, type);

		FontMetrics fm = g.getFontMetrics();

		int h = Do.fontHeight(fm);
		int w = fm.stringWidth(getLabel());

		if (wParent) {
			EntityInstance pe = getEnterableParent();

			if (pe != null) {
				w = Math.max(fm.stringWidth(pe.getLabel() + " | "), w);
				h += h/2;
		}	} 
		return new Dimension(w, h);
	}

	public Dimension getLabelDim(Graphics g, int type) 
	{
		return getLabelDim(g, type, false);
	}

	public Dimension getFitDim(Graphics g, int type, boolean wParent) 
	{
		Dimension dim = getLabelDim(g, type, wParent);

		if (hasChildren() && !isOpen()) {
			dim.width += CONTENTS_FLAG_DIM;
		}
		dim.width  += MARGIN*3;
		dim.height += (MARGIN*3)/2;

		return dim;
	}

	public Dimension getFitDim(Graphics g, int type) 
	{
		return getFitDim(g, type, false);
	}

	// Edges

	public void invalidateAllEdges() 
	{ 
		Enumeration		 en;
		RelationInstance ri;

//		System.out.println("EntityInstance.drawAllEdges " + this);
		
		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.invalidateEdge();
		}	

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.invalidateEdge();
	}	}	

	public void drawAllEdges(EntityInstance under) 
	{ 
		Enumeration		 en;
		EntityInstance	 src;
		RelationInstance ri;

//		System.out.println("EntityInstance.drawAllEdges " + this);
		
		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.draw(true);	// allow elision from source
		}	

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			src = ri.m_drawSrc;
			if (!under.hasDescendant(src)) {
				ri.draw(true);	// allow elision to destination
		}	}	

//		System.out.println("EntityInstance.drawAllEdges " + this + " done");
	}

	public void drawHighlightedEdges() 
	{ 
		Enumeration		 en;
		RelationInstance ri;

		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.drawHighlighted();  
		}	

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.drawHighlighted(); 
		}	
	}

	public void getHighlightedEdges(Vector v) 
	{ 
		Enumeration en;
		RelationInstance ri;
		EntityInstance root, src, e;


		for (en = m_srcRelList.elements(); en.hasMoreElements();) {
			ri = (RelationInstance) en.nextElement();
			if (ri.getHighlightFlag() && ri.getRelationClass().isActive()) {
				v.addElement(ri);
			}
		}

		root = getDrawRoot();
		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			src = ri.getSrc();

			if (!root.hasDescendant(src) && ri.getHighlightFlag() && ri.getRelationClass().isActive()) {
				v.addElement(ri);
			}
		}

		// Call method on each child

		for (en = getChildren(); en.hasMoreElements();) {
			e = (EntityInstance) en.nextElement();
			e.getHighlightedEdges(v);
		}
	}


	// TA raw info routines

	public void getInstancesRaw(Vector v, Hashtable st) 
	{
		Enumeration en;
		EntityInstance child;

		// Not $ROOT 
		Integer[] pair = new Integer[2];
		pair[0] = (Integer) st.get(getId());
		pair[1] = (Integer) st.get(getParentClass().getId());
		v.addElement(pair);
		for (en = getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			child.getInstancesRaw(v, st);
		}
	}

	public void getRelationsRaw(Vector v, Hashtable st, Integer cid) 
	{
		// Get the relations on us, and then all our children

		Enumeration en; 

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			RelationInstance ri = (RelationInstance) en.nextElement();
			Integer[] triple = new Integer[3];
			RelationClass rc  = ri.getRelationClass();
			EntityInstance e1 = ri.getSrc();
			EntityInstance e2 = ri.getDst();
			triple[0] = (Integer) st.get(rc.getId());
			triple[1] = (Integer) st.get(e1.getId());
			triple[2] = (Integer) st.get(e2.getId());

			v.addElement(triple);
		}				
		for (en = getChildren(); en.hasMoreElements(); ) {
			EntityInstance child = (EntityInstance) en.nextElement();
			if (!isRoot()) {
				// If not root, output contain relation
				Integer[] triple = new Integer[3];
				triple[0] = cid;
				triple[1] = (Integer) st.get(getId());
				triple[2] = (Integer) st.get(child.getId());
				v.addElement(triple);
			}
			child.getRelationsRaw(v, st, cid);
		}
	}

	// TA file output routines 

	public void writeInstances(PrintStream ps) throws IOException 
	{
		// Write an instance line for ourself, and then all our children

		if (!isRoot()) {
			// Not $ROOT 
			ps.print(Diagram.INSTANCE_ID + " " + qt(getId()) + " " + qt(getParentClass().getId()) + "\n");
		}

		Enumeration en;

		for (en = getChildren(); en.hasMoreElements(); ) {
			EntityInstance child = (EntityInstance) en.nextElement();
			child.writeInstances(ps);
		}
	}

	public void writeRelations(PrintStream ps) throws IOException {

		// Write out the relations on us, and then all our children

		Enumeration en; 

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			RelationInstance ri = (RelationInstance) en.nextElement();
			ri.writeRelation(ps); 
		}				

		for (en = getChildren(); en.hasMoreElements(); ) {
			EntityInstance child = (EntityInstance) en.nextElement();
			if (!isRoot()) {
				// If not root, output contain relation
				ps.print(Diagram.CONTAIN_ID + " " + qt(getId()) + " " + qt(child.getId()) + "\n"); 
			}
			child.writeRelations(ps);
		}
	}

	protected void writeLayout(PrintStream ps) throws IOException 
	{
		// Write out Rectangle attributes

		ps.print(Attribute.indent + "xrel      = " + xRelLocal() + "\n");
		ps.print(Attribute.indent + "yrel      = " + yRelLocal() + "\n"); 
		ps.print(Attribute.indent + "widthrel  = " + widthRelLocal() + "\n"); 
		ps.print(Attribute.indent + "heightrel = " + heightRelLocal() + "\n");
	}

	protected void writeElision(PrintStream ps, Vector ev, String id) 
	{
		if (ev != null && ev.size() > 0) {
			ps.print(Attribute.indent + id + " = (");
			for (Enumeration en = ev.elements(); en.hasMoreElements(); ) {
				String rcId = (String) en.nextElement(); 
				ps.print(rcId);
				if (en.hasMoreElements()) {
					ps.print(" ");
			}	}
			ps.print(")\n"); 
		}
	}

	protected void writePoints(PrintStream ps, EdgePoint[] pts, String name) 
	{
		if (pts == null) {
			return;
		}

		boolean isDefault = true;

		for (int i = 1; i < pts.length; ++i) {
			if (pts[i] != null) {
				isDefault = isDefault && pts[i].isDefault;
		}	}

		if (isDefault) {
			return;
		}

		ps.print("	" + name + " = ( ");

		for (int i = 1; i < pts.length; ++i) {
			if (pts[i] != null && !pts[i].isDefault) {
				ps.print("(" + pts[i].getRc().getId() + " " + pts[i].m_wf + " " + pts[i].m_hf + ") ");
			}
		}
		ps.print(")\n");
	}

	protected void regRawElision(Vector v, Hashtable st, Vector ev, String id) 
	{
		if (ev != null && ev.size() > 0) {
			int len = ev.size();
			String[] sl = new String[len];

			for (int i=0; i<len; ++i) {
				sl[i] = (String) ev.elementAt(i);
			}
			regRawAttribute(v, st, id, sl);
		}
	}

	public void	writeAttributes(PrintStream ps) throws IOException
	{  
		LandscapeClassObject parentClass = getParentClass();
		Enumeration			 en;

		// Write out attribute record for us, and then our children

		ps.print(qt(getId()) + " {\n");
		writeLayout(ps);

		String label = getLabel();

		if (label != null && !label.equals(mungeId(getId()))) {
			if (isRoot() || !parentClass.defaultValue(LABEL_ID, label)) {
				// Save only if it differs from munged id (ie. auto-label) or the root
				ps.print(Attribute.indent + LABEL_ID + " = " + qt(label) + "\n");
		}	}

		String description = getDescription();

		if (description != null) {
			if (isRoot() || !parentClass.defaultValue(DESC_ID, description)) {
				ps.print(Attribute.indent + DESC_ID + " = \"" + description + "\"\n");
		}	}

		if (!isRoot()) {
			// First order attributes not associated with $ROOT 
			writeElision(ps, m_dstElision, IN_ELISION_ID);
			writeElision(ps, m_srcElision, OUT_ELISION_ID);
			writeElision(ps, m_enteringElision, CLIENT_ELISION_ID);
			writeElision(ps, m_exitingElision, SUPPLIER_ELISION_ID);
			writeElision(ps, m_internalElision, INTERNAL_ELISION_ID);
			writePoints(ps, topPoints, INPOINT_ID);
			writePoints(ps, bottomPoints, OUTPOINT_ID);
			writePoints(ps, leftPoints, LEFTPOINT_ID);
			writePoints(ps, rightPoints, RIGHTPOINT_ID);

			if (m_fontDelta != 0) {
				ps.print(Attribute.indent + FONTDELTA_ID + " = ");
				ps.print(m_fontDelta + "\n");
			}
		}

		// Finally output the second-class attributes 

		super.writeAttributes(ps, parentClass, false); 

		// End the record 

		ps.print("}\n"); 

		// Write any attributes of src relations

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			RelationInstance ri = (RelationInstance) en.nextElement();
			ri.writeAttributes(ps);
		}

		// Recurse for contained children

		for (en = getChildren(); en.hasMoreElements(); ) {
			EntityInstance child = (EntityInstance) en.nextElement();
			child.writeAttributes(ps);
		}
	}

	public void getLsAttributesRaw(Vector mv, Hashtable st) {

		Vector v = new Vector();

 		regRawAttribute(v, st, XRELPOSITION_ID, m_xrelLocal);
		regRawAttribute(v, st, YRELPOSITION_ID, m_yrelLocal);
		regRawAttribute(v, st, WIDTHREL_ID, m_widthrelLocal);
		regRawAttribute(v, st, HEIGHTREL_ID, m_heightrelLocal);

		String label = getLabel();

		if (label != null && !label.equals(mungeId(getId()))) {
			// Save only if it differs from munged id (ie. auto-label)
			regRawAttribute(v, st, LABEL_ID, label);
		}

		String description = getDescription();

		if (description != null) {
			regRawAttribute(v, st, DESC_ID, description);
		}

		if (!isRoot()) {
			// First order attributes not associated with $ROOT 
			LandscapeClassObject parentClass = getParentClass();
			Color				 pc	         = parentClass.getObjectColor();
			Color color1 = getObjectColor();
			if (!color1.equals(pc)) {
				regRawAttribute(v, st, COLOUR_ID, color1);
			}
			pc = parentClass.getLabelColor();
			Color labelcolor1;
			labelcolor1 = getLabelColor();
			if (!labelcolor1.equals(pc)) {
				regRawAttribute(v, st, LABEL_COLOUR_ID, labelcolor1);
			}
			color1 = getColorWhenOpen();
			if (color1 != null) {
				regRawAttribute(v, st, OPEN_COLOUR_ID, labelcolor1);
			}
			regRawElision(v, st, m_dstElision, IN_ELISION_ID);
			regRawElision(v, st, m_srcElision, OUT_ELISION_ID);
			regRawElision(v, st, m_enteringElision, OUT_ELISION_ID);
			regRawElision(v, st, m_exitingElision, SUPPLIER_ELISION_ID);
			regRawElision(v, st, m_internalElision, INTERNAL_ELISION_ID);

			// addRawIOpoints(v, st);
			if (m_fontDelta != 0) {
				regRawAttribute(v, st, FONTDELTA_ID, m_fontDelta);
			}
		}

		// Finally output the second-class attributes 
		if (getLsAttributesSize() > 0) 
			super.getLsAttributesRaw(v, st, false);

		Object[] obj = new Object[2];

		obj[0] = st.get(getId());
		obj[1] = v;

		mv.addElement(obj);

		Enumeration en;

/*
		// Write any attributes of src relations

		Enumeration en;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			RelationInstance ri = (RelationInstance) en.nextElement();
			ri.writeAttributes(ps);
		}
*/

		// Recurse for contained children

		for (en = getChildren(); en.hasMoreElements(); ) {
			EntityInstance child = (EntityInstance) en.nextElement();
			child.getLsAttributesRaw(mv, st);
		}
	}

	// Accessor functions and queries 

	public boolean canOpen() 
	{
		return !m_containsList.isEmpty();
	}

	public void setOpen() 
	{
		if (!isMarked(OPEN_MARK)) {
			nandMark(CLOSED_MARK);
			orMark(OPEN_MARK);
	}	}

	public void setClosed()
	{
		if (!isMarked(CLOSED_MARK)) {
			nandMark(OPEN_MARK);
			orMark(CLOSED_MARK);
	}	}

	public void openStatusUnknown()
	{
		nandMark(OPEN_MARK|CLOSED_MARK);
	}

	public boolean isOpen() 
	{
		// If haven't yet decided if open or closed
		// We will treat zero sized objects as being closed so that we don't have to repaint edges to zero
		// sized objects which is very expensive if have huge tree and everything open

		if (!isMarked(OPEN_MARK|CLOSED_MARK)) {
			if (canOpen() /* Has children */ && getWidth() > 0 && getHeight() > 0 && !isDstRelationElided(Diagram.CONTAIN_ID)) {
				setOpen();
			} else {
				setClosed();
		}	}

		return(isMarked(OPEN_MARK));
	}

	public boolean red_closed()
	{
		return(isMarked(REDBOX_MARK) && !isOpen());
	}

	public boolean red_open()
	{
		return(isMarked(REDBOX_MARK) && isOpen());
	}

	public boolean close_with_children_under_drawroot()
	{
		return(!isOpen() && hasChildren() && !isMarked(EntityInstance.CLIENT_SUPPLIER));
	}


	public EntityInstance getContainedBy() 
	{ 
		return m_containedBy;
	}	

	public EntityInstance getEnterableParent() 
	{
		EntityInstance e;
		
		for (e = m_containedBy; e != null; e = e.m_containedBy) {
			if (e.isEnterable()) {
				break;
		}	}
		return e;
	}

	public EntityClass getEntityClass() 
	{
		return (EntityClass) getParentClass();
	}

	public boolean isRoot() 
	{
		return (m_containedBy == null);
	}

	public boolean hasChildren() 
	{
		return !m_containsList.isEmpty();
	}

	public int numChildren() 
	{
		return m_containsList.size();
	}

	public Enumeration getChildren() 
	{
		return m_containsList.elements();
	}

	public String toString() 
	{
		return getLabel();
	}

	// Rectangle is global, adjust it to coords local to parent

	public void setDiagramBounds(int diagramX, int diagramY, int width, int height) 
	{
		double	width1, height1;

		m_diagramX = diagramX;
		m_diagramY = diagramY;
		width1     = parentsWidth();
		height1    = parentsHeight();

		if (width1 <= 0.0) {
			setxRelLocal(0);
			setwidthRelLocal(0);
		} else {
			setxRelLocal((diagramX - getParentDiagramX())/width1);
			setwidthRelLocal(width/width1);
		}

		if (height1 <= 0.0) {
			setyRelLocal(0);
			setheightRelLocal(0);
		} else {
			setyRelLocal((diagramY - getParentDiagramY())/height1);
			setheightRelLocal(height/height1);
		}
/*
		if (getLabel().equals("code")) {
//			System.out.println("EntityInstance.setDiagramBounds [" + diagramX + "," + diagramY + "," + width + "," + height + "]");
			m_debug_x = (int) (diagramX-getParentDiagramX());
			m_debug_y = (int) (diagramY-getParentDiagramY());
			m_debug_width  = width;
			m_debug_height = height;
		}
 */	
		
//		System.out.println("EntityInstance.setDiagramBounds " + label + " xrel=" + m_xrelLocal + " yrel=" + m_yrelLocal + " widthrel=" + m_widthrelLocal + " heightrel=" + m_heightrelLocal );
		setBounds((int) (diagramX-getParentDiagramX()), (int) (diagramY-getParentDiagramY()), width, height);

		validateAllMyEdges();
		moveCardinals();
	} 

	public void setDiagramBounds(Rectangle lyt) 
	{
		setDiagramBounds(lyt.x, lyt.y, lyt.width, lyt.height);
	} 

	public Rectangle getChildBoundingBox() 
	{
		Enumeration en;
		EntityInstance e;

		// Calc the global bounding box of children

		if (m_containsList.isEmpty()) {
			return null;
		}

		int x1 = Integer.MAX_VALUE;
		int x2 = Integer.MIN_VALUE;
		int y1 = Integer.MAX_VALUE;
		int y2 = Integer.MIN_VALUE;

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if (e.getX() < x1) {
				x1 = e.getX();
			}
			if (e.getY() < y1) {
				y1 = e.getY();
			}
			if (e.getX() + e.getWidth() > x2) {
				x2 = e.getX() + e.getWidth();
			}
			if (e.getY() + e.getHeight() > y2) {
				y2 = e.getY() + e.getHeight();
		}	}
		return new Rectangle(x1, y1, x2-x1, y2-y1);
	}

	public Color getBackgroundWhenOpen() {

		Color c;

		// Container is handled specially
		// Find colour from depth

		c = getColorWhenOpen();
		if (c == null) {

			float v = Diagram.BG - 0.05f;

			EntityInstance b = this;

			if (isTransparent()) {
				b = b.m_containedBy;
			}

			EntityInstance root = getDrawRoot();

			if (!root.hasDescendant(this)) {
				root = root.commonAncestor(this);
			}


			for (; b != root; b = b.m_containedBy) {
				v -= 0.05f;
			}

			c = new Color(v, v, v);

			if (Util.isBlack(c)) {
				c = Color.lightGray;
		}	}
		return c;
	}
			

	public Color getCurrentObjectColor() 
	{
		Color c;

		if (isOpen()) {
			c = getBackgroundWhenOpen();
		} else {
			c = getObjectColor();
		}
		return c;
	}

	public boolean isRelationElided(Vector v, String id) 
	{
		return (v != null && v.contains(id));
	}

	protected boolean toggleElision(Vector v, String id) 
	{
		if (isRelationElided(v, id)) {
			if (!v.removeElement(id)) {
				MsgOut.println("remove() failed");
			}
			return false; 
		} 

		v.addElement(id); 
		return true; 
	}

	public boolean toggleDstElision(String id) 
	{
		MsgOut.dprintln("toggle target " + id);
		return toggleElision(neededDstElision(), id);
	}

	public void toggleContainElision() 
	{
		toggleDstElision(Diagram.CONTAIN_ID);
		openStatusUnknown();
	}

	public void setContainElision() 
	{
		if (canOpen() /* Has children */ && !isDstRelationElided(Diagram.CONTAIN_ID)) {
			neededDstElision().addElement(Diagram.CONTAIN_ID);
			openStatusUnknown();
	}	}

	public void clearContainElision() 
	{
		if (m_dstElision != null) {
			m_dstElision.removeElement(Diagram.CONTAIN_ID);
	}	}

	public boolean toggleDstElision(RelationClass rc) 
	{
		return toggleDstElision(rc.getId());
	}

	public boolean toggleSrcElision(String id) 
	{
		MsgOut.dprintln("toggle out " + id);
		return toggleElision(neededSrcElision(), id);
	}

	public boolean toggleSrcElision(RelationClass rc)
	{
		return toggleSrcElision(rc.getId());
	}

	public boolean toggleEnteringElision(String id) 
	{
		MsgOut.dprintln("toggle client " + id);
		return toggleElision(neededEnteringElision(), id);
	}

	public boolean toggleEnteringElision(RelationClass rc) 
	{
		return toggleEnteringElision(rc.getId());
	}

	public boolean toggleExitingElision(String id) 
	{
		MsgOut.dprintln("toggle exiting " + id);
		return toggleElision(neededExitingElision(), id);
	}

	public boolean toggleExitingElision(RelationClass rc) 
	{
		return toggleExitingElision(rc.getId());
	}

	public boolean toggleInternalElision(String id) 
	{
		MsgOut.dprintln("toggle internal " + id);
		return toggleElision(neededInternalElision(), id);
	}

	public boolean toggleInternalElision(RelationClass rc) 
	{
		return toggleInternalElision(rc.getId());
	}

	// Queries 

	public boolean isDstRelationElided(RelationClass rc) 
	{
		return isRelationElided( m_dstElision, rc.getId() );
	}

	public boolean isDstRelationElided(String id) 
	{
		return isRelationElided(m_dstElision, id);
	}

	public boolean isSrcRelationElided(RelationClass rc) 
	{
		return isRelationElided(m_srcElision, rc.getId());
	}

	public boolean isSrcRelationElided(String id) 
	{
		return isRelationElided(m_srcElision, id);
	}

	public boolean isEnteringRelationElided(RelationClass rc) 
	{
		return isRelationElided(m_enteringElision, rc.getId());
	}

	public boolean isEnteringRelationElided(String id) 
	{
		return isRelationElided(m_enteringElision, id);
	}

	public boolean isExitingRelationElided(RelationClass rc) 
	{
		return isRelationElided(m_exitingElision, rc.getId());
	}

	public boolean isExitingRelationElided(String id) 
	{
		return isRelationElided(m_exitingElision, id);
	}

	public boolean isInternalRelationElided(RelationClass rc) 
	{
		return isRelationElided(m_internalElision, rc.getId());
	}

	public boolean isInternalRelationElided(String id) 
	{
		return isRelationElided(m_internalElision, id);
	}

	public int getPostorder()
	{
		return (m_postorder);
	}

	public boolean hasAncestor(EntityInstance e) 
	{
		if (m_preorder == 0 || e.m_preorder == 0 || m_postorder == 0 || e.m_postorder == 0) {
			System.out.println("EntityInstance.hasAncestor error " + this + "(" + m_preorder + "," + m_postorder + ") " + e + "(" + e.m_preorder + "," + e.m_postorder + ")");
		}

		return(e.m_preorder < m_preorder && m_postorder < e.m_postorder);
	}


	// Returns true if e is a descendant of me

	public boolean hasDescendant(EntityInstance e) 
	{
		if (m_preorder == 0 || e.m_preorder == 0 || m_postorder == 0 || e.m_postorder == 0) {
			System.out.println("EntityInstance.hasDescendant error " + this + "(" + m_preorder + "," + m_postorder + ") " + e + "(" + e.m_preorder + "," + e.m_postorder + ")");
		}
		return(m_preorder < e.m_preorder && e.m_postorder < m_postorder);
	}

	public boolean hasDescendantOrSelf(EntityInstance e) 
	{
		if (m_preorder == 0 || e.m_preorder == 0 || m_postorder == 0 || e.m_postorder == 0) {
			System.out.println("EntityInstance.hasDescendant error " + this + "(" + m_preorder + "," + m_postorder + ") " + e + "(" + e.m_preorder + "," + e.m_postorder + ")");
		}
		return(m_preorder <= e.m_preorder && e.m_postorder <= m_postorder);
	}

	public boolean isPathBetween(EntityInstance e)
	{
		if (m_preorder == 0 || e.m_preorder == 0 || m_postorder == 0 || e.m_postorder == 0) {
			System.out.println("EntityInstance.isPathBetween error " + this + "(" + m_preorder + "," + m_postorder + ") " + e + "(" + e.m_preorder + "," + e.m_postorder + ")");
		}
		return((m_preorder <= e.m_preorder && e.m_postorder <= m_postorder) || (e.m_preorder < m_preorder && m_postorder < e.m_postorder));
	}

	// Return the common ancestor entity

	public EntityInstance commonAncestor(EntityInstance e) 
	{
		EntityInstance e1;

		for (e1 = m_containedBy; e1 != null; e1 = e1.m_containedBy) {
			if (e1.hasDescendant(e)) {
				break;
		}	}
		return(e1);
	}

	// Finds that entity being displayed either as a client or a server
	// to which arrows to my entity should be addressed

	public EntityInstance clientServer() 
	{
		EntityInstance e1;

		for (e1 = this; e1 != null; e1 = e1.m_containedBy) {
			if (e1.isMarked(CLIENT_MARK | SUPPLIER_MARK)) {
				break;
		}	}
		return(e1);
	}

	public boolean inDiagram()
	{
		return(isMarked(IN_DIAGRAM));
	}

	public EntityInstance getVisibleEntity() 
	{
		EntityInstance e;

		for (e = this; e != null; e = e.m_containedBy) {
			if (inDiagram()) {
				break;
		}	}
		return e;
	}

	// Return true if we're a client of passed entity.
	// That is, a relation exist between us, or our children and 
	// the passed entity or its children.

	public boolean isClientOf(EntityInstance pc) 
	{
		Enumeration en;
		
		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			RelationInstance ri = (RelationInstance) en.nextElement();
			EntityInstance e = ri.getDst();

			if (e == pc) {
				return true;
			}

			if (pc.hasAncestor(e)) {
				return true;
			}
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			EntityInstance e = (EntityInstance) en.nextElement();
			if (e.isClientOf(pc)) {
				return true;
		}	}

		return false;
	}

	// Return reference to entity the cursor is over. 
	// Return null if none.

	public EntityInstance getMouseOver(int x, int y) 
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null && entityComponent.contains(x,y)) {
			if (isOpen()) {
				Enumeration en;
				EntityInstance e, over;

				for (en = getChildren(); en.hasMoreElements(); ) {
					e = (EntityInstance) en.nextElement();
					over = e.getMouseOver(x, y);
					if (over != null)
						return over; 
			}	}
			// It's not over any of our children, so it's over us.
			return this; 
		}
		return null;
	}

	public EntityInstance intersects(Rectangle lyt) 
	{
		if (containsRectangle(lyt)) {
			if (!m_containsList.isEmpty()) {
				// Check children
				Enumeration en;

				for (en = getChildren(); en.hasMoreElements(); ) {
					EntityInstance e = (EntityInstance) en.nextElement();
					EntityInstance oe = e.intersects(lyt); 
					if (oe != null) {
						return oe; 
				}	}
				return null; 
			}
			return this;  // over us 
		} else if (intersectsLayout(lyt)) { 
			return this;
		}
		return null; 
	}

	public EntityInstance containing(Rectangle lyt) 
	{
		if (containsRectangle(lyt)) {
			if (!m_containsList.isEmpty() && isOpen()) {
				// Check children
				Enumeration en;

				for (en = getChildren(); en.hasMoreElements(); ) {
					EntityInstance e = (EntityInstance) en.nextElement();
					EntityInstance oe = e.containing(lyt);
					if (oe != null) {
						return oe;
				}	}
			}
			return this;
		}
		return null;
	}

	public Enumeration srcRelationElements() 
	{
		return m_srcRelList.elements(); 
	}

	public Enumeration dstRelationElements() 
	{
		return m_dstRelList.elements(); 
	}

	public Enumeration srcLiftedRelationElements() 
	{
		return m_srcLiftedList.elements(); 
	}

	public Enumeration dstLiftedRelationElements() 
	{
		return m_dstLiftedList.elements(); 
	}

	protected void addSrcRels(Vector v) 
	{
		Enumeration en;
		EntityInstance e;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			v.addElement(en.nextElement());
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.addSrcRels(v);
		}
	}

	public Enumeration srcRelationAbstractedElements()
	{
		// Return enumeration for all edges which
		// have this entity as the source (real and abstracted).

		Vector v = new Vector();
		addSrcRels(v);
		return v.elements();
	}

	protected void addDstRels(Vector v) 
	{
		Enumeration en;
		EntityInstance e;

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			v.addElement(en.nextElement());
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.addDstRels(v);
		}
	}

	public Enumeration dstRelationAbstractedElements() 
	{
		// Return enumeration for all edges which
		// have this entity as the destination (real and abstracted).

		Vector v = new Vector();
		addDstRels(v);
		return v.elements();
	}

	public Vector groupRegion(Rectangle lyt) 
	{
		// This entity isn't in the group, but any children which
		// intersect the passed region are.

		if (m_containsList.isEmpty()) {
			return null;
		}
		Vector grp = new Vector();
		Enumeration en;
		EntityInstance e;
		
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement(); 
			if (e.intersectsLayout(lyt)) {
				e.setGroupFlag(); 
				grp.addElement(e);
			}
		}

		if (grp.isEmpty()) {
			return null;
		}
		return grp;
	}

	public void getGroup(Vector grp) 
	{
		Enumeration en;
		EntityInstance e;
		
		if (getGroupFlag()) {
			grp.addElement(this);
		}

		for (en = getChildren(); en.hasMoreElements();) {
			e = (EntityInstance) en.nextElement(); 
			e.getGroup(grp);
	}	}

	protected void setGroupFlag() 
	{
		if (!isMarked(GROUP_MARK)) {
			orMark(GROUP_MARK);
			repaint(); 
	}	}

	protected void clearGroupFlag() 
	{
		if (isMarked(GROUP_MARK|GROUPKEY_MARK)) {
			nandMark(GROUP_MARK|GROUPKEY_MARK);
			repaint();
	}	}		

	public boolean getGroupFlag() 
	{
		return isMarked(GROUP_MARK);
	}

	protected void setGroupKeyFlag() 
	{
		if (!isMarked(GROUPKEY_MARK)) {
			orMark(GROUPKEY_MARK);
			repaint();
	}	}

	protected void clearGroupKeyFlag() 
	{
		if (isMarked(GROUPKEY_MARK)) {
			nandMark(GROUPKEY_MARK);
			repaint();
	}	}

	public boolean getGroupKeyFlag() 
	{
		return isMarked(GROUPKEY_MARK);
	}

	public void getRedBoxGroup(Vector grp) 
	{
		Enumeration		en;
		EntityInstance	e;

		if (isMarked(REDBOX_MARK)) {
			grp.addElement(this);
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement(); 
			e.getRedBoxGroup(grp);
	}	}

	public void setRedBoxFlag() 
	{
		if (!isMarked(REDBOX_MARK)) {
			orMark(REDBOX_MARK);
			repaint();
	}	}

	public void clearRedBoxFlag() 
	{
		if (isMarked(REDBOX_MARK)) {
			nandMark(REDBOX_MARK);
			repaint();
	}	}

	public void clearAllFlags() 
	{
		Enumeration en;
		RelationInstance ri;
		EntityInstance e;

		clearGroupFlag();
		clearGroupKeyFlag();
		clearRedBoxFlag();
		openStatusUnknown();

		for (en = m_srcRelList.elements(); en.hasMoreElements();) {
			ri = (RelationInstance) en.nextElement();
			ri.clearHighlightFlag();
			ri.clearGroupFlag();
		}
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement(); 
			e.clearAllFlags();
		}
	}

	// Remove redbox and highlight flags at and under me

	public void clearQueryFlags() 
	{
		Enumeration en;
		RelationInstance ri;
		EntityInstance e;

		clearRedBoxFlag();

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.clearHighlightFlag();
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e    = (EntityInstance) en.nextElement(); 
			e.clearQueryFlags();
	}	}

	public void clearGroupFlags() 
	{
		Enumeration en;
		EntityInstance e;

		clearGroupFlag();
		clearGroupKeyFlag();

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement(); 
			e.clearGroupFlags();
		}
	}

	public boolean isClippedLabel() 
	{
		if (getWidth() < MIN_WIDTH || getHeight() < MIN_HEIGHT) {
			return(true);
		}
		return(false);
	}

	// Internal attributes of different entities

	public boolean isClickable() 
	{
		return true;
	}

	public void orMark(int val) 
	{
/*
		if ((m_mark & REDBOX_MARK) == 0) {
			if ((val & REDBOX_MARK) != 0) {
				System.out.println("EntityInstance.orMark(REDBOX_MARK) " + this);
		}	}
*/
		m_mark |= val;
	}

	public void andMark(int val)
	{
/*
		if ((m_mark & REDBOX_MARK) != 0) {
			if ((val & REDBOX_MARK) == 0) {
				System.out.println("EntityInstance.andMark(~REDBOX_MARK) " + this);
		}	}
*/	
		m_mark &= val;
	}

	public void nandMark(int val) 
	{
/*
		if ((m_mark & REDBOX_MARK) != 0) {
			if ((val & REDBOX_MARK) != 0) {
				System.out.println("EntityInstance.nandMark(REDBOX_MARK) " + this);
		}	}	
*/
		m_mark &= ~val;
	}
	
	public boolean isMarked(int val)
	{
		return((m_mark & val) != 0);
	}

	public int getMark()
	{
		return m_mark;
	}

	public boolean isClient()
	{
		return(isMarked(CLIENT_MARK));
	}

	public boolean isSupplier()
	{
		return(isMarked(SUPPLIER_MARK));
	}

	public boolean isClientOrSupplier()
	{
		return(isMarked(CLIENT_MARK|SUPPLIER_MARK));
	}

	static public Font getSmallFont() 
	{
		return smallFont;
	}

	public double parentsWidthLocal()
	{
		if (m_containedBy == null) {
			return(getDiagram().getWidth());
		} 
		return(m_containedBy.parentsWidthLocal() * m_containedBy.widthRelLocal());
	}

	public double parentsHeightLocal()
	{
		if (m_containedBy == null) {
			return(getDiagram().getHeight());
		} 
		return(m_containedBy.parentsHeightLocal() * m_containedBy.heightRelLocal());
	}

	public double parentsWidth()
	{
		if (m_containedBy == null) {
			return(getDiagram().getWidth());
		} 
		return(m_containedBy.getWidth());
	}

	public double parentsHeight()
	{
		if (m_containedBy == null) {
			return(getDiagram().getHeight());
		} 
		return(m_containedBy.getHeight());
	}

	/* Relative local coordinate system
     *
     * 0 same offset as top/left hand edge of parent
     * 1 same offset as bottom/right hand edge of parent
     */

	public double xRelLocal()  
	{
		return(m_xrelLocal);
	}

	public double yRelLocal() 
	{
		return(m_yrelLocal);
	}

	public double widthRelLocal() 
	{
		return(m_widthrelLocal);
	}

	public double heightRelLocal() 
	{
		return(m_heightrelLocal);
	}

	public void setxRelLocal(double xRelLocal)  
	{
		if (xRelLocal >= 0) {
			m_xrelLocal = xRelLocal;
		} else {
			m_xrelLocal = 0;
	}	}

	public void setyRelLocal(double yRelLocal) 
	{
		if (yRelLocal >= 0) {
			m_yrelLocal = yRelLocal;
		} else {
			m_yrelLocal = 0;
	}	}	

	public void setwidthRelLocal(double widthRelLocal) 
	{
		if (widthRelLocal > 1.0) {
			widthRelLocal = 1.0;
		}
		if ((m_xrelLocal + widthRelLocal) > 1.0) {
			m_xrelLocal     = 1.0 - widthRelLocal;
		}
		m_widthrelLocal = widthRelLocal;
	}

	public void setheightRelLocal(double heightRelLocal) 
	{
		if (heightRelLocal > 1.0) {
			heightRelLocal = 1.0;
		}
		if (m_yrelLocal + heightRelLocal > 1.0) {
			m_yrelLocal = 1.0 - heightRelLocal;
		}
		m_heightrelLocal = heightRelLocal;
	}

	/* Local coordinate system (obsoleted because of numeric underflow)
	 *
	 * 0 - Same as top/left edge of parent
	 * n - As position n while parent at position m.
     */

	/* This is only called if we are using legacy coordinate system..
	 * It is called after loading coordinates
	 * and converts the old local coordinates temporarily stored into relative ones
	 */

	public void computeRelCoordinates(double xParent, double yParent, double widthParent, double heightParent)
	{
		double			xLocal, yLocal, widthLocal, heightLocal;
		Enumeration		en;
		EntityInstance	e;

		xLocal      = m_xrelLocal;
		yLocal      = m_yrelLocal;
		widthLocal  = m_widthrelLocal;
		heightLocal = m_heightrelLocal;

		if (widthParent == 0.0) {
			m_xrelLocal      = 0.0;
			m_widthrelLocal  = 0.0;
		} else {
			m_xrelLocal      = xLocal/widthParent;
			m_widthrelLocal  = widthLocal/widthParent;
		}
		if (heightParent == 0.0) {
			m_yrelLocal      = 0.0;
			m_heightrelLocal = 0.0;
		} else {
			m_yrelLocal      = yLocal/heightParent;
			m_heightrelLocal = heightLocal/heightParent;
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.computeRelCoordinates(xLocal, yLocal, widthLocal, heightLocal);
		}
//		System.out.println("EntityInstance:computeRelCoordinates(" + xParent + ", " + yParent + ", " + widthParent + ", " + heightParent + ") = {" + m_xrelLocal + ", " + m_yrelLocal + ", " + m_widthrelLocal + ", " + m_heightrelLocal + "}");
	}

	public void setxLocal(double xLocal)  
	{
		getDiagram().m_uses_local_coordinates = true;
		m_xrelLocal                           = xLocal;
	}


	public void setyLocal(double yLocal) 
	{
		getDiagram().m_uses_local_coordinates = true;
		m_yrelLocal                           = yLocal;
	}

	public void setwidthLocal(double widthLocal) 
	{
		getDiagram().m_uses_local_coordinates = true;
		m_widthrelLocal                       = widthLocal;
	}

	public void setheightLocal(double heightLocal) 
	{
		getDiagram().m_uses_local_coordinates = true;
		m_heightrelLocal                      = heightLocal;
	}

	// The routines that follow hide the complexity of getting/setting attribute values
	// from EditAttributes
 
	public int getPrimaryAttributeCount()
	{
		return(13);
	}

	public String getLsAttributeNameAt(int index)
	{
		String	name;

		switch (index) {
		case 0:
			name  = "id";
			break;
		case 1:
			name  = "class";
			break;
		case 2:
			name  = LABEL_ID;
			break;
		case 3:
			name  = TITLE_ID;
			break;
		case 4:
			name  = DESC_ID;
			break;	
		case 5:
			name  = COLOUR_ID;
			break;
		case 6:
			name  = LABEL_COLOUR_ID;
			break;
		case 7:
			name  = OPEN_COLOUR_ID;
			break;
		case 8:
			name  = XRELPOSITION_ID;
			break;
		case 9:
			name  = YRELPOSITION_ID;
			break;
		case 10:
			name  = WIDTHREL_ID;
			break;
		case 11:
			name  = HEIGHTREL_ID;
			break;
		case 12:
			name  = FONTDELTA_ID;
			break;
		default:
			name  = super.getLsAttributeNameAt(index);
		}
		return(name);
	}

	public Object getLsAttributeValueAt(int index)
	{
		Object				 value;

		switch (index) {
		case 0:
			value = getId();
			break;
		case 1:
		{
			LandscapeClassObject parentClass = getParentClass();

			if (parentClass == null) {
				value = null;
			} else {
				value = parentClass.getId();
			}
			break;
		}
		case 2:
			value = getLabel();
			break;
		case 3:
			value = getTitle();
			break;
		case 4:
			value = getDescription();
			break;
		case 5:
			if (hasObjectColor()) {
				value = getObjectColor();
			} else {
				value = null;
			}
			break;
		case 6:
			if (hasLabelColor()) {
				value = getLabelColor();
			} else {
				value = null;
			}
			break;
		case 7:
			if (hasColorWhenOpen()) {
				value = getColorWhenOpen();
			} else {
				value = null;
			}
			break;
		case 8:
			value = new Double(xRelLocal());
			break;
		case 9:
			value = new Double(yRelLocal());
			break;
		case 10:
			value = new Double(widthRelLocal());
			break;
		case 11:
			value = new Double(heightRelLocal());
			break;
		case 12:
			value = new Integer(m_fontDelta);
			break;
		default:
			value = super.getLsAttributeValueAt(index);
		}
		return(value);
	}

	public void setAttributeValueAt(int index, Object value)
	{
		switch (index) {
		case 0:
			setId((String) value);
			break;
		case 1:
		{
			if (value != null) {
				LandscapeClassObject parentClass = getParentClass();
				String newId = (String) value;
				if (parentClass == null || !parentClass.getId().equals(newId)) {
					Enumeration	en;
					EntityClass	ec;

					for (en = getDiagram().enumEntityClasses(); en.hasMoreElements(); ) {
						ec = (EntityClass) en.nextElement();
						if (ec.getId().equals(newId)) {
							setParentClass(ec);
							break;
			}	}	}	}
			break;
		}
		case 2:
			setLabel((String) value);
			break;
		case 3:
			setTitle((String) value);
			break;
		case 4:
			setDescription((String) value);
			break;
		case 5:
			setObjectColor((Color) value);
			break;
		case 6:
			setLabelColor((Color) value);
			break;
		case 7:
			setColorWhenOpen((Color) value);
			break;
		case 8:
			setxRelLocal(((Double) value).doubleValue());
			break;
		case 9:
			setyRelLocal(((Double) value).doubleValue());
			break;
		case 10:
			setwidthRelLocal(((Double) value).doubleValue());
			break;
		case 11:
			setheightRelLocal(((Double) value).doubleValue());
			break;
		case 12:
			m_fontDelta    = ((Integer) value).intValue();
			break;
		default:
			super.setAttributeValueAt(index, value);
	}	}


	// Need to know the type in cases where value might be null
	// For example with some colors

	public int getLsAttributeTypeAt(int index)
	{
		int		ret;
		
		switch (index) {
		case 0:
		case 2:
		case 3:
			ret = Attribute.STRING_TYPE;
			break;
		case 1:
			ret = Attribute.ENTITY_CLASS_TYPE;
			break;
		case 4:
			ret = Attribute.TEXT_TYPE;
			break;
		case 5:
		case 6:
		case 7:
			ret = Attribute.COLOR_OR_NULL_TYPE;
			break;
		case 8:
		case 9:
		case 10:
		case 11:
			ret = Attribute.DOUBLE_TYPE;
			break;
		case 12:
			ret = Attribute.INT_TYPE;
			break;
		default:
			ret = super.getLsAttributeTypeAt(index);
		}
		return(ret);
	}

	public boolean containsDiagramPoint(int x, int y)
	{
		if (x < getDiagramX()) {
			return(false);
		}
		if (x > getDiagramX() + getWidth()) {
			return(false);
		}
		if (y < getDiagramY()) {
			return(false);
		}
		if (y > getDiagramY() + getHeight()) {
			return(false);
		}
		return(true);
	}

	public void dump(int indent)
	{
		Enumeration		en;
		EntityInstance	e;
		int				i;

		for (i = 0; i < indent; ++i) {
			System.out.print(" ");
		}
		System.out.println(this);

		// Handle children

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.dump(indent+2);
		}
	}

	public int prepostorder(int value)
	{
		Enumeration		en;
		EntityInstance	e;

		m_preorder = value;

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			value = e.prepostorder(value+1);
		}
		m_postorder = ++value;
		return(value);
	}

	public void clearAllMarks(int preserve_entity_marks, int preserve_relation_marks) 
	{
		Enumeration			en;
		EntityInstance		e;
		RelationInstance	ri;

		andMark(preserve_entity_marks);
		
//		System.out.println("EntityInstance.clearAllMarks(" + preserve_entity_marks + ", " + preserve_relation_marks + ") " + getLabel() + " srcLifted empty" );
		m_srcLiftedList.removeAllElements();
		m_dstLiftedList.removeAllElements();
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.clearAllMarks(preserve_entity_marks, preserve_relation_marks);
		}

		// Doing all the source points clears all edges since all edges have a source

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.clearMark(preserve_relation_marks);
	}	}

	/* It is cheaper to visit each node outside of the draw root and not above it
	 * and see once if it has anything into the drawing, than to examine the edges
	 * inside the diagram to see where they go
	 *
	 * Adds to the vector set all those top most nodes outside of the draw root but
	 * not above it which have edges into the drawing
	 */

	public void addClients(Vector set, EntityInstance drawRoot)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		e;
		EntityClass			ec;

		if (this != drawRoot) {
			// Don't descend beneath the drawroot
			if (!hasDescendant(drawRoot)) {
				for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
					ri  = (RelationInstance) en.nextElement();
					e   = ri.getDst();
					if (drawRoot.hasDescendant(e)) {
						ec = e.getEntityClass();
						if (ec.isShown()) {
							orMark(CLIENT_MARK);
							set.addElement(this);
						}
						return;
			}	}	}
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.addClients(set, drawRoot);
	}	}	}

	/* It is cheaper to visit each node outside of the draw root and not above it
	 * and see once if it has anything into the drawing, than to examine the edges
	 * inside the diagram to see where they go
	 *
	 * Adds to the vector set all those top most nodes outside of the draw root but
	 * not above it which have edges from the drawing
	 */

	public void addSuppliers(Vector set, EntityInstance drawRoot)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		e;
		EntityClass			ec;

		if (this != drawRoot) {
			// Don't descend beneath the drawroot
			if (!hasDescendant(drawRoot)) {
				for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
					ri  = (RelationInstance) en.nextElement();
					e   = ri.getSrc();
					if (drawRoot.hasDescendant(e)) {
						ec = e.getEntityClass();
						if (ec.isShown()) {
//							System.out.println("EntityInstance.addSuppliers " + this);
							orMark(SUPPLIER_MARK);
							set.addElement(this);
						}
						return;
			}	}	}
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.addSuppliers(set, drawRoot);
	}	}	}

	protected void liftSrc(RelationInstance ri)
	{
		LandscapeClassObject	relationClass = ri.getParentClass();
		Enumeration				en;
		RelationInstance		other;

		if (!ri.isMarked(RelationInstance.PRESENTATION_MARKS)) {
			for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
				other = (RelationInstance) en.nextElement();
				if (ri.m_drawSrc == other.m_drawSrc && ri.m_drawDst == other.m_drawDst && relationClass == other.getParentClass()) {
					return;
		}	}	} 

//		System.out.println("EntityInstance.liftSrc into " + getLabel() + " " + ri);
		m_srcLiftedList.add(ri);	// Add this relation to the vector of relations that have draw source in this entity
	}

	protected void liftDst(RelationInstance ri)
	{
		LandscapeClassObject	relationClass = ri.getParentClass();
		Enumeration				en;
		RelationInstance		other;

		if (!ri.isMarked(RelationInstance.PRESENTATION_MARKS)) {
			for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
				other = (RelationInstance) en.nextElement();
				if (ri.m_drawSrc == other.m_drawSrc && ri.m_drawDst == other.m_drawDst && relationClass == other.getParentClass()) {
					return;
		}	}	} 
//		System.out.println("EntityInstance.liftDst into " + getLabel() + " " + ri);
		m_dstLiftedList.add(ri);	// Add this relation to the vector of relations that have draw destination to this entity
	}

	// Mark any source relation whose destination is under 'under'

	public void orSrcRelationsDstUnder(EntityInstance under)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		dst;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			dst = ri.getDst();
			if (under.hasDescendantOrSelf(dst)) {
				ri.orMark(RelationInstance.ADD_RESULTS_MARK);
	}	}	}

	public void orDstRelationsSrcUnder(EntityInstance under)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		src;

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			src = ri.getSrc();
			if (under.hasDescendantOrSelf(src)) {
				ri.orMark(RelationInstance.ADD_RESULTS_MARK);
	}	}	}

	public void orAllContainedSrcRelationsDstUnder(EntityInstance under)
	{
		Enumeration			en;
		EntityInstance		e;

		orSrcRelationsDstUnder(under);
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.orAllContainedSrcRelationsDstUnder(under);
	}	}

	public void addSrcRelations(int value, ResultBox resultBox)
	{
		Enumeration			en;
		RelationInstance	ri;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			if (ri.isMarked(value)) {
				resultBox.addRelation(ri);
				ri.orMark(RelationInstance.HIGHLIGHT_FLAG_MARK);
				ri.nandMark(value);
	}	}	}

	public void addDstRelations(int value, ResultBox resultBox)
	{
		Enumeration			en;
		RelationInstance	ri;

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			if (ri.isMarked(value)) {
				resultBox.addRelation(ri);
				ri.orMark(RelationInstance.HIGHLIGHT_FLAG_MARK);
				ri.nandMark(value);
	}	}	}

	public void addSrcDstRelations(int value, ResultBox resultBox)
	{
		Enumeration			en;
		EntityInstance		e;

		addSrcRelations(value, resultBox);
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.addSrcDstRelations(value, resultBox);
	}	}

	/* Compute all the diagram edges before lifting them so that we can later when lifting them detect duplicate draw edges
	   and eliminate them.  That is we will set none null values for ri.m_drawSrc/ri.m_drawDst but not actually add them into
	   the entity vectors yet.
	 */

	public void computeAllDiagramEdges(EntityInstance drawRoot, Vector clients, Vector suppliers, EntityInstance closedEntity, boolean liftEdges)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		src, dst, e;
		EntityClass			ec;

		ec = getEntityClass();
		if (!ec.isShown()) {
			return;
		}

//		System.out.println("EntityInstance.computeAllDiagramEdges for " + this);

		// For every edge that comes to us (something in or beneath entities in the diagram)
		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			src = ri.m_src;
//			System.out.println(" -> " + ri);

			if (clients != null || suppliers != null) {
				// N.B. Clients may actually be classified as suppliers if one and the same
				if (!drawRoot.isPathBetween(src)) {
					ri.m_drawSrc = src.clientServer();
			}	}
			// The destination of ri comes to our entity

			if (closedEntity != null) {
				if (!closedEntity.hasDescendant(src)) {
					// Ignore internal loops beneath a closed entity
					ri.m_drawDst = closedEntity;
				}
			} else {
				// The draw destination of ri is its actual destination
				ri.m_drawDst = this;
			}
		}

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
//			System.out.println(" <- " + ri);
			dst = ri.m_dst;

			if (suppliers != null && !drawRoot.isPathBetween(dst)) {
				ri.m_drawDst = dst.clientServer();
			}

			// The source of ri comes from our entity

			if (closedEntity != null) {
				if (!closedEntity.hasDescendant(dst)) {
					// Ignore internal loops beneath a close entity
					ri.m_drawSrc = closedEntity;
				}
			} else {
				// The source destination of ri is its actual destination
				ri.m_drawSrc = this;
			}
//			System.out.println(" <= " + ri);
		}

		if (closedEntity == null) {
			orMark(DIAGRAM_MARK);
			if (!isOpen()) {
				closedEntity = this;
				if (!liftEdges) {
					return;
			}	}
		} else {
			setSwingObject(null);	// Release this EntityComponent -- its not visible
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.computeAllDiagramEdges(drawRoot, clients, suppliers, closedEntity, liftEdges);
	}	}
	
	public void liftAllDiagramEdges(EntityInstance drawRoot, boolean liftEdges)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		e, src, dst;

//		System.out.println("EntityInstance.liftAllDiagramEdges " + this);

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
//			System.out.println("==>" + ri);
			if (!ri.isMarked(LIFTED_MARK)) {
				ri.orMark(LIFTED_MARK);
				src = ri.m_drawSrc;
				if (src != null) {
					dst = ri.m_drawDst;
					if (dst != null) {
						src.liftSrc(ri);
						dst.liftDst(ri);
					}
		}	}	}
		
		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
//			System.out.println("<==" + ri);
			if (!ri.isMarked(LIFTED_MARK)) {
				ri.orMark(LIFTED_MARK);
				src = ri.m_drawSrc;
				if (src != null) {
					dst = ri.m_drawDst;
					if (dst != null) {
						src.liftSrc(ri);
						dst.liftDst(ri);
		}	}	}	}
		
		if (!liftEdges && !isOpen()) {
			return;
		}
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.liftAllDiagramEdges(drawRoot, liftEdges);
	}	}

	public void validateEdges()
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		e;

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			ri.validate();
		}

		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			ri.validate();
		}

		if (!isMarked(CLOSED_MARK)) {
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.validateEdges();
	}	}	}

	public boolean intersectsLayout(Rectangle rect)
	{
		// Return true if the intersection of passed layout and 
		// entities layout is non-null

		// It overlaps if any corner of layout is contained in
		// entity, or vice versa.

		Rectangle box = new Rectangle(getX(), getY(), getWidth(), getHeight());
		return box.intersects(rect);
	}

 	public boolean containsRectangle(Rectangle rect) 
	{
		int x = getDiagramX();
		int y = getDiagramY();

		return (x < rect.x && rect.x+rect.width < x+getWidth() && y < rect.y && rect.y+rect.height < y+getHeight()); 
	}

	public int getParentDiagramX()
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null) {
			DiagramCoordinates above;
			Container          parentComponent = entityComponent.getParent();

			if (parentComponent instanceof EntityComponent) {
				above = (DiagramCoordinates) ((EntityComponent) parentComponent).getEntityInstance();
			} else {
				above = (DiagramCoordinates) parentComponent;
			}
			if (above != null) {
				return(above.getDiagramX());
		}	}
		return(0);
	}

	public int getParentDiagramY()
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null) {
			DiagramCoordinates above;
			Container          parentComponent = entityComponent.getParent();

			if (parentComponent instanceof EntityComponent) {
				above = (DiagramCoordinates) ((EntityComponent) parentComponent).getEntityInstance();
			} else {
				above = (DiagramCoordinates) parentComponent;
			}
			if (above != null) {
				return(above.getDiagramY());
		}	}
		return(0);
	}

	// Diagram Coordinates
	
	public int getDiagramX()
	{
		return(m_diagramX);
	}

	public int getDiagramY()
	{
		return(m_diagramY);
	}

	/* Compute the average position on the x axis of all drawn edges in/out of me */

	public void computeAvgX() 
	{
		EntityComponent ec = neededComponent();

		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		src, dst;
		int					edgeMode;
		double				f, avg;
		double				x = 0.0;
		int					n = 0;

		edgeMode = getDiagram().getEdgeMode();
		if (edgeMode == Do.DIRECT_EDGE_STATE) {
			// For every edge coming out of us consider the destination
			for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
				dst = ri.m_drawDst;
				x  += (dst.getDiagramX() + dst.getWidth()/2);
				++n;
			}
			// For every edge coming into us consider the source
			for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
				src = ri.m_drawSrc;
				x  += (src.getDiagramX() + src.getWidth()/2);
				++n;
			}
		} else {
			for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
				dst = ri.m_drawDst;
				f   = ri.getRelationClass().getIOfactor();
				x  += (dst.getDiagramX() + dst.getWidth()*f);
				++n;
			}
			for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
				src = ri.m_drawSrc;
				f   = ri.getRelationClass().getIOfactor();
				x  += (src.getDiagramX() + src.getWidth()*f);
				++n;
		}	}
		if (n > 0) {
			avg = x/((double) n);
		} else {
			avg = -1.0;
		}
		ec.setAvgX(avg);
	}

	public double getAvgX()
	{
		EntityComponent ec = neededComponent();

		return ec.getAvgX();
	}

	public void addUnder(JComponent under)
	{
		EntityComponent entityComponent = neededComponent();

//		System.out.println("EntityInstance:addUnder " + this + " " + isOpen() + " " + numChildren());
		entityComponent.removeAll();
		orMark(DIAGRAM_MARK);

		if (isOpen()) {
			Enumeration		en;
			EntityInstance	e;
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.addUnderEntity(this); // Add all children of open parent to diagram
		}	}
		under.add(entityComponent);		// Add this entity to diagram
		// Adding causes call to validate
	}

	public void addUnderEntity(EntityInstance under)
	{
		EntityClass	ec = getEntityClass();

		if (ec.isShown()) {
			EntityComponent parentComponent = under.neededComponent();
			addUnder(parentComponent);
	}	}
	
	// Reset all cardinals associated with this entity and things it contains

	public void resetCardinals(int numRelations) 
	{
		Enumeration en;

		if (m_dstCardinals == null) {
			if (numRelations > 0) {
				m_dstCardinals = new Cardinal[numRelations];
			}
		} else {
			int		 i;
			Cardinal cardinal;
			
			for (i = 0; i < numRelations; ++i) {
				cardinal = m_dstCardinals[i];
				if (cardinal != null) {
					cardinal.reset();
		}	}	}

		for (en = getChildren(); en.hasMoreElements(); ) {
			EntityInstance e = (EntityInstance) en.nextElement();
			e.resetCardinals(numRelations);
		}
	}

	public void incCardinal(int ind) 
	{
		Cardinal cardinal;
		
		cardinal = m_dstCardinals[ind];
		if (cardinal == null) {
			cardinal            = new Cardinal();
			m_dstCardinals[ind] = cardinal;
		}
		cardinal.inc();
	}

	// Calculate the number of edges into me

	public void calcEdgeCardinals(EntityInstance closedEntity, boolean hOnly)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		src, dst, target;
		EntityInstance			e;
		int					ind;

//		System.out.println("EntityInstance.calcEdgeCardinals for " + this);

		// For every edge that comes to us (something in or beneath entities in the diagram)
		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
		
			// The destination of ri comes to our entity

			if (closedEntity != null) {
				src = ri.m_src;
				if (closedEntity.hasDescendant(src)) {
					// Ignore internal loops beneath a closed entity
					continue;
				}
				target = closedEntity;
			} else {
				target = this;
			}

			if (!hOnly || ri.getHighlightFlag()) {
				ind = ri.getRelationClass().getNid();
				((EntityInstance) target).incCardinal(ind);
			}
		}

		if (closedEntity == null) {
			if (!isOpen()) {
				closedEntity = this;
		}	}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.calcEdgeCardinals(closedEntity, hOnly);
	}	}
	
	public void showCardinals()
	{
		Enumeration		en;
		EntityInstance	e;
		int				width, height;

		width    = getWidth();
		height   = getHeight();

		if (m_dstCardinals != null && width > 0 && height > 0) {

			int				cnt;
			JComponent	entityComponent = getSwingObject();

			Diagram		diagram = getDiagram();
			Cardinal	cardinal;
			int			i, diagramX, top, w, h, w1;
			FontMetrics fm;
			RelationClass rc;
			double		f;

			fm       = entityComponent.getFontMetrics(smallFont);
			h        = fm.getAscent();
			diagramX = getDiagramX();
			top      = getDiagramY() + height + MARGIN;

			for (i = m_dstCardinals.length; i > 0; ) {
				cardinal = m_dstCardinals[--i];
				if (cardinal != null) {
					cnt      = cardinal.getCnt();
					if (cnt > 0) {
						rc = diagram.numToRelationClass(i);
						f  = rc.getIOfactor();
						w  = fm.stringWidth("" + cnt);
						cardinal.setBackground(rc.getObjectColor());
						cardinal.setTextSize(w, h);
						cardinal.setCenterTop(diagramX + ((int) (((double) width)*f)), top);
						diagram.add(cardinal /* JLayeredPane.PALETTE_LAYER */);		// Add this cardinal to the diagram
		}	}	}	}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.showCardinals();
	}	}

	public void moveCardinals()
	{
		Enumeration	en;
		EntityInstance	e;
		int			width;

		// Move cardinals in sync with entity

		width = getWidth();
		if (m_dstCardinals != null) {
			Diagram			diagram = getDiagram();
			Cardinal		cardinal;
			int				i, diagramX, top;
			RelationClass	rc;
			double			f;

			diagramX = getDiagramX();
			top      = getDiagramY() + getHeight() + MARGIN;
			for (i = m_dstCardinals.length; i > 0; ) {
				cardinal = m_dstCardinals[--i];
				if (cardinal != null) {
					rc       = diagram.numToRelationClass(i);
					f        = rc.getIOfactor();
					cardinal.setCenterTop(diagramX + ((int) (((double) width)*f)), top);
					cardinal.revalidate();
		}	}	}
	}

	public boolean isTransparent() 
	{
		switch (getStyle()) {
		case EntityClass.ENTITY_STYLE_CLASS:
		case EntityClass.ENTITY_STYLE_LABELLED_GROUP:
			return true;
		}
		return false;
	}

	public boolean isCloseable() 	
	{
		switch (getStyle()) {
		case EntityClass.ENTITY_STYLE_CLASS:
		case EntityClass.ENTITY_STYLE_LABELLED_GROUP:
			return false;
		}
		return true;
	}	

	public boolean isLabelDrawable() 	
	{
		switch (getStyle()) {
		case EntityClass.ENTITY_STYLE_CLASS:
		case EntityClass.ENTITY_STYLE_LABELLED_GROUP:
			return false;
		}
		return true;
	}

	public boolean isEnterable() 	
	{
		switch (getStyle()) {
		case EntityClass.ENTITY_STYLE_CLASS:
		case EntityClass.ENTITY_STYLE_LABELLED_GROUP:
			return false;
		}
		return true;
	}

	// Assuming p1 is in this object and p2 is outside,
	// return the point that is the intersection between this object 
	// and the line segment p1->p2.

	public RealPoint calculateIntercept(RealPoint p1, RealPoint p2) 
	{
		double x = 0.0;
		double y = 0.0;

		double t, b, l, r;	// Top, bottom, left, and right
		double x1, y1, x2, y2;

		t = getY() -1;
		b = getY() + getHeight() + 1;
		l = getX() - 1;
		r = getX() + getWidth() + 1;

		boolean found = true;

		x1 = p1.getX();
		y1 = p1.getY();
		
		if (x1 < l || x1 > r || y1 < t || y1 > b) {
			MsgOut.println("calculateIntercept: p1 is not in box");
			return new RealPoint(x, y);
		}

		x2 = p2.getX();
		y2 = p2.getY();
		
		if (x1 == x2 && y1 == y2) {
			MsgOut.println("calculateIntercept: p1 == p2");
			return new RealPoint(x, y);
		}

		if (r <= x2) {
			x = r;
		} else if (x2 < l) {
			x = l;
		} else {
			found = false;
		}

		if (found) {
			// y = mx + b
			y = y1 + (x - x1) * ( (y2 - y1) / (x2 - x1) );
			found = ( t <= y && y <= b );
		}

		if (!found) {
			found = true;

			if (y2 <= t) {
				y = t;
			} else if (y2 >= b) {
				y = b;
			} else {
				found = false;
			}

			if (found) {
				x = x1 + (y - y1) * ( (x2 - x1) / (y2 - y1) );
				found = (l <= x && x <= r);
			}

		}

		if (!found) {
			MsgOut.println("calculateIntercept failed: " + x1 + " " + y1 + " " + x2 + " " + y2); 
		}
		return new RealPoint(x, y);
	}

	public int overResizeTab(int x1, int y1) 
	{
		int xLeft, xMid, xRight;
		int	yTop,  yMid, yBottom;
		int	pos;

		xLeft  = getDiagramX();

		if (x1 < xLeft) {
			// Outside object
			return RSZ_NONE;
		}
		if (x1 <= xLeft + 6) {
			pos = 0;
		} else {
			xRight = xLeft + getWidth();
			if (x1 > xRight) {
				// Outside object
				return RSZ_NONE;
			}
			if (x1 >= xRight - 6) {
				pos = 2;
			} else {
				xMid   = (xLeft + xRight)  / 2;
				if (x1 < xMid - 3 || x1 > xMid + 3) {
					return RSZ_NONE;
				}
				pos = 1;
		}	}

		yTop = getDiagramY();
		if (y1 < yTop) {
			// Outside object
			return RSZ_NONE;
		}
		if (y1 > yTop + 6) {
			yBottom = (int) (yTop + getHeight());
			if (y1 > yBottom) {
				// Outside object
				return RSZ_NONE;
			}
			if (y1 >= yBottom - 6) {
				pos += 6;
			} else {
				yMid = (yTop  + yBottom) / 2;
				if (y1 < yMid - 3 || y1 > yMid + 3) {
					return RSZ_NONE;
				}
				pos += 3;
		}	}

		switch (pos) {
		case 0:
			return RSZ_NW;
		case 1:
			return RSZ_N;
		case 2:
			return RSZ_NE;
		case 3:
			return RSZ_W;
		case 5:
			return RSZ_E;
		case 6:
			return RSZ_SW;
		case 7:
			return RSZ_S;
		case 8:
			return RSZ_SE;
		}
		return RSZ_NONE;
	}

	public boolean isPointOverIO(EdgePoint pt, int x, int y) 
	{
		int	x1, y1;

		x1 = (int) (pt.getX() + 0.5);	// round
		y1 = (int) (pt.getY() + 0.5);	// round	

		return ((x1 - RelationInstance.NEAR_PIXEL_SIZE/2) < x && x < (x1 + RelationInstance.NEAR_PIXEL_SIZE/2) && (y1 - RelationInstance.NEAR_PIXEL_SIZE/2) < y && y < (y1 + RelationInstance.NEAR_PIXEL_SIZE/2));
	}

	public void drawHighlight() 
	{
		if (!isMarked(HIGHLIGHT_EDGE_MARK)) {
			orMark(HIGHLIGHT_EDGE_MARK);
			repaint();
	}	}

	public void undrawHighlight() 
	{
		if (isMarked(HIGHLIGHT_EDGE_MARK)) {
			nandMark(HIGHLIGHT_EDGE_MARK);
			repaint();
	}	}

	private EdgePoint getPoint(EdgePoint[] pts, RelationClass rc, int side) 
	{
		int		  nid;
		EdgePoint cached;

		nid	   = rc.getNid();
		cached = pts[nid];

		// Cache calculated points

		if (cached == null || cached.getRc() != rc) {

			double f  = rc.getIOfactor();
			double wf = 0.0;
			double hf = 0.0;

			switch(side) {
			case EdgePoint.TOP:
				wf = f;					// Put at entity x + width * f at top
				break;
			case EdgePoint.BOTTOM:
				wf = f;
				hf = 1.0;				// But at bottom
				break;
			case EdgePoint.LEFT:
				hf = f;
				break;
			default:
				wf = 1.0;				// Put at right
				hf = f;
				break;
			}
			if (cached == null) {
				pts[nid] = cached = new EdgePoint(this, rc, wf, hf);
			} else {
				cached.setRc(rc);
			}
			cached.isDefault = true;
			cached.side		 = side;
			cached.rescale();	// Compute actual point given current position of e
		}
/*
		if (side == EdgePoint.TOP && getLabel().equals("code")) {
			System.out.println("EntityInstance.getPoint " + cached);
		}
*/  
		return cached;
	}

	public EdgePoint getPoint(RelationClass rc, int side) 
	{
		EdgePoint[] cache;

		switch(side) {
		case EdgePoint.TOP:
			cache = topPoints;
			if (cache == null) {
				topPoints = cache = new EdgePoint[numRelationClasses()];
			}
			break;
		case EdgePoint.BOTTOM:
			cache = bottomPoints;
			if (cache == null) {
				bottomPoints = cache = new EdgePoint[numRelationClasses()];
			}
			break;
		case EdgePoint.LEFT:
			cache = leftPoints;
			if (cache == null) {
				leftPoints = cache = new EdgePoint[numRelationClasses()];
			}
			break;
		default:
			cache = rightPoints;
			if (cache == null) {
				rightPoints = cache = new EdgePoint[numRelationClasses()];
		}	 }
		return getPoint(cache, rc, side);
	}


	// At what point does the ri relation hit this, given that it goes from the box specified by srcLyt to dstLyt
	// N.B. Most of the time anyway it appears that srcLyt is the srcLyt of this.

	public EdgePoint getOutPoint(RelationInstance ri, int edge_mode, Rectangle srcLyt, Rectangle dstLyt) 
	{
		RelationClass rc = ri.getRelationClass();
		int nid = rc.getNid();

		if (edge_mode == Do.TB_EDGE_STATE) {
			// Only allow edges to be from top or bottom
			EntityInstance src = (EntityInstance) ri.getSrc();
			if (this == src || src.hasAncestor(this)) {
				return getPoint(rc, EdgePoint.BOTTOM);
			}
			return getPoint(rc, EdgePoint.TOP);
		}
		if ((dstLyt.y - (srcLyt.y+srcLyt.height)) > SEP_THRESHOLD) {

			// dstLyt strictly below srcLyt
			return getPoint(rc, EdgePoint.BOTTOM);
		}

		if ((srcLyt.y - (dstLyt.y+dstLyt.height)) > SEP_THRESHOLD) {
			// srcLyt strictly below dstLyt
			return getPoint(rc, EdgePoint.TOP);
		}

		if ((dstLyt.x - (srcLyt.x+srcLyt.width)) > SEP_THRESHOLD) {
			return getPoint(rc, EdgePoint.RIGHT);
		}

		if ((srcLyt.x - (dstLyt.x+dstLyt.width)) > SEP_THRESHOLD) {
			return getPoint(rc, EdgePoint.LEFT);
		}

		if (dstLyt.y > (srcLyt.y+srcLyt.height)) {
			return getPoint(rc, EdgePoint.BOTTOM);
		}
		return getPoint(rc, EdgePoint.TOP);
	}

	protected EdgePoint testMouseOverIO(EdgePoint[] pts, int x, int y) {

		if (pts == null) {
			return null;
		}

		for (int i = 0; i < pts.length; i++) {
			EdgePoint pt = pts[i];

			if (pt != null) {
				if (isPointOverIO(pt, x, y)) {
					return pt;
				}
			}
		}
		return null;
	}

	public EdgePoint getMouseOverIO(int x, int y) 
	{
		EdgePoint pt = testMouseOverIO(topPoints, x, y);
		if (pt != null) {
			return pt;
		}

		pt = testMouseOverIO(bottomPoints, x, y);
		if (pt != null) {
			return pt;
		}

		pt = testMouseOverIO(leftPoints, x, y);
		if (pt != null) {
			return pt;
		}
		return testMouseOverIO(rightPoints, x, y);
	}

	public Enumeration srcRelListEnum()
	{
		return m_srcRelList.elements();
	}

	// Icon interface (used to paint legends)

	public int getIconWidth()
	{
		return(getWidth());
	}

	public int getIconHeight()
	{
		return(getHeight());
	}

	public void paintIcon(Component c, Graphics g, int x, int y)
	{
		EntityComponent entityComponent = neededComponent();

		entityComponent.paintIcon(c, g, x, y);	
	}

	// MouseListener interface

	public void mouseClicked(MouseEvent e)
	{
	}


	public void mouseEntered(MouseEvent e)
	{
	/*
	 	if (m_label.equals("code")) {
			System.out.println("EntityInstance.mouseEntered code " + getDiagramBounds());
			repaint();
		}
	*/
	}

	public void mouseExited(MouseEvent e)
	{
	}

	public void mousePressed(MouseEvent ev)
	{
		Diagram	diagram;
		int		x, y;

//		System.out.println("EntityInstance.mousePressed " + this);

		diagram = getDiagram();
		x       = ev.getX();
		y       = ev.getY();

		if (x       <= EntityComponent.CONTENTS_FLAG_X + EntityComponent.CONTENTS_FLAG_DIM && 
		    y       <= EntityComponent.CONTENTS_FLAG_Y+EntityComponent.CONTENTS_FLAG_DIM &&
		    x       >= EntityComponent.CONTENTS_FLAG_X &&
			y       >= EntityComponent.CONTENTS_FLAG_Y &&
			m_width  > EntityComponent.CONTENTS_FLAG_X+EntityComponent.CONTENTS_FLAG_DIM &&
			m_height > EntityComponent.CONTENTS_FLAG_Y+EntityComponent.CONTENTS_FLAG_DIM &&
			close_with_children_under_drawroot()) {
			LandscapeViewerCore	ls      = diagram.getLs();
			ls.processKey(Do.SHOW_CONTENTS, 0, this);
			return;
		}
		diagram.entityPressed(ev, this, ev.getX() + getDiagramX(), ev.getY() + getDiagramY());
	}

	public void mouseReleased(MouseEvent ev)
	{
		getDiagram().entityReleased(ev, this, ev.getX() + getDiagramX(), ev.getY() + getDiagramY());
	}

	// MouseMotionListener interface

	public void mouseDragged(MouseEvent ev)
	{
		getDiagram().entityDragged(ev, this, ev.getX() + getDiagramX(), ev.getY() + getDiagramY());
	}

	public void mouseMoved(MouseEvent ev)
	{
		Diagram				diagram = getDiagram();

		if (this != m_infoShown) {
			LandscapeViewerCore	ls      = diagram.getLs();
			m_infoShown = this;

			String str = getLabel();
			EntityInstance pe = getEnterableParent();

			if (pe != null) {
				str = pe.getLabel() + " . " + str /* + " " + getDiagramX() + "x" + getDiagramY() + " " + getX() + "X" + getY() */;
			} 
			ls.showInfo(str);

			if (m_currentDescEntity != this && !isOpen() && getEntityClass() != null) {
				String label = getLabel();
				String title = getTitle(); 
				String desc  = getDescription();

				if (desc == null) {
					desc = "The " + getLabel() + " " + getEntityClass().getLabel() + ".";
				}

				String topline = " (" + getEntityClass().getLabel() + (hasChildren() ? " - " + numChildren() + " items)" : ")" );

				if (title != null) {
					topline = title + topline;
				} else {
					topline = label + topline;
				}
				ls.setRightTextBox(topline, desc);
				m_currentDescEntity = this;
		}	}
		diagram.movedOverThing(ev, this, ev.getX() + getDiagramX(), ev.getY() + getDiagramY());
	}
}
