package lsedit;

import java.awt.Font;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

import java.awt.event.*;
import java.util.*;
import javax.swing.*;

public class Feedback extends JTextField {

	protected static final Font feedbackFont = new Font("Helvetica", Font.PLAIN, 11);
	protected String m_helpString;
	protected LandscapeViewerCore m_ls;

	// --------------
	// Public Methods
	// --------------

	public Feedback(LandscapeViewerCore ls, String helpString) 
	{
		m_ls = ls;
		m_helpString = helpString;
		setToolTipText(helpString);

		setBackground(Diagram.boxColour);
		setForeground(Color.black);
		setFont(feedbackFont);
		setEditable(false);
		setVisible(true);
	}

	public void set(String str) 
	{
		setText(str);
		revalidate();
	}

	public String get() 
	{
		return(getText());
	}
}

