package lsedit;

import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.util.*;

public class Find extends Object 
{

	protected Vector results = new Vector();
	protected int groups = 0;
	protected int ind	 = 0;

	protected void find(Pattern pattern, EntityInstance e) 
	{
		Enumeration en;
		EntityInstance	ce;
		boolean firstMatch = true;
		Matcher	m;

		for (en = e.getChildren(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			m = pattern.matcher(ce.getLabel());
			if (m.matches()) {
//				System.out.println("Found " + ce);
				results.addElement(ce);
				if (firstMatch) {
					firstMatch = false;
					groups++;
		}	}	}
		for (en = e.getChildren(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			find(pattern, ce);
		}
	}

	protected Vector getGroup() 
	{
		if (ind < 0 || ind >= results.size()) {
			return null;
		}

		Vector v = new Vector();
		EntityInstance pe = ((EntityInstance) results.elementAt(ind)).getContainedBy();

		for (; ind < results.size(); ++ind) {
			EntityInstance e = (EntityInstance) results.elementAt(ind);
			if (e.getContainedBy() != pe) {
				break;
			}
			v.addElement(e);
		} 
		return v;
	}

	protected boolean rewind() {

		if (ind == 0) {
			return false;
		}
		int orgInd = ind;
		ind--;

		EntityInstance pe = ((EntityInstance) results.elementAt(ind)).getContainedBy();

		for (; ind > 0; --ind) {

			EntityInstance e = (EntityInstance) results.elementAt(ind);

			if (e.getContainedBy() != pe) {
				pe = e.getContainedBy();
				break;
			}
		} 

		if (ind == 0) {
			ind = orgInd;
			return false;
		}

		for (; ind > 0; --ind) {

			EntityInstance e = (EntityInstance) results.elementAt(ind);

			if (e.getContainedBy() != pe) {
				ind++;
				break;
			}
		} 
		return true;
	}

	/*
	 * Public methods
	 */

	public Find(Pattern pattern, EntityInstance root) 
	{
		find(pattern, root);
	}

	public int foundCount() 
	{
		return groups;
	}

	public Vector prevResult() 
	{
		if (rewind()) {
			return getGroup();
		}
		return null;
	}

	public boolean haveNextResult() 
	{
		return (ind < results.size());
	}

	public Vector nextResult() 
	{
		return getGroup();
	}

	public Vector firstResult() 
	{
		ind = 0;
		return nextResult();
	}
}

