package lsedit;

import java.awt.Color;
import java.util.*;
import java.io.*; 
import javax.swing.*;

// 3 dimension objects have foreground colors, labels etc.
// This is everything but line objects such as edges

public abstract class LandscapeObject3D extends LandscapeObject {

	private String	m_id;			// The id of this entity or class (the name that identifies it uniquely in TA)
	private String	m_description;	// The description of this entity or class
	private String	m_label;		// The label for this entity or class

	/* Logical color's need to be kept separate from the JComponent colors
	 * otherwise when we paint a component we set its actual color to its
	 * logical color loosing the fact that it may not have had a logical color
	 * to begin with (ie. null->red if the class was red)
	 */

	private Color	m_labelColor  = null;
	private	Color	m_colorWhenOpen;

	// --------------
	// Public methods 
	// --------------

	public LandscapeObject3D() 
	{
		super();
	}

	public String toString() 
	{
		return m_id;
	}

	public String getId() 
	{
		return m_id;
	}

	public void setId(String id) 
	{
		m_id = id;
	}

	public boolean hasId(String id) 
	{
		return m_id.equals(id);
	}

	public String getDescription() 
	{
		return m_description;
	}

	public void setDescription(String description) 
	{
		if (description != null && description.length() == 0) {
			description = null;
		}
		m_description = description;
	}

	protected void setLabel(String label)
	{
		JComponent swingObject = getSwingObject();

		m_label = label;
		if (swingObject != null) {
			swingObject.setToolTipText(label);
	}	}

	protected String getLabel()
	{
		return(m_label);
	}

	public boolean hasLabelColor()
	{
		return(m_labelColor != null);
	}

	public Color getLabelColor() 
	{
		Color	ret;

		ret = m_labelColor;
		if (ret == null) {
			LandscapeClassObject	superclass;

			for (int i = 0; (superclass = derivedFrom(i)) != null; ++i) {
				ret = superclass.getLabelColor();
				if (ret != null) {
					break;
		}	}	}
		return ret;
	}

	public void setLabelColor(Color color) 
	{
		m_labelColor = color;
	}

	public boolean hasColorWhenOpen()
	{
		return(m_colorWhenOpen != null);
	}

	public Color getColorWhenOpen() 
	{
		Color	ret;

		ret = m_colorWhenOpen;
		if (ret == null) {
			LandscapeClassObject	superclass;

			for (int i = 0; (superclass = derivedFrom(i)) != null; ++i) {
				ret = superclass.getColorWhenOpen();
				if (ret != null) {
					break;
		}	}	}
		return ret;
	}

	public void setColorWhenOpen(Color color) 
	{
		m_colorWhenOpen = color;
	}

	public boolean canEditAttribute(int index)
	{
		if (index == 0) {
			// This is the id of the object
			return(false);
		}
		return(super.canEditAttribute(index));
	}
}

