package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.plaf.basic.BasicArrowButton;

public class LegendBox extends JComponent /* implements Scrollable */ 
{
	protected static final int MARGIN = 5;
	protected static final int GAP    = 5; 

	private class DisplayClassHierarchy implements ActionListener
	{
		private LegendBox				m_legendBox;
		private LandscapeClassObject	m_landscapeClass;
		int								m_x;
		int								m_y;
		JPopupMenu						m_popup = null;

 
		public DisplayClassHierarchy(JMenuItem menuitem, LegendBox legendBox, LandscapeClassObject landscapeClass, int x, int y)
		{
			Enumeration parentElements;

			parentElements = landscapeClass.getParentElements();

			if (parentElements == null || !parentElements.hasMoreElements()) {
				menuitem.setEnabled(false);
			}
			m_legendBox 	 = legendBox;
			m_landscapeClass = landscapeClass;
			m_x				 = x;
			m_y				 = y;
		}

		public void actionPerformed(ActionEvent e)
		{
			Enumeration					parentElements;
			LandscapeClassObject		parent;

			parentElements = m_landscapeClass.getParentElements();

			if (parentElements != null && parentElements.hasMoreElements()) {
				JPopupMenu		popup;
				JMenuItem		mi;
				String			label;

				label = m_landscapeClass.getLabel();
				popup = new JPopupMenu(label);

				while (parentElements.hasMoreElements()) {
					parent = (LandscapeClassObject) parentElements.nextElement();

					mi = new JMenuItem(parent.getLabel());
					mi.addActionListener(new DisplayClassHierarchy(mi, m_legendBox, parent, m_x, m_y)); 
					popup.add(mi);
				} 
				m_ls.add(popup);

				popup.show(m_legendBox, m_x, m_y);
			}
	}	}

	private class EditClassAttributes implements ActionListener
	{
		private LegendBox				m_legendBox;
		private EntityClass				m_entity;
 
		public EditClassAttributes(LegendBox legendBox, EntityClass entity)
		{

			m_legendBox = legendBox;
			m_entity    = entity;
		}

		public void actionPerformed(ActionEvent e)
		{
			EditAttribute.Create(m_ls, m_entity);
	}	}

	private class EditRelationClassAttributes implements ActionListener
	{
		private LandscapeViewerCore		m_ls;
		private RelationClass			m_relation;
 
		public EditRelationClassAttributes(LandscapeViewerCore ls, RelationClass relation)
		{

			m_ls	   = ls;
			m_relation = relation;
		}

		public void actionPerformed(ActionEvent e)
		{
			EditAttribute.Create(m_ls, m_relation);
	}	}

	private class EntityLabel extends EntityChkBox implements ItemListener, MouseListener
	{
		protected	LegendBox			m_legendBox;
		protected	JPopupMenu			m_popup = null;

		public EntityLabel(LegendBox legendBox, EntityClass ec, int index, int h) 
		{
			super(ec, index, h, false);

			m_legendBox = legendBox;
			setFont(LegendBox.textFont);
			addItemListener(this);
			addMouseListener(this);
		}

		public void setClassShown(boolean value)
		{
			if (m_ec.isShown() != value) {
				m_ec.setShown(value);
				m_ls.getDiagram().redrawDiagram();
		}	}

		public void itemStateChanged(ItemEvent ev)
		{
//			System.out.println("EntityLabel.itemStateChanged " + ev.getStateChange() + " " + isSelected());
			setClassShown(ev.getStateChange() == ItemEvent.SELECTED);
		}


		// MouseListener interface

		public void mouseClicked(MouseEvent e)
		{
		}

		public void mouseEntered(MouseEvent e)
		{
		}

		public void mouseExited(MouseEvent e)
		{
		}

		public void mousePressed(MouseEvent ev)
		{
			if (ev.isMetaDown()) {
				JMenuItem			mi;
				int					x  = ev.getX();
				int					y  = ev.getY();

				if (m_popup == null) {
					m_popup = new JPopupMenu("Class menu");

					mi = new JMenuItem("Display hierarchy");
					mi.addActionListener(new DisplayClassHierarchy(mi, m_legendBox, m_ec, x, y)); 
					m_popup.add(mi);

					mi = new JMenuItem("Edit attributes");
					mi.addActionListener(new EditClassAttributes(m_legendBox, m_ec)); 
					m_popup.add(mi);
					m_legendBox.add(m_popup);
				}
				m_popup.show(this, x, y);
		}	}

		public void mouseReleased(MouseEvent ev) 
		{
		}
	}
		
	class VisibleRelnChkBox extends RelnChkBox /* extends JComponent */ implements ItemListener, MouseListener
	{
		protected	LegendBox			m_legendBox;
		protected	JPopupMenu			m_popup;

		public VisibleRelnChkBox(LegendBox legendBox, RelationClass rc,  int index) 
		{
			super(rc, index, rc.isClassVisible()); 

			m_legendBox = legendBox;

			addItemListener(this);
			addMouseListener(this);
		}

		public boolean isClassVisible()
		{
			return(m_rc.isClassVisible());
		}

		public void setClassVisible(boolean value)
		{
			if (isClassVisible() != value) {
				m_rc.setClassVisible(value);
				m_ls.getDiagram().redrawDiagram();
		}	}

		public void itemStateChanged(ItemEvent ev)
		{
//			System.out.println("VisibleRelnChkBox.itemStateChanged " + ev.getStateChange() + " " + isSelected());
			setClassVisible(ev.getStateChange() == ItemEvent.SELECTED);
		}

		// MouseListener interface

		public void mouseClicked(MouseEvent e)
		{
		}

		public void mouseEntered(MouseEvent e)
		{
		}

		public void mouseExited(MouseEvent e)
		{
		}

		public void mousePressed(MouseEvent ev)
		{
			if (ev.isMetaDown()) {

				JMenuItem	mi;
				int		x           = ev.getX();
				int		y           = ev.getY();

				m_popup = new JPopupMenu("Relation menu");

				mi = new JMenuItem("Display hierarchy");
				mi.addActionListener(new DisplayClassHierarchy(mi, m_legendBox, m_rc, x, y)); 
				m_popup.add(mi);

				mi = new JMenuItem("Edit attributes");
				mi.addActionListener(new EditRelationClassAttributes(m_ls, (RelationClass) m_rc)); 
				m_popup.add(mi);
				m_legendBox.add(m_popup);
				m_popup.show(this, x, y);
		}	}
		
		public void mouseReleased(MouseEvent ev) 
		{
		}
	}

	protected LandscapeViewerCore   m_ls;
	protected JTabbedPane			m_tabbedPane;
	protected JScrollPane			m_scrollPane;

	protected static final Font   textFont	 = new Font("Helvetica", Font.PLAIN, 11); 
	protected static final Font	  titleFont  = new Font("Helvetica", Font.BOLD,  12);

	public    static final String m_helpStr	 = "This box shows the types of entities and relations that are present in the current landscape.";

	protected JLabel				m_ulabel;	// TODO underline it
	protected JLabel				m_elabel1;
	protected JLabel				m_elabel2;
	protected JLabel				m_rlabel;	// TODO underline it
	protected JLabel				m_flabel1;
	protected JLabel				m_flabel2;

	protected int					m_width;
	protected int					m_height;

	// --------------
	// Public methods 
	// --------------

	public LegendBox(LandscapeViewerCore ls, JTabbedPane tabbedPane) 
	{
		m_ls          = ls;
		m_tabbedPane  = tabbedPane;

		m_ulabel = new JLabel("Entities");
		m_ulabel.setForeground(Color.red);
		m_ulabel.setFont(titleFont);

		m_elabel1 = new JLabel("Pass cursor over entity for description.");
		m_elabel1.setForeground(Color.black);
		m_elabel1.setFont(textFont);

		m_elabel2 = new JLabel("Right click for menu.");
		m_elabel2.setForeground(Color.black);
		m_elabel2.setFont(textFont);

		m_rlabel = new JLabel("Relations");
		m_rlabel.setForeground(Color.red);
		m_rlabel.setFont(titleFont);

		m_flabel1 = new JLabel("Checkboxes select visible relations.");
		m_flabel1.setForeground(Color.black);
		m_flabel1.setFont(textFont);

		m_flabel2 = new JLabel("Right click for menu.");
		m_flabel2.setForeground(Color.black);
		m_flabel2.setFont(textFont);


		setLayout(null);
		setBackground(Diagram.boxColour);
		setToolTipText(m_helpStr);

		m_scrollPane = new JScrollPane();
		m_scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED); 
		m_scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED); 

//		m_scrollPane.setBounds(tabbedPane.getBounds());
//		setBounds(tabbedPane.getBounds());
		m_scrollPane.setViewportView(this);

		tabbedPane.addTab("Legend", null, m_scrollPane, m_helpStr);
	}

	public LandscapeViewerCore getLegendLs()
	{
		return(m_ls);
	}

	public void activate() 
	{
		m_tabbedPane.setSelectedComponent(m_scrollPane);
	}

	public boolean isActive() 
	{
		Component active;

		if (!isVisible()) {
			return(false);
		}
		active = m_tabbedPane.getSelectedComponent();
		return(active != null && this == active);
	}

/*
	public void setBounds(int x, int y, int width, int height)
	{
		super.setBounds(x,y,width,height);
		System.out.println("Legend size " + getBounds());
		return;
	}
*/

	protected void add(JComponent component)
	{
		Dimension	d;
		int			width, height;

		d      = component.getPreferredSize();
		width  = d.width;
		height = d.height;
		if (width > m_width) {
//			System.out.println("Width=" + width + " for " + component);
			m_width = width;
		}
		component.setBounds(MARGIN, m_height, width, height);
		super.add(component);
		m_height += height;
	}

	public void fillLegendBox()
	{
		Diagram				diagram;
		Enumeration			en;
		int					item,n,h;
		JViewport			viewport;
		int					width, height;
		Dimension 			dimension;

/*		System.out.println("LegendBox.fillLegendBox()");
		java.lang.Thread.dumpStack();
		System.out.println("-----");
*/

		diagram = m_ls.getDiagram();

		removeAll();

		m_width  = 0;
		m_height = 0;

		// Draw legend for entities

		item = 0;
		n	 = 0;
		h    = Do.fontHeight(textFont); 

		EntityClass ec;
		String		id;

		m_height += 10;
		add(m_ulabel);

		if (diagram != null) {
			for (en = diagram.enumEntityClassesInOrder(); en.hasMoreElements(); ) {
				ec = (EntityClass) en.nextElement();
				id	 = ec.getId();

				if (!id.equals(EntityClass.ENTITY_BASE_CLASS_ID)) {
					m_height += 10;
					add(new EntityLabel(this, ec, ++n, h));
		}	}	}

		if (n == 0) {
			m_height  += 10;
			add(new EntityLabel(this, diagram.m_entityBaseClass, ++n, h));
		}	

		m_height += 10;
		add(m_elabel1);
		add(m_elabel2);
		m_height += 20;
		add(m_rlabel);

		// Draw legend for relations

		m_height += GAP;

		n = 0;
		if (diagram != null) {
			for (en = diagram.enumRelationClassesInOrder(); en.hasMoreElements(); ) {
				RelationClass rc = (RelationClass) en.nextElement();

				if (!rc.excludeReln()) {
					add(new VisibleRelnChkBox(this, rc, ++n));
		}	}	}

		if (n == 0) {
			add(new VisibleRelnChkBox(this, diagram.m_relationBaseClass, ++n));
		}

		m_height += 20;
		add(m_flabel1);
		add(m_flabel2);

		// Max width is computed in the add() method
		m_width  += MARGIN;
		m_height += 10;

		dimension = new Dimension(m_width, m_height);
		setPreferredSize(dimension);
		setBounds(0, 0, m_width, m_height);
	}

/*
	public Dimension getMinimumSize()
	{
		return(getPreferredSize());
	}
*/
	
	public Dimension getMaximumSize()
	{
		return(getPreferredSize());
	}

	public void toggleRelationVisibility(int key) 
	{
		int				cnt = getComponentCount();
		int				i;
		Component		c;
		boolean			ns;

		ns = true;
		if (key == 0) {
			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof VisibleRelnChkBox) {
					if ( ((VisibleRelnChkBox) c).getIndex() == 1) {
						// Change everything the same way as the way the first one changed
						ns = !((VisibleRelnChkBox) c).isClassVisible();
						break;
			}	}	}

			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof VisibleRelnChkBox) {
					if (ns != ((VisibleRelnChkBox) c).isClassVisible()) {
						((VisibleRelnChkBox) c).doClick();
			}	}	}
		} else {
			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof VisibleRelnChkBox) {
					if (((VisibleRelnChkBox) c).getIndex() == key) {
						((VisibleRelnChkBox) c).doClick();
						break;
		}	}	}	}
	}

/*
	// Scrollable interface
	// We need to implement this to stop iterative size changes..
	// The mapbox knows what size it wants to be and sets it on every validate
	// If we don't disable it the viewport tries to change the size to fit the window every time it validates

	public Dimension getPreferredScrollableViewportSize()
	{
		return(getSize());
	}
	 
	public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return(50);
	}
	 
	public boolean getScrollableTracksViewportHeight() 
	{
		return(false);
	}

	public boolean getScrollableTracksViewportWidth() 
	{
		return(false);
	}

	public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return(10);
	} 
*/
}



