package lsedit;

import java.awt.Color;
import java.util.*;
import java.io.*;

public class RelationClass extends LandscapeClassObject /* extends LandscapeObject3D extends LandscapeObject */ {

	protected static final String FACTOR_ID = "class_iofactor";

	protected static final String RELATION_BASE_CLASS_ID = "$RELATION";

	protected boolean m_active  = true; 
	protected boolean m_visible = true; 

	// Permitted relations

	// This is the list of Entity class pairs that can participate in relations of this relation class
	// It can be presumed to be quite small.

	private Vector m_relationList = new Vector();	 
	protected int ordinal;

	// --------------
	// Public methods
	// --------------

	public RelationClass(String id, int nid, RelationClass prc, Diagram dg)
	{
		setId(id);						// The string name of this relation class
		setNid(nid);					// The numeric id
		setLabel(id);					// The label of this relation
		setDiagram(dg);					// Backreference to diagram

		setStyle(Util.LINE_STYLE_NORMAL);

		addParentClass(prc);			// Parent class
		setObjectColor(Color.black);
	}

	// Is this the BASE CLASS relation or the contains relation

	public boolean excludeReln () 
	{
		String id = getId();

		return id.equals(Diagram.CONTAIN_ID) || id.equals(RelationClass.RELATION_BASE_CLASS_ID);
	}

	// If new, add an edge to the ERD (permitted relation)

	public void addRelation(EntityClass ec1, EntityClass ec2) {

		// Should check to see if relation is already present  
		EntityClassPair p = new EntityClassPair(ec1, ec2);
		if (m_relationList == null) {
			m_relationList = new Vector();
		}
		m_relationList.addElement(p);

	}

	// Return RelationInstance based on our RelationClass

	public RelationInstance newRelation(EntityInstance e1, EntityInstance e2) 
	{
		RelationInstance ri = new RelationInstance(this, e1, e2);
		makeInstanceOfUs(ri);
		return ri;
	}

	public void writeRelations(PrintStream ps) throws IOException 
	{
		Enumeration en;
		EntityClassPair ep;

		for (en = m_relationList.elements(); en.hasMoreElements(); ) {
			ep = (EntityClassPair) en.nextElement();
			ps.print(qt(getId()) + " " + qt(ep.entityClass1.getId()) + " " + qt(ep.entityClass2.getId()) + "\n");
		}
	}

	public void getRelationsRaw(Vector v, Hashtable st) 
	{
		Enumeration en;
		EntityClassPair ep;

		for (en = m_relationList.elements(); en.hasMoreElements();) {
			ep = (EntityClassPair) en.nextElement();
			Integer[] tup = new Integer[3];
			tup[0] = (Integer) st.get(getId());
			tup[1] = (Integer) st.get(ep.entityClass1.getId());
			tup[2] = (Integer) st.get(ep.entityClass2.getId());

			v.addElement(tup);	  
		}
	}

	public void writeAttributes(PrintStream ps) throws IOException 
	{

		if (getNid() >= 2) {
			ps.print("(" + qt(getId()) + ") {\n");
			super.writeAttributes(ps);
			ps.print("}\n\n");
		}
	}

	// Accessor functions

	public boolean isClassVisible() 
	{
		return m_visible;
	}

	public void setClassVisible(boolean state) 
	{
		m_visible = state; 
	}

	public boolean isActive() 
	{
		return m_active;
	}

	public void setActiveState(boolean state) 
	{
		m_active = state; 
	}

	public String addParentClass(RelationClass inherits) 
	{
		return addParentClass(inherits, RELATION_BASE_CLASS_ID);
	}

	public void setOrdinal(int ord) 
	{
		ordinal = ord;
	}

	public double getIOfactor() 
	{
		Attribute attr = getLsAttribute(FACTOR_ID);

		if (attr != null) {
			return Util.parseReal(attr.avi.value);
		}
		
		Diagram diagram = getDiagram();

		if (diagram.allowElision()) {
			double num = diagram.numVisibleRelationClasses();
			return (ordinal+1)/(num+1);
		}
		double num = diagram.numRelationClasses();
		return ((num > 2) ? (getNid()-1)/(num-1) : 0.5);
	}

	// The routines that follow hide the complexity of getting/setting attribute values
	// from EditAttributes

	public int getPrimaryAttributeCount()
	{
		return(6);
	}

	public String getLsAttributeNameAt(int index)
	{
		String	name;

		switch (index) {
		case 0:
			name  = "id";
			break;
		case 1:
			name  = CLASSLABEL_ID;
			break;
		case 2:
			name  = CLASSDESC_ID;
			break;
		case 3:
			name  = CLASSSTYLE_ID;
			break;	
		case 4:
			name  = COLOUR_ID;
			break;
		case 5:
			name  = LABEL_COLOUR_ID;
			break;
		default:
			name  = super.getLsAttributeNameAt(index);
		}
		return(name);
	}

	public Object getLsAttributeValueAt(int index)
	{
		Object	value;

		switch (index) {
		case 0:
			value = getId();
			break;
		case 1:
			value = getLabel();
			break;
		case 2:
			value = getDescription();
			break;
		case 3:
			value = new Integer(getStyle());
			break;
		case 4:
			value = getObjectColor();
			break;
		case 5:
			value = getLabelColor();
			break;
		default:
			value = super.getLsAttributeValueAt(index);
		}
		return(value);
	}

	public void setAttributeValueAt(int index, Object value)
	{
		switch (index) {
		case 0:
			setId((String) value);
			break;
		case 1:
			setLabel((String) value);
			break;
		case 2:
			setDescription((String) value);
			break;
		case 3:
			setStyle(((Integer) value).intValue());
			break;
		case 4:
			setObjectColor((Color) value);
			break;
		case 5:
			setLabelColor((Color) value);
			break;
		default:
			super.setAttributeValueAt(index, value);
	}	}

	// Need to know the type in cases where value might be null
	// For example with some colors

	public int getLsAttributeTypeAt(int index)
	{
		int		ret;
		
		switch (index) {
		case 0:
		case 1:
			ret = Attribute.STRING_TYPE;
			break;
		case 2:
			ret = Attribute.TEXT_TYPE;
			break;
		case 3:
			ret = Attribute.REL_STYLE_TYPE;
			break;
		case 4:
		case 5:
			ret = Attribute.COLOR_TYPE;
			break;
		default:
			ret = super.getLsAttributeTypeAt(index);
		}
		return(ret);
	}
}

