package lsedit;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

// Used by query and legend box

class RelnChkBox extends JComponent
{
	protected static final int GAP    = 5; 
	protected static final int WIDTH  = 45;
	protected static final int HEIGHT = 20;

	protected   JCheckBox			m_checkbox;
	protected	RelationClass		m_rc;
	protected	int					m_index;

	public RelnChkBox(RelationClass rc, int index, boolean value) 
	{
		FlowLayout	flowLayout;
		Color		color;
		JCheckBox	checkbox;
		Arrow		arrow;
		JLabel		label;

		flowLayout = new FlowLayout(FlowLayout.LEFT);
		flowLayout.setHgap(GAP);
		setLayout(new FlowLayout(FlowLayout.LEFT));

		m_rc    = rc;
		m_index = index;

		color       = rc.getObjectColor();

		m_checkbox = checkbox = new JCheckBox();
//		checkbox.setBackground(Color.WHITE);
		checkbox.setBorderPaintedFlat(false);
		checkbox.setSelected(value);
		checkbox.setEnabled(true);
		checkbox.setVisible(true);
		add(checkbox);

		arrow = new Arrow(WIDTH, HEIGHT);
		arrow.setBackground(color);
		add(arrow);

		label = new JLabel(rc.getLabel() + " (" + index + ")");
		label.setForeground(color);
		add(label);

		setToolTipText(rc.getDescription());
	}

	public void addItemListener(ItemListener listener)
	{
		m_checkbox.addItemListener(listener);
	}

	public boolean isSelected()
	{
		return(m_checkbox.isSelected());
	}

	public void doClick()
	{
		m_checkbox.doClick();
	}

	public int getIndex()
	{
		return(m_index);
	}
}
