package lsedit;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;

public class TextBox extends JTextArea
{
	protected static final Color titleColor = Color.red.darker();

	protected static final Font m_titleFont = new Font("Helvetica", Font.BOLD, 14);
	protected static final Font m_textFont =	new Font("Helvetica", Font.PLAIN, 11); 

	protected LandscapeViewerCore m_ls;
	protected JScrollPane		  m_scroller;	// null if not under any JScrollPane
	protected String			  m_helpString;

	// --------------
	// Public methods 
	// --------------

	public TextBox(LandscapeViewerCore ls, JScrollPane scroller, String helpString) 
	{
		m_ls          = ls;
		m_scroller    = scroller;

		scroller.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED); 
		scroller.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED); 

		m_helpString  = helpString;
		setToolTipText(helpString);

		setBackground(Diagram.boxColour);
		setFont(m_textFont);
		setEditable(false);
//		setSize(5, 5);
		setLineWrap(true);


		if (scroller != null) {
			scroller.setViewportView(this);
	}	}

	public void set(String text) 
	{
		setText(text); 
		repaint();
	}
}





