package lsedit;

import java.lang.Runtime;

public class Version {
	public final static int MAJOR = 7;
	public final static int MINOR = 0;
	public final static int BUILD = 14;
	public final static String COMPILED = "April 6th, 2004";

	public static String Number()
	{
			return(MAJOR + "." + MINOR + "." + BUILD);
	}

	public static String CompileDate()
	{
			return("Compiled: " + COMPILED);
	}

	private static String Detail(String property)
	{
			String result;

			try {
					result = System.getProperty(property);
			} catch (Exception e) {
					result = "";
			};
			return(result);
	}

	public static String Details(Diagram diagram)
	{
			String  result;
			Runtime	r
			;
			// System.getProperties().list(System.out);

			result	= Version.Number() + "\n\n";


			try		{ //set if possible
					result += Version.CompileDate() + "\n";
					result += "Original Author: Gary Farmaner\n";
					result += "Developed at the University of Waterloo under the supervision of Prof. Ric Holt\n";
					result += "Version 6.0 corrections and improvements by Ian Davis \n";
					result += "LSEDIT is part of the Software Landscape tool suite\n\n";
					result += " licensed to CTBTO by Telepresence Systems, Inc. (www.telepres.com)\n";
					result += " under contact No. 01/2/20/163\n\n";
					result += "Run Time Engine: " + Detail("java.vendor") + " " + Detail("java.version") + "\n";
					result += "Virtual Machine: " + Detail("java.vm.name") + " " + Detail("java.vm.version") + "\n";
					result += "V/M Vendor: " + Detail("java.vm.vendor") + "\n"; 
					result += "Operating System: " + Detail("os.name") + " " + Detail("os.arch") + " " + Detail("os.version") + "\n";
					result += "Patch level: " + Detail("sun.os.patch.level") + "\n";
					result += "User id: " + Detail("user.name") + "\n";
					result += "Directory: " + Detail("user.dir") + "\n";

					r       = Runtime.getRuntime();
					result += "Memory: " + r.totalMemory() + " - Free: " + r.freeMemory() + " = " + (r.totalMemory() - r.freeMemory()) + " Max: " + r.maxMemory() + "\n";
					r.gc();
					result += "Memory: " + r.totalMemory() + " - Free: " + r.freeMemory() + " = " + (r.totalMemory() - r.freeMemory()) + " Max: " + r.maxMemory() + "\n";
					if (diagram != null) {
						result += "Entities: " + diagram.getNumberEntitiesLoaded() + " Relations: " + diagram.getNumberRelationsLoaded() + "\n";
//						result += "Sizes: " + sizeOf(EntityInstance) + "+" + sizeOf(EntityComponent) + " " + sizeOf(RelationInstance) + "+" + sizeOf(RelationComponent) + "\n";
					}

			} catch (Exception e) {}

			return(result);
	}
}

/* History:
   6.0.0 -- Changes by Ian Davis

   April 4th (All day) 9:30-10pm
   
   Placed all source in package lsedit.
   Fixed minor compile problems under latest version of sun.
   Added code to close window when x pressed in Top Right hand corner.
   Enhanced the version information.
   Changed file prompt to prompt using java.awt.FileDialog
   Made right tabbed box go away completely when turned off
   Activated appropriate right tab so will display properly when turned back on

   April 5th		   10:30-4pm
   Removed some debug output
   Made animation optional to improve refresh rate.
   By default now in options menu "Show animations" is set to false.
   Changed cursor back to default after double click of mouse
   Removed some null pointer exceptions (rather by guessing desired behaviour)

   6.0.1 

   April 7th
   Corrected bug in drawing edges introduced in 6.0.0
   Worked towards understanding lsedit layout strategy
   Cleaned up code
   Traced layout problem to	  Diagram.setToViewport()
   Attempting to decipher what occurs beneath this.
   Quite bemused since right now nothing makes much sense.
   Concerns include:
	(1) rootInstance.getChildBoundingBoxLocal();
		  this only gets the bounding box of its own children, not its decendants.
		  Is there a presumption that children strictly contained within parent.
	(2) old formula for y scale was bizarre.
		  yScale = (height-width/16)/bb.height;	 [ changed to function purely of height]
	(3) don't understand dx and dy at all..	 Don't see how using only height and width one
		can correct positions of children.
	(4) translateChildrenLocal changes local values using dx and dy for both children and bends
		But bends not considered in computing what the bounding box was

   April 8th-10
   Released 6.0.1

   6.0.2

   Began exploring the refresh problem
   Tracked bug down to repaints() on both mouse down and mouse up pairs
   Have changed code to paint group flags in tight relationship to setting/clearing group flag
   Have delayed painting of group to be moved until move actually begins to avoid need to refresh
   Removed debug messages
   Released 6.0.2

   6.0.3

   April 14th

   Corrected the way in which point positions were cached.	There was a problem that simply rescaling
   the point positions when want to actually say discard the cache of point positions doesn't work
   because the x,y positions of the objects containing these points may not yet be right.

   6.0.4

   April 16th

   Added source file provided by eric.
   Rewrote Stringlinizer.  Potentially some problems now with <A ...> </A> tags.. No idea what was
   being attempted before here.	 Investigated types of object.	Investigated setting color of
   objects manually.

   April 17th

   Added ability to assign open color to entity.  "opencolor=value".
   Added dynamic color changes to object through P or menu.
   Hopefully all works when saved.

   6.0.5

   Corrected displaying of descriptions in Legend box
   Corrected minor error in drawing flags on box.. An outline is one pixel wider than a fill.
   Enhanced color chooser to allow for an alpha
   Fixed bug in forward edge tracing

   6.0.6

   Wednesday April 24th

   Changed how flags were cleared
   Removed key codes from popup menus
   Removed U/u/S/s from entity popup menu
   Removed U/u/S/s from toolbar
   Removed fit child to container
   Removed save landscape raw from File menu
   Removed print all to eps files
   Moved towards handling resize of objects correctly
   Cleaned up forward/back reporting on result tab logic
   Improved/rewrote again stringLiner
   Corrected infinite loop in util

   6.0.7

   Wednesday April 25th 2002

   Added feedback message to description box when over feedback box, so can read entire error message.
   Refresh entire drawing if selecting a box clears highlighting anywhere
   Renamed edit button to menu button
   Removed duplication of this button
   Added code to remove menu popup on mouse down if no mouse up seen.	This is purely preventative code
   for a bug not well understood.

  6.0.8

  Thursday April 26th. 2002

  Fixed problems with Forward/Back refs..

  6.0.9

  Friday April 27th, 2002

  Removed minMax button on applet
  Changed client/suppliers so will compress rather than not draw if can't reduce while still being too wide

  6.0.10

  Added short cut keys back into menus and toolbar buttons u/s etc.

  6.0.11

  Added ability to change color of classes and relations from Legendbox
  Added ability to query things in the legend box
  Added popup menus

  6.0.12

  Changed to 4 character tabs in source code -- no release

  6.0.13

  Added CorrectBadLayout to handle irregularities in input TA file
  Huge amount of cleanup
  Completely rewrote how attributes were edited, etc

  6.0.14

  Allowed class style changes to impact on diagram
  Fixed bug in StringLinizer

  6.0.15

  Added ability to change class an entity belongs to through editing attributes
  Changed creation of new entity to use EditAttribute logic (simplifies code to maintain)

  6.0.16

  Very unclear whether this version was ever released. Work stopped so that a co-op
  student could implement 6.0.17. and 6.0.16 was where it stopped.  However, co-op
  student never did take on programming task.

  6.0.17

  Fix depth limit problems.  Converted code from using absolute external coordinate
  system to relative to parent coordinate system.  Huge rewrite of all graph drawing
  software. (Also reworked lslayout and lsadjust).

  6.0.18

  Minor cleanup.. stopped allowing drag of boxes into $ROOT box.
  Corrected problems saving and restoring raw dumps.

  6.0.19

  Changed RelationInstance.findNearestSeg to work with doubles instead of ints and
  to check for threshold^2 > dist^2 thus avoiding expensive sqrt operation.  N.B.
  Since working in pixels threshold^2 > dist^2 iff threshold > dist.

  Fixed:  PR 5. When attempting to highlight an arrow after a forward or back trace, 
  non-visible arrows may be selected that are in the same region.  Select a node,
  do a forward or back trace.  Try to select a visible arrow that overlaps with a 
  non-visible arrow (at their intersection), both arrows will be selected.

  Fixed:  PR 7. When doing an "same size" (or width/height), the entity will not 
  fully resize if the new size brings part of it outside the window.  Suggest maybe a 
  better course of action would be to do the full resize, then relocate the entity so 
  that it is entirely inside the window. To-repeat: Place an entity at the right edge 
  of the window.  Select it, then select a wider entity.  Click Arrange, then "Same width".

  (New rules: if width > 1 width = 1; if (width+x>1) x= 1-width; ) etc. 

  6.0.19a

  Fixed correction of PR5 fix.

  6.0.20

  Changed to not emit default values of attributes

  7.0.1

  Absolutely huge rewrite.. to work under swing..
  This is essentially an entirely new product..
  Key enhancements are -- interrupt handling quite different (interrupts now come in at listeners)
  Drawing of relations quite different  (Objects created to do the actual drawing)
  Management of draw src/dst quite different (The draw src/dst always indicates where an edge is drawn from/to)
  Management of heirachy -- this is now done using pre/post order numbers
  Integer arithmetic used rather than doubles everywhere.
  Scroll panes added all over the place
  TOC box redone as a tree..
  All keystrokes tied to menu accelerators and accessible from menus.
  The list goes on and on
  
  7.0.2
  
  Changed tokenizer to reuse strings to save memory

  7.0.3

  Fixed moving of edge cardinals in sync with box.

  7.0.4

  Fixed moving edge cardinals better :-)
  Fixed problems with TOC not first requested then requested
  Made Cntl-V immediate

  7.0.5

  Changed to use layout manager

  7.0.6

  Moved TOC into tab box, fixed minor bugs

  7.0.7

  Do is no longer a subclass of JPanel and this ripples up.
  LandscapeViewerCore adds to the originial contentPane() instead of being a replacement content pane... this fixes problems
  Changed lsedit to use split pane three ways..
  Changed -G to be <percent>x<percent> indicating fraction of layout to be occupied by diagram.  0 = none.. 100 = all.

  7.0.8

  Fixed bug when dragging into new box loosing edges (need call to prepostorder)
  Fixed bug with 0-9 not actually changing the diagram (changed to use doClick() so simulates precisely the action of a real click)
  Changed query box numbers to match legend box numbers

  7.0.9

  Rewrote printing from the ground up.

  7.0.10

  Cleaned up tab box images so don't scroll
  Fixed performance problem.(zero sized boxes are considered closed)
  Made TOC align with editorial changes to the main diagram
  Added back in notion of TOC visible or not loaded
  Allow cutting and pasting in TOC

  7.0.11

  Reworked LandscapeEditorFrame so could be invoked from arbitrary java code
  Reworked LandscapeEditorFrame so that could run either LandscapeEditorCore or LandscapeViewerCore
  Removed  LandscapeEditorApp
  Moved all TA read/write code into ta.java

  7.0.12

  Change Landscape objects so have JComponent rather than are a JComponent
  Reduced memory requirements for edges substantially
  Allowed editing of relations and relation classes
  Removed BaseEntity
  Added   EntityComponent/RelationComponent

  7.0.13

  Made avgX a constant inside a sort -- not recomputed for each compare
  Fixed a slew of bugs

  7.0.14

  Change Legend to handle hiding of entities
  

*/
