/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import lsedit.LandscapeViewerCore;
import lsedit.Util;

public class ArrowDimensions
extends JDialog
implements ActionListener {
    static double m_old_length;
    static double m_old_arc;
    static int m_old_width;
    static double m_new_length;
    static double m_new_arc;
    static int m_new_width;
    JTextField m_length;
    JTextField m_arc;
    JTextField m_width;
    JButton m_ok;
    JButton m_cancel;
    JButton m_default;
    JLabel m_message;

    protected ArrowDimensions(LandscapeViewerCore ls) {
        super(ls.getFrame(), "Modify arrow settings", true);
        m_old_width = Util.LINE_W;
        m_old_length = Util.ARROW_L;
        m_old_arc = Util.ARROW_TH;
        m_new_width = Util.LINE_W;
        m_new_length = Util.ARROW_L;
        m_new_arc = Util.ARROW_TH;
        this.setSize(438, 369);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(null);
        this.setForeground(new Color(0, 0, 0));
        this.setBackground(new Color(192, 192, 192));
        this.setFont(new Font("Dialog", 0, 12));
        JLabel label = new JLabel("Width of edge:");
        label.setBounds(40, 20, 200, 30);
        contentPane.add(label);
        label.setVisible(true);
        this.m_width = new JTextField("" + m_old_width, 100);
        this.m_width.setBounds(240, 20, 75, 30);
        contentPane.add(this.m_width);
        this.m_width.setVisible(true);
        label = new JLabel("pixels");
        label.setBounds(320, 20, 50, 30);
        contentPane.add(label);
        label.setVisible(true);
        label = new JLabel("Length of arrow edge:");
        label.setBounds(40, 80, 200, 30);
        contentPane.add(label);
        label.setVisible(true);
        this.m_length = new JTextField("" + m_old_length, 100);
        this.m_length.setBounds(240, 80, 75, 30);
        contentPane.add(this.m_length);
        this.m_length.setVisible(true);
        label = new JLabel("pixels");
        label.setBounds(320, 80, 50, 30);
        contentPane.add(label);
        label.setVisible(true);
        label = new JLabel("Arc between edge and arrow edge:");
        label.setBounds(40, 140, 200, 30);
        contentPane.add(label);
        label.setVisible(true);
        this.m_arc = new JTextField("" + m_old_arc, 30);
        this.m_arc.setBounds(240, 140, 75, 30);
        contentPane.add(this.m_arc);
        label = new JLabel("radians");
        label.setBounds(320, 140, 50, 30);
        contentPane.add(label);
        label.setVisible(true);
        this.m_ok = new JButton("Ok");
        this.m_ok.setBounds(40, 210, 50, 30);
        contentPane.add(this.m_ok);
        this.m_ok.addActionListener(this);
        this.m_default = new JButton("Default");
        this.m_default.setBounds(115, 210, 100, 30);
        contentPane.add(this.m_default);
        this.m_default.addActionListener(this);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setBounds(240, 210, 100, 30);
        contentPane.add(this.m_cancel);
        this.m_cancel.addActionListener(this);
        this.m_message = new JLabel("");
        this.m_message.setBounds(40, 260, 400, 30);
        contentPane.add(this.m_message);
        this.setVisible(true);
    }

    public static void create(LandscapeViewerCore ls) {
        new ArrowDimensions(ls);
        if (m_old_length != m_new_length || m_old_arc != m_new_arc || m_old_width != m_new_width) {
            Util.LINE_W = m_new_width;
            Util.ARROW_L = m_new_length;
            Util.ARROW_TH = m_new_arc;
            ls.repaint();
        }
    }

    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_default) {
            this.m_width.setText("1");
            this.m_length.setText("10.0");
            this.m_arc.setText("0.4");
            this.m_message.setText("Values set to initial default");
            return;
        }
        if (source != this.m_cancel && source != this.m_ok) {
            return;
        }
        if (source == this.m_ok) {
            double arc;
            double length;
            int width;
            String string = this.m_width.getText();
            try {
                width = Integer.parseInt(string);
                if (width < 0) {
                    this.m_message.setText("Width negative");
                    return;
                }
            }
            catch (Throwable exception) {
                this.m_message.setText("Width not an integer string value");
                return;
            }
            string = this.m_length.getText();
            try {
                length = Double.parseDouble(string);
                if (Double.isNaN(length)) {
                    this.m_message.setText("Length is not a double precision number");
                    return;
                }
            }
            catch (Throwable exception) {
                this.m_message.setText("Length is not a double precision string value");
                return;
            }
            if (length < 0.0) {
                this.m_message.setText("Length is negative");
                return;
            }
            string = this.m_arc.getText();
            try {
                arc = Double.parseDouble(string);
                if (Double.isNaN(arc)) {
                    this.m_message.setText("Arc is not a double precision number");
                    return;
                }
            }
            catch (Throwable exception) {
                this.m_message.setText("Arc is not a double precision string value");
                return;
            }
            if (arc < 0.0) {
                this.m_message.setText("Arc is negative");
                return;
            }
            if (arc > 1.5) {
                this.m_message.setText("The maximum allowed arc angle is 1.5 (very near pi/2)");
                return;
            }
            m_new_width = width;
            m_new_length = length;
            m_new_arc = arc;
        }
        this.setVisible(false);
        this.dispose();
    }
}

