/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import lsedit.AttributeValueItem;
import lsedit.LandscapeObject;
import lsedit.MsgOut;
import lsedit.Util;

public class Attribute {
    public static final Integer NULL = new Integer(0);
    public static final Integer INT = new Integer(1);
    public static final Integer DOUBLE = new Integer(2);
    public static final Integer STRING = new Integer(3);
    public static final Integer INT_LIST = new Integer(4);
    public static final Integer DOUBLE_LIST = new Integer(5);
    public static final Integer STRING_LIST = new Integer(6);
    public static final int NULL_TYPE = 0;
    public static final int INT_TYPE = 1;
    public static final int DOUBLE_TYPE = 2;
    public static final int STRING_TYPE = 3;
    public static final int INT_LIST_TYPE = 4;
    public static final int DOUBLE_LIST_TYPE = 5;
    public static final int STRING_LIST_TYPE = 6;
    public static final int COLOR_TYPE = 7;
    public static final int COLOR_OR_NULL_TYPE = 8;
    public static final int POINT_TYPE = 9;
    public static final int ELISION_TYPE = 10;
    public static final int AVI_TYPE = 11;
    public static final int TEXT_TYPE = 12;
    public static final int ENTITY_STYLE_TYPE = 13;
    public static final int REL_STYLE_TYPE = 14;
    public static final int ENTITY_CLASS_TYPE = 15;
    public static final int RELATION_CLASS_TYPE = 16;
    public static final String indent = " ";
    public String id;
    public AttributeValueItem avi;
    public boolean cloneOnAssign;
    public Attribute next;
    protected double cachedReal = Double.POSITIVE_INFINITY;
    protected Color cachedColor = null;

    public Attribute(String id, AttributeValueItem avi) {
        this.id = id;
        this.avi = avi;
    }

    public boolean hasId(String id) {
        return this.id.equals(id);
    }

    public String toString() {
        String ret = this.id;
        if (this.avi != null) {
            ret = ret + "=";
        }
        AttributeValueItem avi1 = this.avi;
        while (avi1 != null) {
            if (avi1 != this.avi) {
                ret = ret + ",";
            }
            ret = ret + avi1;
            avi1 = avi1.nextList;
        }
        return ret;
    }

    public Object clone() {
        AttributeValueItem av = this.avi == null ? null : (AttributeValueItem)this.avi.clone();
        return new Attribute(this.id, av);
    }

    public String parseString() {
        return this.avi.value;
    }

    public double parseReal() {
        if (this.avi.value == null) {
            return 0.0;
        }
        if (this.cachedReal == Double.POSITIVE_INFINITY) {
            this.cachedReal = Util.parseReal(this.avi.value);
        }
        return this.cachedReal;
    }

    public int parseInt() {
        if (this.avi.value == null) {
            return 0;
        }
        return Util.parseInt(this.avi.value);
    }

    public boolean parseBoolean() {
        if (this.avi.value == null) {
            return false;
        }
        return Util.parseBoolean(this.avi.value);
    }

    public Color parseColour() {
        if (this.cachedColor != null) {
            return this.cachedColor;
        }
        AttributeValueItem av = this.avi;
        if (av.value == null) {
            MsgOut.println("parseColor: missing values");
            return Color.black;
        }
        float r = new Float(av.value).floatValue();
        av = av.next;
        if (av == null) {
            MsgOut.println("parseColor: missing green and blue values");
            return Color.black;
        }
        float g = new Float(av.value).floatValue();
        av = av.next;
        if (av == null) {
            MsgOut.println("parseColor: missing blue value");
            return Color.black;
        }
        float b = new Float(av.value).floatValue();
        this.cachedColor = new Color(r, g, b);
        return this.cachedColor;
    }

    public Color parseColor() {
        return this.parseColour();
    }

    public void addToList(String value) {
        AttributeValueItem avi = new AttributeValueItem(value);
        avi.next = this.avi;
        this.avi = avi;
    }

    public void removeFromList(String value) {
        AttributeValueItem prev = null;
        AttributeValueItem avi = this.avi;
        while (avi != null) {
            if (avi.value.equals(value)) {
                if (prev != null) {
                    prev.next = avi.next;
                } else {
                    this.avi = avi.next;
                }
                return;
            }
            prev = avi;
            avi = avi.next;
        }
    }

    public void writeAttribute(PrintStream ps, LandscapeObject parentClass, boolean classType) throws IOException {
        if (this.avi == null) {
            if (classType) {
                ps.print(indent + this.id + "\n");
            }
        } else if (!(!classType && this.cloneOnAssign || parentClass != null && parentClass.defaultValue(this.id, this.avi))) {
            ps.print(indent + this.id + " = ");
            this.avi.writeAttribute(ps);
        }
    }
}

