/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.io.IOException;
import java.io.PrintStream;
import lsedit.AttributeRecord;
import lsedit.RealPoint;

public class AttributeValueItem {
    public String value;
    public AttributeRecord nestedAttributeRecord;
    public AttributeValueItem next;
    public AttributeValueItem nextList;
    protected static final String specialChars = " /,:\\\"(){}^<>";

    public static String qt(String str) {
        if (str.length() == 0) {
            return "\"\"";
        }
        for (int i = 0; i < specialChars.length(); ++i) {
            if (str.indexOf(specialChars.charAt(i)) < 0) continue;
            return "\"" + str + "\"";
        }
        return str;
    }

    protected void printList(PrintStream ps) throws IOException {
        AttributeValueItem avi = this;
        while (avi != null) {
            if (avi.next != null) {
                ps.print(AttributeValueItem.qt(avi.value) + " ");
            } else {
                ps.print(AttributeValueItem.qt(avi.value));
            }
            avi = avi.next;
        }
    }

    public AttributeValueItem(String value) {
        this.value = value;
    }

    public AttributeValueItem(AttributeRecord ar) {
        this.nestedAttributeRecord = ar;
    }

    public Object clone() {
        AttributeValueItem av = this.nestedAttributeRecord != null ? new AttributeValueItem((AttributeRecord)this.nestedAttributeRecord.clone()) : new AttributeValueItem(this.value);
        if (this.next != null) {
            av.next = (AttributeValueItem)this.next.clone();
        }
        if (this.nextList != null) {
            av.nextList = (AttributeValueItem)this.nextList.clone();
        }
        return av;
    }

    public String toString() {
        String ret = this.next != null ? "(" : "";
        AttributeValueItem avi = this;
        while (avi != null) {
            if (avi != this) {
                ret = ret + " ";
            }
            ret = ret + AttributeValueItem.qt(avi.value);
            avi = avi.next;
        }
        if (this.next != null) {
            ret = ret + ")";
        }
        return ret;
    }

    public void writeAttribute(PrintStream ps) throws IOException {
        if (this.next != null) {
            ps.print("(");
            this.printList(ps);
            ps.print(")\n");
        } else if (this.nestedAttributeRecord != null) {
            ps.print("{\n");
            ps.print("}\n");
        } else {
            ps.print(AttributeValueItem.qt(this.value) + "\n");
        }
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof AttributeValueItem && this.nestedAttributeRecord == null && ((AttributeValueItem)other).nestedAttributeRecord == null && this.value != null && this.value.equals(((AttributeValueItem)other).value)) {
            if (this.next != null) {
                return this.next.equals(((AttributeValueItem)other).next);
            }
            if (((AttributeValueItem)other).next == null) {
                return true;
            }
        }
        return false;
    }

    public RealPoint parsePoint() {
        if (this.value == null || this.next == null || this.next.value == null) {
            return new RealPoint(0.0, 0.0);
        }
        double v1 = new Double(this.value);
        double v2 = new Double(this.next.value);
        return new RealPoint(v1, v2);
    }
}

