/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Dimension;
import javax.swing.JLabel;
import lsedit.ClientSupplierSet;
import lsedit.Diagram;
import lsedit.DiagramCoordinates;
import lsedit.EntityInstance;

public class ClientSet
extends ClientSupplierSet
implements DiagramCoordinates {
    protected void addSet() {
        super.addSet();
        if (this.m_fullSize != 0 && this.m_displayedSize == 0) {
            if (this.m_label == null) {
                this.m_label = new JLabel();
                this.m_label.setFont(EntityInstance.getSmallFont());
            }
            this.m_label.setText("All clients are also suppliers");
            this.m_label.setHorizontalAlignment(0);
            int w = this.getWidth();
            int h = this.getHeight();
            this.m_label.setBounds(0, 0, w, h);
            this.add(this.m_label);
        }
    }

    public void validate() {
        super.validate();
        if (this.m_label != null) {
            Dimension dim = this.m_label.getPreferredSize();
            this.m_label.setBounds((this.getWidth() - dim.width) / 2, (this.getHeight() - dim.height) / 2, dim.width, dim.height);
        }
    }

    public ClientSet(Diagram diagram) {
        super(diagram);
        this.setToolTipText("Clients are things outside the diagram that have edges into the diagram");
    }

    public void findClients(EntityInstance root, EntityInstance drawRoot) {
        this.m_drawRoot = drawRoot;
        root.addClients(this.m_set, drawRoot, this.m_ls.isVisibleEdges());
        this.m_fullSize = this.m_set.size();
        this.setToolTipText(this.m_fullSize + " clients");
    }

    public int getDiagramX() {
        return super.getDiagramX();
    }

    public int getDiagramY() {
        return super.getDiagramY();
    }
}

