/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lsedit.ClientSet;
import lsedit.Diagram;
import lsedit.DiagramCoordinates;
import lsedit.EntityInstance;
import lsedit.LandscapeViewerCore;
import lsedit.SortVector;
import lsedit.SupplierSet;

public abstract class ClientSupplierSet
extends JPanel
implements DiagramCoordinates {
    public static final int CLIENT_SUPPLIER_HEIGHT = 50;
    public static final int GAP = 5;
    protected LandscapeViewerCore m_ls;
    protected Diagram m_diagram;
    protected JLabel m_label = null;
    protected EntityInstance m_drawRoot;
    protected Vector m_set;
    protected int m_fullSize;
    protected int m_displayedSize;

    protected int calcWidth(Graphics g) {
        int tw = 0;
        Enumeration en = this.m_set.elements();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            Dimension dim = e.getFitDim(g, 0, true);
            tw += dim.width;
        }
        return tw;
    }

    protected EntityInstance mostFrequentParent() {
        Vector<EntityInstance> p = new Vector<EntityInstance>();
        int[] cnt = new int[this.m_set.size()];
        Enumeration en = this.m_set.elements();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            EntityInstance pe = e.getEnterableParent();
            if (pe.hasDescendantOrSelf(this.m_drawRoot)) continue;
            int ind = p.indexOf(pe);
            if (ind < 0) {
                cnt[p.size()] = 1;
                p.addElement(pe);
                continue;
            }
            int n = ind;
            cnt[n] = cnt[n] + 1;
        }
        int mVal = 0;
        int mInd = -1;
        for (int i = 0; i < p.size(); ++i) {
            if (cnt[i] <= mVal) continue;
            mVal = cnt[i];
            mInd = i;
        }
        if (mInd < 0) {
            return null;
        }
        return (EntityInstance)p.elementAt(mInd);
    }

    protected boolean elimDescendents(EntityInstance pe) {
        Vector v = this.m_set;
        boolean ret = false;
        int i = v.size();
        while (i > 0) {
            EntityInstance ei;
            if (!pe.hasDescendantOrSelf(ei = (EntityInstance)v.elementAt(--i))) continue;
            ei.nandMark(6);
            v.remove(i);
            ret = true;
        }
        return ret;
    }

    protected void sort() {
        if (this.m_set.size() > 1) {
            SortVector.byAvgX(this.m_set, true);
        }
    }

    protected void addSet() {
        int components = this.m_set.size();
        if (components != 0) {
            int gaps = (components + 1) * 5;
            int w = this.getWidth();
            int width = w - gaps;
            Graphics g = this.m_ls.getGraphics();
            int tw = this.calcWidth(g);
            double scale = (double)width / (double)tw;
            double xpos = 5.0;
            if (scale > 2.0) {
                scale = 2.0;
                xpos += (double)(width - tw * 2) / 2.0;
            }
            int diagramX = this.getX();
            int diagramY = this.getY();
            int height = this.getHeight();
            Enumeration en = this.m_set.elements();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                e.removeAll();
                Dimension dim = e.getFitDim(g, 0, true);
                double width2 = scale * (double)dim.width;
                int width1 = (int)width2;
                e.setBothBounds(diagramX, diagramY, (int)xpos, 0, width1, height);
                e.setVisible(true);
                xpos += width2 + 5.0;
                e.addUnder(this);
            }
        }
    }

    public ClientSupplierSet(Diagram diagram) {
        this.setLayout(null);
        this.m_diagram = diagram;
        this.m_ls = diagram.getLs();
        this.m_set = new Vector();
    }

    public Vector getFullSet() {
        return this.m_set;
    }

    public int getFullSetSize() {
        return this.m_fullSize;
    }

    public int getDisplaySetSize() {
        return this.m_displayedSize;
    }

    public void removeAll() {
        super.removeAll();
        this.m_set.removeAllElements();
        this.m_fullSize = 0;
        this.m_displayedSize = 0;
    }

    public static void compact(ClientSet clientSet, SupplierSet supplierSet) {
        block18: {
            EntityInstance e;
            EntityInstance pe;
            Vector clients = clientSet.getFullSet();
            Vector suppliers = supplierSet.getFullSet();
            int i = clients.size();
            while (i > 0) {
                for (pe = e = (EntityInstance)clients.elementAt(--i); pe != null; pe = pe.getContainedBy()) {
                    if (!pe.isMarked(4)) continue;
                    e.nandMark(2);
                    pe.orMark(2);
                    clients.remove(i);
                }
            }
            boolean seen = false;
            i = suppliers.size();
            while (i > 0) {
                e = (EntityInstance)suppliers.elementAt(--i);
                for (pe = e.getContainedBy(); pe != null; pe = pe.getContainedBy()) {
                    if (!pe.isMarked(2)) continue;
                    e.nandMark(4);
                    pe.orMark(4);
                    suppliers.remove(i);
                    seen = true;
                }
            }
            if (seen) {
                i = clients.size();
                while (i > 0) {
                    if (!(e = (EntityInstance)clients.elementAt(--i)).isMarked(4)) continue;
                    clients.remove(i);
                    suppliers.addElement(e);
                }
            }
            if (!clientSet.m_ls.isUseCompaction()) {
                return;
            }
            int cwidth = clientSet.getWidth();
            int swidth = supplierSet.getWidth();
            if (cwidth <= 0 && swidth <= 0) break block18;
            Graphics g = clientSet.m_ls.getGraphics();
            int clientWidth = -1;
            int supplierWidth = -1;
            do {
                seen = false;
                if (cwidth > 0) {
                    if (clientWidth < 0) {
                        clientWidth = clientSet.calcWidth(g) + 5 * (clients.size() + 1);
                    }
                    if (clientWidth > cwidth) {
                        pe = clientSet.mostFrequentParent();
                        if (pe == null) {
                            clientWidth = cwidth;
                        } else {
                            seen = true;
                            clientSet.elimDescendents(pe);
                            pe.orMark(2);
                            if (supplierSet.elimDescendents(pe)) {
                                pe.orMark(4);
                                suppliers.addElement(pe);
                                supplierWidth = -1;
                            } else {
                                clients.addElement(pe);
                            }
                            clientWidth = -1;
                        }
                    }
                }
                if (swidth <= 0) continue;
                if (supplierWidth < 0) {
                    supplierWidth = supplierSet.calcWidth(g) + 5 * (suppliers.size() + 1);
                }
                if (supplierWidth <= swidth) continue;
                pe = supplierSet.mostFrequentParent();
                if (pe == null) {
                    supplierWidth = swidth;
                    continue;
                }
                seen = true;
                supplierSet.elimDescendents(pe);
                pe.orMark(4);
                if (clientSet.elimDescendents(pe)) {
                    pe.orMark(2);
                    clientWidth = -1;
                }
                suppliers.addElement(pe);
                supplierWidth = -1;
            } while (seen);
        }
    }

    public void order() {
        this.m_displayedSize = this.m_set.size();
        this.sort();
        this.addSet();
    }

    public int getDiagramX() {
        return this.getX();
    }

    public int getDiagramY() {
        return this.getY();
    }
}

