/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class ColorChooser
extends JDialog
implements ActionListener {
    private static JColorChooser m_tcc = null;
    private JSlider m_slider = null;
    private JButton m_okButton;
    private JButton m_canButton;
    private JButton m_nullButton;
    private Color m_color;
    int alpha;

    private ColorChooser(JFrame frame, String title, Color oldColor, boolean include_alpha, boolean allow_null) {
        super(frame, title, true);
        this.m_color = oldColor;
        Container contentPane = this.getContentPane();
        if (m_tcc == null) {
            m_tcc = new JColorChooser();
            m_tcc.setDragEnabled(true);
        }
        m_tcc.setColor(oldColor == null ? Color.gray : oldColor);
        contentPane.add("North", m_tcc);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1, 15, 15));
        if (include_alpha) {
            JPanel p1 = new JPanel();
            this.m_slider = new JSlider(1, 255, 255);
            this.m_slider.setMajorTickSpacing(50);
            this.m_slider.setPaintLabels(true);
            this.m_slider.setPaintTicks(true);
            this.alpha = oldColor == null ? 255 : oldColor.getAlpha();
            this.m_slider.setValue(this.alpha);
            p1.add("Top", this.m_slider);
            p1.add("Bottom", new JLabel("Alpha", 0));
            contentPane.add("Center", p1);
        }
        this.m_okButton = new JButton("OK");
        this.m_okButton.addActionListener(this);
        p.add(this.m_okButton);
        if (!allow_null) {
            this.m_nullButton = null;
        } else {
            this.m_nullButton = new JButton("Null");
            this.m_nullButton.addActionListener(this);
            p.add(this.m_nullButton);
        }
        this.m_canButton = new JButton("Cancel");
        this.m_canButton.addActionListener(this);
        p.add(this.m_canButton);
        contentPane.add("South", p);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source != this.m_canButton) {
            if (source == this.m_okButton) {
                int alpha;
                this.m_color = m_tcc.getColor();
                if (this.m_slider != null && (alpha = this.m_slider.getValue()) != 255) {
                    this.m_color = new Color(this.m_color.getRed(), this.m_color.getGreen(), this.m_color.getBlue(), alpha);
                }
            } else if (source != null && source == this.m_nullButton) {
                this.m_color = null;
            } else {
                return;
            }
        }
        this.setVisible(false);
    }

    public Color getColor() {
        return this.m_color;
    }

    public static Color create(JFrame frame, String title, Color oldColor, boolean include_alpha, boolean allow_null) {
        ColorChooser mb = new ColorChooser(frame, title, oldColor, include_alpha, allow_null);
        mb.setLocation(20, 20);
        mb.setVisible(true);
        Color color = mb.getColor();
        mb.dispose();
        return color;
    }
}

