/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.EntityInstance;
import lsedit.RelationClass;
import lsedit.RelationInstance;

public class DagGridLayout {
    int numLevels = 0;
    int maxBreadth = 0;
    EntityInstance[][] grid = new EntityInstance[100][100];

    protected boolean atLevel(EntityInstance e, Vector grp, int ln, RelationClass rc) {
        boolean noPar = true;
        boolean hasEdge = false;
        Enumeration en = e.srcRelationElements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            if (ri.getRelationClass() != rc) continue;
            EntityInstance dst = ri.getDst();
            hasEdge = true;
            noPar = noPar && !grp.contains(dst);
        }
        return hasEdge && noPar;
    }

    protected Vector findLevel(Vector grp, int ln, RelationClass rc) {
        Vector<EntityInstance> lvl = new Vector<EntityInstance>();
        Enumeration en = grp.elements();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            if (!this.atLevel(e, grp, ln, rc)) continue;
            lvl.addElement(e);
        }
        return lvl;
    }

    public DagGridLayout(Vector ogrp, RelationClass rc) {
        Vector grp = new Vector();
        for (int i = 0; i < ogrp.size(); ++i) {
            grp.addElement(ogrp.elementAt(i));
        }
        while (grp.size() > 0) {
            Vector v = this.findLevel(grp, this.numLevels, rc);
            int sz = v.size();
            if (sz == 0) {
                this.numLevels = 0;
                return;
            }
            if (sz > this.maxBreadth) {
                this.maxBreadth = sz;
            }
            for (int i = 0; i < sz; ++i) {
                EntityInstance te;
                this.grid[this.numLevels][i] = te = (EntityInstance)v.elementAt(i);
                grp.removeElement(te);
            }
            ++this.numLevels;
        }
    }

    public int numLevels() {
        return this.numLevels;
    }

    public int maxBreadth() {
        return this.maxBreadth;
    }

    public EntityInstance getGrid(int level, int pos) {
        return this.grid[level][pos];
    }
}

