/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Cardinal;
import lsedit.ClientSet;
import lsedit.ClientSupplierSet;
import lsedit.DiagramCoordinates;
import lsedit.EditAttribute;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;
import lsedit.LandscapeObject;
import lsedit.LandscapeViewerCore;
import lsedit.MapBox;
import lsedit.MsgOut;
import lsedit.MyUndoableEdit;
import lsedit.RelationClass;
import lsedit.RelationComponent;
import lsedit.RelationInstance;
import lsedit.SupplierSet;
import lsedit.UndoableTa;

public class Diagram
extends UndoableTa
implements MouseMotionListener,
UndoableEditListener,
DiagramCoordinates {
    public static final float BG = 0.75f;
    public static final Color boxColour = Color.lightGray;
    protected static final int GAP = 5;
    protected static final int MARGIN = 10;
    protected double m_zoom_x = 1.0;
    protected double m_zoom_y = 1.0;
    protected EntityInstance m_drawRoot;
    protected Container m_edges = null;
    protected Container m_cardinals = null;
    protected int numVisibleRelationClasses = 0;
    protected boolean persistentQuery = false;
    protected boolean m_loaded = false;
    protected int mode;
    protected int gridPixels = 1;
    protected int m_preserve_entity_marks = 0;
    protected int m_preserve_relation_marks = 0;
    protected Attribute relVisibilityAttr;
    protected boolean m_visibleEdges = true;
    protected boolean m_drawEdges = true;
    protected boolean m_drawBends = false;
    protected int newCnt = 0;
    protected boolean undoValid = false;
    protected int timeStamp = 0;
    protected EntityInstance m_keyEntity;
    protected ExitFlag m_exitFlag;
    protected SupplierSet m_supplierSet;
    protected ClientSet m_clientSet;
    protected Vector m_suppliers;
    protected Vector m_dClients;
    protected Vector m_dSuppliers;
    protected boolean m_suppliersSorted = false;
    protected boolean allClients = true;
    protected boolean allSuppliers = true;
    protected boolean m_modeHandlingActive = false;
    protected LandscapeModeHandler m_modeHandler;

    protected Diagram getDiagram() {
        return this;
    }

    protected void findClientsAndSuppliers() {
        boolean showClients;
        boolean showSuppliers;
        EntityInstance drawRoot = this.m_drawRoot;
        if (drawRoot == this.m_rootInstance) {
            showSuppliers = false;
            showClients = false;
        } else {
            showSuppliers = this.m_ls.isShowSuppliers();
            showClients = this.m_ls.isShowClients();
        }
        this.m_clientSet.removeAll();
        if (showClients) {
            this.m_clientSet.findClients(this.m_rootInstance, drawRoot);
        }
        this.m_supplierSet.removeAll();
        if (showSuppliers) {
            this.m_supplierSet.findSuppliers(this.m_rootInstance, drawRoot);
        }
    }

    protected void setVisibilityFlags() {
        this.numVisibleRelationClasses = 0;
        Enumeration en = this.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (rc.excludeReln() || !rc.isClassVisible()) continue;
            rc.setOrdinal(this.numVisibleRelationClasses++);
        }
        this.m_visibleEdges = this.numVisibleRelationClasses > 0;
    }

    public void cutEntity(EntityInstance e) {
        if (this.m_drawRoot == e || this.m_drawRoot.hasAncestor(e)) {
            this.navigateTo(e.getContainedBy());
        }
        e.getContainedBy().removeContainment(e);
        this.m_entityInstances.remove(e.getId());
    }

    public void pasteEntity(EntityInstance parent, EntityInstance e) {
        parent.addContainment(e);
        this.m_entityInstances.put(e.getId(), e);
    }

    public void prepostorder() {
        this.m_rootInstance.prepostorder(1);
    }

    public boolean contains(int x, int y) {
        return this.m_loaded && super.contains(x, y);
    }

    public void setPreserveEntityMarks(int value) {
        this.m_preserve_entity_marks = value;
    }

    public void setPreserveRelationMarks(int value) {
        this.m_preserve_relation_marks = value;
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
    }

    public void repaint() {
        super.repaint();
    }

    public Diagram(LandscapeViewerCore ls) {
        super(ls);
        this.setLayout(null);
        this.setLocation(0, 0);
        this.setDoubleBuffered(true);
    }

    public Component add(Component c) {
        if (c instanceof RelationComponent) {
            return this.m_edges.add(c);
        }
        if (c instanceof Cardinal) {
            return this.m_cardinals.add(c);
        }
        return super.add(c);
    }

    public void remove(Component c) {
        if (c instanceof RelationComponent) {
            this.m_edges.remove(c);
            return;
        }
        if (c instanceof Cardinal) {
            this.m_cardinals.remove(c);
            return;
        }
        super.remove(c);
    }

    public Diagram(LandscapeViewerCore ls, boolean makeBackup) {
        super(ls);
        this.setLayout(null);
        this.setLocation(0, 0);
        this.m_exitFlag = new ExitFlag(this);
        this.m_exitFlag.setLocation(3, 3);
        this.m_supplierSet = new SupplierSet(this);
        this.m_clientSet = new ClientSet(this);
        this.addMouseMotionListener(this);
        this.setPreserveEntityMarks(0);
        this.setPreserveRelationMarks(0);
        this.navigateTo(this.m_rootInstance);
    }

    public String loadDiagram(String taPath, Vector bgPaths, Object context) {
        boolean option;
        String ret = this.loadTA(taPath, bgPaths, context);
        Attribute attr = this.m_rootInstance.getLsAttribute("edgemode");
        if (attr.avi == null) {
            attr.avi = new AttributeValueItem(String.valueOf(2));
        }
        LandscapeObject.setEdgeMode(attr.parseInt());
        attr = this.m_rootInstance.getLsAttribute("topclients");
        if (attr.avi == null) {
            option = true;
            attr.avi = new AttributeValueItem(String.valueOf(option));
        } else {
            option = attr.parseBoolean();
        }
        this.m_ls.setTopClients(option);
        attr = this.m_rootInstance.getLsAttribute("wantclients");
        if (attr.avi == null) {
            option = true;
            attr.avi = new AttributeValueItem(String.valueOf(option));
        } else {
            option = attr.parseBoolean();
        }
        this.m_ls.setShowClients(option);
        attr = this.m_rootInstance.getLsAttribute("wantsuppliers");
        if (attr.avi == null) {
            option = true;
            attr.avi = new AttributeValueItem(String.valueOf(option));
        } else {
            option = attr.parseBoolean();
        }
        this.m_ls.setShowSuppliers(option);
        attr = this.m_rootInstance.getLsAttribute("wantcardinals");
        if (attr.avi == null) {
            option = false;
            attr.avi = new AttributeValueItem(String.valueOf(option));
        } else {
            option = attr.parseBoolean();
        }
        this.m_ls.setShowCardinals(option);
        this.relVisibilityAttr = attr = this.m_rootInstance.getLsAttribute("reln_hidden");
        AttributeValueItem avi = attr.avi;
        while (avi != null) {
            RelationClass rc = (RelationClass)this.m_relationClasses.get(avi.value);
            rc.setClassVisible(false);
            avi = avi.next;
        }
        this.setVisibilityFlags();
        return ret;
    }

    public boolean isUndoAvailable() {
        return this.undoValid;
    }

    public Graphics getContext(Graphics gc) {
        int vpwidth = this.getWidth() - 10;
        int vpheight = this.getHeight() - 10;
        return gc.create(this.getX() + 5, this.getY() + 5, vpwidth, vpheight);
    }

    public void rescaleDiagram() {
        this.m_drawRoot.rescaleChildren();
    }

    public void rescaleDiagram(int x, int y, int width, int height) {
        this.m_drawRoot.setBothBounds(0, 0, x, y, width, height);
    }

    public void deleteEdge(RelationInstance ri) {
        ri.getSrc().removeSrcRelation(ri);
        ri.getDst().removeDstRelation(ri);
    }

    public EntityInstance intersects(Rectangle lyt) {
        return this.m_drawRoot.intersects(lyt);
    }

    public EntityInstance containing(Rectangle lyt) {
        return this.m_drawRoot.containing(lyt);
    }

    public Vector setGroupRegion(Rectangle lyt) {
        EntityInstance e = this.m_drawRoot.getMouseOver(lyt.x, lyt.y);
        if (e == null) {
            return null;
        }
        return e.groupRegion(lyt);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setDrawBends(boolean state) {
        MsgOut.dprintln("Draw bends set to: " + state);
        this.m_drawBends = state;
    }

    public boolean isDrawBends() {
        return this.m_drawBends;
    }

    public void setEdgeMode(int mode) {
        LandscapeObject.setEdgeMode(mode);
        Attribute attr = this.m_rootInstance.getLsAttribute("edgemode");
        attr.avi = new AttributeValueItem(String.valueOf(mode));
    }

    public int getEdgeMode() {
        return LandscapeObject.getEdgeMode();
    }

    public EntityInstance getDrawRoot() {
        return this.m_drawRoot;
    }

    public void setDrawRoot(EntityInstance e) {
        if (e != this.m_drawRoot) {
            this.m_drawRoot = e;
            e.setOpen();
            MapBox mapBox = this.m_ls.m_mapBox;
            if (mapBox != null) {
                mapBox.fill(e);
                mapBox.validate();
                mapBox.setVisible(true);
            }
        }
    }

    public EntityInstance getRootInstance() {
        return this.m_rootInstance;
    }

    public int getTimeStamp() {
        return this.timeStamp;
    }

    public void toggleDstElision(EntityInstance e) {
        Enumeration en = this.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (rc.excludeReln() || !rc.isClassVisible()) continue;
            e.toggleDstElision(rc);
        }
    }

    public void toggleSrcElision(EntityInstance e) {
        Enumeration en = this.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (rc.excludeReln() || !rc.isClassVisible()) continue;
            e.toggleSrcElision(rc);
        }
    }

    public void toggleEnteringElision(EntityInstance e) {
        Enumeration en = this.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (rc.excludeReln() || !rc.isClassVisible()) continue;
            e.toggleEnteringElision(rc);
        }
    }

    public void toggleExitingElision(EntityInstance e) {
        Enumeration en = this.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (rc.excludeReln() || !rc.isClassVisible()) continue;
            e.toggleExitingElision(rc);
        }
    }

    public void toggleInternalElision(EntityInstance e) {
        Enumeration en = this.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (rc.excludeReln() || !rc.isClassVisible()) continue;
            e.toggleInternalElision(rc);
        }
    }

    public void toggleContainElision(EntityInstance e) {
        MsgOut.dprintln("Toggle contains elision on " + e.getLabel());
        e.toggleContainElision();
    }

    public void setVisible(boolean value) {
        if (this.m_drawRoot != null) {
            this.m_drawRoot.setVisible(value);
        }
    }

    public void setEdgeVisibilityState(RelationClass rc, boolean state) {
        rc.setClassVisible(state);
        if (state) {
            this.relVisibilityAttr.removeFromList(rc.getId());
        } else {
            this.relVisibilityAttr.addToList(rc.getId());
        }
        this.setVisibilityFlags();
    }

    public void toggleEdgeVisibility() {
        Enumeration en = this.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (rc.excludeReln() || !rc.isClassVisible()) continue;
            this.setEdgeVisibilityState(rc, false);
        }
    }

    public void clearDrawEdges() {
        this.m_drawEdges = false;
    }

    public void setDrawEdges() {
        this.m_drawEdges = true;
    }

    public boolean getDrawEdges() {
        return this.m_drawEdges;
    }

    public Vector getHighlightedEdges() {
        Vector v = new Vector();
        this.m_drawRoot.getHighlightedEdges(v);
        if (v.size() == 0) {
            return null;
        }
        return v;
    }

    public void clearKeyEntity() {
        this.m_keyEntity = null;
    }

    public boolean clearFlags() {
        this.clearKeyEntity();
        boolean ret = false;
        if (!this.getDrawEdges()) {
            ret = true;
            this.setDrawEdges();
        }
        this.m_rootInstance.clearAllFlags();
        if (this.m_drawRoot != null) {
            this.m_drawRoot.setOpen();
        }
        return ret;
    }

    public void clearQueryFlags() {
        this.m_rootInstance.clearQueryFlags();
    }

    public void clearGroupFlags() {
        this.clearKeyEntity();
        this.setDrawEdges();
        this.m_rootInstance.clearGroupFlags();
    }

    public boolean toggleQueryPersistence() {
        this.persistentQuery = !this.persistentQuery;
        return this.persistentQuery;
    }

    public boolean getQueryPersistance() {
        return this.persistentQuery;
    }

    public EntityInstance newEntity(EntityInstance container) {
        String ename;
        int n = 0;
        while (this.entityExists(ename = "Entity#" + n)) {
            ++n;
        }
        EntityInstance e = new EntityInstance(this.defaultEntityClass, ename);
        this.putEntity(e);
        EntityClass ec = e.getEntityClass();
        if (ec != null) {
            ec.makeInstanceOfUs(e);
        }
        e.setxRelLocal(0.25);
        e.setyRelLocal(0.25);
        e.setwidthRelLocal(0.5);
        e.setheightRelLocal(0.5);
        e.rescale(container.getDiagramX(), container.getDiagramY(), container.getWidth(), container.getHeight());
        container.addContainment(e);
        this.prepostorder();
        EditAttribute.Create(this.m_ls, e);
        return e;
    }

    public EntityInstance addEntity(String initId, Rectangle lyt, EntityInstance container) {
        EntityInstance e = new EntityInstance(this.defaultEntityClass, initId);
        e.setDiagramBounds(lyt);
        this.putEntity(e);
        EditAttribute.Create(this.m_ls, e);
        EntityClass parent = e.getEntityClass();
        if (parent != null) {
            parent.makeInstanceOfUs(e);
        }
        container.addContainment(e);
        this.prepostorder();
        this.m_rootInstance.rescaleChildren();
        return e;
    }

    public EntityInstance DeleteEntity(EntityInstance e) {
        if (e != null) {
            if (e == this.getDrawRoot()) {
                this.m_ls.doFeedback("Can't delete the draw root");
                return null;
            }
            e.updateDelete();
            this.m_ls.doFeedback("Entity " + e.getLabel() + " and its contents have been deleted.");
        }
        return e;
    }

    public int numVisibleRelationClasses() {
        return this.numVisibleRelationClasses;
    }

    public Vector getGroup() {
        Vector grp = new Vector();
        this.m_rootInstance.getGroup(grp);
        if (grp.isEmpty()) {
            return null;
        }
        return grp;
    }

    public Rectangle getGroupBoundingBox() {
        Vector grp = this.getGroup();
        if (grp == null || grp.isEmpty()) {
            return null;
        }
        double x1 = Double.MAX_VALUE;
        double y1 = Double.MAX_VALUE;
        double x2 = Double.MIN_VALUE;
        double y2 = Double.MIN_VALUE;
        Enumeration en0 = grp.elements();
        while (en0.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en0.nextElement();
            Rectangle lyt = e.getDiagramBounds();
            if ((double)lyt.x < x1) {
                x1 = lyt.x;
            }
            if ((double)lyt.y < y1) {
                y1 = lyt.y;
            }
            if ((double)(lyt.x + lyt.width) > x2) {
                x2 = lyt.x + lyt.width;
            }
            if (!((double)(lyt.y + lyt.height) > y2)) continue;
            y2 = lyt.y + lyt.height;
        }
        return new Rectangle((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
    }

    public EntityInstance getKeyEntity() {
        return this.m_keyEntity;
    }

    public void setKeyEntity(EntityInstance e) {
        if (this.m_keyEntity != null) {
            this.m_keyEntity.clearGroupKeyFlag();
            this.m_keyEntity.setGroupFlag();
        }
        this.m_keyEntity = e;
        this.m_keyEntity.setGroupKeyFlag();
        this.m_keyEntity.setGroupFlag();
    }

    public Vector getRedBoxGroup() {
        Vector grp = new Vector();
        this.m_rootInstance.getRedBoxGroup(grp);
        if (grp.isEmpty()) {
            return null;
        }
        return grp;
    }

    public void selectEdges(Vector edges) {
        Enumeration en = edges.elements();
        while (en.hasMoreElements()) {
            RelationInstance r = (RelationInstance)en.nextElement();
            r.setGroupAndHighlightFlag();
        }
        this.clearDrawEdges();
    }

    public boolean isOverGroupRegion(int x, int y) {
        Rectangle lyt = this.getGroupBoundingBox();
        if (lyt != null) {
            return lyt.contains(x, y);
        }
        return false;
    }

    public int getGrid() {
        return this.gridPixels;
    }

    public void setGrid(int val) {
        this.gridPixels = val;
    }

    public void flagChanged() {
        this.changedFlag = true;
    }

    public boolean getChangedFlag() {
        return this.changedFlag;
    }

    public void resetChangedFlag() {
        this.changedFlag = false;
    }

    public void setToViewport() {
        this.navigateTo();
    }

    public void fitTo(EntityInstance e) {
        e.fitTo(true);
        this.rescaleDiagram();
    }

    public void invalidateAllEdges(EntityInstance root) {
        root.invalidateAllEdges();
        if (root.isOpen()) {
            Enumeration en = root.getChildren();
            while (en.hasMoreElements()) {
                this.invalidateAllEdges((EntityInstance)en.nextElement());
            }
        }
    }

    protected void drawHighlightEdges(EntityInstance e) {
        e.drawHighlightedEdges();
        if (e.isOpen()) {
            Enumeration en = e.getChildren();
            while (en.hasMoreElements()) {
                this.drawHighlightEdges((EntityInstance)en.nextElement());
            }
        }
    }

    protected void drawAllEdges(EntityInstance e, EntityInstance under) {
        e.drawAllEdges(under);
        if (e.isOpen()) {
            Enumeration en = e.getChildren();
            while (en.hasMoreElements()) {
                this.drawAllEdges((EntityInstance)en.nextElement(), under);
            }
        }
    }

    protected void doDrawEdges(EntityInstance e, EntityInstance under) {
        if (this.getDrawEdges()) {
            if (this.m_visibleEdges) {
                this.drawAllEdges(e, under);
            }
        } else {
            this.drawHighlightEdges(e);
        }
    }

    public boolean isValidateRoot() {
        return true;
    }

    public Dimension getPreferredSize() {
        int mh;
        int mw;
        JComponent container = (JComponent)this.getParent();
        if (container == null) {
            mw = 0;
            mh = 0;
        } else {
            Insets insets = container.getInsets();
            mw = container.getWidth() - insets.right - insets.left;
            if (mw <= 0) {
                mw = 0;
            }
            if ((mh = container.getHeight() - insets.bottom - insets.top) <= 0) {
                mw = 0;
            }
            mw = (int)((double)mw * this.m_zoom_x);
            mh = (int)((double)mh * this.m_zoom_y);
        }
        Dimension preferredSize = super.getPreferredSize();
        if (preferredSize.width != mw || preferredSize.height != mh) {
            preferredSize.setSize(mw, mh);
            this.setPreferredSize(preferredSize);
            container.revalidate();
        }
        return preferredSize;
    }

    public void validate() {
        EntityInstance e;
        int temp;
        this.m_loaded = false;
        Dimension size = this.getSize();
        int mw = size.width;
        int mh = size.height;
        if (mw < 1 || mh < 1) {
            return;
        }
        this.m_ls.waitCursorOn();
        if (this.m_cardinals == null) {
            this.m_cardinals = new Container();
            this.m_cardinals.setLayout(null);
        }
        if (this.m_edges == null) {
            this.m_edges = new Container();
            this.m_edges.setLayout(null);
        }
        this.removeAll();
        this.m_cardinals.removeAll();
        if (this.getLs().isShowCardinals()) {
            this.m_cardinals.setBounds(0, 0, mw, mh);
            this.add(this.m_cardinals);
        }
        this.m_edges.removeAll();
        this.m_edges.setBounds(0, 0, mw, mh);
        this.add(this.m_edges);
        if (!this.getDrawEdges()) {
            this.m_preserve_entity_marks |= 0x8000;
            this.m_preserve_relation_marks |= 0x400;
        }
        this.m_rootInstance.clearAllMarks(this.m_preserve_entity_marks, this.m_preserve_relation_marks);
        this.m_drawRoot.setOpen();
        mw -= 30;
        mh -= 20;
        int yshift = 0;
        Vector clients = null;
        Vector suppliers = null;
        boolean isTopClients = this.m_ls.isTopClients();
        if (this.m_drawRoot != this.m_rootInstance) {
            this.add(this.m_exitFlag);
            this.m_exitFlag.setVisible(true);
        } else {
            this.repaint();
        }
        this.findClientsAndSuppliers();
        if (this.m_clientSet.getFullSetSize() != 0) {
            temp = 70;
            mh -= temp;
            if (isTopClients) {
                this.m_clientSet.setBounds(15, 10, mw, 50);
                yshift = temp;
            } else {
                this.m_clientSet.setBounds(15, this.getHeight() - 50 - 10, mw, 50);
            }
        }
        if (this.m_supplierSet.getFullSetSize() != 0) {
            temp = 70;
            mh -= temp;
            if (!isTopClients) {
                this.m_supplierSet.setBounds(15, 10, mw, 50);
                yshift = temp;
            } else {
                this.m_supplierSet.setBounds(15, this.getHeight() - 50 - 10, mw, 50);
            }
        }
        ClientSupplierSet.compact(this.m_clientSet, this.m_supplierSet);
        clients = this.m_clientSet.getFullSet();
        if (clients != null && clients.size() == 0) {
            clients = null;
        }
        if ((suppliers = this.m_supplierSet.getFullSet()) != null && suppliers.size() == 0) {
            suppliers = null;
        }
        this.rescaleDiagram(15, 10 + yshift, mw, mh);
        this.m_drawRoot.addUnder(this);
        boolean liftEdges = this.m_ls.isLiftEdges();
        Enumeration en = this.m_drawRoot.getChildren();
        while (en.hasMoreElements()) {
            e = (EntityInstance)en.nextElement();
            e.computeAllDiagramEdges(this.m_drawRoot, clients, suppliers, null, liftEdges);
        }
        en = this.m_drawRoot.getChildren();
        while (en.hasMoreElements()) {
            e = (EntityInstance)en.nextElement();
            e.liftAllDiagramEdges(this.m_drawRoot, liftEdges);
        }
        if (this.m_supplierSet.getFullSetSize() != 0) {
            this.m_supplierSet.order();
            this.add(this.m_supplierSet);
            this.m_supplierSet.setVisible(true);
        }
        if (this.m_clientSet.getFullSetSize() != 0) {
            this.m_clientSet.order();
            this.add(this.m_clientSet);
            this.m_clientSet.setVisible(true);
        }
        this.doDrawEdges(this.m_drawRoot, this.m_drawRoot);
        if (this.getLs().isShowCardinals()) {
            EntityInstance drawInstance = this.m_drawRoot;
            drawInstance.resetCardinals(this.m_numRelationClasses);
            drawInstance.calcEdgeCardinals(null, !this.getDrawEdges());
            drawInstance.showCardinals();
        }
        this.m_ls.waitCursorOff();
        this.m_loaded = true;
        this.repaint();
    }

    public void redrawDiagram() {
        this.revalidate();
    }

    public boolean shouldScrollDiagram() {
        return this.m_zoom_x > 1.0 || this.m_zoom_y > 1.0;
    }

    public boolean zoom(double xfactor, double yfactor) {
        if (xfactor <= 1.0 && yfactor <= 1.0 && this.m_zoom_x == 1.0 && this.m_zoom_y == 1.0) {
            return false;
        }
        double x = this.m_zoom_x * xfactor;
        double y = this.m_zoom_y * yfactor;
        if (x < 1.0) {
            x = 1.0;
        }
        if (y < 1.0) {
            y = 1.0;
        }
        if (x != this.m_zoom_x || y != this.m_zoom_y) {
            new UpdateDiagramZoom(this, x, y);
        }
        return true;
    }

    public boolean set_to_viewport() {
        if (!this.shouldScrollDiagram()) {
            return false;
        }
        this.m_zoom_x = 1.0;
        this.m_zoom_y = 1.0;
        this.getPreferredSize();
        this.redrawDiagram();
        return true;
    }

    public void navigateTo(EntityInstance e) {
        this.setDrawRoot(e);
        this.redrawDiagram();
    }

    public void navigateTo(String eid) {
        EntityInstance e = this.getEntity(eid);
        if (e != null) {
            this.navigateTo(e);
        }
    }

    public void navigateTo() {
        Enumeration en = this.m_rootInstance.getChildren();
        EntityInstance e = this.m_rootInstance;
        if (en.hasMoreElements()) {
            e = (EntityInstance)en.nextElement();
            if (en.hasMoreElements()) {
                e = this.m_rootInstance;
            }
        }
        this.setPreserveEntityMarks(0);
        this.setPreserveRelationMarks(0);
        this.navigateTo(e);
    }

    public void navigateToDrawRootParent() {
        EntityInstance e = this.m_drawRoot.getEnterableParent();
        if (e == null) {
            this.m_ls.error("At topmost landscape");
        } else {
            this.setPreserveEntityMarks(0);
            this.setPreserveRelationMarks(0);
            this.navigateTo(e);
        }
    }

    public boolean entityExists(String name) {
        return this.getEntity(name) != null;
    }

    public boolean allowElision() {
        return this.getDrawEdges();
    }

    public void setModeHandler(LandscapeModeHandler modeHandler) {
        if (modeHandler != this.m_modeHandler) {
            if (modeHandler != null) {
                modeHandler.select(this);
            }
            this.m_modeHandler = modeHandler;
        }
    }

    public LandscapeModeHandler getModeHandler() {
        return this.m_modeHandler;
    }

    public boolean isModeHandlingActive() {
        return this.m_modeHandlingActive;
    }

    public void setModeHandlingActive(boolean value) {
        this.m_modeHandlingActive = value;
    }

    public RelationInstance targetRelation(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector v = (Vector)object;
                switch (v.size()) {
                    case 0: {
                        this.m_ls.doFeedback("Target relation set is empty");
                        break;
                    }
                    case 1: {
                        return (RelationInstance)v.firstElement();
                    }
                    default: {
                        this.m_ls.doFeedback("Target relation set has multiple objects in it");
                    }
                }
                return null;
            }
            return (RelationInstance)object;
        }
        Vector v = this.getHighlightedEdges();
        if (v == null) {
            this.m_ls.doFeedback("Highlight the edge you wish to work on");
        } else {
            if (v.size() == 1) {
                return (RelationInstance)v.firstElement();
            }
            this.m_ls.doFeedback("Can't operate on " + v.size() + " highlight edges");
        }
        return null;
    }

    public EntityInstance targetEntity(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector v = (Vector)object;
                switch (v.size()) {
                    case 0: {
                        this.m_ls.doFeedback("Target entity set is empty");
                        break;
                    }
                    case 1: {
                        return (EntityInstance)v.firstElement();
                    }
                    default: {
                        this.m_ls.doFeedback("Target entity set has multiple objects in it");
                    }
                }
                return null;
            }
            return (EntityInstance)object;
        }
        EntityInstance ke = this.getKeyEntity();
        if (ke != null) {
            return ke;
        }
        return this.getDrawRoot();
    }

    public Vector targetRelations(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector v = (Vector)object;
                if (v.size() > 0) {
                    return v;
                }
                this.m_ls.doFeedback("Target relation set is empty");
                return null;
            }
            Vector<Object> v = new Vector<Object>();
            v.addElement(object);
            return v;
        }
        Vector v = this.getHighlightedEdges();
        if (v == null) {
            this.m_ls.doFeedback("Select the edges you wish to work on");
        }
        return v;
    }

    public Vector targetEntities(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector v = (Vector)object;
                if (v.size() > 0) {
                    return v;
                }
                this.m_ls.doFeedback("Target entity set is empty");
                return null;
            }
            Vector<Object> v = new Vector<Object>();
            v.addElement(object);
            return v;
        }
        return this.getGroup();
    }

    public void entityPressed(MouseEvent ev, EntityInstance e, int x, int y) {
        this.m_ls.showDescription(e, true);
        if (this.m_modeHandler != null) {
            this.setModeHandlingActive(true);
            if (!this.m_modeHandler.entityPressed(ev, e, x, y)) {
                this.m_modeHandler.cleanup();
                this.setModeHandlingActive(false);
            }
        }
    }

    public void entityDragged(MouseEvent ev, EntityInstance e, int x, int y) {
        if (this.isModeHandlingActive() && this.m_modeHandler.entityDragged(ev, e, x, y)) {
            return;
        }
        this.movedOverThing(ev, e, x, y);
    }

    public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y) {
        if (this.isModeHandlingActive()) {
            LandscapeModeHandler modeHandler = this.getModeHandler();
            modeHandler.entityReleased(ev, e, x, y);
            modeHandler.cleanup();
            this.setModeHandlingActive(false);
        }
        if (y > 0) {
            this.getLs().toolButton[0].requestFocus();
            this.getLs().requestFocus();
        }
    }

    public void relationPressed(MouseEvent ev, RelationInstance ri, int x, int y) {
        this.m_ls.showDescription(ri, true);
        if (this.m_modeHandler != null) {
            this.setModeHandlingActive(true);
            if (!this.m_modeHandler.relationPressed(ev, ri, x, y)) {
                this.m_modeHandler.cleanup();
                this.setModeHandlingActive(false);
            }
        }
    }

    public void relationDragged(MouseEvent ev, RelationInstance ri, int x, int y) {
        if (this.isModeHandlingActive() && this.m_modeHandler.relationDragged(ev, ri, x, y)) {
            return;
        }
        this.movedOverThing(ev, ri, x, y);
    }

    public void relationReleased(MouseEvent ev, RelationInstance ri, int x, int y) {
        if (this.isModeHandlingActive()) {
            LandscapeModeHandler modeHandler = this.getModeHandler();
            modeHandler.relationReleased(ev, ri, x, y);
            modeHandler.cleanup();
            this.setModeHandlingActive(false);
        }
        if (y > 0) {
            this.getLs().toolButton[0].requestFocus();
            this.getLs().requestFocus();
        }
    }

    public void movedOverThing(MouseEvent ev, Object thing, int x, int y) {
        this.m_ls.resetAnticipateCursor();
        if (this.m_modeHandler != null) {
            this.m_modeHandler.movedOverThing(ev, thing, x, y);
        }
        this.m_ls.useAnticipateCursor();
    }

    public void mouseDragged(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
        this.movedOverThing(ev, this, ev.getX(), ev.getY());
    }

    public int getDiagramX() {
        return 0;
    }

    public int getDiagramY() {
        return 0;
    }

    class UpdateDiagramZoom
    extends MyUndoableEdit
    implements UndoableEdit {
        Diagram m_o;
        double m_oldX;
        double m_oldY;
        double m_newX;
        double m_newY;

        UpdateDiagramZoom(Diagram o, double x, double y) {
            this.m_o = o;
            this.m_oldX = o.m_zoom_x;
            this.m_oldY = o.m_zoom_y;
            this.m_newX = x;
            this.m_newY = y;
            if (Diagram.this.logEdit(this)) {
                this.redo();
            }
        }

        public String getPresentationName() {
            return " Zoom diagram";
        }

        public void undo() {
            this.m_o.m_zoom_x = this.m_oldX;
            this.m_o.m_zoom_y = this.m_oldY;
            this.m_o.getPreferredSize();
            this.m_o.redrawDiagram();
        }

        public void redo() {
            this.m_o.m_zoom_x = this.m_newX;
            this.m_o.m_zoom_y = this.m_newY;
            this.m_o.getPreferredSize();
            this.m_o.redrawDiagram();
        }
    }

    class ExitFlag
    extends JComponent
    implements MouseListener {
        protected static final int EXIT_FLAG_DIM = 8;
        protected Diagram m_diagram;

        public ExitFlag(Diagram diagram2) {
            this.m_diagram = diagram2;
            this.addMouseListener(this);
        }

        public void setLocation(int x, int y) {
            this.setBounds(x, y, 8, 8);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(boxColour.darker());
            g.drawRect(0, 0, 8, 8);
            g.drawLine(2, 4, 6, 4);
        }

        public void mouseClicked(MouseEvent ev) {
            this.m_diagram.navigateToDrawRootParent();
        }

        public void mouseEntered(MouseEvent e) {
            Diagram.this.getLs().setCursor(12);
        }

        public void mouseExited(MouseEvent e) {
            Diagram.this.getLs().setCursor(0);
        }

        public void mousePressed(MouseEvent ev) {
        }

        public void mouseReleased(MouseEvent ev) {
        }
    }
}

