/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import lsedit.AttributeValueItem;
import lsedit.ColorChooser;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeObject;
import lsedit.LandscapeTokenStream;
import lsedit.LandscapeViewerCore;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.Util;

public class EditAttribute
extends JDialog {
    protected EditAttribute(JFrame frame, LandscapeViewerCore ls, LandscapeObject e, String title) {
        super(frame, title, true);
        this.setSize(438, 369);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setForeground(new Color(0, 0, 0));
        this.setBackground(new Color(192, 192, 192));
        this.setFont(new Font("Dialog", 0, 12));
        AttributeTableModel tableModel = new AttributeTableModel(e);
        MyJTable table = new MyJTable(frame, ls, tableModel, e);
        tableModel.setJTable(table);
        table.setVisible(true);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setVisible(true);
        contentPane.add((Component)scrollPane, "Center");
        this.repaint();
        this.setVisible(true);
    }

    private static boolean sameColors(Color color1, Color color2) {
        if (color1 == color2) {
            return true;
        }
        if (color1 == null || color2 == null) {
            return false;
        }
        return color1.equals(color2);
    }

    public static void Create(LandscapeViewerCore ls, EntityInstance e) {
        ls.beginUndoRedo("Edit Entity " + e.getLabel());
        EditAttribute editAttribute = new EditAttribute(ls.getFrame(), ls, e, "Edit Entity Attributes");
        editAttribute.dispose();
        ls.repaint();
        ls.endUndoRedo();
    }

    public static void Create(LandscapeViewerCore ls, RelationInstance e) {
        ls.beginUndoRedo("Edit Relation " + e);
        EditAttribute editAttribute = new EditAttribute(ls.getFrame(), ls, e, "Edit Relation Attributes");
        editAttribute.dispose();
        ls.repaint();
        ls.endUndoRedo();
    }

    public static void Create(LandscapeViewerCore ls, EntityClass ec) {
        ls.beginUndoRedo("Edit EntityClass " + ec.getLabel());
        Color oldColorWhenOpen = ec.getColorWhenOpen();
        Color oldColor = ec.getObjectColor();
        Color oldLabelColor = ec.getLabelColor();
        int oldStyle = ec.getStyle();
        EditAttribute editAttribute = new EditAttribute(ls.getFrame(), ls, ec, "Edit Entity Class Attributes");
        Color newColorWhenOpen = ec.getColorWhenOpen();
        Color newColor = ec.getObjectColor();
        Color newLabelColor = ec.getLabelColor();
        int newStyle = ec.getStyle();
        boolean sameColorWhenOpen = EditAttribute.sameColors(oldColorWhenOpen, newColorWhenOpen);
        boolean sameColor = EditAttribute.sameColors(oldColor, newColor);
        boolean sameLabelColor = EditAttribute.sameColors(oldLabelColor, newLabelColor);
        boolean sameStyle = oldStyle == newStyle;
        editAttribute.dispose();
        ls.classChanges();
        if (!(sameColorWhenOpen && sameColor && sameLabelColor && sameStyle)) {
            ls.repaint();
        }
        ls.endUndoRedo();
    }

    public static void Create(LandscapeViewerCore ls, RelationClass rc) {
        ls.beginUndoRedo("Edit RelationClass " + rc);
        int oldStyle = rc.getStyle();
        Color oldColor = rc.getObjectColor();
        EditAttribute editAttribute = new EditAttribute(ls.getFrame(), ls, rc, "Edit Relation Class Attributes");
        Color newColor = rc.getObjectColor();
        int newStyle = rc.getStyle();
        boolean sameColor = EditAttribute.sameColors(oldColor, newColor);
        boolean sameStyle = oldStyle == newStyle;
        editAttribute.dispose();
        ls.classChanges();
        if (!sameColor || !sameStyle) {
            ls.repaint();
        }
        ls.endUndoRedo();
    }

    protected class MyJTable
    extends JTable {
        JFrame m_frame;
        LandscapeViewerCore m_ls;
        LandscapeObject m_object;

        public MyJTable(JFrame frame, LandscapeViewerCore ls, AbstractTableModel tableModel, LandscapeObject object) {
            super(tableModel);
            this.m_frame = frame;
            this.m_ls = ls;
            this.m_object = object;
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            TableCellRenderer ret = null;
            String tip = null;
            if (this.convertColumnIndexToModel(column) == 1) {
                Object value = this.dataModel.getValueAt(row, column);
                int type = this.m_object.getLsAttributeTypeAt(row);
                switch (type) {
                    case 3: {
                        if (row != 0) {
                            tip = "Click to change string";
                            break;
                        }
                        tip = "This value is fixed";
                        break;
                    }
                    case 2: {
                        tip = "Click to change double";
                        break;
                    }
                    case 1: {
                        tip = "Click to change integer";
                        break;
                    }
                    case 7: 
                    case 8: {
                        if (value != null) {
                            ret = new ColorRenderer();
                        }
                        tip = "Click to change color";
                        break;
                    }
                    case 12: {
                        if (value != null) {
                            ret = new TextRenderer();
                        }
                        tip = "Click to change text";
                        break;
                    }
                    case 13: {
                        if (value != null) {
                            ret = new StyleRenderer();
                        }
                        tip = "Click to change entity style";
                        break;
                    }
                    case 14: {
                        if (value != null) {
                            ret = new RelStyleRenderer();
                        }
                        tip = "Click to change relation style";
                        break;
                    }
                    case 11: {
                        tip = "Click to change attribute value";
                        break;
                    }
                    case 0: {
                        tip = "First enter name to create new attribute";
                        break;
                    }
                    case 15: {
                        tip = "Click to change entity class";
                        break;
                    }
                    case 16: {
                        tip = "Click to change relation class";
                    }
                }
                if (ret == null) {
                    ret = super.getCellRenderer(row, column);
                    ((JLabel)((Object)ret)).setForeground(Color.black);
                }
            } else {
                Color foreground;
                ret = super.getCellRenderer(row, column);
                if (row < this.m_object.getPrimaryAttributeCount()) {
                    foreground = Color.blue;
                    tip = "This attribute name is fixed";
                } else {
                    foreground = Color.red;
                    tip = row == this.m_object.getLsAttributeCount() - 1 ? "Click to add new attribute name" : "Click to change/delete attribute name";
                }
                ((JLabel)((Object)ret)).setForeground(foreground);
            }
            if (ret != null) {
                ((JComponent)((Object)ret)).setToolTipText(tip);
            }
            return ret;
        }

        public TableCellEditor getCellEditor(int row, int column) {
            if (this.convertColumnIndexToModel(column) == 1) {
                int type = this.m_object.getLsAttributeTypeAt(row);
                switch (type) {
                    case 7: {
                        return new ColorEditor(this.m_frame, false);
                    }
                    case 8: {
                        return new ColorEditor(this.m_frame, true);
                    }
                    case 12: {
                        return new TextEditor(this.m_frame);
                    }
                    case 2: {
                        return new DoubleEditor();
                    }
                    case 1: {
                        return new IntegerEditor();
                    }
                    case 13: {
                        return new StyleEditor();
                    }
                    case 14: {
                        return new RelStyleEditor();
                    }
                    case 11: {
                        return new AviTextEditor(this.m_frame);
                    }
                    case 15: {
                        return new ParentEntityClassEditor();
                    }
                    case 16: {
                        return new ParentRelationClassEditor();
                    }
                }
            }
            return super.getCellEditor(row, column);
        }

        class ParentRelationClassEditor
        extends DefaultCellEditor {
            String m_current;
            JComboBox m_comboBox;

            public ParentRelationClassEditor() {
                super(new JCheckBox());
                this.m_comboBox = new JComboBox();
                Enumeration en = MyJTable.this.m_ls.enumRelationClassesInOrder();
                en = MyJTable.this.m_ls.enumRelationClassesInOrder();
                while (en.hasMoreElements()) {
                    RelationClass rc = (RelationClass)en.nextElement();
                    if (rc.excludeReln()) continue;
                    this.m_comboBox.addItem(rc.getId());
                }
                this.editorComponent = this.m_comboBox;
                this.setClickCountToStart(1);
                this.m_comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ParentRelationClassEditor.this.fireEditingStopped();
                    }
                });
                this.m_comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        int selected = ParentRelationClassEditor.this.m_comboBox.getSelectedIndex();
                        if (selected >= 0) {
                            ParentRelationClassEditor.this.m_current = (String)ParentRelationClassEditor.this.m_comboBox.getItemAt(selected);
                        }
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_current;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.m_current = (String)value;
                int selected = 0;
                Enumeration en = MyJTable.this.m_ls.enumRelationClassesInOrder();
                while (en.hasMoreElements()) {
                    RelationClass rc = (RelationClass)en.nextElement();
                    if (rc.excludeReln()) continue;
                    if (rc.getId().equals(this.m_current)) {
                        this.m_comboBox.setSelectedIndex(selected);
                        break;
                    }
                    ++selected;
                }
                return this.editorComponent;
            }
        }

        class ParentEntityClassEditor
        extends DefaultCellEditor {
            String m_current;
            JComboBox m_comboBox;

            public ParentEntityClassEditor() {
                super(new JCheckBox());
                this.m_comboBox = new JComboBox();
                Enumeration en = MyJTable.this.m_ls.enumEntityClassesInOrder();
                while (en.hasMoreElements()) {
                    EntityClass ec = (EntityClass)en.nextElement();
                    this.m_comboBox.addItem(ec.getId());
                }
                this.editorComponent = this.m_comboBox;
                this.setClickCountToStart(1);
                this.m_comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ParentEntityClassEditor.this.fireEditingStopped();
                    }
                });
                this.m_comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        int selected = ParentEntityClassEditor.this.m_comboBox.getSelectedIndex();
                        if (selected >= 0) {
                            ParentEntityClassEditor.this.m_current = (String)ParentEntityClassEditor.this.m_comboBox.getItemAt(selected);
                        }
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_current;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.m_current = (String)value;
                int selected = 0;
                Enumeration en = MyJTable.this.m_ls.enumEntityClassesInOrder();
                while (en.hasMoreElements()) {
                    EntityClass ec = (EntityClass)en.nextElement();
                    if (ec.getId().equals(this.m_current)) {
                        this.m_comboBox.setSelectedIndex(selected);
                        break;
                    }
                    ++selected;
                }
                return this.editorComponent;
            }
        }

        class RelStyleEditor
        extends DefaultCellEditor {
            Integer m_current;
            JComboBox m_comboBox;

            public RelStyleEditor() {
                super(new JCheckBox());
                this.m_comboBox = new JComboBox();
                for (int i = 0; i < Util.lineStyleName.length; ++i) {
                    this.m_comboBox.addItem(Util.lineStyleName[i]);
                }
                this.editorComponent = this.m_comboBox;
                this.setClickCountToStart(1);
                this.m_comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        RelStyleEditor.this.fireEditingStopped();
                    }
                });
                this.m_comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        int selected = RelStyleEditor.this.m_comboBox.getSelectedIndex();
                        if (selected >= 0) {
                            RelStyleEditor.this.m_current = new Integer(selected);
                        }
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_current;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.m_current = (Integer)value;
                int selected = this.m_current;
                if (selected >= 0 && selected < this.m_comboBox.getItemCount()) {
                    this.m_comboBox.setSelectedIndex(this.m_current);
                }
                return this.editorComponent;
            }
        }

        protected class RelStyleRenderer
        extends JTextField
        implements TableCellRenderer {
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                int style = (Integer)value;
                String description = style < 0 || style >= Util.lineStyleName.length ? "" : Util.lineStyleName[style];
                this.setText(description);
                return this;
            }
        }

        class StyleEditor
        extends DefaultCellEditor {
            Integer m_current;
            JComboBox m_comboBox;

            public StyleEditor() {
                super(new JCheckBox());
                this.m_comboBox = new JComboBox();
                for (int i = 0; i < EntityClass.styleName.length; ++i) {
                    this.m_comboBox.addItem(EntityClass.styleName[i]);
                }
                this.editorComponent = this.m_comboBox;
                this.setClickCountToStart(1);
                this.m_comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        StyleEditor.this.fireEditingStopped();
                    }
                });
                this.m_comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        int selected = StyleEditor.this.m_comboBox.getSelectedIndex();
                        if (selected >= 0) {
                            StyleEditor.this.m_current = new Integer(selected);
                        }
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_current;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.m_current = (Integer)value;
                int selected = this.m_current;
                if (selected >= 0 && selected < this.m_comboBox.getItemCount()) {
                    this.m_comboBox.setSelectedIndex(this.m_current);
                }
                return this.editorComponent;
            }
        }

        protected class StyleRenderer
        extends JTextField
        implements TableCellRenderer {
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                int style = (Integer)value;
                String description = style < 0 || style >= EntityClass.styleName.length ? "" : EntityClass.styleName[style];
                this.setText(description);
                return this;
            }
        }

        class IntegerEditor
        extends DefaultCellEditor {
            Integer m_current;
            JTextField m_textField;

            public IntegerEditor() {
                super(new JCheckBox());
                this.m_textField = new JTextField();
                this.editorComponent = this.m_textField;
                this.setClickCountToStart(1);
                this.m_textField.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        IntegerEditor.this.fireEditingStopped();
                    }
                });
                this.m_textField.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            Integer newValue;
                            IntegerEditor.this.m_current = newValue = new Integer(IntegerEditor.this.m_textField.getText());
                        }
                        catch (Exception e1) {
                            System.out.println("\"" + IntegerEditor.this.m_textField.getText() + "\" is not an integer");
                        }
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_current;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.m_current = (Integer)value;
                this.m_textField.setText(this.m_current.toString());
                return this.editorComponent;
            }
        }

        class DoubleEditor
        extends DefaultCellEditor {
            Double m_current;
            JTextField m_textField;

            public DoubleEditor() {
                super(new JCheckBox());
                this.m_textField = new JTextField();
                this.editorComponent = this.m_textField;
                this.setClickCountToStart(1);
                this.m_textField.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        DoubleEditor.this.fireEditingStopped();
                    }
                });
                this.m_textField.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            Double newValue;
                            DoubleEditor.this.m_current = newValue = new Double(DoubleEditor.this.m_textField.getText());
                        }
                        catch (Exception e1) {
                            System.out.println("\"" + DoubleEditor.this.m_textField.getText() + "\" is not a double");
                        }
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_current;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.m_current = (Double)value;
                this.m_textField.setText(this.m_current.toString());
                return this.editorComponent;
            }
        }

        class AviTextEditor
        extends TextEditor {
            AttributeValueItem m_avi;
            String m_oldText;

            public AviTextEditor(JFrame frame) {
                super(frame);
            }

            public Object getCellEditorValue() {
                if (!this.m_oldText.equals(this.m_currentText)) {
                    int i;
                    for (i = this.m_currentText.length() - 1; i >= 0 && Character.isWhitespace(this.m_currentText.charAt(i)); --i) {
                    }
                    if (i < 0) {
                        this.m_avi = null;
                    } else {
                        StringBufferInputStream stream = new StringBufferInputStream(this.m_currentText);
                        LandscapeTokenStream ts = new LandscapeTokenStream(stream, "Attribute Editor");
                        try {
                            AttributeValueItem avi = ts.parseAttributeValueItem();
                            if (avi != null) {
                                this.m_avi = avi;
                            } else {
                                System.out.println("Can't parse '" + this.m_currentText + "' as attribute value");
                            }
                        }
                        catch (Exception e) {
                            System.out.println("Can't parse '" + this.m_currentText + "' as attribute value - exception thrown");
                        }
                    }
                }
                return this.m_avi;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.m_avi = (AttributeValueItem)value;
                this.m_currentText = value == null ? "" : value.toString();
                this.m_oldText = this.m_currentText;
                return this.editorComponent;
            }
        }

        class TextEditor
        extends DefaultCellEditor {
            JFrame m_frame;
            String m_currentText;
            JButton m_button;
            JTextArea m_textArea;
            JDialog m_dialog;

            public TextEditor(JFrame frame) {
                super(new JCheckBox());
                this.m_textArea = null;
                this.m_dialog = null;
                this.m_frame = frame;
                this.m_button = new JButton();
                this.m_button.setBackground(Color.white);
                this.m_button.setBorderPainted(false);
                this.m_button.setMargin(new Insets(0, 0, 0, 0));
                this.editorComponent = this.m_button;
                this.setClickCountToStart(1);
                this.m_button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (TextEditor.this.m_dialog == null) {
                            TextEditor.this.m_dialog = new JDialog(TextEditor.this.m_frame, "Change Text", true);
                            TextEditor.this.m_textArea = new JTextArea();
                            TextEditor.this.m_dialog.setSize(438, 369);
                            Container contentPane = TextEditor.this.m_dialog.getContentPane();
                            contentPane.setLayout(null);
                            Font font = new Font("Dialog", 0, 12);
                            TextEditor.this.m_dialog.setForeground(new Color(0, 0, 0));
                            TextEditor.this.m_dialog.setBackground(new Color(192, 192, 192));
                            TextEditor.this.m_dialog.setFont(font);
                            JScrollPane scrollPane = new JScrollPane(TextEditor.this.m_textArea);
                            scrollPane.setVisible(true);
                            scrollPane.setBounds(5, 5, 423, 300);
                            contentPane.add(scrollPane);
                            JButton OK_button = new JButton("OK", null);
                            OK_button.setFont(font);
                            OK_button.setBounds(5, 310, 60, 30);
                            contentPane.add(OK_button);
                            OK_button.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    TextEditor.this.m_currentText = TextEditor.this.m_textArea.getText();
                                    TextEditor.this.m_dialog.setVisible(false);
                                }
                            });
                        }
                        TextEditor.this.m_textArea.setText(TextEditor.this.m_currentText);
                        TextEditor.this.m_dialog.setVisible(true);
                        TextEditor.this.fireEditingStopped();
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_currentText;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.m_currentText = (String)value;
                return this.editorComponent;
            }
        }

        protected class TextRenderer
        extends JTextField
        implements TableCellRenderer {
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setText((String)value);
                return this;
            }
        }

        class ColorEditor
        extends DefaultCellEditor {
            JFrame m_frame;
            Color m_currentColor;
            boolean m_allowNull;
            JButton m_button;

            public ColorEditor(JFrame frame, boolean allowNull) {
                super(new JCheckBox());
                this.m_frame = frame;
                this.m_allowNull = allowNull;
                this.m_button = new JButton(){

                    public void setText(String s) {
                    }
                };
                this.m_button.setBackground(Color.white);
                this.m_button.setBorderPainted(false);
                this.m_button.setMargin(new Insets(0, 0, 0, 0));
                this.editorComponent = this.m_button;
                this.setClickCountToStart(1);
                this.m_button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ColorEditor.this.m_button.setBackground(ColorEditor.this.m_currentColor);
                        ColorEditor.this.m_currentColor = ColorChooser.create(ColorEditor.this.m_frame, "Pick a color", ColorEditor.this.m_currentColor, true, ColorEditor.this.m_allowNull);
                        ColorEditor.this.fireEditingStopped();
                    }
                });
            }

            public Object getCellEditorValue() {
                return this.m_currentColor;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.m_currentColor = (Color)value;
                return this.editorComponent;
            }
        }

        protected class ColorRenderer
        extends JLabel
        implements TableCellRenderer {
            Border unselectedBorder = null;
            Border selectedBorder = null;

            public ColorRenderer() {
                this.setOpaque(true);
            }

            public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setBackground((Color)color);
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
                return this;
            }
        }
    }

    protected class AttributeTableModel
    extends AbstractTableModel {
        LandscapeObject m_object;
        JTable m_table;

        public AttributeTableModel(LandscapeObject object) {
            this.m_object = object;
        }

        public void setJTable(JTable table) {
            this.m_table = table;
        }

        public int getRowCount() {
            return this.m_object.getLsAttributeCount();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Name";
            }
            return "Value";
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.m_object.getLsAttributeNameAt(row);
            }
            return this.m_object.getLsAttributeValueAt(row);
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return this.getValueAt(0, col).getClass();
            }
            Object x = new Object();
            return x.getClass();
        }

        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                return this.m_object.canEditName(row);
            }
            return this.m_object.canEditAttribute(row);
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                if (this.m_object.setAttributeNameAt(row, value)) {
                    this.m_table.revalidate();
                    this.m_table.repaint();
                }
            } else {
                this.m_object.setAttributeValueAt(row, value);
            }
        }
    }
}

