/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.EdgePoint;
import lsedit.EditAttribute;
import lsedit.EntityInstance;
import lsedit.LandscapeViewerCore;
import lsedit.RelationInstance;
import lsedit.ViewModeHandler;

public class EditModeHandler
extends ViewModeHandler {
    protected JPopupMenu buildEntityPopup() {
        JPopupMenu m = new JPopupMenu("Entity options");
        JMenu m1 = new JMenu("Navigate");
        Do.navigateEntityMenu(m1, this.m_ls);
        m.add(m1);
        m1 = new JMenu("Query");
        Do.queryMenuItem(m1, this.m_ls);
        m.add(m1);
        m1 = new JMenu("Elide");
        Do.hideMenuItem(m1, this.m_ls);
        m.add(m1);
        m1 = new JMenu("Draw");
        Do.drawMenuItem(m1, this.m_ls);
        m1.addSeparator();
        Do.editEntityMenuItem(m1, this.m_ls);
        m1.addSeparator();
        LandscapeViewerCore.fontMenuItem(m1, this.m_ls);
        m.addSeparator();
        m.add(m1);
        m1 = new JMenu("Move");
        Do.groupAllMenuItem(m1, this.m_ls);
        Do.fitMenuItem(m1, this.m_ls);
        m.addSeparator();
        Do.scaleMenuItem(m1, this.m_ls);
        m.add(m1);
        return m;
    }

    protected JPopupMenu buildRelationPopup() {
        JPopupMenu m = new JPopupMenu("Edge options");
        Do.navigateEdgeMenu(m, this.m_ls);
        Do.deleteEdgeMenuItem(m, this.m_ls);
        Do.editRelationMenuItem(m, this.m_ls);
        return m;
    }

    protected void moveRedBoxes(Object object) {
        Vector grp = this.m_dg.getRedBoxGroup();
        if (grp == null) {
            this.m_ls.error("No query result active.");
            return;
        }
        EntityInstance container = this.m_dg.targetEntity(object);
        if (container == null) {
            return;
        }
        if (container == this.m_dg.getRootInstance()) {
            this.m_ls.error("Can't add objects into the root");
            return;
        }
        Enumeration en = grp.elements();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            if (e.hasDescendantOrSelf(container)) {
                this.m_ls.error("Entity " + e.getLabel() + " can't be moved into " + container.getLabel() + " because it contains the entity");
                continue;
            }
            this.m_ls.moveEntityContainment(container, e);
        }
        this.m_dg.fitTo(container);
    }

    protected void deltaFont(int delta) {
        Vector grp = this.m_dg.getGroup();
        if (grp != null && !grp.isEmpty()) {
            Enumeration en = grp.elements();
            while (en.hasMoreElements()) {
                EntityInstance ge = (EntityInstance)en.nextElement();
                ge.deltaFont(delta);
            }
            this.m_ls.doFeedback("Selected entities font changed");
            return;
        }
        EntityInstance ge = this.m_dg.getDrawRoot();
        if (ge != null) {
            ge.deltaFont(delta);
            this.m_ls.doFeedback("Outer entities font changed");
            return;
        }
        this.m_ls.doFeedback("No entities exist");
    }

    protected boolean handleCommands(int key, int modifiers, Object object) {
        boolean handled = false;
        if ((modifiers & 1) != 0) {
            switch (key) {
                case 127: {
                    this.DeleteEdge(object);
                    return true;
                }
            }
        } else if (modifiers == 0) {
            switch (key) {
                case 127: {
                    this.m_ls.DeleteEntity(object);
                    return true;
                }
                case 84: {
                    this.deltaFont(1);
                    handled = true;
                    break;
                }
                case 116: {
                    this.deltaFont(-1);
                    handled = true;
                    break;
                }
                case 101: {
                    EntityInstance e = this.m_dg.targetEntity(object);
                    if (e == null) {
                        return false;
                    }
                    this.m_ls.newEntity(e);
                    handled = true;
                    break;
                }
                case 65: {
                    EntityInstance e = this.m_dg.targetEntity(object);
                    if (e == null) {
                        return false;
                    }
                    EditAttribute.Create(this.m_ls, e.getEntityClass());
                    handled = true;
                    break;
                }
                case 97: {
                    EntityInstance e = this.m_dg.targetEntity(object);
                    if (e == null) {
                        return false;
                    }
                    EditAttribute.Create(this.m_ls, e);
                    handled = true;
                    break;
                }
                case 82: {
                    RelationInstance ri = this.m_dg.targetRelation(object);
                    if (ri == null) {
                        return false;
                    }
                    EditAttribute.Create(this.m_ls, ri.getRelationClass());
                    handled = true;
                    break;
                }
                case 114: {
                    RelationInstance ri = this.m_dg.targetRelation(object);
                    if (ri == null) {
                        return false;
                    }
                    EditAttribute.Create(this.m_ls, ri);
                    handled = true;
                    break;
                }
                case 107: {
                    EntityInstance e = this.m_dg.targetEntity(object);
                    if (e == null) {
                        return false;
                    }
                    if (e == this.m_dg.getRootInstance()) {
                        this.m_ls.error("Can't delete root instance");
                        return false;
                    }
                    this.m_ls.deleteContainer(e);
                    handled = true;
                    break;
                }
                case 77: {
                    this.m_ls.beginUndoRedo("Move Redboxes");
                    this.moveRedBoxes(object);
                    this.m_ls.endUndoRedo();
                    handled = true;
                }
            }
        }
        if (handled) {
            this.m_ls.redrawDg();
        } else {
            handled = super.handleCommands(key, modifiers, object);
        }
        return handled;
    }

    public void select(Diagram dg) {
        super.select(dg);
        dg.setDrawBends(true);
    }

    protected void DeleteEdge(Object object) {
        RelationInstance ri = this.m_dg.targetRelation(object);
        if (ri != null) {
            this.m_ls.doFeedback("Edge deleted.");
            this.m_dg.deleteEdge(ri);
            this.m_dg.redrawDiagram();
        }
    }

    public void movedOverThing(MouseEvent ev, Object thing, int x, int y) {
        RelationInstance ri;
        EdgePoint edgepoint;
        if (thing instanceof RelationInstance && (edgepoint = (ri = (RelationInstance)thing).mouseOverEdgePoint(x, y)) != null) {
            this.m_ls.setAnticipateCursor(1);
            return;
        }
        super.movedOverThing(ev, thing, x, y);
    }
}

