/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import lsedit.EntityClass;
import lsedit.EntityComponent;
import lsedit.EntityInstance;

class EntityChkBox
extends JComponent {
    protected static final int GAP = 5;
    protected static final int WIDTH = 45;
    protected static final int HEIGHT = 20;
    protected JCheckBox m_checkbox;
    protected EntityClass m_ec;
    protected EntityInstance m_e;
    protected int m_index;
    protected JLabel m_label;

    public EntityChkBox(EntityClass ec, int index, int height, boolean value) {
        JLabel label;
        JCheckBox checkbox;
        int bh = height * 2;
        int bw = bh * 4 / 3;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setHgap(5);
        this.setLayout(new FlowLayout(0));
        this.m_ec = ec;
        this.m_index = index;
        Color color = ec.getObjectColor();
        this.m_checkbox = checkbox = new JCheckBox();
        checkbox.setBorderPaintedFlat(false);
        checkbox.setSelected(ec.isShown());
        checkbox.setEnabled(true);
        checkbox.setVisible(true);
        this.add(checkbox);
        this.m_e = ec.newEntity("class");
        EntityComponent entityComponent = this.m_e.neededPlainComponent();
        this.m_e.setBounds(0, 0, bw, bh);
        entityComponent.setPreferredSize(new Dimension(bw, bh));
        this.add(entityComponent);
        this.m_label = label = new JLabel(ec.getLabel());
        label.setForeground(ec.getLabelColor());
        this.add(label);
        this.setToolTipText(ec.getDescription());
    }

    public void setFont(Font font) {
        this.m_label.setFont(font);
    }

    public void addItemListener(ItemListener listener) {
        this.m_checkbox.addItemListener(listener);
    }

    public boolean isSelected() {
        return this.m_checkbox.isSelected();
    }

    public void doClick() {
        this.m_checkbox.doClick();
    }

    public int getIndex() {
        return this.m_index;
    }
}

