/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;

public class EntityClass
extends LandscapeClassObject {
    public static final String ENTITY_BASE_CLASS_ID = "$ENTITY";
    public static final int ENTITY_STYLE_NONE = -1;
    public static final int ENTITY_STYLE_3DBOX = 0;
    public static final int ENTITY_STYLE_2DBOX = 1;
    public static final int ENTITY_STYLE_FILE = 2;
    public static final int ENTITY_STYLE_DISK = 3;
    public static final int ENTITY_STYLE_FOLDER = 4;
    public static final int ENTITY_STYLE_SOURCEOBJ = 5;
    public static final int ENTITY_STYLE_CLASS = 6;
    public static final int ENTITY_STYLE_GROUP = 7;
    public static final int ENTITY_STYLE_LABELLED_GROUP = 8;
    public static final String[] styleName = new String[]{"3D Box", "2D Box", "File", "Disk", "Folder", "Source Object", "Class", "Group", "Labelled Group"};
    private boolean m_shown = true;

    public EntityClass(String id, int nid, EntityClass pec, Diagram dg) {
        this.setId(id);
        this.setNid(nid);
        this.setLabel(id);
        this.setDiagram(dg);
        this.addParentClass(pec);
        this.setStyle(0);
        this.setObjectColor(Color.blue);
        this.setLabelColor(Color.cyan);
    }

    public static String getEntityStyleName(int style) {
        if (style < 0 || style >= styleName.length) {
            return "";
        }
        return styleName[style];
    }

    public String getStyleName(int style) {
        return EntityClass.getEntityStyleName(style);
    }

    public void setShown(boolean value) {
        this.m_shown = value;
    }

    public boolean isShown() {
        return this.m_shown;
    }

    public void writeAttributes(PrintStream ps) throws IOException {
        ps.print(this.qt(this.getId()) + " {\n");
        super.writeAttributes(ps);
        ps.print("}\n\n");
    }

    public EntityInstance newEntity(String id) {
        EntityInstance e = new EntityInstance(this, id);
        this.makeInstanceOfUs(e);
        return e;
    }

    public String addParentClass(EntityClass inherits) {
        return this.addParentClass(inherits, ENTITY_BASE_CLASS_ID);
    }

    public int getPrimaryAttributeCount() {
        return 7;
    }

    public String getLsAttributeNameAt(int index) {
        String name;
        switch (index) {
            case 0: {
                name = "id";
                break;
            }
            case 1: {
                name = "class_label";
                break;
            }
            case 2: {
                name = "class_description";
                break;
            }
            case 3: {
                name = "class_style";
                break;
            }
            case 4: {
                name = "color";
                break;
            }
            case 5: {
                name = "labelcolor";
                break;
            }
            case 6: {
                name = "opencolor";
                break;
            }
            default: {
                name = super.getLsAttributeNameAt(index);
            }
        }
        return name;
    }

    public Object getLsAttributeValueAt(int index) {
        Object value;
        switch (index) {
            case 0: {
                value = this.getId();
                break;
            }
            case 1: {
                value = this.getLabel();
                break;
            }
            case 2: {
                value = this.getDescription();
                break;
            }
            case 3: {
                value = new Integer(this.getStyle());
                break;
            }
            case 4: {
                if (this.hasObjectColor()) {
                    value = this.getObjectColor();
                    break;
                }
                value = null;
                break;
            }
            case 5: {
                if (this.hasLabelColor()) {
                    value = this.getLabelColor();
                    break;
                }
                value = null;
                break;
            }
            case 6: {
                value = this.getColorWhenOpen();
                break;
            }
            default: {
                value = super.getLsAttributeValueAt(index);
            }
        }
        return value;
    }

    public void setAttributeValueAt(int index, Object value) {
        switch (index) {
            case 0: {
                this.setId((String)value);
                break;
            }
            case 1: {
                this.updateLabel((String)value);
                break;
            }
            case 2: {
                this.updateDescription((String)value);
                break;
            }
            case 3: {
                this.updateStyle((Integer)value);
                break;
            }
            case 4: {
                this.updateObjectColor((Color)value);
                break;
            }
            case 5: {
                this.updateLabelColor((Color)value);
                break;
            }
            case 6: {
                this.updateColorWhenOpen((Color)value);
                break;
            }
            default: {
                super.setAttributeValueAt(index, value);
            }
        }
    }

    public int getLsAttributeTypeAt(int index) {
        int ret;
        switch (index) {
            case 0: 
            case 1: {
                ret = 3;
                break;
            }
            case 2: {
                ret = 12;
                break;
            }
            case 3: {
                ret = 13;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                ret = 8;
                break;
            }
            default: {
                ret = super.getLsAttributeTypeAt(index);
            }
        }
        return ret;
    }
}

