/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JComponent;
import lsedit.EntityInstance;
import lsedit.Util;

public class EntityComponent
extends JComponent
implements Icon {
    private static final int MARGIN = 5;
    public static final int MIN_FLAP_HT = 3;
    public static final int MAX_FLAP_HT = 8;
    public static final int FLAP_MARGIN = 4;
    public static final int TINY_FLAP_WD = 10;
    public static final int MIN_FLAP_WD = 75;
    public static final int CONTENTS_FLAG_X = 3;
    public static final int CONTENTS_FLAG_Y = 9;
    public static final int CONTENTS_FLAG_DIM = 8;
    private EntityInstance m_entityInstance;
    private double m_avgX;

    public EntityComponent(EntityInstance entityInstance) {
        this.m_entityInstance = entityInstance;
        this.setLayout(null);
        entityInstance.setSwingObject(this);
        this.setBounds(entityInstance.getX(), entityInstance.getY(), entityInstance.getWidth(), entityInstance.getHeight());
    }

    public String toString() {
        return "EntityComponent: " + this.m_entityInstance.toString();
    }

    public EntityInstance getEntityInstance() {
        return this.m_entityInstance;
    }

    public void setAvgX(double avgX) {
        this.m_avgX = avgX;
    }

    public double getAvgX() {
        return this.m_avgX;
    }

    protected void setGraphicsColor(Graphics g, Color explicit, EntityInstance entityInstance) {
        if (explicit != null) {
            g.setColor(explicit);
        } else if (entityInstance.red_closed()) {
            g.setColor(Color.red.darker());
        } else {
            g.setColor(entityInstance.getCurrentObjectColor());
        }
    }

    public void paintShape(Graphics g, int x, int y, int width, int height, boolean fill, Color fillColor) {
        if (width > 0 && height > 0) {
            EntityInstance entityInstance = this.m_entityInstance;
            switch (entityInstance.getStyle()) {
                case 0: {
                    if (fill) {
                        this.setGraphicsColor(g, fillColor, entityInstance);
                        g.fill3DRect(x + 1, y + 1, width - 1, height - 1, true);
                    }
                    this.setGraphicsColor(g, null, entityInstance);
                    g.draw3DRect(x, y, width, height, true);
                    break;
                }
                case 1: {
                    if (fill) {
                        this.setGraphicsColor(g, fillColor, entityInstance);
                        g.fillRect(x, y, width, height);
                    }
                    g.setColor(Color.black);
                    g.drawRect(x, y, width, height);
                    break;
                }
                case 2: {
                    int fd = Math.min(Math.min(width, height) / 2, 8);
                    int[] xp = new int[6];
                    int[] yp = new int[6];
                    xp[0] = x;
                    yp[0] = y;
                    xp[1] = x + width - fd;
                    yp[1] = y;
                    xp[2] = x + width - 1;
                    yp[2] = y + fd;
                    xp[3] = xp[2];
                    yp[3] = y + height - 1;
                    xp[4] = x;
                    yp[4] = yp[3];
                    xp[5] = xp[0];
                    yp[5] = yp[0];
                    if (fill) {
                        this.setGraphicsColor(g, fillColor, entityInstance);
                        g.fillPolygon(xp, yp, 6);
                    }
                    g.setColor(Color.darkGray);
                    g.drawPolygon(xp, yp, 6);
                    xp[0] = xp[1];
                    yp[0] = yp[2];
                    xp[3] = xp[0];
                    yp[3] = yp[0];
                    g.drawPolygon(xp, yp, 4);
                    break;
                }
                case 3: {
                    int ad = Math.min(Math.min(width, height) / 2, 8);
                    if (fill) {
                        this.setGraphicsColor(g, fillColor, entityInstance);
                        g.fillRect(x, y + ad / 2, width, height - ad);
                        g.fillOval(x, y, width, ad);
                        g.fillOval(x, y + height - ad, width, ad);
                    }
                    g.setColor(Color.black);
                    g.drawOval(x, y, width, ad);
                    g.drawArc(x, y + height - ad - 1, width, ad, 180, 180);
                    g.drawLine(x, y + ad / 2, x, y + height - ad / 2);
                    g.drawLine(x + width - 1, y + ad / 2, x + width - 1, y + height - ad / 2);
                    break;
                }
                case 4: {
                    int fw = (int)((double)width * 0.4);
                    int fh = Math.max(3, Math.min(8, (int)((double)height * 0.2)));
                    int fm = 4;
                    if (fw < 75) {
                        fw += fw / 2;
                    }
                    if (fw < 10) {
                        fw = Math.min(fw + 4, width - width / 3);
                        fm = 0;
                    }
                    int[] xp = new int[9];
                    int[] yp = new int[9];
                    xp[0] = x;
                    yp[0] = y + fh;
                    xp[1] = x + fm;
                    yp[1] = y + fh;
                    xp[2] = xp[1] + fh / 2;
                    yp[2] = y;
                    xp[3] = x + fw;
                    yp[3] = yp[2];
                    xp[4] = xp[3] + fh / 2;
                    yp[4] = yp[0];
                    xp[5] = x + width - 1;
                    yp[5] = yp[0];
                    xp[6] = xp[5];
                    yp[6] = y + height - 1;
                    xp[7] = xp[0];
                    yp[7] = yp[6];
                    xp[8] = xp[0];
                    yp[8] = yp[0];
                    if (fill) {
                        this.setGraphicsColor(g, fillColor, entityInstance);
                        g.fillPolygon(xp, yp, 9);
                    }
                    g.setColor(entityInstance.red_open() ? Color.red : Color.black);
                    g.drawPolygon(xp, yp, 9);
                    if (entityInstance.isOpen()) break;
                    g.drawLine(xp[1], yp[1], xp[4], yp[4]);
                    break;
                }
                case 5: {
                    if (fill) {
                        this.setGraphicsColor(g, fillColor, entityInstance);
                        g.fillOval(x, y, width, height);
                    }
                    g.setColor(this.m_entityInstance.red_open() ? Color.red : Color.black);
                    g.drawOval(x, y, width, height);
                    break;
                }
                case 6: {
                    int arc_w = width / 5;
                    int arc_h = height / 5;
                    int arc = Math.min(arc_w, arc_h);
                    if (fill) {
                        this.setGraphicsColor(g, fillColor, entityInstance);
                        g.fillRoundRect(x, y, width, height, arc, arc);
                    }
                    g.setColor(Color.black);
                    g.drawRoundRect(x, y, width, height, arc, arc);
                    break;
                }
                case 7: {
                    Util.drawOutlineBox(g, x, y, width, height, true);
                    break;
                }
                case 8: {
                    g.setFont(EntityInstance.smallFont);
                    Util.drawGroupBox(g, x, y, width, height, entityInstance.getLabel(), entityInstance.getCurrentLabelColor(), true);
                }
            }
        }
    }

    public void paintMap(Graphics g, int x, int y, int width, int height, EntityInstance onPath, int depth) {
        if (width > 0 && height > 0) {
            EntityInstance entityInstance = this.m_entityInstance;
            Color color = entityInstance == onPath ? Color.green : entityInstance.getObjectColor();
            this.paintShape(g, x, y, width, height, !entityInstance.hasChildren() || depth == 1, color);
            if (depth < 1) {
                Enumeration children = entityInstance.getChildren();
                while (children.hasMoreElements()) {
                    EntityInstance child = (EntityInstance)children.nextElement();
                    int x1 = x + (int)((double)width * child.xRelLocal());
                    int y1 = y + (int)((double)height * child.yRelLocal());
                    int width1 = (int)((double)width * child.widthRelLocal());
                    int height1 = (int)((double)height * child.heightRelLocal());
                    child.paintMap(g, x1, y1, width1, height1, onPath, depth + 1);
                }
            }
        }
    }

    protected void drawTopLeftLabel(Graphics g) {
        EntityInstance entityInstance = this.m_entityInstance;
        switch (entityInstance.getStyle()) {
            case 4: {
                g.setFont(EntityInstance.smallFont);
                int fw = (int)((double)this.getWidth() * 0.4);
                int fh = Math.max(3, Math.min(8, (int)((double)this.getHeight() * 0.2)));
                if (fw < 75) {
                    fw += fw / 2;
                }
                if (fw < 10) {
                    fw = Math.min(fw + 4, this.getWidth() - this.getWidth() / 3);
                }
                Util.drawStringClipped(g, entityInstance.getLabel(), 4 + fh / 2 + 2, 0.0, fw, this.getHeight() - 10);
                break;
            }
            case 6: {
                g.setFont(EntityInstance.openFont);
                Util.drawStringClipped(g, entityInstance.getLabel(), 15.0, 5.0, this.getWidth() - 10, this.getHeight() - 10);
                break;
            }
            default: {
                g.setFont(EntityInstance.smallFont);
                Util.drawStringClipped(g, entityInstance.getLabel(), 5.0, 5.0, this.getWidth() - 10, this.getHeight() - 10);
            }
        }
    }

    public void paintComponent(Graphics g) {
        EntityInstance entityInstance = this.m_entityInstance;
        int width = this.getWidth();
        int height = this.getHeight();
        this.paintShape(g, 0, 0, width, height, true, null);
        if (entityInstance.isMarked(4096)) {
            g.setColor(Color.white);
            g.drawRect(0, 0, width, height);
            g.drawRect(1, 1, width - 1, height - 1);
        }
        if (entityInstance.close_with_children_under_drawroot() && width > 11 && height > 17) {
            g.setColor(new Color(entityInstance.getObjectColor().getRGB() ^ 0xFFFFFF));
            g.drawRect(3, 9, 8, 8);
            g.drawLine(4, 13, 10, 13);
            g.drawLine(7, 10, 7, 16);
        }
        if (entityInstance.isMarked(8192)) {
            Util.drawArrow(g, width - 5, (int)Util.ARROW_L, (int)((double)width - Util.ARROW_L * 2.0 - 5.0), (int)Util.ARROW_L);
        }
        if (entityInstance.isMarked(16384)) {
            Util.drawArrow(g, (int)((double)width - Util.ARROW_L * 2.0 - 5.0), (int)Util.ARROW_L, width - 5, (int)Util.ARROW_L);
        }
        if (entityInstance.getContainedBy() != null && entityInstance.isLabelDrawable()) {
            g.setColor(entityInstance.getCurrentLabelColor());
            if (entityInstance.isOpen()) {
                this.drawTopLeftLabel(g);
            } else {
                String label1 = entityInstance.getLabel();
                if (!entityInstance.isMarked(6)) {
                    g.setFont(EntityInstance.closedFont[6 + entityInstance.getFontDelta()]);
                } else {
                    g.setFont(EntityInstance.smallFont);
                    EntityInstance pe = entityInstance.getEnterableParent();
                    if (pe != null) {
                        label1 = pe.getLabel() + " .\n" + label1;
                    }
                }
                Util.drawStringWrapped(g, label1, 5.0, 5.0, this.getWidth() - 10, this.getHeight() - 10, true, false);
            }
        }
        if (entityInstance.getGroupFlag()) {
            int pdim;
            g.setColor(entityInstance.getLabelColor());
            int n = pdim = height < 20 ? 4 : 6;
            if (entityInstance.getGroupKeyFlag()) {
                g.fillRect(1, 1, pdim, pdim);
                g.fillRect(width / 2 - pdim / 2, 1, pdim, pdim);
                g.fillRect(width - pdim, 1, pdim, pdim);
                g.fillRect(1, height / 2 - pdim / 2, pdim, pdim);
                g.fillRect(width - pdim, height / 2 - pdim / 2, pdim, pdim);
                g.fillRect(1, height - pdim, pdim, pdim);
                g.fillRect(width / 2 - pdim / 2, height - pdim, pdim, pdim);
                g.fillRect(width - pdim, height - pdim, pdim, pdim);
            } else {
                g.drawRect(1, 1, pdim, pdim);
                g.drawRect(width / 2 - pdim / 2, 1, pdim, pdim);
                g.drawRect(width - pdim - 1, 1, pdim, pdim);
                g.drawRect(1, height / 2 - pdim / 2, pdim, pdim);
                g.drawRect(width - pdim - 1, height / 2 - pdim / 2, pdim, pdim);
                g.drawRect(1, height - pdim - 1, pdim, pdim);
                g.drawRect(width / 2 - pdim / 2, height - pdim - 1, pdim, pdim);
                g.drawRect(width - pdim - 1, height - pdim - 1, pdim, pdim);
            }
        }
    }

    public int getIconWidth() {
        return this.getWidth();
    }

    public int getIconHeight() {
        return this.getHeight();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.translate(x, y);
        this.paintComponent(g);
    }
}

