/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Cardinal;
import lsedit.Diagram;
import lsedit.DiagramCoordinates;
import lsedit.Do;
import lsedit.EdgePoint;
import lsedit.EntityClass;
import lsedit.EntityComponent;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeObject3D;
import lsedit.LandscapeViewerCore;
import lsedit.MsgOut;
import lsedit.MyUndoableEdit;
import lsedit.RealPoint;
import lsedit.RelRectangle;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ResultBox;
import lsedit.Util;

public class EntityInstance
extends LandscapeObject3D
implements Icon,
DiagramCoordinates,
MouseListener,
MouseMotionListener {
    public static final int SMALL_FONT = 0;
    public static final int REG_FONT = 1;
    public static final String LABEL_ID = "label";
    public static final String XPOSITION_ID = "x";
    public static final String YPOSITION_ID = "y";
    public static final String WIDTH_ID = "width";
    public static final String HEIGHT_ID = "height";
    public static final String XRELPOSITION_ID = "xrel";
    public static final String YRELPOSITION_ID = "yrel";
    public static final String WIDTHREL_ID = "widthrel";
    public static final String HEIGHTREL_ID = "heightrel";
    public static final String IN_ELISION_ID = "elision";
    public static final String OUT_ELISION_ID = "outelision";
    public static final String CLIENT_ELISION_ID = "clientelision";
    public static final String SUPPLIER_ELISION_ID = "supplierelision";
    public static final String INTERNAL_ELISION_ID = "internalelision";
    public static final String AGG_ELISION_ID = "aggelision";
    public static final String LINK_ID = "navlink";
    public static final String INPOINT_ID = "inpoints";
    public static final String OUTPOINT_ID = "outpoints";
    public static final String LEFTPOINT_ID = "leftpoints";
    public static final String RIGHTPOINT_ID = "rightpoints";
    public static final String DESC_ID = "description";
    public static final String TITLE_ID = "title";
    public static final String FONTDELTA_ID = "fontdelta";
    public static final int RSZ_NONE = -1;
    private static final int RSZ_NW = 0;
    private static final int RSZ_N = 1;
    private static final int RSZ_NE = 2;
    private static final int RSZ_E = 3;
    private static final int RSZ_SE = 4;
    private static final int RSZ_S = 5;
    private static final int RSZ_SW = 6;
    private static final int RSZ_W = 7;
    private static final int DEF_CONT_CAP = 35;
    private static final int ROOT_CONT_CAP = 1000;
    private static final double TAB_HEIGHT = 16.0;
    private static final int MOUSE_NEAR_EDGE_THRESHOLD = 4;
    private static final int SEP_THRESHOLD = 8;
    private static final int MARGIN = 5;
    private static final int MIN_HEIGHT = 10;
    private static final int MIN_WIDTH = 30;
    private static final int CONTENTS_FLAG_DIM = 8;
    private static final String OPEN_FAMILY = "Helvetica";
    private static final int OPEN_FONT_SIZE = 12;
    public static final Font openFont = new Font("Helvetica", 0, 12);
    private static final String CLOSED_FAMILY = "Helvetica";
    private static final int CLOSED_FONT_MIN_SIZE = 6;
    private static final int CLOSED_FONT_SMALL_SIZE = 10;
    private static final int NUM_FONTS = 25;
    public static final int START_FONT_NUM = 6;
    public static final Font smallFont = new Font("Helvetica", 0, 10);
    public static final int DIAGRAM_MARK = 1;
    public static final int CLIENT_MARK = 2;
    public static final int SUPPLIER_MARK = 4;
    public static final int HIGHLIGHT_EDGE_MARK = 4096;
    public static final int DRAW_CLIENT_MARK = 8192;
    public static final int DRAW_SUPPLIER_MARK = 16384;
    public static final int REDBOX_MARK = 32768;
    public static final int GROUP_MARK = 65536;
    public static final int GROUPKEY_MARK = 131072;
    public static final int OPEN_MARK = 262144;
    public static final int CLOSED_MARK = 524288;
    public static final int CLIENT_SUPPLIER = 6;
    public static final int IN_DIAGRAM = 7;
    public static final int PRESENTATION_MARKS = 233472;
    public static final int IN_TREE_MARK = 0x100000;
    public static final int LIFTED_MARK = 0x200000;
    private static EntityInstance m_currentDescEntity = null;
    public static Font[] closedFont = new Font[25];
    private int m_mark = 0;
    private String m_title;
    private Vector m_dstElision;
    private Vector m_srcElision;
    private Vector m_enteringElision;
    private Vector m_exitingElision;
    private Vector m_internalElision;
    private EdgePoint[] topPoints;
    private EdgePoint[] bottomPoints;
    private EdgePoint[] leftPoints;
    private EdgePoint[] rightPoints;
    private int m_diagramX = Integer.MIN_VALUE;
    private int m_diagramY = Integer.MIN_VALUE;
    private int m_x;
    private int m_y;
    private int m_width;
    private int m_height;
    protected double m_xrelLocal = 0.03125;
    protected double m_yrelLocal = 0.03125;
    protected double m_widthrelLocal = 0.9375;
    protected double m_heightrelLocal = 0.9375;
    private int m_fontDelta = 0;
    private int m_preorder;
    private int m_postorder;
    private EntityInstance m_containedBy;
    private Hashtable m_containsList;
    private Vector m_srcRelList = new Vector();
    private Vector m_dstRelList = new Vector();
    private Vector m_srcLiftedList = new Vector();
    private Vector m_dstLiftedList = new Vector();
    Rectangle tempLyt;
    private Cardinal[] m_dstCardinals;
    protected static Hashtable est = new Hashtable();
    protected String[] endSet = new String[]{".ss", ".dup", "__funcdef", "__funcdcl", "__vardef", "__vardcl", "__macro", "__struct", "__union", "__enum", "__type"};

    public EntityComponent neededPlainComponent() {
        EntityComponent entityComponent = (EntityComponent)this.getSwingObject();
        if (entityComponent == null) {
            entityComponent = new EntityComponent(this);
        }
        return entityComponent;
    }

    public EntityComponent neededComponent() {
        EntityComponent entityComponent = (EntityComponent)this.getSwingObject();
        if (entityComponent == null) {
            entityComponent = new EntityComponent(this);
            entityComponent.setToolTipText(this.getLabel());
            entityComponent.addMouseListener(this);
            entityComponent.addMouseMotionListener(this);
        }
        return entityComponent;
    }

    private Vector neededDstElision() {
        Vector dstElision = this.m_dstElision;
        if (dstElision == null) {
            this.m_dstElision = dstElision = new Vector();
        }
        return dstElision;
    }

    private Vector neededSrcElision() {
        Vector srcElision = this.m_srcElision;
        if (srcElision == null) {
            this.m_srcElision = srcElision = new Vector();
        }
        return srcElision;
    }

    private Vector neededEnteringElision() {
        Vector enteringElision = this.m_enteringElision;
        if (enteringElision == null) {
            this.m_enteringElision = enteringElision = new Vector();
        }
        return enteringElision;
    }

    private Vector neededExitingElision() {
        Vector exitingElision = this.m_exitingElision;
        if (exitingElision == null) {
            this.m_exitingElision = exitingElision = new Vector();
        }
        return exitingElision;
    }

    private Vector neededInternalElision() {
        Vector internalElision = this.m_internalElision;
        if (internalElision == null) {
            this.m_internalElision = internalElision = new Vector();
        }
        return internalElision;
    }

    public void removeAll() {
        JComponent entityComponent = this.getSwingObject();
        if (entityComponent != null) {
            entityComponent.removeAll();
        }
    }

    public void setVisible(boolean value) {
        if (value) {
            EntityComponent entityComponent = this.neededComponent();
            entityComponent.setVisible(true);
        } else {
            EntityComponent entityComponent = (EntityComponent)this.getSwingObject();
            if (entityComponent != null) {
                entityComponent.setVisible(false);
            }
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        JComponent entityComponent = this.getSwingObject();
        if (width <= 0 || height <= 0) {
            if (this.m_width > 0 && this.m_height > 0) {
                this.openStatusUnknown();
            }
        } else if (this.m_width <= 0 || this.m_height <= 0) {
            this.openStatusUnknown();
        }
        this.m_x = x;
        this.m_y = y;
        this.m_width = width;
        this.m_height = height;
        if (entityComponent != null) {
            entityComponent.setBounds(x, y, width, height);
        }
        this.rescaleChildren();
    }

    public void setBothBounds(int parentDiagramX, int parentDiagramY, int x, int y, int width, int height) {
        this.m_diagramX = parentDiagramX + x;
        this.m_diagramY = parentDiagramY + y;
        this.setBounds(x, y, width, height);
    }

    public void repaint() {
        JComponent entityComponent = this.getSwingObject();
        if (entityComponent != null) {
            entityComponent.repaint();
        }
    }

    public void validate() {
        JComponent entityComponent = this.getSwingObject();
        if (entityComponent != null) {
            entityComponent.validate();
        }
    }

    public void paintMap(Graphics g, int x, int y, int width, int height, EntityInstance onPath, int depth) {
        EntityComponent entityComponent = this.neededComponent();
        entityComponent.paintMap(g, x, y, width, height, onPath, depth);
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    protected EntityInstance getDrawRoot() {
        return this.getDiagram().getDrawRoot();
    }

    protected int numRelationClasses() {
        return this.getDiagram().numRelationClasses();
    }

    protected RelationClass numToRelationClass(int i) {
        return this.getDiagram().numToRelationClass(i);
    }

    protected void setFont(Graphics g, int type) {
        switch (type) {
            case 0: {
                g.setFont(smallFont);
                return;
            }
        }
        g.setFont(closedFont[6 + this.m_fontDelta]);
    }

    public int getFontDelta() {
        return this.m_fontDelta;
    }

    protected void setFontDelta(int fd) {
        this.m_fontDelta = Math.max(-6, Math.min(fd, 18));
        this.repaint();
    }

    public void updateFontDelta(int value) {
        if (value != this.m_fontDelta) {
            new UpdateFontDelta(this, value);
        }
    }

    public Color getCurrentLabelColor() {
        if (this.isMarked(32768) && !this.isOpen()) {
            return Color.yellow;
        }
        return this.getLabelColor();
    }

    protected void parsePoints(EdgePoint[] ept, Attribute attr) {
        AttributeValueItem avi = attr.avi;
        while (avi != null) {
            RelationClass rc = this.getDiagram().nameToRelationClass(avi.value);
            if (rc != null) {
                int nid = rc.getNid();
                double wf = Util.parseReal(avi.next.value);
                double hf = Util.parseReal(avi.next.next.value);
                if (ept[nid] == null) {
                    ept[nid] = new EdgePoint(this, rc, wf, hf);
                } else {
                    if (rc != ept[nid].getRc()) {
                        MsgOut.println("Class nid mismatch");
                    }
                    ept[nid].m_wf = wf;
                    ept[nid].m_hf = hf;
                }
                ept[nid].isDefault = false;
            }
            avi = avi.nextList;
        }
    }

    protected void processElision(Attribute attr, Vector list) {
        AttributeValueItem av = attr.avi;
        while (av != null) {
            String str = (String)est.get(av.value);
            if (str == null) {
                str = av.value;
                est.put(str, str);
            }
            if (!list.contains(str)) {
                list.addElement(str);
            }
            av = av.next;
        }
    }

    protected void processRawElision(String[] sl, Vector list) {
        for (int i = 0; i < sl.length; ++i) {
            list.addElement(sl[i]);
        }
    }

    protected boolean processFirstOrderAttributes(Attribute attr) {
        boolean hasVal;
        boolean bl = hasVal = attr.avi != null;
        if (attr.hasId(XPOSITION_ID)) {
            if (hasVal) {
                this.setxLocal(attr.parseReal());
                attr.id = XRELPOSITION_ID;
            }
            return true;
        }
        if (attr.hasId(YPOSITION_ID)) {
            if (hasVal) {
                this.setyLocal(attr.parseReal());
                attr.id = YRELPOSITION_ID;
            }
            return true;
        }
        if (attr.hasId(WIDTH_ID)) {
            if (hasVal) {
                this.setwidthLocal(attr.parseReal());
                attr.id = WIDTHREL_ID;
            }
            return true;
        }
        if (attr.hasId(HEIGHT_ID)) {
            if (hasVal) {
                this.setheightLocal(attr.parseReal());
                attr.id = HEIGHTREL_ID;
            }
            return true;
        }
        if (attr.hasId(XRELPOSITION_ID)) {
            if (hasVal) {
                this.setxRelLocal(attr.parseReal());
            }
            return true;
        }
        if (attr.hasId(YRELPOSITION_ID)) {
            if (hasVal) {
                this.setyRelLocal(attr.parseReal());
            }
            return true;
        }
        if (attr.hasId(WIDTHREL_ID)) {
            if (hasVal) {
                this.setwidthRelLocal(attr.parseReal());
            }
            return true;
        }
        if (attr.hasId(HEIGHTREL_ID)) {
            if (hasVal) {
                this.setheightRelLocal(attr.parseReal());
            }
            return true;
        }
        if (attr.hasId(LABEL_ID)) {
            if (hasVal) {
                this.setLabel(attr.parseString());
            }
            return true;
        }
        if (attr.hasId(DESC_ID)) {
            if (hasVal) {
                this.setDescription(attr.parseString());
            }
            return true;
        }
        if (attr.hasId(TITLE_ID)) {
            if (hasVal) {
                this.setTitle(attr.parseString());
            }
            return true;
        }
        if (attr.hasId(FONTDELTA_ID)) {
            if (hasVal) {
                this.setFontDelta(attr.parseInt());
            }
            return true;
        }
        if (attr.hasId("color")) {
            if (hasVal) {
                this.setObjectColor(attr.parseColour());
            }
            return true;
        }
        if (attr.hasId("opencolor")) {
            if (hasVal) {
                this.setColorWhenOpen(attr.parseColour());
            }
            return true;
        }
        if (attr.hasId("labelcolor")) {
            if (hasVal) {
                this.setLabelColor(attr.parseColour());
            }
            return true;
        }
        if (attr.hasId(IN_ELISION_ID)) {
            if (hasVal) {
                this.processElision(attr, this.neededDstElision());
            }
            return true;
        }
        if (attr.hasId(OUT_ELISION_ID)) {
            if (hasVal) {
                this.processElision(attr, this.neededSrcElision());
            }
            return true;
        }
        if (attr.hasId(CLIENT_ELISION_ID)) {
            if (hasVal) {
                this.processElision(attr, this.neededEnteringElision());
            }
            return true;
        }
        if (attr.hasId(SUPPLIER_ELISION_ID)) {
            if (hasVal) {
                this.processElision(attr, this.neededExitingElision());
            }
            return true;
        }
        if (attr.hasId(INTERNAL_ELISION_ID)) {
            if (hasVal) {
                this.processElision(attr, this.neededInternalElision());
            }
            return true;
        }
        if (attr.hasId(INPOINT_ID)) {
            if (hasVal) {
                if (this.topPoints == null) {
                    this.topPoints = new EdgePoint[this.numRelationClasses()];
                }
                this.parsePoints(this.topPoints, attr);
            }
            return true;
        }
        if (attr.hasId(OUTPOINT_ID)) {
            if (hasVal) {
                if (this.bottomPoints == null) {
                    this.bottomPoints = new EdgePoint[this.numRelationClasses()];
                }
                this.parsePoints(this.bottomPoints, attr);
            }
            return true;
        }
        if (attr.hasId(LEFTPOINT_ID)) {
            if (hasVal) {
                if (this.leftPoints == null) {
                    this.leftPoints = new EdgePoint[this.numRelationClasses()];
                }
                this.parsePoints(this.leftPoints, attr);
            }
            return true;
        }
        if (attr.hasId(RIGHTPOINT_ID)) {
            if (hasVal) {
                if (this.rightPoints == null) {
                    this.rightPoints = new EdgePoint[this.numRelationClasses()];
                }
                this.parsePoints(this.rightPoints, attr);
            }
            return true;
        }
        return false;
    }

    public RelRectangle getChildrenRelBoundingBox() {
        double x1 = 2.147483647E9;
        double x2 = -2.147483648E9;
        double y1 = 2.147483647E9;
        double y2 = -2.147483648E9;
        boolean seen = false;
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            seen = true;
            EntityInstance e = (EntityInstance)en.nextElement();
            double temp = e.xRelLocal();
            if (temp < x1) {
                x1 = temp;
            }
            if ((temp = e.yRelLocal()) < y1) {
                y1 = temp;
            }
            if ((temp = e.xRelLocal() + e.widthRelLocal()) > x2) {
                x2 = temp;
            }
            if (!((temp = e.yRelLocal() + e.heightRelLocal()) > y2)) continue;
            y2 = temp;
        }
        if (!seen) {
            MsgOut.dprintln("No children");
            return null;
        }
        return new RelRectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public String mungeId(String id) {
        if (id.length() > 0) {
            for (int i = 0; i < this.endSet.length; ++i) {
                if (!id.endsWith(this.endSet[i])) continue;
                id = id.substring(0, id.length() - this.endSet[i].length());
                break;
            }
            if (id.charAt(0) != '<') {
                int lpi = id.lastIndexOf(47);
                if (lpi < 0) {
                    lpi = id.lastIndexOf(92);
                }
                if (lpi >= 0 && id.length() != lpi + 1) {
                    return id.substring(lpi + 1);
                }
            }
        }
        return id;
    }

    public static void generateFonts() {
        for (int i = 0; i < 25; ++i) {
            EntityInstance.closedFont[i] = new Font("Helvetica", 0, 6 + i);
        }
    }

    public EntityInstance(EntityClass parentClass, String id) {
        this.setParentClass(parentClass);
        this.setLabel(this.mungeId(id));
        this.setId(id);
        this.m_containsList = new Hashtable(id.equals("$ROOT") ? 1000 : 35);
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public String getStyleName(int style) {
        return EntityClass.getEntityStyleName(style);
    }

    public void updateTitle(String title) {
        if (title == null ? this.m_title == null : title.equals(this.m_title)) {
            return;
        }
        new UpdateTitle(this, title);
    }

    public void deleteJustMe() {
        new UpdateDeleteJustMe(this);
    }

    public void disconnectEdgesJustMe(EntityInstance top) {
        EntityInstance other;
        RelationInstance ri;
        Enumeration en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            other = ri.getDst();
            if (top.hasDescendantOrSelf(other)) continue;
            other.removeDstRelation(ri);
        }
        en = this.m_dstRelList.elements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            other = ri.getSrc();
            if (top.hasDescendantOrSelf(other)) continue;
            other.removeSrcRelation(ri);
        }
    }

    public void disconnectEdges(EntityInstance top) {
        this.disconnectEdgesJustMe(top);
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.disconnectEdges(top);
        }
    }

    public void reconnectEdgesJustMe(EntityInstance top) {
        EntityInstance other;
        RelationInstance ri;
        Enumeration en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            other = ri.getDst();
            if (top.hasDescendantOrSelf(other)) continue;
            other.addDstRelation(ri);
        }
        en = this.m_dstRelList.elements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            other = ri.getSrc();
            if (top.hasDescendantOrSelf(other)) continue;
            other.addSrcRelation(ri);
        }
    }

    public void reconnectEdges(EntityInstance top) {
        this.reconnectEdgesJustMe(top);
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.reconnectEdges(top);
        }
    }

    public void updateDelete() {
        new UpdateDelete(this);
    }

    public void addContainment(EntityInstance e) {
        String id = e.getId();
        if (this.m_containsList.put(id, e) != null) {
            MsgOut.println("Entity " + this.getId() + " already contains " + id);
        } else {
            e.m_containedBy = this;
            if (e.inDiagram()) {
                EntityComponent entityComponent = this.neededComponent();
                EntityComponent childComponent = e.neededComponent();
                this.nandMark(786432);
                entityComponent.add(childComponent);
            }
        }
    }

    public boolean removeContainment(EntityInstance e) {
        String id = e.getId();
        if (this.m_containsList.containsKey(id)) {
            JComponent childComponent;
            JComponent entityComponent = this.getSwingObject();
            this.m_containsList.remove(id);
            if (entityComponent != null && (childComponent = e.getSwingObject()) != null) {
                entityComponent.remove(childComponent);
            }
            e.m_containedBy = null;
            e.m_mark = 0;
            return true;
        }
        MsgOut.println("Entity " + this.getId() + " doesn't contain " + id);
        return false;
    }

    public void moveEntityContainment(EntityInstance newContainer) {
        if (newContainer != this.m_containedBy) {
            new UpdateContainment(this, newContainer);
        }
    }

    public void addRelation(RelationInstance ri, EntityInstance dst) {
        this.addSrcRelation(ri);
        dst.addDstRelation(ri);
    }

    public RelationInstance getRelation(RelationClass rc, EntityInstance dst) {
        Enumeration en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            if (ri.getRelationClass() != rc || ri.getDst() != dst) continue;
            return ri;
        }
        return null;
    }

    public void addSrcRelation(RelationInstance ri) {
        this.m_srcRelList.addElement(ri);
    }

    public void removeSrcRelation(RelationInstance ri) {
        this.m_srcRelList.removeElement(ri);
    }

    public void addDstRelation(RelationInstance ri) {
        this.m_dstRelList.addElement(ri);
    }

    public void removeDstRelation(RelationInstance ri) {
        this.m_dstRelList.removeElement(ri);
    }

    public void addAttribute(Attribute attr) {
        if (this.processFirstOrderAttributes(attr)) {
            return;
        }
        super.addAttribute(attr);
    }

    public boolean addRawAttribute(String id, int val) {
        if (id.equals(FONTDELTA_ID)) {
            this.setFontDelta(val);
            return true;
        }
        return false;
    }

    public boolean addRawAttribute(String id, double val) {
        if (id.equals(XPOSITION_ID)) {
            this.setxLocal(val);
            return true;
        }
        if (id.equals(YPOSITION_ID)) {
            this.setyLocal(val);
            return true;
        }
        if (id.equals(WIDTH_ID)) {
            this.setwidthLocal(val);
            return true;
        }
        if (id.equals(HEIGHT_ID)) {
            this.setheightLocal(val);
            return true;
        }
        if (id.equals(XRELPOSITION_ID)) {
            this.setxRelLocal(val);
            return true;
        }
        if (id.equals(YRELPOSITION_ID)) {
            this.setyRelLocal(val);
            return true;
        }
        if (id.equals(WIDTHREL_ID)) {
            this.setwidthRelLocal(val);
            return true;
        }
        if (id.equals(HEIGHTREL_ID)) {
            this.setheightRelLocal(val);
            return true;
        }
        return false;
    }

    public boolean addRawAttribute(String id, String val) {
        if (id.equals(LABEL_ID)) {
            this.setLabel(val);
            return true;
        }
        if (id.equals(DESC_ID)) {
            this.setDescription(val);
            return true;
        }
        if (id.equals(TITLE_ID)) {
            this.setTitle(val);
            return true;
        }
        return super.addRawAttribute(id, val);
    }

    public boolean addRawAttribute(String id, int[] il) {
        return false;
    }

    public boolean addRawAttribute(String id, double[] dl) {
        if (id.equals("color")) {
            this.setObjectColor(new Color((float)dl[0], (float)dl[1], (float)dl[2]));
            return true;
        }
        if (id.equals("labelcolor")) {
            this.setLabelColor(new Color((float)dl[0], (float)dl[1], (float)dl[2]));
            return true;
        }
        if (id.equals("opencolor")) {
            this.setColorWhenOpen(new Color((float)dl[0], (float)dl[1], (float)dl[2]));
            return true;
        }
        return false;
    }

    public boolean addRawAttribute(String id, String[] sl) {
        if (id.equals(IN_ELISION_ID)) {
            this.processRawElision(sl, this.neededDstElision());
            return true;
        }
        if (id.equals(OUT_ELISION_ID)) {
            this.processRawElision(sl, this.neededSrcElision());
            return true;
        }
        if (id.equals(CLIENT_ELISION_ID)) {
            this.processRawElision(sl, this.neededEnteringElision());
            return true;
        }
        if (id.equals(SUPPLIER_ELISION_ID)) {
            this.processRawElision(sl, this.neededExitingElision());
            return true;
        }
        if (id.equals(INTERNAL_ELISION_ID)) {
            this.processRawElision(sl, this.neededInternalElision());
            return true;
        }
        return super.addRawAttribute(id, sl);
    }

    public void assignAttributes(Attribute attr) {
        while (attr != null) {
            if (attr.avi == null) {
                MsgOut.println("Null attribute assignment");
            } else if (!this.processFirstOrderAttributes(attr)) {
                Attribute attrVar = this.getLsAttribute(attr.id);
                if (attrVar == null) {
                    MsgOut.println("Missing attribute '" + attr.toString() + "'");
                } else {
                    if (attrVar.cloneOnAssign) {
                        attrVar = (Attribute)attrVar.clone();
                        attrVar.cloneOnAssign = false;
                        this.replaceAttribute(attrVar);
                    }
                    attrVar.avi = attr.avi;
                }
            }
            attr = attr.next;
        }
    }

    public void assignRelnAttributes(RelationClass rc, EntityInstance dst, Attribute attr) {
        System.out.println("Asgn: " + rc.getId() + " " + this.getId() + " " + dst.getId());
    }

    public void validateAllMyEdges() {
        RelationInstance ri;
        Enumeration en = this.srcLiftedRelationElements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            if (ri.m_drawSrc != this) {
                System.out.println("validateAllMyEdges() " + this + " drawsrc " + ri.m_drawSrc);
                continue;
            }
            ri.validate();
        }
        en = this.dstLiftedRelationElements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            if (ri.m_drawDst != this) {
                System.out.println("validateAllMyEdges() " + this + " drawdst " + ri.m_drawDst);
                continue;
            }
            ri.validate();
        }
    }

    protected void rescale(EdgePoint[] pts) {
        if (pts != null) {
            for (int i = 0; i < pts.length; ++i) {
                if (pts[i] == null) continue;
                pts[i].clearRc();
            }
        }
    }

    public void rescale(int parentDiagramX, int parentDiagramY, int parent_width, int parent_height) {
        int new_x = (int)((double)parent_width * this.m_xrelLocal);
        int new_y = (int)((double)parent_height * this.m_yrelLocal);
        int new_width = (int)((double)parent_width * this.m_widthrelLocal);
        int new_height = (int)((double)parent_height * this.m_heightrelLocal);
        this.setBothBounds(parentDiagramX, parentDiagramY, new_x, new_y, new_width, new_height);
    }

    public void rescaleChildren() {
        int width = this.getWidth();
        int height = this.getHeight();
        this.rescale(this.topPoints);
        this.rescale(this.bottomPoints);
        this.rescale(this.leftPoints);
        this.rescale(this.rightPoints);
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.rescale(this.m_diagramX, this.m_diagramY, width, height);
        }
    }

    public Rectangle getDiagramBounds() {
        return new Rectangle(this.getDiagramX(), this.getDiagramY(), this.getWidth(), this.getHeight());
    }

    protected void scale(double wf, double hf, boolean doContainer, boolean doPos) {
        if (doContainer) {
            double x1 = this.xRelLocal();
            double y1 = this.yRelLocal();
            double w1 = this.widthRelLocal() * wf;
            double h1 = this.heightRelLocal() * hf;
            if (doPos) {
                x1 *= wf;
                y1 *= hf;
            }
            if (x1 >= 0.0 && w1 > 0.0 && y1 >= 0.0 && h1 > 0.0 && x1 + w1 <= 1.0 && y1 + h1 <= 1.0) {
                this.updateRelLocal(x1, y1, w1, h1);
            }
            return;
        }
        RelRectangle bb = this.getChildrenRelBoundingBox();
        if (bb == null) {
            return;
        }
        bb.width *= wf;
        bb.height *= hf;
        if (doPos) {
            bb.x *= wf;
            bb.y *= hf;
        }
        if (bb.x >= 0.0 && bb.width > 0.0 && bb.y >= 0.0 && bb.height > 0.0 && bb.x + bb.width < 1.0 && bb.y + bb.height < 1.0) {
            Enumeration en = this.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                e.scale(wf, hf, true, true);
            }
        }
    }

    public void scale(double sf, boolean doContainer, boolean doPos) {
        this.scale(sf, sf, doContainer, doPos);
    }

    public void scale(double sf, boolean doContainer) {
        this.scale(sf, sf, doContainer, false);
    }

    public void scale(double sf) {
        this.scale(sf, sf, true, false);
    }

    public void scaleX(double sf, boolean doContainer, boolean doPos) {
        this.scale(sf, 1.0, doContainer, doPos);
    }

    public void scaleX(double sf, boolean doContainer) {
        this.scale(sf, 1.0, doContainer, false);
    }

    public void scaleX(double sf) {
        this.scale(sf, 1.0, true, false);
    }

    public void scaleY(double sf, boolean doContainer, boolean doPos) {
        this.scale(1.0, sf, doContainer, doPos);
    }

    public void scaleY(double sf, boolean doContainer) {
        this.scale(1.0, sf, doContainer, false);
    }

    public void scaleY(double sf) {
        this.scale(1.0, sf, true, false);
    }

    private void doFitScale(double dx, double dy, double wf, double hf) {
        this.updateRelLocal(this.xRelLocal() * wf + dx, this.yRelLocal() * hf - dy, dx + this.widthRelLocal() * wf, dy + this.heightRelLocal() * hf);
    }

    public void fitTo(boolean alwaysFit) {
        MsgOut.dprintln("Fit to: " + this.getId());
        if (this.widthRelLocal() == 0.0 || this.heightRelLocal() == 0.0) {
            this.m_containsList = new Hashtable();
        }
        if (this.m_containsList.size() == 0) {
            MsgOut.dprintln("No children");
            return;
        }
        RelRectangle bb = this.getChildrenRelBoundingBox();
        if (bb.width <= 0.0 || bb.height <= 0.0) {
            return;
        }
        if (!alwaysFit && bb.x >= 0.0 && bb.y >= 0.0 && bb.x + bb.width <= 1.0 && bb.y + bb.height <= 1.0) {
            return;
        }
        double scaleX = 13.0 / (15.0 * bb.width);
        double scaleY = 13.0 / (15.0 * bb.height);
        double dx = 0.06666666666666667 - scaleX * bb.x;
        double dy = 0.06666666666666667 - scaleY * bb.y;
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.doFitScale(dx, dy, scaleX, scaleY);
        }
        MsgOut.dprintln("Fit: " + scaleX + " " + scaleY);
    }

    public void deltaFont(int delta) {
        this.updateFontDelta(this.m_fontDelta + delta);
    }

    public Dimension getLabelDim(Graphics g, int type, boolean wParent) {
        EntityInstance pe;
        this.setFont(g, type);
        FontMetrics fm = g.getFontMetrics();
        int h = Do.fontHeight(fm);
        int w = fm.stringWidth(this.getLabel());
        if (wParent && (pe = this.getEnterableParent()) != null) {
            w = Math.max(fm.stringWidth(pe.getLabel() + " | "), w);
            h += h / 2;
        }
        return new Dimension(w, h);
    }

    public Dimension getLabelDim(Graphics g, int type) {
        return this.getLabelDim(g, type, false);
    }

    public Dimension getFitDim(Graphics g, int type, boolean wParent) {
        Dimension dim = this.getLabelDim(g, type, wParent);
        if (this.hasChildren() && !this.isOpen()) {
            dim.width += 8;
        }
        dim.width += 15;
        dim.height += 7;
        return dim;
    }

    public Dimension getFitDim(Graphics g, int type) {
        return this.getFitDim(g, type, false);
    }

    public void invalidateAllEdges() {
        RelationInstance ri;
        Enumeration en = this.srcLiftedRelationElements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            ri.invalidateEdge();
        }
        en = this.dstLiftedRelationElements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            ri.invalidateEdge();
        }
    }

    public void drawAllEdges(EntityInstance under) {
        RelationInstance ri;
        Enumeration en = this.srcLiftedRelationElements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            ri.draw(true);
        }
        en = this.dstLiftedRelationElements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            EntityInstance src = ri.m_drawSrc;
            if (under.hasDescendant(src)) continue;
            ri.draw(true);
        }
    }

    public void drawHighlightedEdges() {
        RelationInstance ri;
        Enumeration en = this.srcLiftedRelationElements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            ri.drawHighlighted();
        }
        en = this.dstLiftedRelationElements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            ri.drawHighlighted();
        }
    }

    public void getHighlightedEdges(Vector v) {
        RelationInstance ri;
        Enumeration en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            if (!ri.getHighlightFlag() || !ri.getRelationClass().isActive()) continue;
            v.addElement(ri);
        }
        EntityInstance root = this.getDrawRoot();
        en = this.m_dstRelList.elements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            EntityInstance src = ri.getSrc();
            if (root.hasDescendant(src) || !ri.getHighlightFlag() || !ri.getRelationClass().isActive()) continue;
            v.addElement(ri);
        }
        en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.getHighlightedEdges(v);
        }
    }

    public void getInstancesRaw(Vector v, Hashtable st) {
        Integer[] pair = new Integer[]{(Integer)st.get(this.getId()), (Integer)st.get(this.getParentClass().getId())};
        v.addElement(pair);
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            child.getInstancesRaw(v, st);
        }
    }

    public void getRelationsRaw(Vector v, Hashtable st, Integer cid) {
        Integer[] triple;
        Enumeration en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            triple = new Integer[3];
            RelationClass rc = ri.getRelationClass();
            EntityInstance e1 = ri.getSrc();
            EntityInstance e2 = ri.getDst();
            triple[0] = (Integer)st.get(rc.getId());
            triple[1] = (Integer)st.get(e1.getId());
            triple[2] = (Integer)st.get(e2.getId());
            v.addElement(triple);
        }
        en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            if (!this.isRoot()) {
                triple = new Integer[]{cid, (Integer)st.get(this.getId()), (Integer)st.get(child.getId())};
                v.addElement(triple);
            }
            child.getRelationsRaw(v, st, cid);
        }
    }

    public void writeInstances(PrintStream ps) throws IOException {
        if (!this.isRoot()) {
            ps.print("$INSTANCE " + this.qt(this.getId()) + " " + this.qt(this.getParentClass().getId()) + "\n");
        }
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            child.writeInstances(ps);
        }
    }

    public void writeRelations(PrintStream ps) throws IOException {
        Enumeration en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            ri.writeRelation(ps);
        }
        en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            if (!this.isRoot()) {
                ps.print("contain " + this.qt(this.getId()) + " " + this.qt(child.getId()) + "\n");
            }
            child.writeRelations(ps);
        }
    }

    protected void writeLayout(PrintStream ps) throws IOException {
        ps.print(" xrel      = " + this.xRelLocal() + "\n");
        ps.print(" yrel      = " + this.yRelLocal() + "\n");
        ps.print(" widthrel  = " + this.widthRelLocal() + "\n");
        ps.print(" heightrel = " + this.heightRelLocal() + "\n");
    }

    protected void writeElision(PrintStream ps, Vector ev, String id) {
        if (ev != null && ev.size() > 0) {
            ps.print(" " + id + " = (");
            Enumeration en = ev.elements();
            while (en.hasMoreElements()) {
                String rcId = (String)en.nextElement();
                ps.print(rcId);
                if (!en.hasMoreElements()) continue;
                ps.print(" ");
            }
            ps.print(")\n");
        }
    }

    protected void writePoints(PrintStream ps, EdgePoint[] pts, String name) {
        int i;
        if (pts == null) {
            return;
        }
        boolean isDefault = true;
        for (i = 1; i < pts.length; ++i) {
            if (pts[i] == null) continue;
            isDefault = isDefault && pts[i].isDefault;
        }
        if (isDefault) {
            return;
        }
        ps.print("\t" + name + " = ( ");
        for (i = 1; i < pts.length; ++i) {
            if (pts[i] == null || pts[i].isDefault) continue;
            ps.print("(" + pts[i].getRc().getId() + " " + pts[i].m_wf + " " + pts[i].m_hf + ") ");
        }
        ps.print(")\n");
    }

    protected void regRawElision(Vector v, Hashtable st, Vector ev, String id) {
        if (ev != null && ev.size() > 0) {
            int len = ev.size();
            String[] sl = new String[len];
            for (int i = 0; i < len; ++i) {
                sl[i] = (String)ev.elementAt(i);
            }
            this.regRawAttribute(v, st, id, sl);
        }
    }

    public void writeAttributes(PrintStream ps) throws IOException {
        String description;
        LandscapeClassObject parentClass = this.getParentClass();
        ps.print(this.qt(this.getId()) + " {\n");
        this.writeLayout(ps);
        String label = this.getLabel();
        if (!(label == null || label.equals(this.mungeId(this.getId())) || !this.isRoot() && parentClass.defaultValue(LABEL_ID, label))) {
            ps.print(" label = " + this.qt(label) + "\n");
        }
        if ((description = this.getDescription()) != null && (this.isRoot() || !parentClass.defaultValue(DESC_ID, description))) {
            ps.print(" description = \"" + description + "\"\n");
        }
        if (!this.isRoot()) {
            this.writeElision(ps, this.m_dstElision, IN_ELISION_ID);
            this.writeElision(ps, this.m_srcElision, OUT_ELISION_ID);
            this.writeElision(ps, this.m_enteringElision, CLIENT_ELISION_ID);
            this.writeElision(ps, this.m_exitingElision, SUPPLIER_ELISION_ID);
            this.writeElision(ps, this.m_internalElision, INTERNAL_ELISION_ID);
            this.writePoints(ps, this.topPoints, INPOINT_ID);
            this.writePoints(ps, this.bottomPoints, OUTPOINT_ID);
            this.writePoints(ps, this.leftPoints, LEFTPOINT_ID);
            this.writePoints(ps, this.rightPoints, RIGHTPOINT_ID);
            if (this.m_fontDelta != 0) {
                ps.print(" fontdelta = ");
                ps.print(this.m_fontDelta + "\n");
            }
        }
        super.writeAttributes(ps, parentClass, false);
        ps.print("}\n");
        Enumeration en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            ri.writeAttributes(ps);
        }
        en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            child.writeAttributes(ps);
        }
    }

    public void getLsAttributesRaw(Vector mv, Hashtable st) {
        String description;
        Vector v = new Vector();
        this.regRawAttribute(v, st, XRELPOSITION_ID, this.m_xrelLocal);
        this.regRawAttribute(v, st, YRELPOSITION_ID, this.m_yrelLocal);
        this.regRawAttribute(v, st, WIDTHREL_ID, this.m_widthrelLocal);
        this.regRawAttribute(v, st, HEIGHTREL_ID, this.m_heightrelLocal);
        String label = this.getLabel();
        if (label != null && !label.equals(this.mungeId(this.getId()))) {
            this.regRawAttribute(v, st, LABEL_ID, label);
        }
        if ((description = this.getDescription()) != null) {
            this.regRawAttribute(v, st, DESC_ID, description);
        }
        if (!this.isRoot()) {
            LandscapeClassObject parentClass = this.getParentClass();
            Color pc = parentClass.getObjectColor();
            Color color1 = this.getObjectColor();
            if (!color1.equals(pc)) {
                this.regRawAttribute(v, st, "color", color1);
            }
            pc = parentClass.getLabelColor();
            Color labelcolor1 = this.getLabelColor();
            if (!labelcolor1.equals(pc)) {
                this.regRawAttribute(v, st, "labelcolor", labelcolor1);
            }
            if ((color1 = this.getColorWhenOpen()) != null) {
                this.regRawAttribute(v, st, "opencolor", labelcolor1);
            }
            this.regRawElision(v, st, this.m_dstElision, IN_ELISION_ID);
            this.regRawElision(v, st, this.m_srcElision, OUT_ELISION_ID);
            this.regRawElision(v, st, this.m_enteringElision, OUT_ELISION_ID);
            this.regRawElision(v, st, this.m_exitingElision, SUPPLIER_ELISION_ID);
            this.regRawElision(v, st, this.m_internalElision, INTERNAL_ELISION_ID);
            if (this.m_fontDelta != 0) {
                this.regRawAttribute(v, st, FONTDELTA_ID, this.m_fontDelta);
            }
        }
        if (this.getLsAttributesSize() > 0) {
            super.getLsAttributesRaw(v, st, false);
        }
        Object[] obj = new Object[]{st.get(this.getId()), v};
        mv.addElement(obj);
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            child.getLsAttributesRaw(mv, st);
        }
    }

    public boolean canOpen() {
        return !this.m_containsList.isEmpty();
    }

    public void setOpen() {
        if (!this.isMarked(262144)) {
            this.nandMark(524288);
            this.orMark(262144);
        }
    }

    public void setClosed() {
        if (!this.isMarked(524288)) {
            this.nandMark(262144);
            this.orMark(524288);
        }
    }

    public void openStatusUnknown() {
        this.nandMark(786432);
    }

    public boolean isOpen() {
        if (!this.isMarked(786432)) {
            if (this.canOpen() && this.getWidth() > 0 && this.getHeight() > 0 && !this.isDstRelationElided("contain")) {
                this.setOpen();
            } else {
                this.setClosed();
            }
        }
        return this.isMarked(262144);
    }

    public boolean red_closed() {
        return this.isMarked(32768) && !this.isOpen();
    }

    public boolean red_open() {
        return this.isMarked(32768) && this.isOpen();
    }

    public boolean close_with_children_under_drawroot() {
        return !this.isOpen() && this.hasChildren() && !this.isMarked(6);
    }

    public EntityInstance getContainedBy() {
        return this.m_containedBy;
    }

    public EntityInstance getEnterableParent() {
        EntityInstance e = this.m_containedBy;
        while (e != null && !e.isEnterable()) {
            e = e.m_containedBy;
        }
        return e;
    }

    public EntityClass getEntityClass() {
        return (EntityClass)this.getParentClass();
    }

    public boolean isRoot() {
        return this.m_containedBy == null;
    }

    public boolean hasChildren() {
        return !this.m_containsList.isEmpty();
    }

    public int numChildren() {
        return this.m_containsList.size();
    }

    public Enumeration getChildren() {
        return this.m_containsList.elements();
    }

    public String toString() {
        return this.getLabel();
    }

    public void setDiagramBounds(int diagramX, int diagramY, int width, int height) {
        double heightRel;
        double yRel;
        double widthRel;
        double xRel;
        this.m_diagramX = diagramX;
        this.m_diagramY = diagramY;
        double width1 = this.parentsWidth();
        double height1 = this.parentsHeight();
        if (width1 <= 0.0) {
            xRel = 0.0;
            widthRel = 0.0;
        } else {
            xRel = (double)(diagramX - this.getParentDiagramX()) / width1;
            widthRel = (double)width / width1;
        }
        if (height1 <= 0.0) {
            yRel = 0.0;
            heightRel = 0.0;
        } else {
            yRel = (double)(diagramY - this.getParentDiagramY()) / height1;
            heightRel = (double)height / height1;
        }
        this.updateRelLocal(xRel, yRel, widthRel, heightRel);
        this.setBounds(diagramX - this.getParentDiagramX(), diagramY - this.getParentDiagramY(), width, height);
        this.validateAllMyEdges();
        this.moveCardinals();
    }

    public void setDiagramBounds(Rectangle lyt) {
        this.setDiagramBounds(lyt.x, lyt.y, lyt.width, lyt.height);
    }

    public Rectangle getChildBoundingBox() {
        if (this.m_containsList.isEmpty()) {
            return null;
        }
        int x1 = Integer.MAX_VALUE;
        int x2 = Integer.MIN_VALUE;
        int y1 = Integer.MAX_VALUE;
        int y2 = Integer.MIN_VALUE;
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            if (e.getX() < x1) {
                x1 = e.getX();
            }
            if (e.getY() < y1) {
                y1 = e.getY();
            }
            if (e.getX() + e.getWidth() > x2) {
                x2 = e.getX() + e.getWidth();
            }
            if (e.getY() + e.getHeight() <= y2) continue;
            y2 = e.getY() + e.getHeight();
        }
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public Color getBackgroundWhenOpen() {
        Color c = this.getColorWhenOpen();
        if (c == null) {
            EntityInstance root;
            float v = 0.7f;
            EntityInstance b = this;
            if (this.isTransparent()) {
                b = b.m_containedBy;
            }
            if (!(root = this.getDrawRoot()).hasDescendant(this)) {
                root = root.commonAncestor(this);
            }
            while (b != root) {
                v -= 0.05f;
                b = b.m_containedBy;
            }
            c = new Color(v, v, v);
            if (Util.isBlack(c)) {
                c = Color.lightGray;
            }
        }
        return c;
    }

    public Color getCurrentObjectColor() {
        Color c = this.isOpen() ? this.getBackgroundWhenOpen() : this.getObjectColor();
        return c;
    }

    public boolean isRelationElided(Vector v, String id) {
        return v != null && v.contains(id);
    }

    protected boolean toggleElision(Vector v, String id) {
        if (this.isRelationElided(v, id)) {
            if (!v.removeElement(id)) {
                MsgOut.println("remove() failed");
            }
            return false;
        }
        v.addElement(id);
        return true;
    }

    public boolean toggleDstElision(String id) {
        MsgOut.dprintln("toggle target " + id);
        return this.toggleElision(this.neededDstElision(), id);
    }

    public void toggleContainElision() {
        this.toggleDstElision("contain");
        this.openStatusUnknown();
    }

    public void setContainElision() {
        if (this.canOpen() && !this.isDstRelationElided("contain")) {
            this.neededDstElision().addElement("contain");
            this.openStatusUnknown();
        }
    }

    public void clearContainElision() {
        if (this.m_dstElision != null) {
            this.m_dstElision.removeElement("contain");
        }
    }

    public boolean toggleDstElision(RelationClass rc) {
        return this.toggleDstElision(rc.getId());
    }

    public boolean toggleSrcElision(String id) {
        MsgOut.dprintln("toggle out " + id);
        return this.toggleElision(this.neededSrcElision(), id);
    }

    public boolean toggleSrcElision(RelationClass rc) {
        return this.toggleSrcElision(rc.getId());
    }

    public boolean toggleEnteringElision(String id) {
        MsgOut.dprintln("toggle client " + id);
        return this.toggleElision(this.neededEnteringElision(), id);
    }

    public boolean toggleEnteringElision(RelationClass rc) {
        return this.toggleEnteringElision(rc.getId());
    }

    public boolean toggleExitingElision(String id) {
        MsgOut.dprintln("toggle exiting " + id);
        return this.toggleElision(this.neededExitingElision(), id);
    }

    public boolean toggleExitingElision(RelationClass rc) {
        return this.toggleExitingElision(rc.getId());
    }

    public boolean toggleInternalElision(String id) {
        MsgOut.dprintln("toggle internal " + id);
        return this.toggleElision(this.neededInternalElision(), id);
    }

    public boolean toggleInternalElision(RelationClass rc) {
        return this.toggleInternalElision(rc.getId());
    }

    public boolean isDstRelationElided(RelationClass rc) {
        return this.isRelationElided(this.m_dstElision, rc.getId());
    }

    public boolean isDstRelationElided(String id) {
        return this.isRelationElided(this.m_dstElision, id);
    }

    public boolean isSrcRelationElided(RelationClass rc) {
        return this.isRelationElided(this.m_srcElision, rc.getId());
    }

    public boolean isSrcRelationElided(String id) {
        return this.isRelationElided(this.m_srcElision, id);
    }

    public boolean isEnteringRelationElided(RelationClass rc) {
        return this.isRelationElided(this.m_enteringElision, rc.getId());
    }

    public boolean isEnteringRelationElided(String id) {
        return this.isRelationElided(this.m_enteringElision, id);
    }

    public boolean isExitingRelationElided(RelationClass rc) {
        return this.isRelationElided(this.m_exitingElision, rc.getId());
    }

    public boolean isExitingRelationElided(String id) {
        return this.isRelationElided(this.m_exitingElision, id);
    }

    public boolean isInternalRelationElided(RelationClass rc) {
        return this.isRelationElided(this.m_internalElision, rc.getId());
    }

    public boolean isInternalRelationElided(String id) {
        return this.isRelationElided(this.m_internalElision, id);
    }

    public int getPostorder() {
        return this.m_postorder;
    }

    public boolean hasAncestor(EntityInstance e) {
        if (this.m_preorder == 0 || e.m_preorder == 0 || this.m_postorder == 0 || e.m_postorder == 0) {
            System.out.println("EntityInstance.hasAncestor error " + this + "(" + this.m_preorder + "," + this.m_postorder + ") " + e + "(" + e.m_preorder + "," + e.m_postorder + ")");
        }
        return e.m_preorder < this.m_preorder && this.m_postorder < e.m_postorder;
    }

    public boolean hasDescendant(EntityInstance e) {
        if (this.m_preorder == 0 || e.m_preorder == 0 || this.m_postorder == 0 || e.m_postorder == 0) {
            System.out.println("EntityInstance.hasDescendant error " + this + "(" + this.m_preorder + "," + this.m_postorder + ") " + e + "(" + e.m_preorder + "," + e.m_postorder + ")");
        }
        return this.m_preorder < e.m_preorder && e.m_postorder < this.m_postorder;
    }

    public boolean hasDescendantOrSelf(EntityInstance e) {
        if (this.m_preorder == 0 || e.m_preorder == 0 || this.m_postorder == 0 || e.m_postorder == 0) {
            System.out.println("EntityInstance.hasDescendant error " + this + "(" + this.m_preorder + "," + this.m_postorder + ") " + e + "(" + e.m_preorder + "," + e.m_postorder + ")");
        }
        return this.m_preorder <= e.m_preorder && e.m_postorder <= this.m_postorder;
    }

    public boolean isPathBetween(EntityInstance e) {
        if (this.m_preorder == 0 || e.m_preorder == 0 || this.m_postorder == 0 || e.m_postorder == 0) {
            System.out.println("EntityInstance.isPathBetween error " + this + "(" + this.m_preorder + "," + this.m_postorder + ") " + e + "(" + e.m_preorder + "," + e.m_postorder + ")");
        }
        return this.m_preorder <= e.m_preorder && e.m_postorder <= this.m_postorder || e.m_preorder < this.m_preorder && this.m_postorder < e.m_postorder;
    }

    public EntityInstance commonAncestor(EntityInstance e) {
        EntityInstance e1 = this.m_containedBy;
        while (e1 != null && !e1.hasDescendant(e)) {
            e1 = e1.m_containedBy;
        }
        return e1;
    }

    public EntityInstance clientServer() {
        EntityInstance e1 = this;
        while (e1 != null && !e1.isMarked(6)) {
            e1 = e1.m_containedBy;
        }
        return e1;
    }

    public boolean inDiagram() {
        return this.isMarked(7);
    }

    public EntityInstance getVisibleEntity() {
        EntityInstance e = this;
        while (e != null && !this.inDiagram()) {
            e = e.m_containedBy;
        }
        return e;
    }

    public EntityInstance getMouseOver(int x, int y) {
        JComponent entityComponent = this.getSwingObject();
        if (entityComponent != null && entityComponent.contains(x, y)) {
            if (this.isOpen()) {
                Enumeration en = this.getChildren();
                while (en.hasMoreElements()) {
                    EntityInstance e = (EntityInstance)en.nextElement();
                    EntityInstance over = e.getMouseOver(x, y);
                    if (over == null) continue;
                    return over;
                }
            }
            return this;
        }
        return null;
    }

    public EntityInstance intersects(Rectangle lyt) {
        if (this.containsRectangle(lyt)) {
            if (!this.m_containsList.isEmpty()) {
                Enumeration en = this.getChildren();
                while (en.hasMoreElements()) {
                    EntityInstance e = (EntityInstance)en.nextElement();
                    EntityInstance oe = e.intersects(lyt);
                    if (oe == null) continue;
                    return oe;
                }
                return null;
            }
            return this;
        }
        if (this.intersectsLayout(lyt)) {
            return this;
        }
        return null;
    }

    public EntityInstance containing(Rectangle lyt) {
        if (this.containsRectangle(lyt)) {
            if (!this.m_containsList.isEmpty() && this.isOpen()) {
                Enumeration en = this.getChildren();
                while (en.hasMoreElements()) {
                    EntityInstance e = (EntityInstance)en.nextElement();
                    EntityInstance oe = e.containing(lyt);
                    if (oe == null) continue;
                    return oe;
                }
            }
            return this;
        }
        return null;
    }

    public Enumeration srcRelationElements() {
        return this.m_srcRelList.elements();
    }

    public Enumeration dstRelationElements() {
        return this.m_dstRelList.elements();
    }

    public Enumeration srcLiftedRelationElements() {
        return this.m_srcLiftedList.elements();
    }

    public Enumeration dstLiftedRelationElements() {
        return this.m_dstLiftedList.elements();
    }

    protected void addSrcRels(Vector v) {
        Enumeration en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            v.addElement(en.nextElement());
        }
        en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.addSrcRels(v);
        }
    }

    public Enumeration srcRelationAbstractedElements() {
        Vector v = new Vector();
        this.addSrcRels(v);
        return v.elements();
    }

    protected void addDstRels(Vector v) {
        Enumeration en = this.m_dstRelList.elements();
        while (en.hasMoreElements()) {
            v.addElement(en.nextElement());
        }
        en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.addDstRels(v);
        }
    }

    public Enumeration dstRelationAbstractedElements() {
        Vector v = new Vector();
        this.addDstRels(v);
        return v.elements();
    }

    public Vector groupRegion(Rectangle lyt) {
        if (this.m_containsList.isEmpty()) {
            return null;
        }
        Vector<EntityInstance> grp = new Vector<EntityInstance>();
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            if (!e.intersectsLayout(lyt)) continue;
            e.setGroupFlag();
            grp.addElement(e);
        }
        if (grp.isEmpty()) {
            return null;
        }
        return grp;
    }

    public void getGroup(Vector grp) {
        if (this.getGroupFlag()) {
            grp.addElement(this);
        }
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.getGroup(grp);
        }
    }

    protected void setGroupFlag() {
        if (!this.isMarked(65536)) {
            this.orMark(65536);
            this.repaint();
        }
    }

    protected void clearGroupFlag() {
        if (this.isMarked(196608)) {
            this.nandMark(196608);
            this.repaint();
        }
    }

    public boolean getGroupFlag() {
        return this.isMarked(65536);
    }

    protected void setGroupKeyFlag() {
        if (!this.isMarked(131072)) {
            this.orMark(131072);
            this.repaint();
        }
    }

    protected void clearGroupKeyFlag() {
        if (this.isMarked(131072)) {
            this.nandMark(131072);
            this.repaint();
        }
    }

    public boolean getGroupKeyFlag() {
        return this.isMarked(131072);
    }

    public void getRedBoxGroup(Vector grp) {
        if (this.isMarked(32768)) {
            grp.addElement(this);
        }
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.getRedBoxGroup(grp);
        }
    }

    public void setRedBoxFlag() {
        if (!this.isMarked(32768)) {
            this.orMark(32768);
            this.repaint();
        }
    }

    public void clearRedBoxFlag() {
        if (this.isMarked(32768)) {
            this.nandMark(32768);
            this.repaint();
        }
    }

    public void clearAllFlags() {
        this.clearGroupFlag();
        this.clearGroupKeyFlag();
        this.clearRedBoxFlag();
        this.openStatusUnknown();
        Enumeration en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            ri.clearHighlightFlag();
            ri.clearGroupFlag();
        }
        en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.clearAllFlags();
        }
    }

    public void clearQueryFlags() {
        this.clearRedBoxFlag();
        Enumeration en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            ri.clearHighlightFlag();
        }
        en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.clearQueryFlags();
        }
    }

    public void clearGroupFlags() {
        this.clearGroupFlag();
        this.clearGroupKeyFlag();
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.clearGroupFlags();
        }
    }

    public boolean isClippedLabel() {
        return this.getWidth() < 30 || this.getHeight() < 10;
    }

    public boolean isClickable() {
        return true;
    }

    public void orMark(int val) {
        this.m_mark |= val;
    }

    public void andMark(int val) {
        this.m_mark &= val;
    }

    public void nandMark(int val) {
        this.m_mark &= ~val;
    }

    public boolean isMarked(int val) {
        return (this.m_mark & val) != 0;
    }

    public int getMark() {
        return this.m_mark;
    }

    public boolean isClient() {
        return this.isMarked(2);
    }

    public boolean isSupplier() {
        return this.isMarked(4);
    }

    public boolean isClientOrSupplier() {
        return this.isMarked(6);
    }

    public static Font getSmallFont() {
        return smallFont;
    }

    public double parentsWidthLocal() {
        if (this.m_containedBy == null) {
            return this.getDiagram().getWidth();
        }
        return this.m_containedBy.parentsWidthLocal() * this.m_containedBy.widthRelLocal();
    }

    public double parentsHeightLocal() {
        if (this.m_containedBy == null) {
            return this.getDiagram().getHeight();
        }
        return this.m_containedBy.parentsHeightLocal() * this.m_containedBy.heightRelLocal();
    }

    public double parentsWidth() {
        if (this.m_containedBy == null) {
            return this.getDiagram().getWidth();
        }
        return this.m_containedBy.getWidth();
    }

    public double parentsHeight() {
        if (this.m_containedBy == null) {
            return this.getDiagram().getHeight();
        }
        return this.m_containedBy.getHeight();
    }

    public double xRelLocal() {
        return this.m_xrelLocal;
    }

    public double yRelLocal() {
        return this.m_yrelLocal;
    }

    public double widthRelLocal() {
        return this.m_widthrelLocal;
    }

    public double heightRelLocal() {
        return this.m_heightrelLocal;
    }

    public void setxRelLocal(double xRelLocal) {
        this.m_xrelLocal = xRelLocal >= 0.0 ? xRelLocal : 0.0;
    }

    public void updatexRelLocal(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value != this.m_xrelLocal) {
            new UpdateXRelLocal(this, value);
        }
    }

    public void setyRelLocal(double yRelLocal) {
        this.m_yrelLocal = yRelLocal >= 0.0 ? yRelLocal : 0.0;
    }

    public void updateyRelLocal(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value != this.m_yrelLocal) {
            new UpdateYRelLocal(this, value);
        }
    }

    public void setwidthRelLocal(double widthRelLocal) {
        if (widthRelLocal > 1.0) {
            widthRelLocal = 1.0;
        }
        if (this.m_xrelLocal + widthRelLocal > 1.0) {
            this.m_xrelLocal = 1.0 - widthRelLocal;
        }
        this.m_widthrelLocal = widthRelLocal;
    }

    public void updatewidthRelLocal(double value) {
        if (value > 1.0) {
            value = 1.0;
        }
        if (this.m_xrelLocal + value > 1.0) {
            this.updatexRelLocal(1.0 - value);
        }
        if (value != this.m_widthrelLocal) {
            new UpdateWidthRelLocal(this, value);
        }
    }

    public void setheightRelLocal(double heightRelLocal) {
        if (heightRelLocal > 1.0) {
            heightRelLocal = 1.0;
        }
        if (this.m_yrelLocal + heightRelLocal > 1.0) {
            this.m_yrelLocal = 1.0 - heightRelLocal;
        }
        this.m_heightrelLocal = heightRelLocal;
    }

    public void updateheightRelLocal(double value) {
        if (value > 1.0) {
            value = 1.0;
        }
        if (this.m_yrelLocal + value > 1.0) {
            this.updateyRelLocal(1.0 - value);
        }
        if (value != this.m_heightrelLocal) {
            new UpdateHeightRelLocal(this, value);
        }
    }

    public void updateRelLocal(double x, double y, double width, double height) {
        if (x < 0.0) {
            x = 0.0;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if (width > 1.0) {
            width = 1.0;
        }
        if (height > 1.0) {
            height = 1.0;
        }
        if (x + width > 1.0) {
            x = 1.0 - width;
        }
        if (y + height > 1.0) {
            y = 1.0 - height;
        }
        new UpdateRelLocal(this, x, y, width, height);
    }

    public void computeRelCoordinates(double xParent, double yParent, double widthParent, double heightParent) {
        double xLocal = this.m_xrelLocal;
        double yLocal = this.m_yrelLocal;
        double widthLocal = this.m_widthrelLocal;
        double heightLocal = this.m_heightrelLocal;
        if (widthParent == 0.0) {
            this.m_xrelLocal = 0.0;
            this.m_widthrelLocal = 0.0;
        } else {
            this.m_xrelLocal = xLocal / widthParent;
            this.m_widthrelLocal = widthLocal / widthParent;
        }
        if (heightParent == 0.0) {
            this.m_yrelLocal = 0.0;
            this.m_heightrelLocal = 0.0;
        } else {
            this.m_yrelLocal = yLocal / heightParent;
            this.m_heightrelLocal = heightLocal / heightParent;
        }
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.computeRelCoordinates(xLocal, yLocal, widthLocal, heightLocal);
        }
    }

    public void setxLocal(double xLocal) {
        this.getDiagram().m_uses_local_coordinates = true;
        this.m_xrelLocal = xLocal;
    }

    public void setyLocal(double yLocal) {
        this.getDiagram().m_uses_local_coordinates = true;
        this.m_yrelLocal = yLocal;
    }

    public void setwidthLocal(double widthLocal) {
        this.getDiagram().m_uses_local_coordinates = true;
        this.m_widthrelLocal = widthLocal;
    }

    public void setheightLocal(double heightLocal) {
        this.getDiagram().m_uses_local_coordinates = true;
        this.m_heightrelLocal = heightLocal;
    }

    public int getPrimaryAttributeCount() {
        return 13;
    }

    public String getLsAttributeNameAt(int index) {
        String name;
        switch (index) {
            case 0: {
                name = "id";
                break;
            }
            case 1: {
                name = "class";
                break;
            }
            case 2: {
                name = LABEL_ID;
                break;
            }
            case 3: {
                name = TITLE_ID;
                break;
            }
            case 4: {
                name = DESC_ID;
                break;
            }
            case 5: {
                name = "color";
                break;
            }
            case 6: {
                name = "labelcolor";
                break;
            }
            case 7: {
                name = "opencolor";
                break;
            }
            case 8: {
                name = XRELPOSITION_ID;
                break;
            }
            case 9: {
                name = YRELPOSITION_ID;
                break;
            }
            case 10: {
                name = WIDTHREL_ID;
                break;
            }
            case 11: {
                name = HEIGHTREL_ID;
                break;
            }
            case 12: {
                name = FONTDELTA_ID;
                break;
            }
            default: {
                name = super.getLsAttributeNameAt(index);
            }
        }
        return name;
    }

    public Object getLsAttributeValueAt(int index) {
        Object value;
        switch (index) {
            case 0: {
                value = this.getId();
                break;
            }
            case 1: {
                LandscapeClassObject parentClass = this.getParentClass();
                if (parentClass == null) {
                    value = null;
                    break;
                }
                value = parentClass.getId();
                break;
            }
            case 2: {
                value = this.getLabel();
                break;
            }
            case 3: {
                value = this.getTitle();
                break;
            }
            case 4: {
                value = this.getDescription();
                break;
            }
            case 5: {
                if (this.hasObjectColor()) {
                    value = this.getObjectColor();
                    break;
                }
                value = null;
                break;
            }
            case 6: {
                if (this.hasLabelColor()) {
                    value = this.getLabelColor();
                    break;
                }
                value = null;
                break;
            }
            case 7: {
                if (this.hasColorWhenOpen()) {
                    value = this.getColorWhenOpen();
                    break;
                }
                value = null;
                break;
            }
            case 8: {
                value = new Double(this.xRelLocal());
                break;
            }
            case 9: {
                value = new Double(this.yRelLocal());
                break;
            }
            case 10: {
                value = new Double(this.widthRelLocal());
                break;
            }
            case 11: {
                value = new Double(this.heightRelLocal());
                break;
            }
            case 12: {
                value = new Integer(this.m_fontDelta);
                break;
            }
            default: {
                value = super.getLsAttributeValueAt(index);
            }
        }
        return value;
    }

    public void setAttributeValueAt(int index, Object value) {
        block0 : switch (index) {
            case 0: {
                this.setId((String)value);
                break;
            }
            case 1: {
                if (value == null) break;
                LandscapeClassObject parentClass = this.getParentClass();
                String newId = (String)value;
                if (parentClass != null && parentClass.getId().equals(newId)) break;
                Enumeration en = this.getDiagram().enumEntityClasses();
                while (en.hasMoreElements()) {
                    EntityClass ec = (EntityClass)en.nextElement();
                    if (!ec.getId().equals(newId)) continue;
                    this.updateParentClass(ec);
                    break block0;
                }
                break;
            }
            case 2: {
                this.updateLabel((String)value);
                break;
            }
            case 3: {
                this.updateTitle((String)value);
                break;
            }
            case 4: {
                this.updateDescription((String)value);
                break;
            }
            case 5: {
                this.updateObjectColor((Color)value);
                break;
            }
            case 6: {
                this.updateLabelColor((Color)value);
                break;
            }
            case 7: {
                this.updateColorWhenOpen((Color)value);
                break;
            }
            case 8: {
                this.updatexRelLocal((Double)value);
                break;
            }
            case 9: {
                this.updateyRelLocal((Double)value);
                break;
            }
            case 10: {
                this.updatewidthRelLocal((Double)value);
                break;
            }
            case 11: {
                this.updateheightRelLocal((Double)value);
                break;
            }
            case 12: {
                this.updateFontDelta((Integer)value);
                break;
            }
            default: {
                super.setAttributeValueAt(index, value);
            }
        }
    }

    public int getLsAttributeTypeAt(int index) {
        int ret;
        switch (index) {
            case 0: 
            case 2: 
            case 3: {
                ret = 3;
                break;
            }
            case 1: {
                ret = 15;
                break;
            }
            case 4: {
                ret = 12;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                ret = 8;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                ret = 2;
                break;
            }
            case 12: {
                ret = 1;
                break;
            }
            default: {
                ret = super.getLsAttributeTypeAt(index);
            }
        }
        return ret;
    }

    public boolean containsDiagramPoint(int x, int y) {
        if (x < this.getDiagramX()) {
            return false;
        }
        if (x > this.getDiagramX() + this.getWidth()) {
            return false;
        }
        if (y < this.getDiagramY()) {
            return false;
        }
        return y <= this.getDiagramY() + this.getHeight();
    }

    public void dump(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
        System.out.println(this);
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.dump(indent + 2);
        }
    }

    public int prepostorder(int value) {
        this.m_preorder = value;
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            value = e.prepostorder(value + 1);
        }
        this.m_postorder = ++value;
        return value;
    }

    public void clearAllMarks(int preserve_entity_marks, int preserve_relation_marks) {
        this.andMark(preserve_entity_marks);
        this.m_srcLiftedList.removeAllElements();
        this.m_dstLiftedList.removeAllElements();
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.clearAllMarks(preserve_entity_marks, preserve_relation_marks);
        }
        en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            ri.clearMark(preserve_relation_marks);
        }
    }

    public void addClients(Vector set, EntityInstance drawRoot, boolean visibleEdges) {
        if (this != drawRoot) {
            EntityInstance e;
            Enumeration en;
            if (!this.hasDescendant(drawRoot)) {
                en = this.m_srcRelList.elements();
                while (en.hasMoreElements()) {
                    RelationClass rc;
                    RelationInstance ri = (RelationInstance)en.nextElement();
                    if (visibleEdges && !(rc = ri.getRelationClass()).isClassVisible() || !drawRoot.hasDescendant(e = ri.getDst())) continue;
                    EntityClass ec = e.getEntityClass();
                    if (ec.isShown()) {
                        this.orMark(2);
                        set.addElement(this);
                    }
                    return;
                }
            }
            en = this.getChildren();
            while (en.hasMoreElements()) {
                e = (EntityInstance)en.nextElement();
                e.addClients(set, drawRoot, visibleEdges);
            }
        }
    }

    public void addSuppliers(Vector set, EntityInstance drawRoot, boolean visibleEdges) {
        if (this != drawRoot) {
            EntityInstance e;
            Enumeration en;
            if (!this.hasDescendant(drawRoot)) {
                en = this.m_dstRelList.elements();
                while (en.hasMoreElements()) {
                    RelationClass rc;
                    RelationInstance ri = (RelationInstance)en.nextElement();
                    if (visibleEdges && !(rc = ri.getRelationClass()).isClassVisible() || !drawRoot.hasDescendant(e = ri.getSrc())) continue;
                    EntityClass ec = e.getEntityClass();
                    if (ec.isShown()) {
                        this.orMark(4);
                        set.addElement(this);
                    }
                    return;
                }
            }
            en = this.getChildren();
            while (en.hasMoreElements()) {
                e = (EntityInstance)en.nextElement();
                e.addSuppliers(set, drawRoot, visibleEdges);
            }
        }
    }

    protected void liftSrc(RelationInstance ri) {
        LandscapeClassObject relationClass = ri.getParentClass();
        if (!ri.isMarked(1536)) {
            Enumeration en = this.srcLiftedRelationElements();
            while (en.hasMoreElements()) {
                RelationInstance other = (RelationInstance)en.nextElement();
                if (ri.m_drawSrc != other.m_drawSrc || ri.m_drawDst != other.m_drawDst || relationClass != other.getParentClass()) continue;
                return;
            }
        }
        this.m_srcLiftedList.add(ri);
    }

    protected void liftDst(RelationInstance ri) {
        LandscapeClassObject relationClass = ri.getParentClass();
        if (!ri.isMarked(1536)) {
            Enumeration en = this.dstLiftedRelationElements();
            while (en.hasMoreElements()) {
                RelationInstance other = (RelationInstance)en.nextElement();
                if (ri.m_drawSrc != other.m_drawSrc || ri.m_drawDst != other.m_drawDst || relationClass != other.getParentClass()) continue;
                return;
            }
        }
        this.m_dstLiftedList.add(ri);
    }

    public void orSrcRelationsDstUnder(EntityInstance under) {
        Enumeration en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            EntityInstance dst = ri.getDst();
            if (!under.hasDescendantOrSelf(dst)) continue;
            ri.orMark(2048);
        }
    }

    public void orDstRelationsSrcUnder(EntityInstance under) {
        Enumeration en = this.m_dstRelList.elements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            EntityInstance src = ri.getSrc();
            if (!under.hasDescendantOrSelf(src)) continue;
            ri.orMark(2048);
        }
    }

    public void orAllContainedSrcRelationsDstUnder(EntityInstance under) {
        this.orSrcRelationsDstUnder(under);
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.orAllContainedSrcRelationsDstUnder(under);
        }
    }

    public void addSrcRelations(int value, ResultBox resultBox) {
        Enumeration en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            if (!ri.isMarked(value)) continue;
            resultBox.addRelation(ri);
            ri.orMark(1024);
            ri.nandMark(value);
        }
    }

    public void addDstRelations(int value, ResultBox resultBox) {
        Enumeration en = this.m_dstRelList.elements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            if (!ri.isMarked(value)) continue;
            resultBox.addRelation(ri);
            ri.orMark(1024);
            ri.nandMark(value);
        }
    }

    public void addSrcDstRelations(int value, ResultBox resultBox) {
        this.addSrcRelations(value, resultBox);
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.addSrcDstRelations(value, resultBox);
        }
    }

    public void computeAllDiagramEdges(EntityInstance drawRoot, Vector clients, Vector suppliers, EntityInstance closedEntity, boolean liftEdges) {
        RelationInstance ri;
        EntityClass ec = this.getEntityClass();
        if (!ec.isShown()) {
            return;
        }
        Enumeration en = this.m_dstRelList.elements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            EntityInstance src = ri.m_src;
            if (!(clients == null && suppliers == null || drawRoot.isPathBetween(src))) {
                ri.m_drawSrc = src.clientServer();
            }
            if (closedEntity != null) {
                if (closedEntity.hasDescendant(src)) continue;
                ri.m_drawDst = closedEntity;
                continue;
            }
            ri.m_drawDst = this;
        }
        en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            EntityInstance dst = ri.m_dst;
            if (suppliers != null && !drawRoot.isPathBetween(dst)) {
                ri.m_drawDst = dst.clientServer();
            }
            if (closedEntity != null) {
                if (closedEntity.hasDescendant(dst)) continue;
                ri.m_drawSrc = closedEntity;
                continue;
            }
            ri.m_drawSrc = this;
        }
        if (closedEntity == null) {
            this.orMark(1);
            if (!this.isOpen()) {
                closedEntity = this;
                if (!liftEdges) {
                    return;
                }
            }
        } else {
            this.setSwingObject(null);
        }
        en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.computeAllDiagramEdges(drawRoot, clients, suppliers, closedEntity, liftEdges);
        }
    }

    public void liftAllDiagramEdges(EntityInstance drawRoot, boolean liftEdges) {
        EntityInstance dst;
        EntityInstance src;
        RelationInstance ri;
        Enumeration en = this.m_dstRelList.elements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            if (ri.isMarked(0x200000)) continue;
            ri.orMark(0x200000);
            src = ri.m_drawSrc;
            if (src == null || (dst = ri.m_drawDst) == null) continue;
            src.liftSrc(ri);
            dst.liftDst(ri);
        }
        en = this.m_srcRelList.elements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            if (ri.isMarked(0x200000)) continue;
            ri.orMark(0x200000);
            src = ri.m_drawSrc;
            if (src == null || (dst = ri.m_drawDst) == null) continue;
            src.liftSrc(ri);
            dst.liftDst(ri);
        }
        if (!liftEdges && !this.isOpen()) {
            return;
        }
        en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.liftAllDiagramEdges(drawRoot, liftEdges);
        }
    }

    public void validateEdges() {
        RelationInstance ri;
        Enumeration en = this.dstLiftedRelationElements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            ri.validate();
        }
        en = this.srcLiftedRelationElements();
        while (en.hasMoreElements()) {
            ri = (RelationInstance)en.nextElement();
            ri.validate();
        }
        if (!this.isMarked(524288)) {
            en = this.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                e.validateEdges();
            }
        }
    }

    public boolean intersectsLayout(Rectangle rect) {
        Rectangle box = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return box.intersects(rect);
    }

    public boolean containsRectangle(Rectangle rect) {
        int x = this.getDiagramX();
        int y = this.getDiagramY();
        return x < rect.x && rect.x + rect.width < x + this.getWidth() && y < rect.y && rect.y + rect.height < y + this.getHeight();
    }

    public int getParentDiagramX() {
        Container parentComponent;
        DiagramCoordinates above;
        JComponent entityComponent = this.getSwingObject();
        if (entityComponent != null && (above = (parentComponent = entityComponent.getParent()) instanceof EntityComponent ? ((EntityComponent)parentComponent).getEntityInstance() : (DiagramCoordinates)((Object)parentComponent)) != null) {
            return above.getDiagramX();
        }
        return 0;
    }

    public int getParentDiagramY() {
        Container parentComponent;
        DiagramCoordinates above;
        JComponent entityComponent = this.getSwingObject();
        if (entityComponent != null && (above = (parentComponent = entityComponent.getParent()) instanceof EntityComponent ? ((EntityComponent)parentComponent).getEntityInstance() : (DiagramCoordinates)((Object)parentComponent)) != null) {
            return above.getDiagramY();
        }
        return 0;
    }

    public int getDiagramX() {
        return this.m_diagramX;
    }

    public int getDiagramY() {
        return this.m_diagramY;
    }

    public void computeAvgX() {
        EntityComponent ec = this.neededComponent();
        double x = 0.0;
        int n = 0;
        int edgeMode = this.getDiagram().getEdgeMode();
        if (edgeMode == 2) {
            RelationInstance ri;
            Enumeration en = this.srcLiftedRelationElements();
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                EntityInstance dst = ri.m_drawDst;
                x += (double)(dst.getDiagramX() + dst.getWidth() / 2);
                ++n;
            }
            en = this.dstLiftedRelationElements();
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                EntityInstance src = ri.m_drawSrc;
                x += (double)(src.getDiagramX() + src.getWidth() / 2);
                ++n;
            }
        } else {
            double f;
            RelationInstance ri;
            Enumeration en = this.srcLiftedRelationElements();
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                EntityInstance dst = ri.m_drawDst;
                f = ri.getRelationClass().getIOfactor();
                x += (double)dst.getDiagramX() + (double)dst.getWidth() * f;
                ++n;
            }
            en = this.dstLiftedRelationElements();
            while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                EntityInstance src = ri.m_drawSrc;
                f = ri.getRelationClass().getIOfactor();
                x += (double)src.getDiagramX() + (double)src.getWidth() * f;
                ++n;
            }
        }
        double avg = n > 0 ? x / (double)n : -1.0;
        ec.setAvgX(avg);
    }

    public double getAvgX() {
        EntityComponent ec = this.neededComponent();
        return ec.getAvgX();
    }

    public void addUnder(JComponent under) {
        EntityComponent entityComponent = this.neededComponent();
        entityComponent.removeAll();
        this.orMark(1);
        if (this.isOpen()) {
            Enumeration en = this.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                e.addUnderEntity(this);
            }
        }
        under.add(entityComponent);
    }

    public void addUnderEntity(EntityInstance under) {
        EntityClass ec = this.getEntityClass();
        if (ec.isShown()) {
            EntityComponent parentComponent = under.neededComponent();
            this.addUnder(parentComponent);
        }
    }

    public void resetCardinals(int numRelations) {
        if (this.m_dstCardinals == null) {
            if (numRelations > 0) {
                this.m_dstCardinals = new Cardinal[numRelations];
            }
        } else {
            for (int i = 0; i < numRelations; ++i) {
                Cardinal cardinal = this.m_dstCardinals[i];
                if (cardinal == null) continue;
                cardinal.reset();
            }
        }
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.resetCardinals(numRelations);
        }
    }

    public void incCardinal(int ind) {
        Cardinal cardinal = this.m_dstCardinals[ind];
        if (cardinal == null) {
            this.m_dstCardinals[ind] = cardinal = new Cardinal();
        }
        cardinal.inc();
    }

    public void calcEdgeCardinals(EntityInstance closedEntity, boolean hOnly) {
        Enumeration en = this.m_dstRelList.elements();
        while (en.hasMoreElements()) {
            EntityInstance target;
            RelationInstance ri = (RelationInstance)en.nextElement();
            if (closedEntity != null) {
                EntityInstance src = ri.m_src;
                if (closedEntity.hasDescendant(src)) continue;
                target = closedEntity;
            } else {
                target = this;
            }
            if (hOnly && !ri.getHighlightFlag()) continue;
            int ind = ri.getRelationClass().getNid();
            target.incCardinal(ind);
        }
        if (closedEntity == null && !this.isOpen()) {
            closedEntity = this;
        }
        en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.calcEdgeCardinals(closedEntity, hOnly);
        }
    }

    public void showCardinals() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.m_dstCardinals != null && width > 0 && height > 0) {
            JComponent entityComponent = this.getSwingObject();
            Diagram diagram = this.getDiagram();
            FontMetrics fm = entityComponent.getFontMetrics(smallFont);
            int h = fm.getAscent();
            int diagramX = this.getDiagramX();
            int top = this.getDiagramY() + height + 5;
            int i = this.m_dstCardinals.length;
            while (i > 0) {
                int cnt;
                Cardinal cardinal;
                if ((cardinal = this.m_dstCardinals[--i]) == null || (cnt = cardinal.getCnt()) <= 0) continue;
                RelationClass rc = diagram.numToRelationClass(i);
                double f = rc.getIOfactor();
                int w = fm.stringWidth("" + cnt);
                cardinal.setBackground(rc.getObjectColor());
                cardinal.setTextSize(w, h);
                cardinal.setCenterTop(diagramX + (int)((double)width * f), top);
                diagram.add(cardinal);
            }
        }
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            e.showCardinals();
        }
    }

    public void moveCardinals() {
        int width = this.getWidth();
        if (this.m_dstCardinals != null) {
            Diagram diagram = this.getDiagram();
            int diagramX = this.getDiagramX();
            int top = this.getDiagramY() + this.getHeight() + 5;
            int i = this.m_dstCardinals.length;
            while (i > 0) {
                Cardinal cardinal;
                if ((cardinal = this.m_dstCardinals[--i]) == null) continue;
                RelationClass rc = diagram.numToRelationClass(i);
                double f = rc.getIOfactor();
                cardinal.setCenterTop(diagramX + (int)((double)width * f), top);
                cardinal.revalidate();
            }
        }
    }

    public boolean isTransparent() {
        switch (this.getStyle()) {
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean isCloseable() {
        switch (this.getStyle()) {
            case 6: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    public boolean isLabelDrawable() {
        switch (this.getStyle()) {
            case 6: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    public boolean isEnterable() {
        switch (this.getStyle()) {
            case 6: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    public RealPoint calculateIntercept(RealPoint p1, RealPoint p2) {
        double x = 0.0;
        double y = 0.0;
        double t = this.getY() - 1;
        double b = this.getY() + this.getHeight() + 1;
        double l = this.getX() - 1;
        double r = this.getX() + this.getWidth() + 1;
        boolean found = true;
        double x1 = p1.getX();
        double y1 = p1.getY();
        if (x1 < l || x1 > r || y1 < t || y1 > b) {
            MsgOut.println("calculateIntercept: p1 is not in box");
            return new RealPoint(x, y);
        }
        double x2 = p2.getX();
        double y2 = p2.getY();
        if (x1 == x2 && y1 == y2) {
            MsgOut.println("calculateIntercept: p1 == p2");
            return new RealPoint(x, y);
        }
        if (r <= x2) {
            x = r;
        } else if (x2 < l) {
            x = l;
        } else {
            found = false;
        }
        if (found) {
            y = y1 + (x - x1) * ((y2 - y1) / (x2 - x1));
            boolean bl = found = t <= y && y <= b;
        }
        if (!found) {
            found = true;
            if (y2 <= t) {
                y = t;
            } else if (y2 >= b) {
                y = b;
            } else {
                found = false;
            }
            if (found) {
                x = x1 + (y - y1) * ((x2 - x1) / (y2 - y1));
                boolean bl = found = l <= x && x <= r;
            }
        }
        if (!found) {
            MsgOut.println("calculateIntercept failed: " + x1 + " " + y1 + " " + x2 + " " + y2);
        }
        return new RealPoint(x, y);
    }

    public int overResizeTab(int x1, int y1) {
        int pos;
        int xLeft = this.getDiagramX();
        if (x1 < xLeft) {
            return -1;
        }
        if (x1 <= xLeft + 6) {
            pos = 0;
        } else {
            int xRight = xLeft + this.getWidth();
            if (x1 > xRight) {
                return -1;
            }
            if (x1 >= xRight - 6) {
                pos = 2;
            } else {
                int xMid = (xLeft + xRight) / 2;
                if (x1 < xMid - 3 || x1 > xMid + 3) {
                    return -1;
                }
                pos = 1;
            }
        }
        int yTop = this.getDiagramY();
        if (y1 < yTop) {
            return -1;
        }
        if (y1 > yTop + 6) {
            int yBottom = yTop + this.getHeight();
            if (y1 > yBottom) {
                return -1;
            }
            if (y1 >= yBottom - 6) {
                pos += 6;
            } else {
                int yMid = (yTop + yBottom) / 2;
                if (y1 < yMid - 3 || y1 > yMid + 3) {
                    return -1;
                }
                pos += 3;
            }
        }
        switch (pos) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 7;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 4;
            }
        }
        return -1;
    }

    public boolean isPointOverIO(EdgePoint pt, int x, int y) {
        int x1 = (int)(pt.getX() + 0.5);
        int y1 = (int)(pt.getY() + 0.5);
        return x1 - 3 < x && x < x1 + 3 && y1 - 3 < y && y < y1 + 3;
    }

    public void drawHighlight() {
        if (!this.isMarked(4096)) {
            this.orMark(4096);
            this.repaint();
        }
    }

    public void undrawHighlight() {
        if (this.isMarked(4096)) {
            this.nandMark(4096);
            this.repaint();
        }
    }

    private EdgePoint getPoint(EdgePoint[] pts, RelationClass rc, int side) {
        int nid = rc.getNid();
        EdgePoint cached = pts[nid];
        if (cached == null || cached.getRc() != rc) {
            double f = rc.getIOfactor();
            double wf = 0.0;
            double hf = 0.0;
            switch (side) {
                case 0: {
                    wf = f;
                    break;
                }
                case 1: {
                    wf = f;
                    hf = 1.0;
                    break;
                }
                case 2: {
                    hf = f;
                    break;
                }
                default: {
                    wf = 1.0;
                    hf = f;
                }
            }
            if (cached == null) {
                pts[nid] = cached = new EdgePoint(this, rc, wf, hf);
            } else {
                cached.setRc(rc);
            }
            cached.isDefault = true;
            cached.side = side;
            cached.rescale();
        }
        return cached;
    }

    public EdgePoint getPoint(RelationClass rc, int side) {
        EdgePoint[] cache;
        switch (side) {
            case 0: {
                cache = this.topPoints;
                if (cache != null) break;
                cache = new EdgePoint[this.numRelationClasses()];
                this.topPoints = cache;
                break;
            }
            case 1: {
                cache = this.bottomPoints;
                if (cache != null) break;
                cache = new EdgePoint[this.numRelationClasses()];
                this.bottomPoints = cache;
                break;
            }
            case 2: {
                cache = this.leftPoints;
                if (cache != null) break;
                cache = new EdgePoint[this.numRelationClasses()];
                this.leftPoints = cache;
                break;
            }
            default: {
                cache = this.rightPoints;
                if (cache != null) break;
                cache = new EdgePoint[this.numRelationClasses()];
                this.rightPoints = cache;
            }
        }
        return this.getPoint(cache, rc, side);
    }

    public EdgePoint getOutPoint(RelationInstance ri, int edge_mode, Rectangle srcLyt, Rectangle dstLyt) {
        RelationClass rc = ri.getRelationClass();
        int nid = rc.getNid();
        if (edge_mode == 1) {
            EntityInstance src = ri.getSrc();
            if (this == src || src.hasAncestor(this)) {
                return this.getPoint(rc, 1);
            }
            return this.getPoint(rc, 0);
        }
        if (dstLyt.y - (srcLyt.y + srcLyt.height) > 8) {
            return this.getPoint(rc, 1);
        }
        if (srcLyt.y - (dstLyt.y + dstLyt.height) > 8) {
            return this.getPoint(rc, 0);
        }
        if (dstLyt.x - (srcLyt.x + srcLyt.width) > 8) {
            return this.getPoint(rc, 3);
        }
        if (srcLyt.x - (dstLyt.x + dstLyt.width) > 8) {
            return this.getPoint(rc, 2);
        }
        if (dstLyt.y > srcLyt.y + srcLyt.height) {
            return this.getPoint(rc, 1);
        }
        return this.getPoint(rc, 0);
    }

    protected EdgePoint testMouseOverIO(EdgePoint[] pts, int x, int y) {
        if (pts == null) {
            return null;
        }
        for (int i = 0; i < pts.length; ++i) {
            EdgePoint pt = pts[i];
            if (pt == null || !this.isPointOverIO(pt, x, y)) continue;
            return pt;
        }
        return null;
    }

    public EdgePoint getMouseOverIO(int x, int y) {
        EdgePoint pt = this.testMouseOverIO(this.topPoints, x, y);
        if (pt != null) {
            return pt;
        }
        pt = this.testMouseOverIO(this.bottomPoints, x, y);
        if (pt != null) {
            return pt;
        }
        pt = this.testMouseOverIO(this.leftPoints, x, y);
        if (pt != null) {
            return pt;
        }
        return this.testMouseOverIO(this.rightPoints, x, y);
    }

    public Enumeration srcRelListEnum() {
        return this.m_srcRelList.elements();
    }

    public int getIconWidth() {
        return this.getWidth();
    }

    public int getIconHeight() {
        return this.getHeight();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        EntityComponent entityComponent = this.neededComponent();
        entityComponent.paintIcon(c, g, x, y);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent ev) {
        Diagram diagram = this.getDiagram();
        int x = ev.getX();
        int y = ev.getY();
        if (x <= 11 && y <= 17 && x >= 3 && y >= 9 && this.m_width > 11 && this.m_height > 17 && this.close_with_children_under_drawroot()) {
            LandscapeViewerCore ls = diagram.getLs();
            ls.processKey(99, 0, this);
            return;
        }
        diagram.entityPressed(ev, this, ev.getX() + this.getDiagramX(), ev.getY() + this.getDiagramY());
    }

    public void mouseReleased(MouseEvent ev) {
        this.getDiagram().entityReleased(ev, this, ev.getX() + this.getDiagramX(), ev.getY() + this.getDiagramY());
    }

    public void mouseDragged(MouseEvent ev) {
        this.getDiagram().entityDragged(ev, this, ev.getX() + this.getDiagramX(), ev.getY() + this.getDiagramY());
    }

    public void mouseMoved(MouseEvent ev) {
        Diagram diagram = this.getDiagram();
        if (this != m_infoShown) {
            LandscapeViewerCore ls = diagram.getLs();
            m_infoShown = this;
            String str = this.getLabel();
            EntityInstance pe = this.getEnterableParent();
            if (pe != null) {
                str = pe.getLabel() + " . " + str;
            }
            ls.showInfo(str);
            if (m_currentDescEntity != this && !this.isOpen() && this.getEntityClass() != null) {
                String label = this.getLabel();
                String title = this.getTitle();
                String desc = this.getDescription();
                if (desc == null) {
                    desc = "The " + this.getLabel() + " " + this.getEntityClass().getLabel() + ".";
                }
                String topline = " (" + this.getEntityClass().getLabel() + (this.hasChildren() ? " - " + this.numChildren() + " items)" : ")");
                topline = title != null ? title + topline : label + topline;
                ls.setRightTextBox(topline, desc);
                m_currentDescEntity = this;
            }
        }
        diagram.movedOverThing(ev, this, ev.getX() + this.getDiagramX(), ev.getY() + this.getDiagramY());
    }

    class UpdateContainment
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_o;
        EntityInstance m_containedByOld;
        EntityInstance m_containedByNew;

        UpdateContainment(EntityInstance o, EntityInstance value) {
            this.m_o = o;
            this.m_containedByOld = o.m_containedBy;
            this.m_containedByNew = value;
            if (EntityInstance.this.logEdit(this)) {
                this.redo();
            }
        }

        public String getPresentationName() {
            return this.m_o + " moved from " + this.m_containedByOld + " to " + this.m_containedByNew;
        }

        public void undo() {
            this.m_containedByNew.removeContainment(this.m_o);
            this.m_containedByOld.addContainment(this.m_o);
            this.m_o.getDiagram().redrawDiagram();
        }

        public void redo() {
            this.m_containedByOld.removeContainment(this.m_o);
            this.m_containedByNew.addContainment(this.m_o);
            this.m_o.getDiagram().redrawDiagram();
        }
    }

    class UpdateDeleteJustMe
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_o;
        EntityInstance m_containedByOld;

        UpdateDeleteJustMe(EntityInstance o) {
            this.m_o = o;
            this.m_containedByOld = o.m_containedBy;
            if (EntityInstance.this.logEdit(this)) {
                this.redo();
            }
        }

        public String getPresentationName() {
            return this.m_o + " Container Deleted";
        }

        public void undo() {
            this.m_containedByOld.addContainment(this.m_o);
            Enumeration en = this.m_o.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                this.m_containedByOld.removeContainment(e);
                e.m_containedBy = this.m_o;
            }
            this.m_o.reconnectEdgesJustMe(this.m_o);
            this.m_o.getDiagram().redrawDiagram();
        }

        public void redo() {
            Enumeration en = this.m_o.getChildren();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                this.m_containedByOld.addContainment(e);
            }
            this.m_o.disconnectEdgesJustMe(this.m_o);
            this.m_containedByOld.removeContainment(this.m_o);
            this.m_o.getDiagram().redrawDiagram();
        }
    }

    class UpdateDelete
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_o;
        EntityInstance m_containedByOld;

        UpdateDelete(EntityInstance o) {
            this.m_o = o;
            this.m_containedByOld = o.m_containedBy;
            if (EntityInstance.this.logEdit(this)) {
                this.redo();
            }
        }

        public String getPresentationName() {
            return this.m_o + " Deleted";
        }

        public void undo() {
            this.m_o.reconnectEdges(this.m_o);
            this.m_containedByOld.addContainment(this.m_o);
            this.m_o.getDiagram().redrawDiagram();
        }

        public void redo() {
            this.m_o.disconnectEdges(this.m_o);
            this.m_containedByOld.removeContainment(this.m_o);
            this.m_o.getDiagram().redrawDiagram();
        }
    }

    class UpdateRelLocal
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_o;
        double m_oldX;
        double m_oldY;
        double m_oldWidth;
        double m_oldHeight;
        double m_newX;
        double m_newY;
        double m_newWidth;
        double m_newHeight;

        UpdateRelLocal(EntityInstance o, double x, double y, double width, double height) {
            this.m_o = o;
            this.m_oldX = o.m_xrelLocal;
            this.m_oldY = o.m_yrelLocal;
            this.m_oldWidth = o.m_widthrelLocal;
            this.m_oldHeight = o.m_heightrelLocal;
            this.m_newX = x;
            this.m_newY = y;
            this.m_newWidth = width;
            this.m_newHeight = height;
            if (EntityInstance.this.logEdit(this)) {
                o.m_xrelLocal = x;
                o.m_yrelLocal = y;
                o.m_widthrelLocal = width;
                o.m_heightrelLocal = height;
            }
        }

        public String getPresentationName() {
            return this.m_o + " RelLocal {" + Util.formatFraction(this.m_newX) + EntityInstance.XPOSITION_ID + Util.formatFraction(this.m_newY) + "," + Util.formatFraction(this.m_newWidth) + EntityInstance.XPOSITION_ID + Util.formatFraction(this.m_newHeight) + "}";
        }

        public void undo() {
            this.m_o.m_xrelLocal = this.m_oldX;
            this.m_o.m_yrelLocal = this.m_oldY;
            this.m_o.m_widthrelLocal = this.m_oldWidth;
            this.m_o.m_heightrelLocal = this.m_oldHeight;
            this.m_o.getDiagram().redrawDiagram();
        }

        public void redo() {
            this.m_o.m_xrelLocal = this.m_newX;
            this.m_o.m_yrelLocal = this.m_newY;
            this.m_o.m_widthrelLocal = this.m_newWidth;
            this.m_o.m_heightrelLocal = this.m_newHeight;
            this.m_o.getDiagram().redrawDiagram();
        }
    }

    class UpdateHeightRelLocal
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_o;
        double m_old;
        double m_new;

        UpdateHeightRelLocal(EntityInstance o, double value) {
            this.m_o = o;
            this.m_old = o.m_heightrelLocal;
            this.m_new = value;
            if (EntityInstance.this.logEdit(this)) {
                this.m_o.m_heightrelLocal = value;
            }
        }

        public String getPresentationName() {
            return this.m_o + " heightRelLocal " + Util.formatFraction(this.m_new);
        }

        public void undo() {
            this.m_o.m_heightrelLocal = this.m_old;
            this.m_o.getDiagram().redrawDiagram();
        }

        public void redo() {
            this.m_o.m_heightrelLocal = this.m_new;
            this.m_o.getDiagram().redrawDiagram();
        }
    }

    class UpdateWidthRelLocal
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_o;
        double m_old;
        double m_new;

        UpdateWidthRelLocal(EntityInstance o, double value) {
            this.m_o = o;
            this.m_old = o.m_widthrelLocal;
            this.m_new = value;
            if (EntityInstance.this.logEdit(this)) {
                this.m_o.m_widthrelLocal = value;
            }
        }

        public String getPresentationName() {
            return this.m_o + " widthRelLocal " + Util.formatFraction(this.m_new);
        }

        public void undo() {
            this.m_o.m_widthrelLocal = this.m_old;
            this.m_o.getDiagram().redrawDiagram();
        }

        public void redo() {
            this.m_o.m_widthrelLocal = this.m_new;
            this.m_o.getDiagram().redrawDiagram();
        }
    }

    class UpdateYRelLocal
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_o;
        double m_old;
        double m_new;

        UpdateYRelLocal(EntityInstance o, double value) {
            this.m_o = o;
            this.m_old = o.m_yrelLocal;
            this.m_new = value;
            if (EntityInstance.this.logEdit(this)) {
                this.m_o.m_yrelLocal = value;
            }
        }

        public String getPresentationName() {
            return this.m_o + " yRelLocal " + Util.formatFraction(this.m_new);
        }

        public void undo() {
            this.m_o.m_yrelLocal = this.m_old;
            this.m_o.getDiagram().redrawDiagram();
        }

        public void redo() {
            this.m_o.m_yrelLocal = this.m_new;
            this.m_o.getDiagram().redrawDiagram();
        }
    }

    class UpdateXRelLocal
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_o;
        double m_old;
        double m_new;

        UpdateXRelLocal(EntityInstance o, double value) {
            this.m_o = o;
            this.m_old = o.m_xrelLocal;
            this.m_new = value;
            if (EntityInstance.this.logEdit(this)) {
                this.m_o.m_xrelLocal = value;
            }
        }

        public String getPresentationName() {
            return this.m_o + " xRelLocal " + Util.formatFraction(this.m_new);
        }

        public void undo() {
            this.m_o.m_xrelLocal = this.m_old;
            this.m_o.getDiagram().redrawDiagram();
        }

        public void redo() {
            this.m_o.m_xrelLocal = this.m_new;
            this.m_o.getDiagram().redrawDiagram();
        }
    }

    class UpdateFontDelta
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_o;
        int m_old;
        int m_new;

        UpdateFontDelta(EntityInstance o, int value) {
            this.m_o = o;
            this.m_old = o.m_fontDelta;
            this.m_new = value;
            if (EntityInstance.this.logEdit(this)) {
                this.redo();
            }
        }

        public String getPresentationName() {
            return this.m_o + " FontDelta " + this.m_new;
        }

        public void undo() {
            this.m_o.m_fontDelta = this.m_old;
            this.m_o.repaint();
        }

        public void redo() {
            this.m_o.m_fontDelta = this.m_new;
            this.m_o.repaint();
        }
    }

    class UpdateTitle
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance m_o;
        String m_old;
        String m_new;

        UpdateTitle(EntityInstance o, String value) {
            this.m_o = o;
            this.m_old = o.m_title;
            this.m_new = value;
            if (EntityInstance.this.logEdit(this)) {
                o.m_title = value;
            }
        }

        public String getPresentationName() {
            return this.m_o + " Title";
        }

        public void undo() {
            this.m_o.m_title = this.m_old;
        }

        public void redo() {
            this.m_o.m_title = this.m_new;
        }
    }
}

