/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeLayouter;
import lsedit.LandscapeViewerCore;
import lsedit.ToolBarEventHandler;

public class FlipLayoutVertically
extends LandscapeLayouter
implements ToolBarEventHandler {
    public FlipLayoutVertically(LandscapeViewerCore ls) {
        super(ls);
    }

    public String getMenuLabel() {
        return "Flip layout vertically";
    }

    public String doLayout(Diagram dg) {
        EntityInstance pe = dg.getDrawRoot();
        Enumeration en = pe.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance ce = (EntityInstance)en.nextElement();
            ce.updateyRelLocal(1.0 - ce.yRelLocal() - ce.heightRelLocal());
        }
        return "Layout flipped vertically";
    }

    public void processKeyEvent(int key, int modifiers, Object object) {
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            dg.beginUndoRedo("Flip Vertically");
            String rmsg = this.doLayout(dg);
            dg.redrawDiagram();
            dg.endUndoRedo();
            this.m_ls.doFeedback(rmsg);
        }
    }
}

