/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.Vertex;

class Graph {
    private Vector vertices;
    private int[] labelled;
    private int curLabel = 1;
    private int size = 0;
    private double maxRowWidth;
    private double maxTotalHeight;
    private int numLayers;
    private boolean debugMode;

    public Graph(int numVertices, double maxWidth, double maxHeight, boolean debug) {
        this.maxTotalHeight = maxHeight;
        this.maxRowWidth = maxWidth;
        this.vertices = new Vector();
        this.labelled = new int[numVertices];
        for (int i = 0; i < numVertices; ++i) {
            this.labelled[i] = 0;
        }
        this.debugMode = debug;
    }

    public void addVertex(double boxWidth) {
        this.vertices.addElement(new Vertex(boxWidth));
        ++this.size;
    }

    public Vertex getVertex(int vertexID) {
        return (Vertex)this.vertices.elementAt(vertexID);
    }

    public void addEdge(int sourceID, int destID) {
        this.getVertex(sourceID).addChild(new Integer(destID));
        this.getVertex(destID).addParent(new Integer(sourceID));
    }

    public void print() {
        int x = 0;
        Enumeration e = this.vertices.elements();
        while (e.hasMoreElements()) {
            System.out.print(x + "  ");
            ++x;
            ((Vertex)e.nextElement()).print();
        }
    }

    private void DeleteInEdges(int vertexID) {
        Vector parentVertices = this.getVertex(vertexID).getParents();
        Enumeration e = parentVertices.elements();
        while (e.hasMoreElements()) {
            this.getVertex((Integer)e.nextElement()).decOutDegree();
        }
    }

    private void DeleteOutEdges(int vertexID, Vector precedingVertices) {
        Vector childrenVertices = this.getVertex(vertexID).getChildren();
        Integer child = null;
        Vector<Integer> childrenToBeRemoved = new Vector<Integer>();
        Enumeration e = childrenVertices.elements();
        while (e.hasMoreElements()) {
            child = (Integer)e.nextElement();
            this.getVertex(child).decInDegree();
            int index = precedingVertices.indexOf(child);
            if (index == -1) continue;
            if (this.debugMode) {
                System.out.println("Reverse " + vertexID + "->" + child);
            }
            this.getVertex(child).removeParent(new Integer(vertexID));
            this.getVertex(child).addChild(new Integer(vertexID));
            childrenToBeRemoved.addElement(child);
            this.getVertex(vertexID).addParent(child);
        }
        Enumeration f = childrenToBeRemoved.elements();
        while (f.hasMoreElements()) {
            this.getVertex(vertexID).removeChild((Integer)f.nextElement());
        }
    }

    private int FindSink(int curSize, Vector precedingVertices) {
        int i;
        block0: do {
            for (i = 0; i < this.size; ++i) {
                if (this.getVertex(i).getOutDegree() != 0 || this.getVertex(i).isVisited()) continue;
                this.getVertex(i).setVisited();
                --curSize;
                this.DeleteOutEdges(i, precedingVertices);
                this.DeleteInEdges(i);
                continue block0;
            }
        } while (i < this.size && curSize > 0);
        return curSize;
    }

    private int FindSource(int curSize, Vector precedingVertices) {
        int i;
        block0: do {
            for (i = 0; i < this.size; ++i) {
                if (this.getVertex(i).getInDegree() != 0 || this.getVertex(i).isVisited()) continue;
                this.getVertex(i).setVisited();
                --curSize;
                this.DeleteOutEdges(i, precedingVertices);
                this.DeleteInEdges(i);
                continue block0;
            }
        } while (i < this.size && curSize > 0);
        return curSize;
    }

    private int FindNext(int curSize, Vector precedingVertices) {
        int diff = 0;
        int maxDiff = -1000;
        int maxVertex = this.size;
        for (int i = 0; i < this.size; ++i) {
            if (this.getVertex(i).isVisited() || (diff = this.getVertex(i).getOutDegree() - this.getVertex(i).getInDegree()) <= maxDiff) continue;
            maxDiff = diff;
            maxVertex = i;
        }
        this.getVertex(maxVertex).setVisited();
        this.DeleteOutEdges(maxVertex, precedingVertices);
        this.DeleteInEdges(maxVertex);
        precedingVertices.addElement(new Integer(maxVertex));
        return --curSize;
    }

    private void RemoveCycles() {
        Vector precedingVertices = new Vector();
        int curSize = this.size;
        while ((curSize = this.FindSink(curSize, precedingVertices)) != 0 && (curSize = this.FindSource(curSize, precedingVertices)) != 0 && (curSize = this.FindNext(curSize, precedingVertices)) > 0) {
        }
    }

    private Vector getLabels(Vector parentIDs) {
        Vector<Integer> labelVector = new Vector<Integer>();
        Enumeration e = parentIDs.elements();
        while (e.hasMoreElements()) {
            int curLabel = this.labelled[(Integer)e.nextElement()];
            if (curLabel == 0) {
                return null;
            }
            labelVector.addElement(new Integer(curLabel));
        }
        return labelVector;
    }

    private Integer maxValue(Vector intVector) {
        Integer maxInt = (Integer)intVector.firstElement();
        for (int i = 1; i < intVector.size(); ++i) {
            if ((Integer)intVector.elementAt(i) <= maxInt) continue;
            maxInt = (Integer)intVector.elementAt(i);
        }
        return maxInt;
    }

    private boolean lessThan(Vector vector1, Vector vector2) {
        if (vector1.isEmpty() && !vector2.isEmpty()) {
            return true;
        }
        if (!vector1.isEmpty() && !vector2.isEmpty()) {
            Integer maxValue1 = this.maxValue(vector1);
            Integer maxValue2 = this.maxValue(vector2);
            if (maxValue1 < maxValue2) {
                return true;
            }
            if (maxValue1 == maxValue2) {
                Vector newVector1 = (Vector)vector1.clone();
                newVector1.removeElement(maxValue1);
                Vector newVector2 = (Vector)vector2.clone();
                newVector2.removeElement(maxValue2);
                return this.lessThan(newVector1, newVector2);
            }
        }
        return false;
    }

    private void AssignLabel() {
        for (int j = 0; j < this.size; ++j) {
            int minVertex = 0;
            Vector minParentsLabels = new Vector();
            minParentsLabels.addElement(new Integer(this.size));
            for (int i = 0; i < this.size; ++i) {
                Vector curParentsLabels;
                if (this.labelled[i] != 0 || (curParentsLabels = this.getLabels(this.getVertex(i).getParents())) == null || !this.lessThan(curParentsLabels, minParentsLabels)) continue;
                minParentsLabels = curParentsLabels;
                minVertex = i;
            }
            ++this.curLabel;
        }
    }

    private boolean childrenPlaced(int vertexID) {
        Vector childrenVertices = this.getVertex(vertexID).getChildren();
        boolean result = true;
        Enumeration e = childrenVertices.elements();
        while (e.hasMoreElements()) {
            if (this.labelled[(Integer)e.nextElement()] == -1) continue;
            result = false;
            break;
        }
        return result;
    }

    private void AddDummies(int vertexID, int curLayer, Vector layers) {
        Vector childrenVertices = this.getVertex(vertexID).getChildren();
        Enumeration e = childrenVertices.elements();
        while (e.hasMoreElements()) {
            Integer child = (Integer)e.nextElement();
            int childLayer = this.getVertex(child).getLayer();
            if (curLayer - childLayer <= 1) continue;
            int curIndex = this.vertices.size();
            int childIndex = child;
            this.getVertex(childIndex).replaceParent(new Integer(vertexID), new Integer(curIndex));
            for (int i = childLayer + 1; i < curLayer - 1; ++i) {
                this.vertices.addElement(new Vertex(0.0));
                ((Vector)layers.elementAt(i)).addElement(new Integer(this.size));
                ++this.size;
                this.getVertex(curIndex).setDummy();
                this.getVertex(curIndex).setLayer(i);
                this.getVertex(curIndex).addChild(new Integer(childIndex));
                this.getVertex(curIndex).addParent(new Integer(curIndex + 1));
                childIndex = curIndex++;
            }
            this.vertices.addElement(new Vertex(0.0));
            ((Vector)layers.elementAt(curLayer - 1)).addElement(new Integer(this.size));
            ++this.size;
            this.getVertex(curIndex).setDummy();
            this.getVertex(curIndex).setLayer(curLayer - 1);
            this.getVertex(curIndex).addChild(new Integer(childIndex));
            this.getVertex(curIndex).addParent(new Integer(vertexID));
            this.getVertex(vertexID).replaceChild(child, new Integer(curIndex));
        }
    }

    public Vector doCoffmanGrahamSugiyama() {
        this.RemoveCycles();
        if (this.debugMode) {
            System.out.println("finish removeCycle");
        }
        this.AssignLabel();
        if (this.debugMode) {
            System.out.println("finish assignLabel");
        }
        int layerNo = 0;
        Vector<Integer> thisLayer = new Vector<Integer>();
        double curWidth = 0.0;
        Vector layers = new Vector();
        layers.addElement(new Vector());
        int currentSize = this.size;
        double newWidth = 0.0;
        int numPlacedVertices = 0;
        while (numPlacedVertices < currentSize) {
            int maxLabel = 0;
            int maxVertex = currentSize;
            for (int i = 0; i < currentSize; ++i) {
                if (this.labelled[i] <= maxLabel || !this.childrenPlaced(i)) continue;
                maxLabel = this.labelled[i];
                maxVertex = i;
            }
            if (maxVertex < currentSize) {
                newWidth = curWidth + this.getVertex(maxVertex).getWidth();
            }
            if (maxVertex < currentSize && newWidth < this.maxRowWidth) {
                this.getVertex(maxVertex).setLayer(layerNo);
                thisLayer.addElement(new Integer(maxVertex));
                ((Vector)layers.lastElement()).addElement(new Integer(maxVertex));
                this.AddDummies(maxVertex, layerNo, layers);
                this.labelled[maxVertex] = 0;
                ++numPlacedVertices;
                curWidth = newWidth;
            }
            if (maxVertex < currentSize && !(newWidth >= this.maxRowWidth)) continue;
            ++layerNo;
            Enumeration e = thisLayer.elements();
            while (e.hasMoreElements()) {
                this.labelled[((Integer)e.nextElement()).intValue()] = -1;
            }
            layers.addElement(new Vector());
            curWidth = 0.0;
        }
        this.numLayers = layerNo;
        this.Sugiyama(layers);
        if (this.debugMode) {
            System.out.println("Finish Sugiyama");
        }
        return layers;
    }

    private void Sort(float[] barycentres, Vector bottomRow) {
        int pos = 0;
        Integer tempVertex = null;
        for (int i = 1; i < bottomRow.size(); ++i) {
            float tempBary = barycentres[i];
            tempVertex = (Integer)bottomRow.elementAt(i);
            for (pos = 0; pos < i && !(barycentres[i] < barycentres[pos]); ++pos) {
            }
            for (int k = i; k > pos; --k) {
                barycentres[k] = barycentres[k - 1];
            }
            bottomRow.removeElementAt(i);
            bottomRow.insertElementAt(tempVertex, pos);
            barycentres[pos] = tempBary;
        }
    }

    public void BarycentreSort(Vector topRow, Vector bottomRow, Vector relations) {
        float[] barycentres = new float[bottomRow.size()];
        int nominator = 0;
        int denominator = 0;
        for (int i = 0; i < bottomRow.size(); ++i) {
            nominator = 0;
            denominator = 0;
            Enumeration e = ((Vector)relations.elementAt(i)).elements();
            while (e.hasMoreElements()) {
                Integer x = (Integer)e.nextElement();
                int index = topRow.indexOf(x);
                if (index == -1) {
                    System.exit(-1);
                    continue;
                }
                nominator += 1 + index;
                ++denominator;
            }
            barycentres[i] = denominator == 0 ? 0.0f : (float)nominator / (float)denominator;
        }
        this.Sort(barycentres, bottomRow);
    }

    private void Sugiyama(Vector layers) {
        for (int i = layers.size() - 2; i >= 0; --i) {
            Vector<Vector> relations = new Vector<Vector>();
            Enumeration e = ((Vector)layers.elementAt(i)).elements();
            while (e.hasMoreElements()) {
                Integer x = (Integer)e.nextElement();
                relations.addElement(this.getVertex(x).getParents());
            }
            this.BarycentreSort((Vector)layers.elementAt(i + 1), (Vector)layers.elementAt(i), relations);
        }
    }
}

