/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeLayouter;
import lsedit.LandscapeViewerCore;
import lsedit.ToolBarEventHandler;

public class GridGroupHorizontally
extends LandscapeLayouter
implements ToolBarEventHandler {
    public GridGroupHorizontally(LandscapeViewerCore ls) {
        super(ls);
    }

    public String getMenuLabel() {
        return "Layout group horizontally";
    }

    public String doLayout(Diagram dg) {
        double scaleX;
        double newHeight;
        double newY;
        EntityInstance ce;
        Vector cset = dg.getGroup();
        if (cset == null) {
            this.beep();
            return "No group selected";
        }
        EntityInstance ke = dg.getKeyEntity();
        if (ke == null) {
            this.beep();
            return "No key entitity";
        }
        int num = 0;
        double width = 0.0;
        Enumeration en = cset.elements();
        while (en.hasMoreElements()) {
            ce = (EntityInstance)en.nextElement();
            width += ce.widthRelLocal();
            ++num;
        }
        if (num == 0) {
            return "Empty group";
        }
        dg.beginUndoRedo("Layout grid horizontally");
        double newX = ke.xRelLocal();
        double y = newY = ke.yRelLocal();
        double newWidth = ke.widthRelLocal();
        double height = newHeight = ke.heightRelLocal();
        double gap = width / ((double)num * 10.0);
        width += gap * (double)(num - 1);
        double startX = newX;
        if (width + startX > 0.95) {
            startX = 0.95 - width;
            if (startX < 0.05) {
                startX = 0.05;
            }
            newX = startX;
        }
        if (width + startX > 0.95) {
            scaleX = 0.95 / (width + startX);
            gap *= scaleX;
            newWidth = ke.widthRelLocal() * scaleX;
        } else {
            scaleX = 1.0;
        }
        ke.updateRelLocal(newX, newY, newWidth, newHeight);
        double x = startX + ke.widthRelLocal();
        en = cset.elements();
        while (en.hasMoreElements()) {
            ce = (EntityInstance)en.nextElement();
            if (ce == ke) continue;
            newX = x += gap;
            newY = y;
            newWidth = ce.widthRelLocal();
            newHeight = height;
            if (scaleX != 1.0) {
                newWidth *= scaleX;
            }
            ce.updateRelLocal(newX, newY, newWidth, newHeight);
            x += ce.widthRelLocal();
        }
        dg.endUndoRedo();
        return "Laid out group to grid horizontally";
    }

    public void processKeyEvent(int key, int modifiers, Object object) {
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            String rmsg = this.doLayout(dg);
            this.m_ls.doFeedback(rmsg);
            dg.redrawDiagram();
        }
    }
}

