/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeLayouter;
import lsedit.LandscapeViewerCore;
import lsedit.ToolBarEventHandler;

public class GridGroupVertically
extends LandscapeLayouter
implements ToolBarEventHandler {
    public GridGroupVertically(LandscapeViewerCore ls) {
        super(ls);
    }

    public String getMenuLabel() {
        return "Layout group vertically";
    }

    public String doLayout(Diagram dg) {
        double scaleY;
        double newWidth;
        double newX;
        EntityInstance ce;
        Vector cset = dg.getGroup();
        if (cset == null) {
            this.beep();
            return "No group selected";
        }
        EntityInstance ke = dg.getKeyEntity();
        if (ke == null) {
            this.beep();
            return "No key entitity";
        }
        int num = 0;
        double height = 0.0;
        Enumeration en = cset.elements();
        while (en.hasMoreElements()) {
            ce = (EntityInstance)en.nextElement();
            height += ce.heightRelLocal();
            ++num;
        }
        if (num == 0) {
            return "Empty group";
        }
        dg.beginUndoRedo("Layout Grid Vertically");
        double x = newX = ke.xRelLocal();
        double newY = ke.yRelLocal();
        double width = newWidth = ke.widthRelLocal();
        double newHeight = ke.heightRelLocal();
        double gap = height / ((double)num * 10.0);
        height += gap * (double)(num - 1);
        double startY = newY;
        if (height + startY > 0.95) {
            startY = 0.95 - height;
            if (startY < 0.05) {
                startY = 0.05;
            }
            newY = startY;
        }
        if (height + startY > 0.95) {
            scaleY = 0.95 / (height + startY);
            gap *= scaleY;
            newHeight *= scaleY;
        } else {
            scaleY = 1.0;
        }
        ke.updateRelLocal(newX, newY, newWidth, newHeight);
        double y = startY + ke.heightRelLocal();
        en = cset.elements();
        while (en.hasMoreElements()) {
            ce = (EntityInstance)en.nextElement();
            if (ce == ke) continue;
            newX = x;
            newY = y += gap;
            newWidth = width;
            newHeight = ce.heightRelLocal();
            if (scaleY != 1.0) {
                newHeight *= scaleY;
            }
            ce.updateRelLocal(newX, newY, newWidth, newHeight);
            y += newHeight;
        }
        dg.endUndoRedo();
        return "Laid out group to grid vertically";
    }

    public void processKeyEvent(int key, int modifiers, Object object) {
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            String rmsg = this.doLayout(dg);
            this.m_ls.doFeedback(rmsg);
            dg.redrawDiagram();
        }
    }
}

