/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;
import lsedit.RelationInstance;
import lsedit.SortVector;

public class GroupModeHandler
extends LandscapeModeHandler {
    protected static final int NONE = 0;
    protected static final int GROUPING = 1;
    protected static final int SINGLE_MOVE = 2;
    protected DrawOutline m_drawOutline;
    protected Vector m_groupList = null;
    protected Rectangle m_grpLayout;
    protected int m_curX;
    protected int m_curY;
    protected Rectangle m_shift = null;
    protected int m_groupMode = 0;
    protected double m_dx;
    protected double m_dy;
    protected LandscapeModeHandler parent = null;
    private boolean seen_motion;
    private Rectangle m_rect;

    protected void setShift(int x, int y, int width, int height) {
        if (this.m_shift == null) {
            this.m_shift = new Rectangle(x, y, width, height);
            this.m_drawOutline.setBounds(this.m_dg.getBounds());
            this.m_drawOutline.setVisible(true);
            this.m_dg.add((Component)this.m_drawOutline, 0);
        } else {
            this.m_shift.setBounds(x, y, width, height);
            this.m_drawOutline.repaint();
        }
    }

    protected void clearShift() {
        if (this.m_shift != null) {
            this.m_shift = null;
            this.m_rect = null;
            this.m_drawOutline.setVisible(false);
            this.m_dg.remove(this.m_drawOutline);
        }
    }

    protected EntityInstance findOverlap(Rectangle lyt) {
        double dx = lyt.x - this.m_grpLayout.x;
        double dy = lyt.y - this.m_grpLayout.y;
        EntityInstance e = this.m_dg.getKeyEntity();
        Rectangle elyt = e.getDiagramBounds();
        elyt.x = (int)((double)elyt.x + dx);
        elyt.y = (int)((double)elyt.y + dy);
        EntityInstance oe = this.m_dg.intersects(lyt);
        if (oe != null && !this.m_groupList.contains(oe)) {
            return oe;
        }
        Enumeration en = this.m_groupList.elements();
        while (en.hasMoreElements()) {
            e = (EntityInstance)en.nextElement();
            elyt = e.getDiagramBounds();
            elyt.x = (int)((double)elyt.x + dx);
            elyt.y = (int)((double)elyt.y + dy);
            oe = this.m_dg.intersects(lyt);
            if (oe == null || this.m_groupList.contains(oe)) continue;
            return oe;
        }
        return null;
    }

    protected void moveGroup(EntityInstance container, double dx, double dy) {
        Enumeration en;
        EntityInstance e = (EntityInstance)this.m_groupList.firstElement();
        boolean changeParent = e.getContainedBy() != container;
        int width = 0;
        int height = 0;
        if (changeParent) {
            int num = container.numChildren();
            if (num == 0) {
                Rectangle plyt = e.getContainedBy().getDiagramBounds();
                Rectangle nplyt = container.getDiagramBounds();
                double xs = (double)nplyt.width / (double)plyt.width;
                double ys = (double)nplyt.height / (double)plyt.height;
                Rectangle lyt = e.getDiagramBounds();
                width = (int)((double)lyt.width * xs);
                height = (int)((double)lyt.height * ys);
            } else {
                en = container.getChildren();
                while (en.hasMoreElements()) {
                    e = (EntityInstance)en.nextElement();
                    Rectangle elyt = e.getDiagramBounds();
                    width += elyt.width;
                    height += elyt.height;
                }
                width /= num;
                height /= num;
            }
        }
        en = this.m_groupList.elements();
        while (en.hasMoreElements()) {
            e = (EntityInstance)en.nextElement();
            Rectangle elyt = e.getDiagramBounds();
            elyt.x = (int)((double)elyt.x + dx);
            elyt.y = (int)((double)elyt.y + dy);
            if (changeParent) {
                elyt.width = width;
                elyt.height = height;
            }
            this.m_ls.moveEntityContainment(container, e);
            e.setDiagramBounds(elyt);
        }
        if (changeParent) {
            this.m_dg.prepostorder();
        }
        en = this.m_groupList.elements();
        while (en.hasMoreElements()) {
            e = (EntityInstance)en.nextElement();
            e.validateEdges();
        }
    }

    protected void moveGroup(EntityInstance container) {
        double dx = this.m_shift.x - this.m_grpLayout.x;
        double dy = this.m_shift.y - this.m_grpLayout.y;
        this.moveGroup(container, dx, dy);
    }

    protected void setAsKeyEntity(EntityInstance e) {
        this.m_dg.setKeyEntity(e);
    }

    protected void selectEntity(EntityInstance e) {
        this.m_dg.setPreserveEntityMarks(196608);
        this.m_dg.setPreserveRelationMarks(0);
        if (e.getGroupFlag()) {
            if (e != this.m_dg.getKeyEntity()) {
                this.setAsKeyEntity(e);
            }
        } else {
            EntityInstance old_ke = this.m_dg.getKeyEntity();
            if (old_ke != null) {
                boolean ret = this.m_dg.clearFlags();
                this.m_dg.setKeyEntity(e);
                if (ret) {
                    this.m_ls.repaintDg();
                }
            } else {
                this.setAsKeyEntity(e);
            }
        }
        this.show_groupList();
    }

    protected void toggleMembership(EntityInstance e) {
        if (e.getGroupFlag()) {
            if (e == this.m_dg.getKeyEntity()) {
                Vector grp = this.m_dg.getGroup();
                if (grp.size() == 1) {
                    this.m_dg.clearFlags();
                    e.repaint();
                } else {
                    e.clearGroupFlag();
                    grp = this.m_dg.getGroup();
                    EntityInstance nke = (EntityInstance)grp.firstElement();
                    this.setAsKeyEntity(nke);
                }
            } else {
                e.clearGroupFlag();
                e.repaint();
            }
        } else {
            EntityInstance fe;
            Vector grp = this.m_dg.getGroup();
            if (grp != null && (fe = (EntityInstance)grp.firstElement()).getContainedBy() != e.getContainedBy()) {
                this.selectEntity(e);
                return;
            }
            this.setAsKeyEntity(e);
        }
        this.show_groupList();
    }

    protected boolean groupingStart(MouseEvent ev, int x, int y) {
        this.m_curX = x;
        this.m_curY = y;
        this.clearShift();
        return true;
    }

    protected void groupingMotion(MouseEvent ev, Object thing, int x, int y) {
        if (thing instanceof EntityInstance) {
            int shiftHeight;
            int shiftY;
            int shiftWidth;
            int shiftX;
            int nx = x;
            int ny = y;
            Rectangle lyt = ((EntityInstance)thing).getDiagramBounds();
            if (nx < lyt.x + 4) {
                nx = lyt.x + 4;
            } else if (nx > lyt.x + lyt.width - 4) {
                nx = lyt.x + lyt.width - 4;
            }
            if (ny < lyt.y + 4) {
                ny = lyt.y + 4;
            } else if (ny > lyt.y + lyt.height - 4) {
                ny = lyt.y + lyt.height - 4;
            }
            if (nx > this.m_curX) {
                shiftX = this.m_curX;
                shiftWidth = nx - this.m_curX;
            } else {
                shiftX = nx;
                shiftWidth = this.m_curX - nx;
            }
            if (ny > this.m_curY) {
                shiftY = this.m_curY;
                shiftHeight = y - this.m_curY;
            } else {
                shiftY = y;
                shiftHeight = this.m_curY - y;
            }
            this.setShift(shiftX, shiftY, shiftWidth, shiftHeight);
            this.m_rect = this.m_shift;
            this.m_drawOutline.repaint();
        }
    }

    protected void groupingEnd(MouseEvent ev) {
        Vector gl = this.m_dg.setGroupRegion(this.m_shift);
        if (gl != null) {
            this.show_groupList();
            this.m_dg.setKeyEntity((EntityInstance)gl.firstElement());
            this.m_rect = null;
        } else {
            this.m_rect = this.m_shift;
        }
        this.m_drawOutline.repaint();
    }

    protected boolean moveGroupStart(MouseEvent ev, int x, int y) {
        this.m_groupList = this.m_dg.getGroup();
        this.seen_motion = false;
        if (this.m_groupList == null) {
            return false;
        }
        EntityInstance pe = ((EntityInstance)this.m_groupList.firstElement()).getContainedBy();
        if (pe == null) {
            return false;
        }
        this.m_grpLayout = this.m_dg.getGroupBoundingBox();
        this.setShift(this.m_grpLayout.x, this.m_grpLayout.y, this.m_grpLayout.width, this.m_grpLayout.height);
        this.m_dx = x - this.m_shift.x;
        this.m_dy = y - this.m_shift.y;
        if (this.m_groupList.size() == 1) {
            this.m_ls.doFeedback("Moving entity: (" + this.m_shift.x + ", " + this.m_shift.y + ")");
        } else {
            this.m_ls.doFeedback("Moving group (key): (" + this.m_shift.x + ", " + this.m_shift.y + ")");
        }
        return true;
    }

    protected void moveGroupMotion(MouseEvent ev, int x, int y) {
        if (!this.seen_motion) {
            EntityInstance pe = ((EntityInstance)this.m_groupList.firstElement()).getContainedBy();
            this.seen_motion = true;
        }
        Rectangle lyt = this.m_dg.getDrawRoot().getDiagramBounds();
        int grid = this.m_dg.getGrid();
        double nx = Math.round((double)x - this.m_dx) / (long)grid * (long)grid;
        double ny = Math.round((double)y - this.m_dy) / (long)grid * (long)grid;
        if (nx < (double)(lyt.x + 4)) {
            nx = lyt.x + 4;
        }
        if (ny < (double)(lyt.y + 4)) {
            ny = lyt.y + 4;
        }
        if (nx + (double)this.m_shift.width > (double)(lyt.x + lyt.width - 8)) {
            nx = lyt.x + lyt.width - this.m_shift.width - 8;
        }
        if (ny + (double)this.m_shift.height > (double)(lyt.y + lyt.height - 8)) {
            ny = lyt.y + lyt.height - this.m_shift.height - 8;
        }
        this.m_shift.x = (int)nx;
        this.m_shift.y = (int)ny;
        if (this.m_groupList.size() == 1) {
            this.m_ls.doFeedback("Moving entity: (" + Math.round(nx) + ", " + Math.round(ny) + ")");
        } else {
            this.m_ls.doFeedback("Moving group (key): (" + Math.round(nx) + ", " + Math.round(ny) + ")");
        }
        this.m_drawOutline.repaint();
    }

    protected void moveGroupEnd(MouseEvent ev) {
        boolean changeParent;
        this.m_ls.clearFeedback();
        if (!this.seen_motion) {
            this.clearShift();
            return;
        }
        EntityInstance ke = this.m_dg.getKeyEntity();
        double dx = this.m_shift.x - this.m_grpLayout.x;
        double dy = this.m_shift.y - this.m_grpLayout.y;
        Rectangle klyt = ke.getDiagramBounds();
        klyt.x = (int)((double)klyt.x + dx);
        klyt.y = (int)((double)klyt.y + dy);
        EntityInstance container = this.m_dg.containing(klyt);
        if (container == null) {
            this.m_ls.error("Failed to find container");
            this.clearShift();
            return;
        }
        boolean bl = changeParent = container != ke.getContainedBy();
        if (changeParent && container.getContainedBy() == null) {
            this.m_ls.error("Can't move into $ROOT");
            this.clearShift();
            return;
        }
        if (this.m_groupList.contains(container)) {
            container = container.getContainedBy();
        }
        Diagram diagram = ke.getDiagram();
        diagram.beginUndoRedo("Group Move");
        this.moveGroup(container);
        if (changeParent) {
            container.setContainElision();
            this.m_ls.doFeedback("Group move into: " + container.getLabel());
        }
        diagram.endUndoRedo();
        this.clearShift();
    }

    public GroupModeHandler(LandscapeModeHandler parent) {
        this.parent = parent;
        this.m_drawOutline = new DrawOutline(this);
    }

    public void select(Diagram dg) {
        if (this.m_dg != dg) {
            this.clearShift();
            super.select(dg);
        }
    }

    public Rectangle getRect() {
        return this.m_rect;
    }

    public Rectangle getShift() {
        return this.m_shift;
    }

    public Rectangle getGrpLayout() {
        return this.m_grpLayout;
    }

    public Vector getGroupList() {
        return this.m_groupList;
    }

    public void halt() {
        this.m_groupMode = 0;
    }

    public void show_groupList() {
        Vector grp = this.m_dg.getGroup();
        if (grp != null) {
            SortVector.byString(grp);
            this.m_ls.showResults("GROUP:", grp, false);
        } else {
            this.m_ls.error("No entities selected");
        }
    }

    public void groupAll() {
        EntityInstance ke;
        EntityInstance ge = ke = this.m_dg.getKeyEntity();
        if (ke == null) {
            ge = ke = this.m_dg.getDrawRoot();
        }
        boolean ret = this.m_dg.clearFlags();
        if (!ge.isOpen()) {
            ge = ge.getContainedBy();
        }
        Enumeration en = ge.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance ce = (EntityInstance)en.nextElement();
            ce.setGroupFlag();
        }
        Vector grp = this.m_dg.getGroup();
        if (grp != null) {
            if (!grp.contains(ke)) {
                ke = (EntityInstance)grp.firstElement();
            }
            this.m_dg.setKeyEntity(ke);
            this.m_dg.setPreserveEntityMarks(196608);
            this.m_dg.setPreserveRelationMarks(0);
            if (ret) {
                this.m_ls.redrawDg();
            }
            this.show_groupList();
        } else {
            this.m_ls.error("No entities selected");
        }
    }

    public void moveGroup(int key) {
        this.m_groupList = this.m_dg.getGroup();
        if (this.m_groupList == null) {
            return;
        }
        EntityInstance pe = this.m_dg.getKeyEntity().getContainedBy();
        double dx = 0.0;
        double dy = 0.0;
        switch (key) {
            case 38: {
                dx = 0.0;
                dy = -1.0;
                break;
            }
            case 40: {
                dx = 0.0;
                dy = 1.0;
                break;
            }
            case 39: {
                dx = 1.0;
                dy = 0.0;
                break;
            }
            case 37: {
                dx = -1.0;
                dy = 0.0;
            }
        }
        this.moveGroup(pe, dx, dy);
    }

    public boolean entityPressed(MouseEvent ev, EntityInstance e, int x, int y) {
        if (ev.isShiftDown()) {
            if (ev.isAltDown()) {
                this.m_groupMode = 1;
                return this.groupingStart(ev, x, y);
            }
            if (ev.isMetaDown()) {
                if (e != this.m_dg.getDrawRoot()) {
                    this.setAsKeyEntity(e);
                }
            } else if (e != this.m_dg.getDrawRoot()) {
                this.toggleMembership(e);
            }
        } else {
            if (e != this.m_dg.getDrawRoot() && !e.isClientOrSupplier()) {
                this.selectEntity(e);
                this.m_ls.setCursor(13);
                this.m_groupMode = 2;
                return this.moveGroupStart(ev, x, y);
            }
            this.selectEntity(e);
            this.m_groupMode = 0;
            return true;
        }
        this.m_groupMode = 0;
        return false;
    }

    public boolean entityDragged(MouseEvent ev, EntityInstance e, int x, int y) {
        switch (this.m_groupMode) {
            case 1: {
                this.groupingMotion(ev, e, x, y);
                break;
            }
            case 2: {
                this.moveGroupMotion(ev, x, y);
            }
        }
        return true;
    }

    public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y) {
        switch (this.m_groupMode) {
            case 1: {
                this.groupingEnd(ev);
                break;
            }
            case 2: {
                this.moveGroupEnd(ev);
                break;
            }
            default: {
                return;
            }
        }
        this.m_ls.setCursor(0);
        this.m_groupMode = 0;
    }

    public boolean relationPressed(MouseEvent ev, RelationInstance ri, int x, int y) {
        ri.setGroupAndHighlightFlag();
        return false;
    }

    protected class DrawOutline
    extends JComponent {
        private GroupModeHandler m_handler;

        public DrawOutline(GroupModeHandler handler) {
            this.m_handler = handler;
            this.setForeground(Color.BLACK);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle rect = this.m_handler.getRect();
            Rectangle shift = this.m_handler.getShift();
            if (rect != null) {
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (shift != null) {
                Rectangle grpLayout = this.m_handler.getGrpLayout();
                int dx = shift.x - grpLayout.x;
                int dy = shift.y - grpLayout.y;
                Enumeration en = this.m_handler.getGroupList().elements();
                while (en.hasMoreElements()) {
                    EntityInstance e = (EntityInstance)en.nextElement();
                    g.drawRect(e.getDiagramX() + dx, e.getDiagramY() + dy, e.getWidth(), e.getHeight());
                }
            }
        }
    }
}

