/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;
import lsedit.Do;
import lsedit.StringLinizer;

public class HelpBox
extends JPanel {
    protected static final int GAP = 5;
    protected static final int HELP_WIDTH = 250;
    protected static final Color BACKGROUND_COLOUR = new Color(1.0f, 1.0f, 0.85f);
    protected static final Font textFont = new Font("Helvetica", 0, 11);
    protected String text;
    protected boolean horizFit = false;

    protected void drawText(Graphics g, Rectangle r) {
        int xpos = 5;
        int ypos = 5;
        String desc = this.text;
        g.setColor(Color.black);
        g.setFont(textFont);
        FontMetrics fm = g.getFontMetrics();
        int h = Do.fontHeight(textFont) - 2;
        ypos += h;
        StringLinizer sl = new StringLinizer(desc, fm, r.width - 10);
        while (sl.hasMoreLines()) {
            String line = sl.nextLine();
            g.drawString(line, xpos, ypos);
            ypos += h + 2;
        }
    }

    protected int countLines(Graphics g, int width) {
        int xpos = 5;
        int ypos = 5;
        g.setFont(textFont);
        FontMetrics fm = g.getFontMetrics();
        String desc = this.text;
        StringLinizer sl = new StringLinizer(desc, fm, width);
        int numLines = 0;
        while (sl.hasMoreLines()) {
            String line = sl.nextLine();
            ++numLines;
        }
        return numLines;
    }

    protected void setSize(Graphics gc) {
        if (this.text != null) {
            gc.setFont(textFont);
            FontMetrics fm = gc.getFontMetrics();
            int w = this.horizFit ? fm.stringWidth(this.text) + 10 : 250;
            int h = Do.fontHeight(textFont);
            int n = this.countLines(gc, w - 10);
            this.setSize(w, h * n + 10);
        }
    }

    public HelpBox() {
        this.setBackground(BACKGROUND_COLOUR);
        this.setSize(250, 5);
        this.setVisible(false);
    }

    public void paintComponent(Graphics gc) {
        this.setSize(gc);
        Rectangle r = this.getBounds();
        gc.clearRect(0, 0, r.width, r.height);
        gc.setColor(Color.black);
        gc.drawRect(0, 0, r.width - 1, r.height - 1);
        if (this.text != null) {
            this.drawText(gc, r);
        }
    }

    public void set(String text, boolean horizFit) {
        this.text = text;
        this.repaint();
        this.horizFit = horizFit;
    }

    public void set(String text) {
        this.set(text, false);
    }
}

