/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.undo.UndoableEdit;
import lsedit.Diagram;
import lsedit.LandscapeViewerCore;
import lsedit.MyCompoundEdit;
import lsedit.MyMenuItem;
import lsedit.MyPaintableUndoableEdit;
import lsedit.ToolBarEventHandler;

public class HistoryBox
extends JComponent
implements ToolBarEventHandler,
MouseListener,
MouseMotionListener {
    protected static final int MARGIN = 5;
    protected static final int HEIGHT = 16;
    protected static final int BASELINE = 12;
    protected static final int GAP = 5;
    protected static final int TY_CLEAR = 0;
    protected static final int TY_RAISED = 1;
    protected static final int TY_SUNK = 2;
    protected LandscapeViewerCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    public static Dimension m_preferredSize = new Dimension(0, 0);
    public static final String m_helpStr = "This box shows the history of updates made in the current diagram.";
    protected int m_style;
    protected int m_over;
    protected static final Font m_textFont = new Font("Helvetica", 0, 11);

    public HistoryBox(LandscapeViewerCore ls, JTabbedPane tabbedPane) {
        this.m_ls = ls;
        this.m_tabbedPane = tabbedPane;
        this.setBackground(Diagram.boxColour);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setHorizontalScrollBarPolicy(30);
        this.m_scrollPane.setVerticalScrollBarPolicy(20);
        this.m_scrollPane.setViewportView(this);
        tabbedPane.addTab("History", null, this.m_scrollPane, m_helpStr);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public Dimension getPreferredSize() {
        return m_preferredSize;
    }

    public LandscapeViewerCore getLegendLs() {
        return this.m_ls;
    }

    public void fillHistoryBox() {
        this.repaint();
    }

    public void activate() {
        this.fillHistoryBox();
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component active = this.m_tabbedPane.getSelectedComponent();
        return active != null && this.m_scrollPane == active;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public void paintComponent(Graphics g) {
        int height = 16;
        Vector v = this.m_ls.getEdits();
        if (v != null) {
            UndoableEdit editToBeRedone = this.m_ls.getEditToBeRedone();
            int at = this.m_over;
            g.setFont(m_textFont);
            g.setColor(Color.BLACK);
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                Color color;
                UndoableEdit undoableEdit = (UndoableEdit)en.nextElement();
                if (undoableEdit == editToBeRedone) {
                    g.setColor(Color.RED);
                }
                if (at == 0 && this.m_style != 0) {
                    color = g.getColor();
                    g.setColor(Color.BLACK);
                    g.draw3DRect(0, height, HistoryBox.m_preferredSize.width - 1, 14, this.m_style == 1);
                    g.setColor(color);
                }
                if (undoableEdit instanceof MyPaintableUndoableEdit) {
                    ((MyPaintableUndoableEdit)undoableEdit).paintComponent(g, 5, height);
                } else if (undoableEdit instanceof MyCompoundEdit) {
                    color = g.getColor();
                    g.setColor(Color.WHITE);
                    g.fill3DRect(0, height, HistoryBox.m_preferredSize.width - 1, 14, at == 0 && this.m_style == 1);
                    g.setColor(color);
                    g.drawString(undoableEdit.getPresentationName(), 5, height + 12);
                } else {
                    g.drawString(undoableEdit.getPresentationName(), 5, height + 12);
                }
                height += 16;
                --at;
            }
        }
    }

    protected void mouseAt(int y) {
        int style;
        int over = y / 16 - 1;
        if (over < 0) {
            style = 0;
            over = -1;
        } else {
            int max = this.m_ls.countEdits();
            if (over >= max) {
                style = 0;
                over = max;
            } else {
                style = 1;
            }
        }
        if (style != this.m_style || over != this.m_over) {
            this.m_style = style;
            this.m_over = over;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
        this.mouseAt(ev.getY());
    }

    public void mouseExited(MouseEvent ev) {
        this.m_style = 0;
        this.repaint();
    }

    public void mousePressed(MouseEvent ev) {
        Vector v;
        int over;
        this.m_over = over = ev.getY() / 16 - 1;
        if (ev.isMetaDown()) {
            int max;
            Vector v2 = this.m_ls.getEdits();
            if (v2 != null && (max = v2.size()) > 0) {
                if (over >= 0 && over < max) {
                    UndoableEdit undoableEdit = (UndoableEdit)v2.elementAt(over);
                    if (undoableEdit instanceof MyCompoundEdit) {
                        JPopupMenu m = new JPopupMenu("Undo/Redo options");
                        MyMenuItem m1 = new MyMenuItem(m, "Show details", this, 0, 10);
                        m1.setObject(undoableEdit);
                        m.show(this, ev.getX(), ev.getY());
                    }
                } else {
                    JPopupMenu m = new JPopupMenu("Discard History");
                    new MyMenuItem(m, "Dispose", this, 0, 127);
                    m.setForeground(Color.RED);
                    m.show(this, ev.getX(), ev.getY());
                }
            }
            return;
        }
        this.m_style = 2;
        if (over >= 0 && (v = this.m_ls.getEdits()) != null) {
            UndoableEdit editToBeRedone = this.m_ls.getEditToBeRedone();
            int at = this.m_over;
            boolean redo = false;
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                UndoableEdit undoableEdit = (UndoableEdit)en.nextElement();
                if (undoableEdit == editToBeRedone) {
                    redo = true;
                }
                if (at == 0) {
                    this.m_ls.massChange(undoableEdit, redo);
                    break;
                }
                --at;
            }
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent ev) {
        this.m_style = 0;
        this.repaint();
    }

    public void mouseDragged(MouseEvent ev) {
        this.mouseAt(ev.getY());
    }

    public void mouseMoved(MouseEvent ev) {
        this.mouseAt(ev.getY());
    }

    public void processKeyEvent(int key, int modifiers, Object object) {
        switch (key) {
            case 10: {
                new ShowCompoundEdit(this, (MyCompoundEdit)object);
                break;
            }
            case 127: {
                this.m_ls.discardAllEdits();
            }
        }
    }

    public void showInfo(String msg) {
    }

    public class ShowCompoundEdit
    extends JDialog {
        MyCompoundEdit m_compoundEdit;

        public ShowCompoundEdit(HistoryBox historyBox2, MyCompoundEdit compoundEdit) {
            super((Frame)historyBox2.m_ls.getFrame(), compoundEdit.getPresentationName());
            Dimension preferredSize = new Dimension();
            int x = historyBox2.m_tabbedPane.getX() + 20;
            int y = historyBox2.m_tabbedPane.getY() + 20;
            this.setLocation(x, y);
            int width = historyBox2.getWidth();
            int height = historyBox2.getHeight();
            this.m_compoundEdit = compoundEdit;
            Vector v = compoundEdit.getEdits();
            preferredSize.height = v.size() * 16 + 5 + 20;
            preferredSize.width = 0;
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                int w;
                UndoableEdit undoableEdit = (UndoableEdit)en.nextElement();
                if (undoableEdit instanceof MyPaintableUndoableEdit) {
                    w = ((MyPaintableUndoableEdit)undoableEdit).getPreferredWidth();
                } else {
                    FontMetrics fm = this.getFontMetrics(m_textFont);
                    w = fm.stringWidth(undoableEdit.getPresentationName());
                }
                if (w <= preferredSize.width) continue;
                preferredSize.width = w;
            }
            preferredSize.width += 5;
            if (preferredSize.width < width / 2) {
                preferredSize.width = width / 2;
            }
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.setSize(preferredSize);
            ShowCompoundEditPanel panel = new ShowCompoundEditPanel(v);
            panel.setPreferredSize(preferredSize);
            panel.setSize(preferredSize);
            contentPane.add((Component)panel, "Center");
            this.pack();
            this.show();
        }

        public class ShowCompoundEditPanel
        extends JComponent {
            Vector m_v;

            ShowCompoundEditPanel(Vector v) {
                this.m_v = v;
            }

            public void paintComponent(Graphics g) {
                int height = 16;
                Vector v = this.m_v;
                this.setBackground(Color.lightGray);
                if (v != null) {
                    g.setFont(m_textFont);
                    g.setColor(Color.BLACK);
                    Enumeration en = v.elements();
                    while (en.hasMoreElements()) {
                        UndoableEdit undoableEdit = (UndoableEdit)en.nextElement();
                        if (undoableEdit instanceof MyPaintableUndoableEdit) {
                            ((MyPaintableUndoableEdit)undoableEdit).paintComponent(g, 5, height);
                        } else {
                            g.drawString(undoableEdit.getPresentationName(), 5, height + 12);
                        }
                        height += 16;
                    }
                }
            }
        }
    }
}

