/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.LandscapeObject;
import lsedit.LandscapeObject3D;
import lsedit.Util;

public abstract class LandscapeClassObject
extends LandscapeObject3D {
    protected Vector inherits = new Vector();
    protected static final String CLASSLABEL_ID = "class_label";
    protected static final String CLASSSTYLE_ID = "class_style";
    protected static final String CLASSDESC_ID = "class_description";
    private int m_nid = -1;
    private Diagram m_dg;

    protected void makeInstanceOfUs(LandscapeObject lo) {
        Enumeration en = this.getParentElements();
        while (en.hasMoreElements()) {
            LandscapeClassObject lco = (LandscapeClassObject)en.nextElement();
            if (lco == null) {
                System.out.println("Internal error: Null inheritance");
                break;
            }
            lco.makeInstanceOfUs(lo);
        }
        if ((en = this.getLsAttributesEnum()) != null) {
            while (en.hasMoreElements()) {
                Attribute attr = (Attribute)en.nextElement();
                if (attr.id.startsWith("class")) continue;
                lo.addAttribute(attr);
            }
        }
    }

    protected String addParentClass(LandscapeClassObject lco, String baseId) {
        if (lco == null) {
            return "Can't inherit from null class";
        }
        if (!this.inherits.contains(lco)) {
            this.inherits.addElement(lco);
            return null;
        }
        return "Already inherits from " + lco.getId();
    }

    protected boolean processClassAttributes(Attribute attr) {
        if (attr.id.startsWith("class_")) {
            if (attr.avi != null) {
                if (attr.id.equals(CLASSLABEL_ID)) {
                    this.setLabel(attr.avi.value);
                } else if (attr.id.equals(CLASSSTYLE_ID)) {
                    this.setStyle(Util.parseInt(attr.avi.value));
                } else if (attr.id.equals(CLASSDESC_ID)) {
                    this.setDescription(attr.avi.value);
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Diagram getDiagram() {
        return this.m_dg;
    }

    public void setDiagram(Diagram dg) {
        this.m_dg = dg;
    }

    public int getNid() {
        return this.m_nid;
    }

    public void setNid(int nid) {
        this.m_nid = nid;
    }

    public LandscapeClassObject derivedFrom(int i) {
        return i < this.inherits.size() ? (LandscapeClassObject)this.inherits.elementAt(i) : null;
    }

    public void addAttribute(Attribute attr) {
        if (this.processClassAttributes(attr)) {
            return;
        }
        if (this.processFirstOrder(attr)) {
            return;
        }
        Attribute curAttr = this.getLsAttribute(attr.id);
        if (curAttr == null) {
            this.putLsAttribute(attr);
            attr.cloneOnAssign = true;
        } else if (attr.avi != null) {
            curAttr.avi = attr.avi;
        }
    }

    public boolean addRawAttribute(String id, int val) {
        if (id.equals(CLASSSTYLE_ID)) {
            this.setStyle(val);
            return true;
        }
        return super.addRawAttribute(id, val);
    }

    public boolean addRawAttribute(String id, double val) {
        return false;
    }

    public boolean addRawAttribute(String id, String val) {
        if (id.equals(CLASSLABEL_ID)) {
            this.setLabel(val);
            return true;
        }
        if (id.equals(CLASSDESC_ID)) {
            this.setDescription(val);
            return true;
        }
        return false;
    }

    public Attribute getLsAttribute(String id) {
        Attribute attr = super.getLsAttribute(id);
        if (attr != null) {
            return attr;
        }
        Enumeration en = this.getParentElements();
        while (en.hasMoreElements()) {
            LandscapeClassObject lco = (LandscapeClassObject)en.nextElement();
            attr = lco.getLsAttribute(id);
            if (attr == null) continue;
            return attr;
        }
        return null;
    }

    public void writeAttributes(PrintStream ps) throws IOException {
        super.writeAttributes(ps, null, true);
        String label = this.getLabel();
        if (!this.getId().equals(label)) {
            ps.print(" class_label = " + this.qt(label) + "\n");
        }
        ps.print(" class_style = " + this.getStyle() + "\n");
        String description = this.getDescription();
        if (description != null) {
            ps.print(" class_description = \"" + description + "\"\n");
        }
    }

    public void getLsAttributesRaw(Vector mv, Hashtable st) {
        Vector v = new Vector();
        super.getLsAttributesRaw(v, st, true);
        String label = this.getLabel();
        if (!this.getId().equals(label)) {
            this.regRawAttribute(v, st, CLASSLABEL_ID, label);
        }
        this.regRawAttribute(v, st, CLASSSTYLE_ID, this.getStyle());
        String description = this.getDescription();
        if (description != null) {
            this.regRawAttribute(v, st, CLASSDESC_ID, description);
        }
        Object[] objs = new Object[]{st.get(this.getId()), v};
        mv.addElement(objs);
    }

    public void setColor(Color c) {
        Attribute attr = this.getLsAttribute("color");
        double r = (double)c.getRed() / 255.0;
        double g = (double)c.getGreen() / 255.0;
        double b = (double)c.getBlue() / 255.0;
        attr.avi.value = "" + r;
        attr.avi.next.value = "" + g;
        attr.avi.next.next.value = "" + b;
    }

    public boolean inheritsFrom(LandscapeClassObject lco) {
        return this.inherits.contains(lco);
    }

    public Enumeration getParentElements() {
        return this.inherits.elements();
    }
}

