/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import lsedit.ArrowDimensions;
import lsedit.DataInputStream;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.EditModeHandler;
import lsedit.EntityInstance;
import lsedit.FlipLayoutHorizontally;
import lsedit.FlipLayoutVertically;
import lsedit.GridGroupHorizontally;
import lsedit.GridGroupVertically;
import lsedit.HistoryBox;
import lsedit.InternalBufferStream;
import lsedit.LandscapeEditorFrame;
import lsedit.LandscapeLayouter;
import lsedit.LandscapeViewerCore;
import lsedit.MsgOut;
import lsedit.MyMenuItem;
import lsedit.SortVector;
import lsedit.SugiyamaLayout;
import lsedit.Util;
import lsedit.ViewModeHandler;
import lsedit.Vista;

public class LandscapeEditorCore
extends LandscapeViewerCore
implements ItemListener {
    protected static final int GRID_MAX = 10;
    protected static final int NUM_TOOL_BUTTONS = 10;
    protected static final String TITLE = "Software Landscape Editor";
    protected static final int FA_SAVE = 1;
    protected static final int FA_PRINT = 2;
    protected static final int FA_PRINT_ALL = 3;
    protected static final int FA_PRINT_BOOK = 4;
    protected EditModeHandler m_editModeHandler;
    protected ViewModeHandler m_viewModeHandler;
    protected Vector diagrams = new Vector();
    protected Vector diagramNames = new Vector();

    public String getTitle() {
        return TITLE;
    }

    public JMenuBar genMenu() {
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu("File");
        Do.landscapeMenuItem(m, this);
        m.addSeparator();
        Do.printLandscapeMenuItem(m, this);
        m.addSeparator();
        m.addSeparator();
        Do.quitMenuItem(m, this);
        mb.add(m);
        m = new JMenu("Edit");
        this.undoLandscapeMenuItem(m, this);
        Do.refreshMenuItem(m, this);
        JMenu m1 = new JMenu("Draw");
        Do.cutMenuItem(m1, this);
        Do.pasteMenuItem(m1, this);
        Do.drawMenuItem(m1, this);
        Do.deleteEdgeMenuItem(m1, this);
        Do.editEntityMenuItem(m1, this);
        Do.editRelationMenuItem(m1, this);
        m.add(m1);
        m1 = new JMenu("Find");
        Do.findMenuItem(m1, this);
        m.add(m1);
        mb.add(m);
        m = new JMenu("Arrange");
        m1 = new JMenu("Align");
        Do.alignMenuItem(m1, this);
        Do.gridMenuItem(m1, this);
        m.add(m1);
        m1 = new JMenu("Scale");
        Do.scaleMenuItem(m1, this);
        m.add(m1);
        m1 = new JMenu("Group");
        Do.fitMenuItem(m1, this);
        Do.groupMenuItem(m1, this);
        Do.groupAllMenuItem(m1, this);
        m.add(m1);
        m1 = new JMenu("Label");
        LandscapeEditorCore.fontMenuItem(m1, this);
        Do.fitLabelMenuItem(m1, this);
        m.add(m1);
        mb.add(m);
        m = new JMenu("Layout");
        LandscapeLayouter layout = new FlipLayoutHorizontally(this);
        new MyMenuItem(m, layout.getMenuLabel(), layout, 0, 0);
        layout = new FlipLayoutVertically(this);
        new MyMenuItem(m, layout.getMenuLabel(), layout, 0, 0);
        m.addSeparator();
        layout = new GridGroupHorizontally(this);
        new MyMenuItem(m, layout.getMenuLabel(), layout, 0, 0);
        layout = new GridGroupVertically(this);
        new MyMenuItem(m, layout.getMenuLabel(), layout, 0, 0);
        m.addSeparator();
        layout = new SugiyamaLayout(this);
        new MyMenuItem(m, layout.getMenuLabel(), layout, 0, 0);
        mb.add(m);
        m = new JMenu("Options");
        this.viewModeMenuItem(m, this);
        m.addSeparator();
        this.bestEdgeMenuItem(m, this);
        m.addSeparator();
        this.showMenuItem(m, this);
        mb.add(m);
        m = new JMenu("Other");
        m1 = new JMenu("Tab box");
        Do.tabMenuItem(m1, this);
        m.add(m1);
        m1 = new JMenu("Visible relations");
        Do.visibleMenuItem(m1, this);
        m.add(m1);
        m1 = new JMenu("Active relations");
        Do.activeMenuItem(m1, this);
        m.add(m1);
        mb.add(m);
        m1 = new JMenu("Navigate");
        Do.navigateEdgeMenu(m1, this);
        Do.navigateEntityMenu(m1, this);
        this.tocMenuItem(m1, this);
        m.add(m1);
        m1 = new JMenu("Query");
        Do.queryMenuItem(m1, this);
        m.add(m1);
        m1 = new JMenu("Elide");
        Do.hideMenuItem(m1, this);
        m.add(m1);
        mb.add(m);
        m = new JMenu("Help");
        Do.helpMenuItem(m, this, "Editor");
        mb.add(m);
        return mb;
    }

    protected void genDropDowns() {
        Dimension dim = new Dimension(100, 24);
        this.m_lsDropDown = new JComboBox();
        this.m_lsDropDown.setMaximumSize(dim);
        this.m_lsDropDown.setMinimumSize(dim);
        this.m_lsDropDown.setPreferredSize(dim);
        this.m_lsDropDown.setSize(dim);
        this.m_lsDropDown.addItemListener(this);
    }

    protected void genHistoryBox(Dimension d) {
        this.m_historyBox = new HistoryBox(this, this.m_rightTabbedPane);
        this.m_historyBox.setSize(d);
        this.m_historyBox.setPreferredSize(d);
    }

    protected void genGUI(int diagramPercentWidth, int diagramPercentHeight) {
        MsgOut.dprintln("App: gen GUI");
        this.genDropDowns();
        this.genMainGUI(diagramPercentWidth, diagramPercentHeight);
    }

    protected void genModeHandlers() {
        this.m_editModeHandler = new EditModeHandler();
        this.m_editModeHandler.init(this);
        this.m_viewModeHandler = new ViewModeHandler();
        this.m_viewModeHandler.init(this);
        this.m_modeHandler = this.m_editModeHandler;
    }

    protected int getNumToolButtons() {
        return this.toolButton.length;
    }

    protected void registerLsName(String name) {
        if (this.m_lsDropDown != null) {
            this.m_lsDropDown.addItem(name);
            if (this.m_lsDropDown.getItemCount() > 1) {
                this.m_lsDropDown.enable();
            }
        }
    }

    protected void setDiagram(Diagram value) {
        super.setDiagram(value);
        if (this.m_diagram != null) {
            this.m_diagram.setDrawBends(!(this.m_modeHandler instanceof ViewModeHandler));
            String diagramName = this.m_diagram.getName();
            if (diagramName != null) {
                for (int i = 0; i < this.m_lsDropDown.getItemCount(); ++i) {
                    String name = (String)this.m_lsDropDown.getItemAt(i);
                    if (!diagramName.equals(name)) continue;
                    this.m_lsDropDown.setSelectedIndex(i);
                    break;
                }
            }
        }
        if (this.m_diagram != null) {
            this.doFeedback("Set to: " + this.m_diagram.getName());
        }
        this.setLeftBox();
    }

    protected void setDiagram(int ind) {
        Diagram newDg = (Diagram)this.diagrams.elementAt(ind);
        if (newDg != this.m_diagram) {
            this.setDiagram(newDg);
        }
    }

    protected void addDiagram(Diagram newDg, String path) {
        this.diagrams.addElement(newDg);
        this.diagramNames.addElement(path);
        this.registerLsName(newDg.getName());
        this.setDiagram(newDg);
        newDg.setToViewport();
    }

    public void attach(String lsPath) {
        int ind = this.diagramNames.indexOf(lsPath);
        if (ind < 0) {
            Diagram dgLink = new Diagram(this, true);
            String rc = dgLink.loadDiagram(lsPath, null, null);
            if (rc != null) {
                this.error("Attach failed: " + rc);
                return;
            }
            dgLink.prepostorder();
            this.addDiagram(dgLink, lsPath);
        } else {
            this.setDiagram(ind);
        }
    }

    public void followLink(String url, int target) {
        switch (target) {
            case 6: {
                this.attach(url);
                break;
            }
            case 1: {
                if (this.af != null) {
                    LandscapeEditorFrame af = LandscapeEditorFrame.create();
                    af.setLsPath(url);
                    af.launch();
                    ++m_openFrames;
                    break;
                }
            }
            default: {
                super.followLink(url, target);
            }
        }
    }

    protected void loadLs(String file) {
        if (file != null && file.length() > 0) {
            this.lsPath = file;
            this.doFeedback("Reading: " + this.lsPath);
            Diagram newDg = new Diagram(this, true);
            String rc = newDg.loadDiagram(this.lsPath, null, null);
            if (rc != null) {
                this.error("Failed to load (" + rc + ")");
            } else {
                newDg.prepostorder();
                this.addDiagram(newDg, this.lsPath);
            }
        }
        this.requestFocus();
        this.repaint();
    }

    protected void fitChildren() {
        this.m_diagram.fitTo(this.m_diagram.getDrawRoot());
        this.doFeedback("Children fitted to: " + this.m_diagram.getDrawRoot().getLabel());
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void fitToLabel() {
        Vector v = this.startGroupOp();
        if (v == null) {
            return;
        }
        int H_MARGIN = 8;
        int V_MARGIN = 4;
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            Dimension ld = e.getLabelDim(this.getGraphics(), 1);
            Rectangle curLayout = e.getDiagramBounds();
            curLayout.width = ld.width + H_MARGIN * 2;
            curLayout.height = ld.height + V_MARGIN * 2;
            e.setDiagramBounds(curLayout);
        }
        this.m_diagram.rescaleDiagram();
        this.redrawDg();
    }

    protected Vector startGroupOp() {
        Vector grp = this.m_diagram.getGroup();
        if (grp == null) {
            this.error("Group not selected");
            return null;
        }
        return grp;
    }

    protected void align(int alignment) {
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        EntityInstance ke = this.m_diagram.getKeyEntity();
        Rectangle klyt = ke.getDiagramBounds();
        int cx = klyt.x + klyt.width / 2;
        int cy = klyt.y + klyt.height / 2;
        Enumeration en = grp.elements();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            if (e == ke) continue;
            Rectangle elyt = (Rectangle)e.getDiagramBounds().clone();
            switch (alignment) {
                case 38: {
                    elyt.y = klyt.y;
                    break;
                }
                case 88: {
                    elyt.y = cy - elyt.height / 2;
                    break;
                }
                case 37: {
                    elyt.x = klyt.x;
                    break;
                }
                case 39: {
                    elyt.x += klyt.x + klyt.width - elyt.width;
                    break;
                }
                case 89: {
                    elyt.x = cx - elyt.width / 2;
                    break;
                }
                default: {
                    MsgOut.println("Illegal allignment option");
                }
            }
            e.setDiagramBounds(elyt);
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void sameSize(int sizeDim) {
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        EntityInstance ke = this.m_diagram.getKeyEntity();
        Rectangle klyt = ke.getDiagramBounds();
        Enumeration en = grp.elements();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            if (e == ke) continue;
            Rectangle elyt = (Rectangle)e.getDiagramBounds().clone();
            switch (sizeDim) {
                case 119: {
                    elyt.width = klyt.width;
                    break;
                }
                case 104: {
                    elyt.height = klyt.height;
                    break;
                }
                case 120: {
                    elyt.width = klyt.width;
                    elyt.height = klyt.height;
                }
            }
            e.setDiagramBounds(elyt);
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void equalSpacing(int mode) {
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        if (grp.size() < 3) {
            this.error("Minimum group of three required");
            return;
        }
        Rectangle bb = this.m_diagram.getGroupBoundingBox();
        if (bb == null) {
            this.error("Group not selected");
            return;
        }
        switch (mode) {
            case 87: {
                SortVector.byDiagramX(grp);
                break;
            }
            case 72: {
                SortVector.byDiagramY(grp);
            }
        }
        double sep = 0.0;
        Enumeration en = grp.elements();
        double th = 0.0;
        double tw = 0.0;
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            Rectangle lyt = e.getDiagramBounds();
            tw += (double)lyt.width;
            th += (double)lyt.height;
        }
        sep = mode == 87 ? ((double)bb.width - tw) / (double)(grp.size() - 1) : ((double)bb.height - th) / (double)(grp.size() - 1);
        EntityInstance ce = (EntityInstance)grp.elementAt(0);
        Rectangle clyt = ce.getDiagramBounds();
        for (int i = 1; i < grp.size() - 1; ++i) {
            EntityInstance e = (EntityInstance)grp.elementAt(i);
            Rectangle lyt = e.getDiagramBounds();
            if (mode == 87) {
                lyt.x = (int)((double)(clyt.x + clyt.width) + sep);
            } else {
                lyt.y = (int)((double)(clyt.y + clyt.height) + sep);
            }
            clyt = (Rectangle)lyt.clone();
            e.setDiagramBounds(lyt);
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void createContainedGroup() {
        String cname;
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        EntityInstance pe = ((EntityInstance)grp.firstElement()).getContainedBy();
        Rectangle nlyt = this.m_diagram.getGroupBoundingBox();
        nlyt.y -= 21;
        nlyt.x -= 5;
        nlyt.width += 10;
        nlyt.height += 26;
        int n = 0;
        do {
            cname = "Container#" + n;
            ++n;
        } while (this.m_diagram.entityExists(cname));
        EntityInstance ne = this.addEntity(cname, nlyt, pe);
        Enumeration en = grp.elements();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            Rectangle lyt = e.getDiagramBounds();
            this.moveEntityContainment(ne, e);
            e.setDiagramBounds(lyt);
        }
        this.m_diagram.rescaleDiagram();
        this.repaintDg();
    }

    protected void cutGroup(Object object) {
        if (this.m_clipboard != null && this.m_clipboard.size() != 0) {
            this.error("Clipboard not empty");
        } else {
            this.m_clipboard = object != null && object == this.m_tocBox ? this.m_tocBox.getGroup() : this.m_diagram.getGroup();
            if (this.m_clipboard == null) {
                this.error("Group not selected");
            } else {
                EntityInstance e;
                Enumeration en = this.m_clipboard.elements();
                while (en.hasMoreElements()) {
                    e = (EntityInstance)en.nextElement();
                    if (e.getContainedBy() != null) continue;
                    this.doFeedback("Can't cut the root node in the diagram");
                    this.m_clipboard = null;
                    return;
                }
                this.m_diagram.clearKeyEntity();
                this.doFeedback("Group copied to clipboard");
                SortVector.byPostorder(this.m_clipboard);
                en = this.m_clipboard.elements();
                while (en.hasMoreElements()) {
                    e = (EntityInstance)en.nextElement();
                    this.cutEntity(e);
                }
            }
            this.redrawDg();
        }
    }

    protected void pasteGroup(Object object) {
        if (this.m_clipboard == null || this.m_clipboard.size() == 0) {
            this.error("Clipboard empty");
        } else {
            EntityInstance pe = object != null && object == this.m_tocBox ? this.m_tocBox.targetEntity() : this.m_diagram.targetEntity(object);
            if (pe != null) {
                int errs = 0;
                int cnt = 0;
                Enumeration en = this.m_clipboard.elements();
                while (en.hasMoreElements()) {
                    EntityInstance e = (EntityInstance)en.nextElement();
                    if (this.m_diagram != e.getDiagram()) {
                        ++errs;
                        this.error("Attempting to paste entity into a different diagram");
                        continue;
                    }
                    this.pasteEntity(pe, e);
                    ++cnt;
                }
                if (cnt != 0) {
                    this.m_diagram.prepostorder();
                    this.doFeedback("Pasted " + cnt + " entities into " + pe.getLabel());
                    this.redrawDg();
                }
            }
        }
        this.m_clipboard = null;
    }

    protected void saveStatus(String stat) {
        this.doFeedback("Save status: " + stat);
    }

    protected String doSaveByURL(String lsSaveURL) {
        OutputStream os;
        URLConnection urlCon;
        URL lsURL;
        try {
            lsURL = new URL(lsSaveURL);
        }
        catch (MalformedURLException e) {
            return "Malformed URL on write";
        }
        try {
            urlCon = lsURL.openConnection();
            urlCon.setDoInput(false);
            urlCon.setDoOutput(true);
            urlCon.setAllowUserInteraction(false);
        }
        catch (IOException e) {
            return "Couldn't open connection";
        }
        try {
            os = urlCon.getOutputStream();
        }
        catch (IOException e) {
            return "Couldn't openStream";
        }
        try {
            this.m_diagram.saveDiagram(os, false);
        }
        catch (IOException e) {
            return "IOException on write";
        }
        return null;
    }

    public void saveByURL(String overridePath) {
        InputStream is;
        URL lsURL;
        MsgOut.dprintln("Save by URL");
        String str = this.doSaveByURL(this.lsSavePath);
        if (str != null) {
            this.saveStatus(str);
            return;
        }
        if (this.lsSaveCmd == null) {
            this.saveStatus("Success");
            return;
        }
        try {
            lsURL = new URL(this.lsSaveCmd);
        }
        catch (MalformedURLException e) {
            this.saveStatus("Malformed URL on write");
            return;
        }
        try {
            is = lsURL.openStream();
        }
        catch (IOException e) {
            this.saveStatus("Couldn't openStream for store");
            return;
        }
        try {
            DataInputStream dis = new DataInputStream(is);
            str = dis.readLine();
            is.close();
            this.saveStatus(str);
        }
        catch (IOException e) {
            this.saveStatus("IOexception on store");
        }
    }

    protected String saveByFile(String newPath) {
        try {
            File file = (File)this.m_diagram.getContext();
            if (newPath == null) {
                String name = file.getPath();
                file.renameTo(new File(name + ".old"));
            } else {
                file = new File(newPath);
                this.m_diagram.setContext(file);
            }
            FileOutputStream os = new FileOutputStream(file);
            this.m_diagram.saveDiagram(os, false);
            return null;
        }
        catch (IOException e) {
            return "IOException on file open";
        }
    }

    protected String saveByFileRaw(String newPath) {
        try {
            File file = (File)this.m_diagram.getContext();
            if (newPath == null) {
                String name = file.getPath();
                if (name.endsWith(".raw")) {
                    file.renameTo(new File(name + ".old"));
                } else {
                    file = new File(name + ".raw");
                }
            } else {
                file = new File(newPath + ".raw");
                this.m_diagram.setContext(file);
            }
            FileOutputStream os = new FileOutputStream(file);
            this.m_diagram.saveDiagramRaw(os);
            return null;
        }
        catch (IOException e) {
            return "IOException on file open";
        }
    }

    protected String saveWithCmd(String saveSuffix, String cmdTemplate) {
        String rc;
        File file = (File)this.m_diagram.getContext();
        String path = file.getPath() + saveSuffix;
        File nfile = new File(path);
        try {
            FileOutputStream os = new FileOutputStream(nfile);
            this.m_diagram.saveDiagram(os, true);
        }
        catch (IOException e) {
            return "IOException on file save";
        }
        String cmd = Util.expand(cmdTemplate, file.getName(), this);
        try {
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(cmd);
            DataInputStream es = new DataInputStream(p.getErrorStream());
            rc = es.readLine();
            if (rc.equals("Done")) {
                rc = "Save succeeded";
            }
            p.destroy();
        }
        catch (Exception e) {
            rc = "Exec failed for: " + cmd;
        }
        return rc;
    }

    protected void doSaveLs(String overridePath) {
        this.doFeedback("Saving landscape...");
        if (this.m_diagram.getContext() instanceof URL) {
            this.saveByURL(overridePath);
        } else {
            String rc;
            if (overridePath == null && this.lsSaveCmd != null) {
                MsgOut.dprintln("Save by app");
                rc = this.saveWithCmd(this.lsSaveSuffix, this.lsSaveCmd);
            } else {
                MsgOut.dprintln("Save by file");
                rc = this.saveByFile(overridePath);
            }
            if (rc == null) {
                rc = "Success";
            }
            this.saveStatus(rc);
        }
    }

    protected void saveLs() {
        Object context = this.m_diagram.getContext();
        String txt = null;
        if (context == null && (txt = this.filePrompt("Save Landscape", this.m_diagram.getAbsolutePath(), 1)).length() == 0) {
            return;
        }
        this.doSaveLs(null);
    }

    protected void doSaveLsRaw(String overridePath) {
        this.doFeedback("Saving landscape in raw format...");
        if (!(this.m_diagram.getContext() instanceof URL)) {
            MsgOut.dprintln("Save by file");
            String rc = this.saveByFileRaw(overridePath);
            if (rc == null) {
                rc = "Success";
            }
            this.saveStatus(rc);
        }
    }

    protected void saveLsRaw() {
        Object context = this.m_diagram.getContext();
        String txt = null;
        if (context == null && (txt = this.filePrompt("Save Landscape Raw", this.m_diagram.getAbsolutePath(), 1)).length() == 0) {
            return;
        }
        this.doSaveLsRaw(null);
    }

    protected void initialLoad() {
        super.initialLoad();
        if (this.lsPath != null) {
            this.diagrams.addElement(this.m_diagram);
            this.diagramNames.addElement(this.lsPath);
            this.registerLsName(this.m_diagram.getName());
        } else {
            this.diagrams.addElement(this.m_diagram);
            this.diagramNames.addElement("");
            this.registerLsName("unnamed");
        }
    }

    public boolean isViewer() {
        return false;
    }

    public void newEntity(EntityInstance container) {
        EntityInstance e = this.m_diagram.newEntity(container);
        this.insertTOC(container, e);
    }

    public EntityInstance addEntity(String initId, Rectangle lyt, EntityInstance container) {
        EntityInstance e = this.m_diagram.addEntity(initId, lyt, container);
        this.insertTOC(container, e);
        return e;
    }

    public void DeleteEntity(Object object) {
        EntityInstance e = this.m_diagram.targetEntity(object);
        this.m_diagram.beginUndoRedo("Delete " + object);
        e = this.m_diagram.DeleteEntity(e);
        if (e != null) {
            this.deleteTOC(e);
        }
        this.m_diagram.endUndoRedo();
    }

    public void cutEntity(EntityInstance e) {
        this.m_diagram.cutEntity(e);
        this.deleteTOC(e);
    }

    public void pasteEntity(EntityInstance parent, EntityInstance e) {
        this.m_diagram.pasteEntity(parent, e);
        this.insertTOC(parent, e);
    }

    public void moveEntityContainment(EntityInstance newparent, EntityInstance e) {
        EntityInstance oldparent = e.getContainedBy();
        if (oldparent != newparent) {
            e.moveEntityContainment(newparent);
            this.deleteTOC(e);
            this.insertTOC(newparent, e);
        }
    }

    public void deleteContainer(EntityInstance e) {
        e.deleteJustMe();
        this.deleteJustMeTOC(e);
        this.doFeedback("Entity " + e.getLabel() + " has been deleted.");
    }

    protected boolean testForClose() {
        if (this.af == null) {
            return false;
        }
        if (!this.m_diagram.getChangedFlag()) {
            return true;
        }
        System.out.print("\u0007");
        int rc = JOptionPane.showConfirmDialog(this.m_frame, "Landscape has been changed.\nShould it be saved?", "Landscape Changed", 1);
        switch (rc) {
            case 0: {
                this.saveLs();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void processKey(int key, int modifiers, Object object) {
        if ((modifiers & 2) != 0) {
            switch (key) {
                case 111: {
                    Object context = this.m_diagram.getContext();
                    String txt = context != null ? this.filePrompt("Load Landscape", this.m_diagram.getAbsolutePath(), 0) : this.filePrompt("Load Landscape", "", 0);
                    this.loadLs(txt);
                    return;
                }
                case 112: {
                    Vista vista = new Vista(this);
                    return;
                }
                case 83: {
                    Object context = this.m_diagram.getContext();
                    String txt = context != null ? this.filePrompt("Save Landscape As", this.m_diagram.getAbsolutePath(), 1) : this.filePrompt("Save Landscape As", "", 1);
                    if (txt == null || txt.length() == 0) {
                        return;
                    }
                    this.doSaveLs(txt);
                    return;
                }
                case 115: {
                    if (this.m_diagram.isReadOnly()) {
                        this.error("Diagram is read-only");
                        return;
                    }
                    if ((modifiers & 8) != 0) {
                        this.saveLsRaw();
                    } else {
                        this.saveLs();
                    }
                    return;
                }
                case 118: {
                    this.pasteGroup(object);
                    return;
                }
                case 120: {
                    this.cutGroup(object);
                    return;
                }
                case 122: {
                    if (this.m_diagram != null) {
                        this.m_diagram.undo();
                    }
                    return;
                }
                case 121: {
                    if (this.m_diagram != null) {
                        this.m_diagram.redo();
                    }
                    return;
                }
            }
        } else if ((modifiers & 8) != 0) {
            switch (key) {
                case 37: 
                case 38: 
                case 39: 
                case 88: 
                case 89: {
                    this.align(key);
                    return;
                }
                case 102: {
                    this.beginUndoRedo("Fit label");
                    this.fitToLabel();
                    this.endUndoRedo();
                    return;
                }
                case 70: {
                    this.beginUndoRedo("Fit children");
                    this.fitChildren();
                    this.endUndoRedo();
                    return;
                }
                case 103: {
                    this.createContainedGroup();
                    return;
                }
                case 104: 
                case 119: 
                case 120: {
                    this.sameSize(key);
                    return;
                }
                case 72: 
                case 87: {
                    this.equalSpacing(key);
                    return;
                }
                case 100: {
                    ArrowDimensions.create(this);
                    this.repaint();
                    return;
                }
            }
        } else if (modifiers == 0) {
            switch (key) {
                case 86: {
                    if (this.m_modeHandler == this.m_editModeHandler) {
                        this.doFeedback("Set to viewer mode");
                        this.m_modeHandler = this.m_viewModeHandler;
                        this.m_diagram.setDrawBends(false);
                        this.setViewMode(true);
                    } else {
                        this.doFeedback("Set to editor mode");
                        this.m_modeHandler = this.m_editModeHandler;
                        this.m_diagram.setDrawBends(true);
                        this.setViewMode(false);
                    }
                    this.m_diagram.setModeHandler(this.m_modeHandler);
                    this.repaintDg();
                    return;
                }
                case 71: {
                    int grid = this.m_diagram.getGrid();
                    if (grid == 10) {
                        this.error("Grid already set to maximum (" + grid + " pixels)");
                    } else {
                        int ng = grid + 1;
                        this.m_diagram.setGrid(ng);
                        this.doFeedback("Grid set to " + ng + " pixels");
                    }
                    return;
                }
                case 103: {
                    int grid = this.m_diagram.getGrid();
                    if (grid == 1) {
                        this.error("Grid already set to minimum (1 pixel)");
                    } else {
                        int ng = grid - 1;
                        this.m_diagram.setGrid(ng);
                        this.doFeedback("Grid set to " + ng + " pixel(s)");
                    }
                    return;
                }
            }
        }
        super.processKey(key, modifiers, object);
    }

    public boolean isreadWrite() {
        return true;
    }

    public InternalBufferStream getInternalBufferStream() {
        return null;
    }

    public void itemStateChanged(ItemEvent ev) {
        int ind = this.m_lsDropDown.getSelectedIndex();
        this.setDiagram(ind);
        this.requestFocus();
    }
}

