/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeTokenStream;
import lsedit.LandscapeViewerCore;
import lsedit.MsgOut;
import lsedit.Util;

class LandscapeEditorFrame
extends JFrame
implements WindowListener {
    protected static final int MAX_WIDTH = 1280;
    protected static final int MAX_HEIGHT = 1024;
    protected static Dimension editorDim = null;
    protected static Dimension diagDim = null;
    protected boolean m_landscapeGeo = false;
    protected int m_frameWidth = 0;
    protected int m_frameHeight = 0;
    protected int m_diagramPercentWidth = 0;
    protected int m_diagramPercentHeight = 0;
    protected LandscapeViewerCore m_app;

    public LandscapeEditorFrame() {
        MsgOut.setVerboseFlag(false);
        MsgOut.setDebugFlag(false);
    }

    public static LandscapeEditorFrame create() {
        return new LandscapeEditorFrame();
    }

    public LandscapeViewerCore getApp() {
        if (this.m_app == null) {
            this.m_app = new LandscapeEditorCore();
        }
        return this.m_app;
    }

    public void launch() {
        if (this.m_frameWidth <= 0 || this.m_frameHeight <= 0) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension dim = tk.getScreenSize();
            double f = 0.75;
            if (this.m_landscapeGeo) {
                this.m_frameWidth = Math.min(1280, dim.width);
                this.m_frameHeight = Math.min(1024, dim.height);
            } else {
                this.m_frameWidth = (int)((double)dim.width / f);
                this.m_frameHeight = dim.height - 50;
            }
            this.m_frameWidth = Math.min(this.m_frameWidth, dim.width);
            this.m_frameHeight = Math.min(this.m_frameHeight, dim.height);
        }
        this.setBounds(0, 0, this.m_frameWidth, this.m_frameHeight);
        LandscapeViewerCore app = this.getApp();
        this.setTitle(app.getTitle());
        this.setVisible(true);
        app.setFrame(this);
        JMenuBar mb = app.genMenu();
        this.setJMenuBar(mb);
        app.init_app(this, null, this.m_diagramPercentWidth, this.m_diagramPercentHeight);
        this.addWindowListener(this);
        this.setBackground(Color.lightGray);
        this.setVisible(true);
    }

    public boolean useViewer() {
        if (this.m_app == null) {
            this.m_app = new LandscapeViewerCore();
            return true;
        }
        return false;
    }

    public void setDebugOn() {
        MsgOut.setDebugFlag(true);
        MsgOut.dprintln("Start app: " + System.getProperty("java.version"));
    }

    public void setTokenStreamDebugOn() {
        LandscapeTokenStream.setDebugOn();
    }

    public void setVerboseOn() {
        MsgOut.setVerboseFlag(true);
    }

    public void setLandscapeGeo() {
        this.m_landscapeGeo = true;
    }

    public boolean setFrameDimension(int width, int height) {
        if (width > 0 && height > 0) {
            this.m_frameWidth = width;
            this.m_frameHeight = height;
            return true;
        }
        return false;
    }

    public boolean setFrameDimension(String geo) {
        int ind = geo.indexOf(120);
        if (ind > 0) {
            try {
                int w = Util.parseInt(geo.substring(0, ind));
                int h = Util.parseInt(geo.substring(ind + 1));
                return this.setFrameDimension(w, h);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean setDiagramPercent(int width, int height) {
        if (width > 0 && width <= 100 && height > 0 && height <= 100) {
            this.m_diagramPercentWidth = width;
            this.m_diagramPercentHeight = height;
            return true;
        }
        return false;
    }

    public boolean setDiagramPercent(String geo) {
        int ind = geo.indexOf(120);
        if (ind > 0) {
            try {
                int w = Util.parseInt(geo.substring(0, ind));
                int h = Util.parseInt(geo.substring(ind + 1));
                return this.setDiagramPercent(w, h);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    public void showToc() {
        LandscapeViewerCore app = this.getApp();
        app.setTocHiddenState(false);
    }

    public boolean setStartEntity(String entityName) {
        LandscapeViewerCore app = this.getApp();
        app.startEntity = entityName;
        return true;
    }

    public boolean setSavePath(String path) {
        LandscapeViewerCore app = this.getApp();
        app.lsSavePath = path;
        return true;
    }

    public boolean setSaveSuffix(String suffix) {
        LandscapeViewerCore app = this.getApp();
        app.lsSaveSuffix = suffix;
        return true;
    }

    public boolean setSaveCommand(String command) {
        LandscapeViewerCore app = this.getApp();
        app.lsSaveCmd = command;
        return true;
    }

    public boolean setLsPath(String file) {
        LandscapeViewerCore app = this.getApp();
        if (app.lsPath == null) {
            app.lsPath = file;
        } else {
            app.lsPath_bg.addElement(file);
        }
        return true;
    }

    public static void usage() {
        System.out.println("\nLandscape Editor 7.0.15\n");
        System.out.println("<executor> LandscapeEditorFrame [options] <HTTP or file path>\n");
        System.out.println("-h\t This message");
        System.out.println("-v\t Verbose parsing output");
        System.out.println("");
        System.out.println("-g<width>x<height> Geometry of editor");
        System.out.println("-G<width>x<height> Geometry of diagram");
        System.out.println("");
        System.out.println("-L\t Start with landscape geometry");
        System.out.println("-V\t Start in viewer mode");
        System.out.println("");
        System.out.println("-P <path>  Optional save path");
        System.out.println("-S <path>  Optional save suffix");
        System.out.println("-X <path>  Optional app to exec on save");
        System.out.println("");
    }

    public boolean setOptions(String[] args) {
        char c;
        int n;
        boolean ok = true;
        for (n = 0; n < args.length && args[n].charAt(0) == '-'; ++n) {
            c = args[n].charAt(1);
            switch (c) {
                case 'h': {
                    LandscapeEditorFrame.usage();
                    return false;
                }
                case 'V': {
                    this.useViewer();
                }
            }
        }
        for (n = 0; n < args.length && args[n].charAt(0) == '-'; ++n) {
            int len = args[n].length();
            block18: for (int i = 1; i < len; ++i) {
                c = args[n].charAt(i);
                switch (c) {
                    case 'd': {
                        this.setDebugOn();
                        if (i >= len - 1 || args[n].charAt(i + 1) != 'd') continue block18;
                        this.setTokenStreamDebugOn();
                        ++i;
                        continue block18;
                    }
                    case 't': {
                        this.showToc();
                        continue block18;
                    }
                    case 'v': {
                        this.setVerboseOn();
                        continue block18;
                    }
                    case 'g': {
                        if (!this.setFrameDimension(args[n].substring(i + 1))) {
                            System.out.println("Illegal -g option [ignored]");
                            ok = false;
                        }
                        i = len;
                        continue block18;
                    }
                    case 'G': {
                        if (!this.setDiagramPercent(args[n].substring(i + 1))) {
                            System.out.println("Illegal -G option [must be percentages]");
                            ok = false;
                        }
                        i = len;
                        continue block18;
                    }
                    case 'L': {
                        this.setLandscapeGeo();
                        continue block18;
                    }
                    case 'N': {
                        if (++n >= args.length || !this.setStartEntity(args[n])) {
                            System.out.println("\nInvalid use of -N");
                            ok = false;
                        }
                        i = len;
                        continue block18;
                    }
                    case 'P': {
                        if (++n >= args.length || !this.setSavePath(args[n])) {
                            System.out.println("\nInvalid use of -P");
                            ok = false;
                        }
                        i = len;
                        continue block18;
                    }
                    case 'S': {
                        if (++n >= args.length || !this.setSaveSuffix(args[n])) {
                            System.out.println("\nInvalid use of -S");
                            ok = false;
                        }
                        i = len;
                        continue block18;
                    }
                    case 'X': {
                        if (++n >= args.length || !this.setSaveCommand(args[n])) {
                            ok = false;
                        }
                        i = len;
                    }
                }
            }
        }
        while (n < args.length) {
            this.setLsPath(args[n++]);
        }
        return ok;
    }

    public static void main(String[] args) {
        LandscapeEditorFrame af = LandscapeEditorFrame.create();
        if (!af.setOptions(args)) {
            LandscapeEditorFrame.usage();
            System.exit(0);
        }
        af.launch();
        MsgOut.dprintln("exit main");
    }

    public void windowOpened(WindowEvent evt) {
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowClosing(WindowEvent evt) {
        this.removeWindowListener(this);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }
}

